/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.result.log;

import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.internal.ui.BuildCompositeImageRegistry;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.editors.result.download.AbstractDownloadsPage;
import com.ibm.team.build.internal.ui.editors.result.download.DownloadContributionNode;
import com.ibm.team.build.internal.ui.editors.result.log.Messages;
import com.ibm.team.build.ui.editors.result.AbstractBuildResultPage;
import com.ibm.team.build.ui.editors.result.IBuildResultContext;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.forms.editor.FormEditor;

public class LogsPage
extends AbstractDownloadsPage {
    protected boolean fShowOKLogs = true;
    protected boolean fShowWarningLogs = true;
    protected boolean fShowErrorLogs = true;
    protected StatusFilter fOKLogsFilter = new StatusFilter(BuildStatus.OK, BuildStatus.INFO);
    protected StatusFilter fWarningLogsFilter = new StatusFilter(BuildStatus.WARNING);
    protected StatusFilter fErrorLogsFilter = new StatusFilter(BuildStatus.ERROR);

    public LogsPage(FormEditor editor, String id, String title, IBuildResultContext buildResultPageInput) {
        super(editor, id, title, new String[]{IBuildResultContribution.LOG_EXTENDED_CONTRIBUTION_ID}, buildResultPageInput);
    }

    @Override
    public AbstractBuildResultPage.PageGroup getPageGroup() {
        return AbstractBuildResultPage.PageGroup.DOWNLOADS;
    }

    @Override
    protected String getPageContributionTypeId() {
        return IBuildResultContribution.LOG_EXTENDED_CONTRIBUTION_ID;
    }

    @Override
    protected String getSectionTitle() {
        return Messages.LogsPage_SECTION_TITLE;
    }

    @Override
    protected String getContextHelpId() {
        return "com.ibm.team.build.ui.editorpage_buildresultlog";
    }

    @Override
    protected void populateToolbar(ToolBar toolbar) {
        Image baseImage = BuildUIPlugin.getImage("icons/obj16/buildart_obj.gif");
        Image okImage = BuildCompositeImageRegistry.getImage(baseImage, BuildStatus.OK, true);
        Image warningImage = BuildCompositeImageRegistry.getImage(baseImage, BuildStatus.WARNING, true);
        Image errorImage = BuildCompositeImageRegistry.getImage(baseImage, BuildStatus.ERROR, true);
        this.createFilterButton(okImage, Messages.LogsPage_SHOW_SUCCESSFUL_LOGS, toolbar, this.fOKLogsFilter, (StructuredViewer)this.fTreeViewer, this.fShowOKLogs);
        this.createFilterButton(warningImage, Messages.LogsPage_SHOW_WARNING_LOGS, toolbar, this.fWarningLogsFilter, (StructuredViewer)this.fTreeViewer, this.fShowWarningLogs);
        this.createFilterButton(errorImage, Messages.LogsPage_SHOW_ERROR_LOGS, toolbar, this.fErrorLogsFilter, (StructuredViewer)this.fTreeViewer, this.fShowErrorLogs);
    }

    @Override
    protected void toggleFilter(boolean buttonSelected, StructuredViewer viewer, ViewerFilter filter) {
        if (filter == this.fOKLogsFilter) {
            this.fShowOKLogs = buttonSelected;
        } else if (filter == this.fWarningLogsFilter) {
            this.fShowWarningLogs = buttonSelected;
        } else if (filter == this.fErrorLogsFilter) {
            this.fShowErrorLogs = buttonSelected;
        }
        super.toggleFilter(buttonSelected, viewer, filter);
    }

    private static class StatusFilter
    extends ViewerFilter {
        final BuildStatus[] expectedStatus;

        public StatusFilter(BuildStatus ... status) {
            this.expectedStatus = status;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof DownloadContributionNode) {
                DownloadContributionNode node = (DownloadContributionNode)element;
                BuildStatus status = node.getContribution().getStatus();
                BuildStatus[] buildStatusArray = this.expectedStatus;
                int n = this.expectedStatus.length;
                int n2 = 0;
                while (n2 < n) {
                    BuildStatus expected = buildStatusArray[n2];
                    if (status == expected) {
                        return false;
                    }
                    ++n2;
                }
            }
            return true;
        }
    }
}

