/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.result.log;

import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.internal.ui.editors.result.log.LogsPage;
import com.ibm.team.build.internal.ui.editors.result.log.Messages;
import com.ibm.team.build.ui.editors.result.AbstractBuildResultContributionProvider;
import com.ibm.team.build.ui.editors.result.AbstractBuildResultPage;
import com.ibm.team.build.ui.editors.result.IBuildResultContext;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.forms.editor.FormEditor;

public class LogContributionProvider
extends AbstractBuildResultContributionProvider {
    private IBuildResultContribution[] fContributions;

    public LogContributionProvider(FormEditor buildEditor, String id, IBuildResultContext context) {
        super(buildEditor, id, context);
    }

    @Override
    public void initializeContributionProvider(IProgressMonitor monitor) throws Exception {
        this.fContributions = this.getContributions();
    }

    @Override
    public BuildStatus getStatus() {
        BuildStatus status = BuildStatus.INFO;
        IBuildResultContribution[] iBuildResultContributionArray = this.fContributions;
        int n = this.fContributions.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildResultContribution contribution = iBuildResultContributionArray[n2];
            if (contribution.getStatus().isMoreSevere(status)) {
                status = contribution.getStatus();
            }
            ++n2;
        }
        return status;
    }

    @Override
    public String getSummaryText() {
        if (this.fContributions.length > 0) {
            return MessageFormat.format(Messages.LogContributionProvider_SUMMARY_TEXT, String.valueOf(this.fContributions.length), this.getLogString());
        }
        return Messages.LogContributionProvider_NO_LOGS;
    }

    private String getLogString() {
        if (this.fContributions.length == 1) {
            return Messages.LogContributionProvider_ONE_LOG;
        }
        return Messages.LogContributionProvider_MULTIPLE_LOGS;
    }

    @Override
    public String[] getExtendedContributionIds() {
        return new String[]{IBuildResultContribution.LOG_EXTENDED_CONTRIBUTION_ID};
    }

    @Override
    public boolean isSummaryLink() {
        return this.fContributions.length > 0;
    }

    @Override
    public void summaryLinkActivated() {
        this.getBuildResultEditor().setActivePage(this.getExtensionId());
    }

    @Override
    public String getSummaryTitle() {
        return Messages.LogContributionProvider_SUMMARY_TITLE;
    }

    @Override
    public AbstractBuildResultPage getBuildResultPage() {
        return new LogsPage(this.getBuildResultEditor(), this.getExtensionId(), Messages.LogContributionProvider_PAGE_TITLE, this.getBuildResultContext());
    }
}

