/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.result.links;

import com.ibm.icu.text.Collator;
import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.internal.ui.BuildCompositeImageRegistry;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.actions.OpenURLAction;
import com.ibm.team.build.internal.ui.actions.SaveURLAction;
import com.ibm.team.build.internal.ui.editors.result.BuildResultPage;
import com.ibm.team.build.internal.ui.editors.result.OpenURLHyperlinkListener;
import com.ibm.team.build.internal.ui.editors.result.StatusLineHyperlinkListener;
import com.ibm.team.build.internal.ui.editors.result.download.CopyToClipboardAction;
import com.ibm.team.build.internal.ui.editors.result.links.Messages;
import com.ibm.team.build.ui.editors.result.AbstractBuildResultPage;
import com.ibm.team.build.ui.editors.result.IBuildResultContext;
import com.ibm.team.jface.JazzResources;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;

public class LinksPage
extends BuildResultPage {
    protected LocalResourceManager fResourceManager;
    private StatusLineHyperlinkListener fURLLinkListener;
    private FormEditor fEditor;
    public static final String LINK_ICON_IMAGE_FILENAME = "icons/obj16/extnal_artfct_obj.gif";
    public static final String LABEL_KEY = "LABEL";
    FormToolkit fToolkit = null;

    public LinksPage(FormEditor editor, String id, String title, String[] contributionIds, IBuildResultContext buildResultContext) {
        super(editor, id, title, contributionIds, buildResultContext);
        this.fEditor = editor;
        this.fURLLinkListener = new OpenURLHyperlinkListener(true, (IEditorPart)this.fEditor);
    }

    @Override
    protected void doCreatePageContent(Composite parent) {
        this.fToolkit = this.getManagedForm().getToolkit();
        this.fToolkit.setBorderStyle(2048);
        this.fResourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        GridLayoutFactory.fillDefaults().applyTo(parent);
        this.createLinksSections(parent);
        parent.layout(true);
        this.getManagedForm().reflow(true);
    }

    protected MenuManager createMenuManager() {
        return new MenuManager("#PopupMenu");
    }

    protected IMenuListener createMenuListener(final Hyperlink hyperlink) {
        return new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IAction)new OpenURLAction((String)hyperlink.getHref(), (IWorkbenchPartSite)LinksPage.this.getFormEditor().getEditorSite(), true));
                manager.add((IAction)new SaveURLAction((String)hyperlink.getHref(), LinksPage.this.getFormEditor().getEditorSite().getShell()));
                manager.add((IAction)new CopyToClipboardAction((String)hyperlink.getHref(), true));
            }
        };
    }

    protected void createHyperlinkContextMenu(Hyperlink hyperlink) {
        MenuManager menuMgr = this.createMenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(this.createMenuListener(hyperlink));
        Menu menu = menuMgr.createContextMenu((Control)hyperlink);
        hyperlink.setMenu(menu);
    }

    protected void createLinksSections(Composite parent) {
        Hashtable contributionsByComponent = new Hashtable();
        ArrayList<String> componentNames = new ArrayList<String>();
        IBuildResultContribution[] contributions = this.getContributions();
        final Collator collator = Collator.getInstance((Locale)Locale.getDefault());
        IBuildResultContribution[] iBuildResultContributionArray = contributions;
        int n = contributions.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildResultContribution contribution = iBuildResultContributionArray[n2];
            String componentName = contribution.getComponentName();
            if (!contributionsByComponent.containsKey(componentName)) {
                contributionsByComponent.put(componentName, new LinkedList());
                componentNames.add(componentName);
            }
            ((LinkedList)contributionsByComponent.get(componentName)).add(contribution);
            ++n2;
        }
        Collections.sort(componentNames, new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                if (s1.length() > 0 && s2.length() == 0) {
                    return -1;
                }
                if (s1.length() == 0) {
                    return s2.length() > 0 ? 1 : 0;
                }
                return collator.compare(s1, s2);
            }
        });
        boolean singleSection = contributionsByComponent.size() == 1;
        String noComponentSectionTitle = contributionsByComponent.size() > 1 ? Messages.LinksContributionProvider_OTHER_SECTION_TITLE : Messages.LinksContributionProvider_PAGE_TITLE;
        for (String componentName : componentNames) {
            String sectionTitle = componentName.length() == 0 ? noComponentSectionTitle : componentName;
            LinkedList sortedContributions = (LinkedList)contributionsByComponent.get(componentName);
            Collections.sort(sortedContributions, new Comparator<IBuildResultContribution>(){

                @Override
                public int compare(IBuildResultContribution c1, IBuildResultContribution c2) {
                    return collator.compare(c1.getLabel(), c2.getLabel());
                }
            });
            this.createSection(parent, sectionTitle, sortedContributions, singleSection);
        }
    }

    protected Section createSection(Composite parent, String sectionTitle, LinkedList<IBuildResultContribution> contributions, boolean singleSection) {
        int expansionStyle = singleSection ? 0 : 2;
        Section section = this.fToolkit.createSection(parent, 0x100 | expansionStyle);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)section);
        section.setText(sectionTitle);
        section.setExpanded(singleSection);
        BuildStatus status = this.getStatus(contributions);
        if (status.isMoreSevere(BuildStatus.INFO)) {
            section.setTitleBarBackground(this.getSectionBackgroundColor(status));
            section.setTitleBarForeground(this.getSectionForegroundColor(status));
        }
        Composite outerComposite = this.fToolkit.createComposite((Composite)section);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)outerComposite);
        GridLayoutFactory.fillDefaults().applyTo(outerComposite);
        section.setClient((Control)outerComposite);
        Composite hyperlinkComposite = this.fToolkit.createComposite(outerComposite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)hyperlinkComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(hyperlinkComposite);
        this.createHyperlinks(hyperlinkComposite, contributions);
        return section;
    }

    private BuildStatus getStatus(List<IBuildResultContribution> contributions) {
        BuildStatus status = BuildStatus.OK;
        for (IBuildResultContribution buildResultContribution : contributions) {
            if (!buildResultContribution.getStatus().isMoreSevere(status)) continue;
            status = buildResultContribution.getStatus();
        }
        return status;
    }

    protected Color getSectionForegroundColor(BuildStatus buildstatus) {
        String key = "com.ibm.team.build.ui.SUCCESS_COLOR_FOREGROUND";
        if (buildstatus == BuildStatus.ERROR) {
            key = "com.ibm.team.build.ui.ERROR_COLOR_FOREGROUND";
        } else if (buildstatus == BuildStatus.WARNING) {
            key = "com.ibm.team.build.ui.WARNING_COLOR_FOREGROUND";
        }
        return JazzResources.getColor((ResourceManager)this.fResourceManager, (RGB)this.getRGB(key));
    }

    protected Color getSectionBackgroundColor(BuildStatus buildstatus) {
        String key = "com.ibm.team.build.ui.SUCCESS_COLOR_BACKGROUND";
        if (buildstatus == BuildStatus.ERROR) {
            key = "com.ibm.team.build.ui.ERROR_COLOR_BACKGROUND";
        } else if (buildstatus == BuildStatus.WARNING) {
            key = "com.ibm.team.build.ui.WARNING_COLOR_BACKGROUND";
        }
        return JazzResources.getColor((ResourceManager)this.fResourceManager, (RGB)this.getRGB(key));
    }

    protected RGB getRGB(String key) {
        return PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry().getRGB(key);
    }

    protected Image getIconImage(IBuildResultContribution contribution) {
        Image image = BuildUIPlugin.getImage(LINK_ICON_IMAGE_FILENAME);
        if (contribution.getStatus() == BuildStatus.OK) {
            return image;
        }
        return BuildCompositeImageRegistry.getImage(image, contribution.getStatus());
    }

    protected void createHyperlinks(Composite composite, LinkedList<IBuildResultContribution> contributions) {
        for (IBuildResultContribution buildResultContribution : contributions) {
            Label imageLabel = this.fToolkit.createLabel(composite, null);
            Image artImage = this.getIconImage(buildResultContribution);
            if (artImage != null) {
                imageLabel.setImage(artImage);
            }
            String fileURL = buildResultContribution.getExtendedContributionProperty(IBuildResultContribution.PROPERTY_NAME_URL);
            Hyperlink hyperlink = this.createHyperlink(composite, buildResultContribution.getLabel());
            hyperlink.setData((Object)buildResultContribution);
            hyperlink.setData(LABEL_KEY, (Object)buildResultContribution.getLabel());
            hyperlink.setHref((Object)fileURL);
            hyperlink.addListener(6, (Listener)this.fURLLinkListener);
            hyperlink.addListener(7, (Listener)this.fURLLinkListener);
            hyperlink.addHyperlinkListener((IHyperlinkListener)this.fURLLinkListener);
            GridDataFactory.fillDefaults().grab(true, false).indent(3, -1).applyTo((Control)hyperlink);
            this.createHyperlinkContextMenu(hyperlink);
        }
    }

    protected Hyperlink createHyperlink(Composite composite, String fileName) {
        return this.getFormToolkit().createHyperlink(composite, fileName, 0);
    }

    protected FormEditor getFormEditor() {
        return this.fEditor;
    }

    protected FormToolkit getFormToolkit() {
        return this.fToolkit;
    }

    @Override
    protected Viewer getViewer() {
        return null;
    }

    @Override
    public AbstractBuildResultPage.PageGroup getPageGroup() {
        return AbstractBuildResultPage.PageGroup.DOWNLOADS;
    }

    @Override
    public String getContextHelpId() {
        return "com.ibm.team.build.ui.editorpage_buildresultlink";
    }
}

