/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.result.download;

import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.editors.result.IBuildTreeNode;
import com.ibm.team.build.internal.ui.editors.result.download.DownloadContributionNode;
import com.ibm.team.build.internal.ui.editors.result.download.DownloadsComponentNode;
import com.ibm.team.repository.client.ITeamRepository;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.graphics.Image;

public class DownloadsRootNode
implements IBuildTreeNode {
    protected IBuildResultContribution[] fContributions;
    protected Hashtable<String, DownloadsComponentNode> fComponentNodes = new Hashtable();
    protected Object[] fChildren;
    private ITeamRepository fRepository;
    private boolean fIsShowingComponentNodes;

    public DownloadsRootNode(IBuildResultContribution[] contributions, ITeamRepository repository) {
        ValidationHelper.validateNotNull((String)"contributions", (Object[])contributions);
        ValidationHelper.validateNotNull((String)"repository", (Object)repository);
        this.fContributions = contributions;
        this.fRepository = repository;
    }

    public void resetBuildResultContributions(IBuildResultContribution[] contributions) {
        this.fContributions = contributions;
        this.fComponentNodes.clear();
        this.fChildren = null;
    }

    protected DownloadContributionNode addContribution(IBuildResultContribution contribution) {
        String componentName = contribution.getComponentName();
        DownloadsComponentNode node = this.fComponentNodes.get(componentName);
        if (node == null) {
            node = new DownloadsComponentNode(this, componentName, this.fRepository);
            this.fComponentNodes.put(componentName, node);
        }
        return node.add(contribution);
    }

    protected Object[] computeChildren() {
        Enumeration<String> componentNames;
        String name;
        this.fIsShowingComponentNodes = true;
        if (this.fComponentNodes.size() == 1 && (name = (componentNames = this.fComponentNodes.keys()).nextElement()).length() == 0) {
            this.fIsShowingComponentNodes = false;
        }
        if (this.fIsShowingComponentNodes) {
            return this.fComponentNodes.values().toArray(new DownloadsComponentNode[this.fComponentNodes.size()]);
        }
        return this.fComponentNodes.elements().nextElement().getChildren();
    }

    public TreePath addNewContribution(IBuildResultContribution contribution) {
        Object[] objectArray;
        DownloadContributionNode node = this.addContribution(contribution);
        this.fChildren = this.computeChildren();
        if (this.fIsShowingComponentNodes) {
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = this;
            objectArray2[1] = node.getParentNode();
            objectArray = objectArray2;
            objectArray2[2] = node;
        } else {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = this;
            objectArray = objectArray3;
            objectArray3[1] = node;
        }
        Object[] nodes = objectArray;
        return new TreePath(nodes);
    }

    public void removeContribution(DownloadContributionNode contributionNode) {
        String componentName = contributionNode.getContribution().getComponentName();
        DownloadsComponentNode node = this.fComponentNodes.get(componentName);
        int remainingContributionCount = node.remove(contributionNode);
        if (remainingContributionCount == 0) {
            this.fComponentNodes.remove(componentName);
        }
        this.fChildren = this.computeChildren();
    }

    @Override
    public Object[] getChildren() {
        if (this.fChildren == null) {
            IBuildResultContribution[] iBuildResultContributionArray = this.fContributions;
            int n = this.fContributions.length;
            int n2 = 0;
            while (n2 < n) {
                IBuildResultContribution contribution = iBuildResultContributionArray[n2];
                this.addContribution(contribution);
                ++n2;
            }
            this.fChildren = this.computeChildren();
        }
        return this.fChildren;
    }

    @Override
    public Image getColumnImage(int columnIndex) {
        return null;
    }

    @Override
    public String getColumnText(int columnIndex) {
        return null;
    }

    @Override
    public Long getColumnAsLong(int columnIndex) {
        return null;
    }

    @Override
    public String getNodeName() {
        return null;
    }

    @Override
    public IBuildTreeNode getParentNode() {
        return null;
    }
}

