/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.result.download;

import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.internal.ui.editors.result.download.ArtifactsDownloadPage;
import com.ibm.team.build.internal.ui.editors.result.download.Messages;
import com.ibm.team.build.ui.editors.result.AbstractBuildResultContributionProvider;
import com.ibm.team.build.ui.editors.result.AbstractBuildResultPage;
import com.ibm.team.build.ui.editors.result.IBuildResultContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.forms.editor.FormEditor;

public class DownloadsContributionProvider
extends AbstractBuildResultContributionProvider {
    private IBuildResultContribution[] fContributions;

    public DownloadsContributionProvider(FormEditor buildEditor, String id, IBuildResultContext context) {
        super(buildEditor, id, context);
    }

    @Override
    public void initializeContributionProvider(IProgressMonitor monitor) throws Exception {
        this.fContributions = this.getContributions();
    }

    @Override
    public BuildStatus getStatus() {
        return BuildStatus.INFO;
    }

    @Override
    public String[] getExtendedContributionIds() {
        return new String[]{IBuildResultContribution.ARTIFACT_EXTENDED_CONTRIBUTION_ID};
    }

    @Override
    public String getSummaryText() {
        if (this.fContributions.length > 0) {
            return NLS.bind((String)Messages.DownloadsContributionProvider_SUMMARY_TEXT, (Object)String.valueOf(this.fContributions.length), (Object)this.getSummaryString());
        }
        return Messages.DownloadsContributionProvider_NO_DOWNLOADS;
    }

    private String getSummaryString() {
        if (this.fContributions.length == 1) {
            return Messages.DownloadsContributionProvider_ONE_DOWNLOAD;
        }
        return Messages.DownloadsContributionProvider_MULTIPLE_DOWNLOADS;
    }

    @Override
    public boolean isSummaryLink() {
        return this.fContributions.length > 0;
    }

    @Override
    public void summaryLinkActivated() {
        this.getBuildResultEditor().setActivePage(this.getExtensionId());
    }

    @Override
    public String getSummaryTitle() {
        return Messages.DownloadsContributionProvider_SUMMARY_TITLE;
    }

    @Override
    public AbstractBuildResultPage getBuildResultPage() {
        return new ArtifactsDownloadPage(this.getBuildResultEditor(), this.getExtensionId(), Messages.DownloadsContributionProvider_PAGE_TITLE, this.getBuildResultContext());
    }
}

