/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.result.download;

import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.BuildCompositeImageRegistry;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.editors.result.BuildResultEditorMessages;
import com.ibm.team.build.internal.ui.editors.result.IBuildTreeNode;
import com.ibm.team.build.internal.ui.editors.result.download.DownloadContributionNode;
import com.ibm.team.repository.client.ITeamRepository;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Image;

public class DownloadsComponentNode
implements IBuildTreeNode {
    private String fComponentName = null;
    private IBuildTreeNode fParentNode;
    private List<DownloadContributionNode> fNodes = new ArrayList<DownloadContributionNode>();
    private Object[] fChildren;
    private ITeamRepository fRepository;

    public DownloadsComponentNode(IBuildTreeNode parent, String componentName, ITeamRepository repository) {
        ValidationHelper.validateNotNull((String)"parent", (Object)parent);
        ValidationHelper.validateNotNull((String)"componentName", (Object)componentName);
        ValidationHelper.validateNotNull((String)"repository", (Object)repository);
        this.fParentNode = parent;
        this.fComponentName = componentName.length() == 0 ? BuildResultEditorMessages.NO_COMPONENT_LABEL : componentName;
        this.fRepository = repository;
    }

    public DownloadContributionNode add(IBuildResultContribution contribution) {
        DownloadContributionNode node = new DownloadContributionNode(this, contribution, this.fRepository);
        this.fNodes.add(node);
        this.fChildren = this.fNodes.toArray();
        return node;
    }

    public int remove(DownloadContributionNode node) {
        this.fNodes.remove(node);
        this.fChildren = this.fNodes.toArray();
        return this.fNodes.size();
    }

    @Override
    public Object[] getChildren() {
        if (this.fChildren == null) {
            this.fChildren = this.fNodes.toArray();
        }
        return this.fChildren;
    }

    @Override
    public Image getColumnImage(int columnIndex) {
        if (columnIndex == 0) {
            Image image = BuildUIPlugin.getImage("icons/obj16/component_obj.gif");
            BuildStatus status = this.getContributionStatus();
            if (status.isMoreSevere(BuildStatus.INFO)) {
                return BuildCompositeImageRegistry.getImage(image, status);
            }
            return image;
        }
        return null;
    }

    private BuildStatus getContributionStatus() {
        BuildStatus status = BuildStatus.OK;
        for (DownloadContributionNode contribution : this.fNodes) {
            if (!contribution.getContribution().getStatus().isMoreSevere(status)) continue;
            status = contribution.getContribution().getStatus();
        }
        return status;
    }

    @Override
    public String getColumnText(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.fComponentName;
            }
        }
        return null;
    }

    @Override
    public Long getColumnAsLong(int columnIndex) {
        return null;
    }

    @Override
    public String getNodeName() {
        return this.fComponentName;
    }

    @Override
    public IBuildTreeNode getParentNode() {
        return this.fParentNode;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DownloadsComponentNode)) {
            return false;
        }
        return this.fComponentName.equals(((DownloadsComponentNode)object).getNodeName());
    }

    public int hashCode() {
        return this.fComponentName.hashCode();
    }
}

