/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.result.download;

import com.ibm.team.build.client.ClientFactory;
import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.TeamBuildException;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.internal.client.util.ContentUtil;
import com.ibm.team.build.internal.ui.actions.OpenDownloadActionDelegate;
import com.ibm.team.build.internal.ui.actions.SaveDownloadActionDelegate;
import com.ibm.team.build.internal.ui.dialogs.BuildResultAttachmentFileDialog;
import com.ibm.team.build.internal.ui.editors.result.BuildContentProvider;
import com.ibm.team.build.internal.ui.editors.result.BuildResultEditorMessages;
import com.ibm.team.build.internal.ui.editors.result.BuildResultPage;
import com.ibm.team.build.internal.ui.editors.result.BuildResultsTreeViewerComparator;
import com.ibm.team.build.internal.ui.editors.result.download.DownloadContributionNode;
import com.ibm.team.build.internal.ui.editors.result.download.DownloadsComponentNode;
import com.ibm.team.build.internal.ui.editors.result.download.DownloadsLabelProvider;
import com.ibm.team.build.internal.ui.editors.result.download.DownloadsRootNode;
import com.ibm.team.build.internal.ui.tooltips.support.ColumnAwareTooltipSupport;
import com.ibm.team.build.ui.editors.result.IBuildResultContext;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.LineDelimiter;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public abstract class AbstractDownloadsPage
extends BuildResultPage {
    public static final String CONTEXT_MENU_ID = "com.ibm.team.build.ui.downloadsPageContextMenu";
    public static final int DESCRIPTION_COLUMN_INDEX = 1;
    public static final int SIZE_COLUMN_INDEX = 2;
    public static final int TIME_COLUMN_INDEX = 3;
    private FormEditor fEditor;
    protected List<IBuildResultContribution> fContributionsToAdd;
    protected List<IBuildResultContribution> fContributionsToRemove;
    protected Map<IBuildResultContribution, String> fContentTypes;
    protected Map<IBuildResultContribution, String> fCharacterEncodings;
    FormToolkit fToolkit = null;
    protected FilteredTree fFilteredTree;
    protected Tree fTree;
    protected TreeViewer fTreeViewer;
    protected Button fOpenButton;
    protected Button fSaveButton;
    protected Button fAddFileButton;
    protected Button fAddLinkButton;
    protected Button fEditButton;
    protected Button fRemoveButton;
    protected IAction fEditAction;
    protected IAction fRemoveAction;
    protected IAction fAddFileAction;
    protected IAction fAddLinkAction;
    private IObjectActionDelegate fOpenActionDelegate = new OpenDownloadActionDelegate();
    private IObjectActionDelegate fSaveActionDelegate = new SaveDownloadActionDelegate();
    private String fSortColumn;
    private int fSortDirection;
    private final String SORT_COLUMN_KEY = "com.ibm.team.build.internal.ui.editors.sort.column";
    private final String SORT_DIRECTION_KEY = "com.ibm.team.build.internal.ui.editors.sort.direction";
    protected Preferences fNode;
    protected DownloadsRootNode fRootNode;

    public AbstractDownloadsPage(FormEditor editor, String id, String title, String[] contributionIds, IBuildResultContext buildResultContext) {
        super(editor, id, title, contributionIds, buildResultContext);
        this.fEditor = editor;
        this.fNode = new InstanceScope().getNode("com.ibm.team.build.ui").node(id);
        this.fSortColumn = this.fNode.get("com.ibm.team.build.internal.ui.editors.sort.column", BuildResultEditorMessages.AbstractDownloadsPage_FILE_NAME_COLUMN_HEADER);
        this.fSortDirection = this.fNode.getInt("com.ibm.team.build.internal.ui.editors.sort.direction", 128);
        this.fEditAction = new Action(BuildResultEditorMessages.AbstractDownloadsPage_EDIT_BUTTON_LABEL){

            public void run() {
                AbstractDownloadsPage.this.editSelection((ISelection)AbstractDownloadsPage.this.getTreeViewerSelection());
            }
        };
        this.fRemoveAction = new Action(BuildResultEditorMessages.AbstractDownloadsPage_REMOVE_BUTTON_LABEL){

            public void run() {
                AbstractDownloadsPage.this.removeSelection((ISelection)AbstractDownloadsPage.this.getTreeViewerSelection());
            }
        };
        this.fAddFileAction = new Action(BuildResultEditorMessages.AbstractDownloadsPage_ADD_FILE_BUTTON_LABEL){

            public void run() {
                AbstractDownloadsPage.this.addFile(false);
            }
        };
        this.fAddLinkAction = new Action(BuildResultEditorMessages.AbstractDownloadsPage_ADD_LINK_BUTTON_LABEL){

            public void run() {
                AbstractDownloadsPage.this.addFile(true);
            }
        };
    }

    @Override
    protected void doCreatePageContent(Composite parent) {
        this.fToolkit = this.getManagedForm().getToolkit();
        this.fToolkit.setBorderStyle(2048);
        GridDataFactory.fillDefaults().grab(true, true).minSize(400, 0).applyTo((Control)parent);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(parent);
        this.createDownloadsSection(parent);
        this.createContextMenu(CONTEXT_MENU_ID, (IWorkbenchPartSite)this.fEditor.getEditorSite());
        if (this.fContributionsToAdd != null) {
            this.fContributionsToAdd.clear();
        }
        if (this.fContributionsToRemove != null) {
            this.fContributionsToRemove.clear();
        }
    }

    @Override
    protected Viewer getViewer() {
        return this.fTreeViewer;
    }

    protected abstract String getSectionTitle();

    protected final void createDownloadsSection(Composite parent) {
        Section section = this.fToolkit.createSection(parent, 256);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 0).applyTo((Control)section);
        section.setText(this.getSectionTitle());
        Composite treeComposite = this.createLinks(parent);
        GridDataFactory.fillDefaults().grab(true, true).indent(0, 9).hint(300, 150).applyTo((Control)treeComposite);
        Composite buttonsComposite = this.createButtons(parent);
        GridDataFactory.fillDefaults().grab(false, true).indent(0, 9).applyTo((Control)buttonsComposite);
        ToolBar toolbar = this.createToolbar(this.fToolkit, (Composite)section);
        section.setTextClient((Control)toolbar);
        this.populateToolbar(toolbar);
    }

    protected void populateToolbar(ToolBar toolbar) {
    }

    protected KeyListener getKeyListener() {
        return new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 127) {
                    AbstractDownloadsPage.this.removeSelection((ISelection)AbstractDownloadsPage.this.getTreeViewerSelection());
                }
            }
        };
    }

    protected SelectionListener getSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractDownloadsPage.this.updateEnablement();
            }
        };
    }

    protected void updateEnablement() {
        IStructuredSelection selection = this.getTreeViewerSelection();
        boolean isSingleSelection = selection.size() == 1;
        boolean openSaveEnabled = false;
        boolean editEnabled = false;
        if (isSingleSelection && selection.getFirstElement() instanceof DownloadContributionNode) {
            editEnabled = true;
            DownloadContributionNode node = (DownloadContributionNode)selection.getFirstElement();
            openSaveEnabled = node.isExternalArtifact() || node.getContribution().getExtendedContributionData() != null;
        }
        this.fOpenButton.setEnabled(openSaveEnabled);
        this.fSaveButton.setEnabled(openSaveEnabled);
        this.fEditButton.setEnabled(editEnabled);
        this.fEditAction.setEnabled(editEnabled);
        boolean selectionIncludesContributionNodes = this.currentSelectionIncludesContributionNodes();
        this.fRemoveButton.setEnabled(selectionIncludesContributionNodes);
        this.fRemoveAction.setEnabled(selectionIncludesContributionNodes);
    }

    protected Composite createLinks(Composite composite) {
        Composite treeComposite = this.fToolkit.createComposite(composite);
        PatternFilter patternFilter = new PatternFilter(){

            protected boolean isLeafMatch(Viewer viewer, Object element) {
                TreeViewer treeViewer = (TreeViewer)viewer;
                DownloadsLabelProvider labelProvider = (DownloadsLabelProvider)treeViewer.getLabelProvider();
                int numColumns = treeViewer.getTree().getColumnCount();
                int i = 0;
                while (i < numColumns) {
                    String label = labelProvider.getColumnText(element, i);
                    if (this.wordMatches(label)) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
        };
        patternFilter.setIncludeLeadingWildcard(true);
        this.fFilteredTree = this.createFilteredTree(treeComposite, 0x10002 | this.fToolkit.getBorderStyle() | this.fToolkit.getOrientation(), patternFilter, true);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fFilteredTree);
        this.fTree = this.fFilteredTree.getViewer().getTree();
        this.fToolkit.adapt((Control)this.fTree, false, false);
        this.fToolkit.adapt((Control)this.fFilteredTree, false, false);
        this.fTree.setHeaderVisible(true);
        this.fTree.setLinesVisible(true);
        this.fTree.setLayoutData((Object)new GridData(1808));
        this.fTree.addKeyListener(this.getKeyListener());
        this.fTree.addSelectionListener(this.getSelectionListener());
        this.fTreeViewer = this.fFilteredTree.getViewer();
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new DownloadsLabelProvider());
        this.fTreeViewer.setContentProvider((IContentProvider)new BuildContentProvider());
        this.fTreeViewer.setComparator((ViewerComparator)new BuildResultsTreeViewerComparator());
        this.fTreeViewer.setComparer(new IElementComparer(){

            public int hashCode(Object element) {
                return System.identityHashCode(element);
            }

            public boolean equals(Object a, Object b) {
                return a == b;
            }
        });
        this.fTreeViewer.addOpenListener(this.getOpenListener());
        new ColumnAwareTooltipSupport((Control)this.fTree, true, false);
        TreeColumnLayout treeColumnLayout = new TreeColumnLayout();
        this.createTreeColumn(this.fTree, treeColumnLayout, BuildResultEditorMessages.AbstractDownloadsPage_FILE_NAME_COLUMN_HEADER, 30, 0, 0);
        this.createTreeColumn(this.fTree, treeColumnLayout, BuildResultEditorMessages.AbstractDownloadsPage_DESCRIPTION_COLUMN_HEADER, 50, 0, 1);
        this.createTreeColumn(this.fTree, treeColumnLayout, BuildResultEditorMessages.AbstractDownloadsPage_FILE_SIZE_COLUMN_HEADER, 20, 131072, 2);
        this.createTreeColumn(this.fTree, treeColumnLayout, BuildResultEditorMessages.AbstractDownloadsPage_CONTRIBUTED_TIME_HEADER, 20, 131072, 3);
        this.fTree.getParent().setLayout((Layout)treeColumnLayout);
        treeComposite.setLayout((Layout)new GridLayout(1, false));
        int sortColumnIndex = this.getSortColumnFromName(this.fSortColumn);
        this.fTree.setSortColumn(this.fTree.getColumn(sortColumnIndex));
        this.fTree.setSortDirection(this.fSortDirection);
        this.fRootNode = new DownloadsRootNode(this.getContributions(), this.getBuildResultContext().getTeamRepository());
        this.fTreeViewer.setInput((Object)this.fRootNode);
        return treeComposite;
    }

    protected FilteredTree createFilteredTree(Composite parent, int style, PatternFilter patternFilter, boolean useNewLook) {
        return new FilteredTree(parent, style, patternFilter, useNewLook);
    }

    private int getSortColumnFromName(String sortColumn) {
        if (sortColumn.equals(BuildResultEditorMessages.AbstractDownloadsPage_FILE_NAME_COLUMN_HEADER)) {
            return 0;
        }
        if (sortColumn.equals(BuildResultEditorMessages.AbstractDownloadsPage_DESCRIPTION_COLUMN_HEADER)) {
            return 1;
        }
        if (sortColumn.equals(BuildResultEditorMessages.AbstractDownloadsPage_FILE_SIZE_COLUMN_HEADER)) {
            return 2;
        }
        if (sortColumn.equals(BuildResultEditorMessages.AbstractDownloadsPage_CONTRIBUTED_TIME_HEADER)) {
            return 3;
        }
        return 0;
    }

    protected void createTreeColumn(Tree tree, TreeColumnLayout treeColumnLayout, String columnName, int weight, int style, int index) {
        TreeColumn treeColumn = new TreeColumn(tree, style, index);
        treeColumn.setText(columnName);
        treeColumn.addSelectionListener(this.getColumnSelectionListener(tree, treeColumn));
        treeColumnLayout.setColumnData((Widget)treeColumn, (ColumnLayoutData)new ColumnWeightData(weight));
    }

    protected IOpenListener getOpenListener() {
        return new IOpenListener(){

            public void open(OpenEvent event) {
                DownloadContributionNode node;
                Object element;
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.size() == 1 && (element = selection.getFirstElement()) instanceof DownloadContributionNode && ((node = (DownloadContributionNode)selection.getFirstElement()).isExternalArtifact() || node.getContribution().getExtendedContributionData() != null)) {
                    AbstractDownloadsPage.this.openSaveSelection(event.getSelection(), false);
                }
            }
        };
    }

    protected Composite createButtons(Composite parent) {
        Composite buttonComposite = this.getFormToolkit().createComposite(parent);
        buttonComposite.setLayout((Layout)new GridLayout());
        this.fOpenButton = this.createButton(buttonComposite, BuildResultEditorMessages.AbstractDownloadsPage_OPEN_BUTTON_LABEL, false, this.getOpenButtonListener());
        this.fSaveButton = this.createButton(buttonComposite, BuildResultEditorMessages.AbstractDownloadsPage_SAVE_AS_BUTTON_LABEL, false, this.getSaveButtonListener());
        int spacerHeight = 15;
        Label spacer = this.getFormToolkit().createLabel(buttonComposite, "");
        spacer.setLayoutData((Object)new GridData(-1, spacerHeight));
        this.fAddFileButton = this.createButton(buttonComposite, BuildResultEditorMessages.AbstractDownloadsPage_ADD_FILE_BUTTON_LABEL, true, this.getAddFileButtonListener(false));
        this.fAddLinkButton = this.createButton(buttonComposite, BuildResultEditorMessages.AbstractDownloadsPage_ADD_LINK_BUTTON_LABEL, true, this.getAddFileButtonListener(true));
        spacer = this.getFormToolkit().createLabel(buttonComposite, "");
        spacer.setLayoutData((Object)new GridData(-1, spacerHeight));
        this.fEditButton = this.createButton(buttonComposite, BuildResultEditorMessages.AbstractDownloadsPage_EDIT_BUTTON_LABEL, false, this.getEditButtonListener());
        this.fRemoveButton = this.createButton(buttonComposite, BuildResultEditorMessages.AbstractDownloadsPage_REMOVE_BUTTON_LABEL, false, this.getRemoveButtonListener());
        return buttonComposite;
    }

    protected Button createButton(Composite parent, String label, boolean enabled, SelectionListener listener) {
        Button button = this.getFormToolkit().createButton(parent, label, 8);
        GridDataFactory.fillDefaults().applyTo((Control)button);
        button.setEnabled(enabled);
        button.addSelectionListener(listener);
        return button;
    }

    protected void openSaveSelection(ISelection selection, boolean save) {
        IObjectActionDelegate actionDelegate = save ? this.fSaveActionDelegate : this.fOpenActionDelegate;
        actionDelegate.selectionChanged(null, selection);
        actionDelegate.setActivePart(null, (IWorkbenchPart)this.fEditor);
        actionDelegate.run(null);
    }

    protected IStructuredSelection getTreeViewerSelection() {
        return (IStructuredSelection)this.fTreeViewer.getSelection();
    }

    protected SelectionListener getOpenButtonListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractDownloadsPage.this.openSaveSelection((ISelection)AbstractDownloadsPage.this.getTreeViewerSelection(), false);
            }
        };
    }

    protected SelectionListener getSaveButtonListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractDownloadsPage.this.openSaveSelection((ISelection)AbstractDownloadsPage.this.getTreeViewerSelection(), true);
            }
        };
    }

    protected SelectionListener getAddFileButtonListener(final boolean isLink) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractDownloadsPage.this.addFile(isLink);
            }
        };
    }

    protected SelectionListener getEditButtonListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractDownloadsPage.this.editSelection((ISelection)AbstractDownloadsPage.this.getTreeViewerSelection());
            }
        };
    }

    protected SelectionListener getRemoveButtonListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractDownloadsPage.this.removeSelection((ISelection)AbstractDownloadsPage.this.getTreeViewerSelection());
            }
        };
    }

    protected void removeSelection(ISelection selection) {
        Object[] nodes;
        Object[] objectArray = nodes = ((IStructuredSelection)selection).toArray();
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof DownloadContributionNode) {
                this.addContributionToBeRemoved((DownloadContributionNode)object);
            }
            ++n2;
        }
    }

    protected boolean promptUserToEditFile(BuildResultAttachmentFileDialog addFileDialog) {
        return addFileDialog.open() == 0 && addFileDialog.isDirty();
    }

    protected void editSelection(ISelection selection) {
        DownloadContributionNode node = (DownloadContributionNode)((IStructuredSelection)selection).getFirstElement();
        IBuildResultContribution contribution = node.getContribution();
        BuildResultAttachmentFileDialog editFileDialog = null;
        boolean isLink = node.isExternalArtifact();
        boolean isNewFile = false;
        if (isLink) {
            editFileDialog = this.createEditLinkDialog(node.getFileURL(), contribution.getLabel(), contribution.getComponentName());
        } else {
            IContent content = contribution.getExtendedContributionData();
            String filePath = contribution.getExtendedContributionProperty(IBuildResultContribution.PROPERTY_NAME_FILE_PATH);
            if (filePath == null) {
                filePath = node.getFileName();
            }
            if (content == null) {
                isNewFile = true;
                String contentType = this.getContentType(contribution);
                String characterEncoding = this.getCharacterEncoding(contribution);
                editFileDialog = this.createEditFileDialog(filePath, contribution.getLabel(), contribution.getComponentName(), contentType, characterEncoding, false);
            } else {
                editFileDialog = this.createEditFileDialog(filePath, contribution.getLabel(), contribution.getComponentName(), content.getContentType(), content.getCharacterEncoding(), true);
            }
        }
        if (this.promptUserToEditFile(editFileDialog)) {
            this.addContributionToBeRemoved(node);
            if (isLink) {
                String linkSize = contribution.getExtendedContributionProperty(IBuildResultContribution.PROPERTY_NAME_FILE_SIZE);
                if (!node.getFileURL().equals(editFileDialog.getFilePath())) {
                    linkSize = null;
                }
                this.addLinkContribution(editFileDialog.getFilePath(), editFileDialog.getFileDescription(), editFileDialog.getComponentName(), linkSize);
            } else {
                this.addFileContribution(editFileDialog.getFilePath(), editFileDialog.getFileDescription(), editFileDialog.getComponentName(), editFileDialog.getContentType(), editFileDialog.getCharacterEncoding(), contribution, isNewFile || editFileDialog.isFilePathChanged());
            }
        }
    }

    protected boolean promptUserToAddFile(BuildResultAttachmentFileDialog addFileDialog) {
        return addFileDialog.open() == 0;
    }

    protected void addFile(boolean isLink) {
        BuildResultAttachmentFileDialog addFileDialog = this.createAddFileDialog(isLink, this.getSelectedComponent());
        if (this.promptUserToAddFile(addFileDialog)) {
            if (isLink) {
                this.addLinkContribution(addFileDialog.getFilePath(), addFileDialog.getFileDescription(), addFileDialog.getComponentName(), null);
            } else {
                this.addFileContribution(addFileDialog.getFilePath(), addFileDialog.getFileDescription(), addFileDialog.getComponentName(), addFileDialog.getContentType(), addFileDialog.getCharacterEncoding(), null, true);
            }
        }
    }

    protected String getSelectedComponent() {
        IStructuredSelection selection = this.getTreeViewerSelection();
        String componentName = null;
        if (selection.size() == 1 && selection.getFirstElement() instanceof DownloadsComponentNode && (componentName = ((DownloadsComponentNode)selection.getFirstElement()).getNodeName()).equals(BuildResultEditorMessages.NO_COMPONENT_LABEL)) {
            componentName = null;
        }
        return componentName;
    }

    protected BuildResultAttachmentFileDialog createAddFileDialog(boolean isLink, String componentName) {
        if (isLink) {
            return BuildResultAttachmentFileDialog.createAddLinkDialog(this.getEditorSite().getShell(), componentName);
        }
        return BuildResultAttachmentFileDialog.createAddFileDialog(this.getEditorSite().getShell(), componentName);
    }

    protected BuildResultAttachmentFileDialog createEditFileDialog(String filePath, String fileDescription, String componentName, String contentType, String characterEncoding, boolean isSaved) {
        return BuildResultAttachmentFileDialog.createEditFileDialog(this.getEditorSite().getShell(), filePath, fileDescription, componentName, contentType, characterEncoding, isSaved);
    }

    protected BuildResultAttachmentFileDialog createEditLinkDialog(String filePath, String fileDescription, String componentName) {
        return BuildResultAttachmentFileDialog.createEditLinkDialog(this.getEditorSite().getShell(), filePath, fileDescription, componentName);
    }

    protected void addFileContribution(String filePath, String fileDescription, String componentName, String contentType, String characterEncoding, IBuildResultContribution source, boolean isNewFile) {
        IBuildResultContribution fileContribution = BuildItemFactory.createBuildResultContribution();
        File file = new File(filePath);
        String fileName = file.getName();
        if (isNewFile) {
            fileContribution.setExtendedContributionProperty(IBuildResultContribution.PROPERTY_NAME_FILE_PATH, filePath);
            fileContribution.setExtendedContributionProperty(IBuildResultContribution.PROPERTY_NAME_FILE_SIZE, Long.toString(file.length()));
        } else {
            fileContribution.setExtendedContributionProperty(IBuildResultContribution.PROPERTY_NAME_FILE_SIZE, source.getExtendedContributionProperty(IBuildResultContribution.PROPERTY_NAME_FILE_SIZE));
            fileContribution.setExtendedContributionData(source.getExtendedContributionData());
        }
        fileContribution.setExtendedContributionProperty(IBuildResultContribution.PROPERTY_NAME_FILE_NAME, fileName);
        fileContribution.setLabel(fileDescription.length() != 0 ? fileDescription : fileName);
        fileContribution.setImpactsPrimaryResult(true);
        fileContribution.setExtendedContributionTypeId(this.getPageContributionTypeId());
        this.storeContentType(contentType, fileContribution);
        this.storeCharacterEncoding(characterEncoding, fileContribution);
        if (componentName.length() > 0) {
            fileContribution.setComponentName(componentName);
        }
        this.addContributionToBeAdded(fileContribution);
    }

    protected void addLinkContribution(String url, String fileDescription, String componentName, String linkSize) {
        IBuildResultContribution linkContribution = BuildItemFactory.createBuildResultContribution();
        String label = fileDescription.length() != 0 ? fileDescription : url;
        linkContribution.setLabel(label);
        linkContribution.setImpactsPrimaryResult(true);
        linkContribution.setExtendedContributionTypeId(this.getPageContributionTypeId());
        if (linkSize != null) {
            linkContribution.setExtendedContributionProperty(IBuildResultContribution.PROPERTY_NAME_FILE_SIZE, linkSize);
        }
        if (componentName.length() > 0) {
            linkContribution.setComponentName(componentName);
        }
        linkContribution.setExtendedContributionProperty(IBuildResultContribution.PROPERTY_NAME_URL, url);
        this.addContributionToBeAdded(linkContribution);
    }

    protected void addContributionToBeAdded(IBuildResultContribution contribution) {
        if (this.fContributionsToAdd == null) {
            this.fContributionsToAdd = new LinkedList<IBuildResultContribution>();
        }
        this.fContributionsToAdd.add(contribution);
        TreePath newNodePath = this.fRootNode.addNewContribution(contribution);
        this.fTreeViewer.refresh();
        this.fTreeViewer.setSelection((ISelection)new TreeSelection(newNodePath), true);
        this.updateEnablement();
        this.setDirtyFlag();
    }

    protected void addContributionToBeRemoved(DownloadContributionNode node) {
        if (this.fContributionsToRemove == null) {
            this.fContributionsToRemove = new LinkedList<IBuildResultContribution>();
        }
        if (this.fContributionsToAdd == null || !this.fContributionsToAdd.remove(node.getContribution())) {
            this.fContributionsToRemove.add(node.getContribution());
        }
        this.fRootNode.removeContribution(node);
        this.fTreeViewer.refresh();
        this.updateEnablement();
        this.setDirtyFlag();
    }

    @Override
    public void saveContributions(IProgressMonitor monitor) throws TeamRepositoryException {
        if (!(this.fContributionsToAdd != null && this.fContributionsToAdd.size() != 0 || this.fContributionsToRemove != null && this.fContributionsToRemove.size() != 0)) {
            return;
        }
        int ticks = this.fContributionsToAdd == null || this.fContributionsToAdd.size() == 0 ? 0 : this.fContributionsToAdd.size() + 1;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)BuildResultEditorMessages.AbstractDownloadsPage_SAVING_CONTRIBUTIONS, (int)(ticks += this.fContributionsToRemove == null ? 0 : 1));
        ITeamRepository teamRepository = this.getBuildResultContext().getTeamRepository();
        if (this.fContributionsToAdd != null && this.fContributionsToAdd.size() > 0) {
            for (IBuildResultContribution contribution : this.fContributionsToAdd) {
                String fileName;
                SubMonitor child = subMonitor.newChild(1, 0);
                if (contribution.getExtendedContributionData() != null || (fileName = contribution.getExtendedContributionProperty(IBuildResultContribution.PROPERTY_NAME_FILE_PATH)) == null) continue;
                FileInputStream inputStream = null;
                try {
                    try {
                        inputStream = new FileInputStream(fileName);
                        child.setTaskName(NLS.bind((String)BuildResultEditorMessages.AbstractDownloadsPage_SAVING_CONTRIBUTION_X, (Object)contribution.getLabel()));
                        String contentType = this.getContentType(contribution);
                        if (contentType == null) {
                            contentType = ContentUtil.getContentTypeFromFileName((String)fileName);
                        }
                        String characterEncoding = this.getCharacterEncoding(contribution);
                        if (contentType != null) {
                            if (ContentUtil.isTextContentType((String)contentType) && characterEncoding == null) {
                                characterEncoding = Charset.defaultCharset().name();
                            }
                        } else {
                            contentType = "application/unknown";
                        }
                        IContent content = null;
                        if (characterEncoding != null) {
                            content = teamRepository.contentManager().storeText(contentType, characterEncoding, LineDelimiter.LINE_DELIMITER_NONE, (InputStream)inputStream, null, (IProgressMonitor)child);
                            contribution.setExtendedContributionProperty(IBuildResultContribution.PROPERTY_NAME_FILE_SIZE, Long.toString(content.getRawLength()));
                        } else {
                            content = teamRepository.contentManager().storeContent(contentType, null, LineDelimiter.LINE_DELIMITER_NONE, (InputStream)new FileInputStream(fileName), null, (IProgressMonitor)child);
                        }
                        contribution.setExtendedContributionData(content);
                    }
                    catch (IOException exception) {
                        throw new TeamBuildException((Throwable)exception);
                    }
                }
                finally {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            ClientFactory.getTeamBuildClient((ITeamRepository)teamRepository).addBuildResultContributions((IBuildResultHandle)this.getBuildResult(), this.fContributionsToAdd.toArray(new IBuildResultContribution[this.fContributionsToAdd.size()]), IBuildResult.PROPERTIES_COMPLETE, (IProgressMonitor)subMonitor.newChild(1, 0));
        }
        if (this.fContributionsToRemove != null && this.fContributionsToRemove.size() > 0) {
            ClientFactory.getTeamBuildClient((ITeamRepository)teamRepository).deleteBuildResultContributions((IBuildResultHandle)this.getBuildResult(), this.fContributionsToRemove.toArray(new IBuildResultContribution[this.fContributionsToRemove.size()]), (IProgressMonitor)subMonitor.newChild(1, 0));
        }
        if (this.fContributionsToAdd != null) {
            this.fContributionsToAdd.clear();
        }
        if (this.fContributionsToRemove != null) {
            this.fContributionsToRemove.clear();
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                AbstractDownloadsPage.this.updateEnablement();
            }
        });
    }

    protected String getContentType(IBuildResultContribution contribution) {
        if (this.fContentTypes != null) {
            return this.fContentTypes.get(contribution);
        }
        return null;
    }

    protected String getCharacterEncoding(IBuildResultContribution contribution) {
        if (this.fCharacterEncodings != null) {
            return this.fCharacterEncodings.get(contribution);
        }
        return null;
    }

    protected void storeContentType(String contentType, IBuildResultContribution contribution) {
        if (contentType == null || contentType.length() == 0) {
            return;
        }
        if (this.fContentTypes == null) {
            this.fContentTypes = new Hashtable<IBuildResultContribution, String>();
        }
        this.fContentTypes.put(contribution, contentType);
    }

    protected void storeCharacterEncoding(String characterEncoding, IBuildResultContribution contribution) {
        if (characterEncoding == null || characterEncoding.length() == 0) {
            return;
        }
        if (this.fCharacterEncodings == null) {
            this.fCharacterEncodings = new Hashtable<IBuildResultContribution, String>();
        }
        this.fCharacterEncodings.put(contribution, characterEncoding);
    }

    @Override
    public void postSave() {
        if (!this.isDirty() && this.fTreeViewer != null) {
            this.fRootNode.resetBuildResultContributions(this.getContributions());
            this.fTreeViewer.refresh();
        }
    }

    protected boolean currentSelectionIncludesContributionNodes() {
        boolean selectionIncludesContributionNodes = false;
        IStructuredSelection selection = this.getTreeViewerSelection();
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object node = objectArray[n2];
            if (node instanceof DownloadContributionNode) {
                selectionIncludesContributionNodes = true;
            }
            ++n2;
        }
        return selectionIncludesContributionNodes;
    }

    @Override
    protected BuildResultPage.CopyStrategy getCopyStrategy(Control control) {
        return BuildResultPage.CopyStrategy.DEFAULT;
    }

    @Override
    protected boolean addActionsToContextMenu(IMenuManager manager) {
        if (this.currentSelectionIncludesContributionNodes()) {
            manager.add(this.fEditAction);
            manager.add(this.fRemoveAction);
            manager.add((IContributionItem)new Separator());
        }
        manager.add(this.fAddFileAction);
        manager.add(this.fAddLinkAction);
        return true;
    }

    protected abstract String getPageContributionTypeId();

    protected FormEditor getFormEditor() {
        return this.fEditor;
    }

    protected FormToolkit getFormToolkit() {
        return this.fToolkit;
    }

    @Override
    protected SelectionListener getColumnSelectionListener(final Tree tree, final TreeColumn treeColumn) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (tree.getSortColumn() == treeColumn) {
                    if (tree.getSortDirection() == 1024) {
                        tree.setSortDirection(128);
                    } else {
                        tree.setSortDirection(1024);
                    }
                } else {
                    tree.setSortColumn(treeColumn);
                    tree.setSortDirection(1024);
                }
                AbstractDownloadsPage.this.fSortColumn = tree.getSortColumn().getText();
                AbstractDownloadsPage.this.fSortDirection = tree.getSortDirection();
                AbstractDownloadsPage.this.fNode.put("com.ibm.team.build.internal.ui.editors.sort.column", AbstractDownloadsPage.this.fSortColumn);
                AbstractDownloadsPage.this.fNode.put("com.ibm.team.build.internal.ui.editors.sort.direction", Integer.toString(AbstractDownloadsPage.this.fSortDirection));
                try {
                    AbstractDownloadsPage.this.fNode.flush();
                }
                catch (BackingStoreException backingStoreException) {
                    // empty catch block
                }
                TreeViewer viewer = (TreeViewer)AbstractDownloadsPage.this.getViewer();
                Object[] expandedElements = viewer.getExpandedElements();
                viewer.refresh(false);
                viewer.setExpandedElements(expandedElements);
            }
        };
    }
}

