/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.result.activities;

import com.ibm.team.build.common.model.BuildState;
import com.ibm.team.build.common.model.IBuildActivity;
import com.ibm.team.build.internal.common.helper.TimeFormatHelper;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.BuildCompositeImageRegistry;
import com.ibm.team.build.internal.ui.editors.result.IBuildTreeNode;
import com.ibm.team.build.internal.ui.editors.result.activities.Messages;
import com.ibm.team.build.ui.editors.result.IBuildResultContext;
import org.eclipse.swt.graphics.Image;

public class BuildActivityNode
implements IBuildTreeNode {
    private IBuildTreeNode fParentNode;
    private IBuildActivity fBuildActivity;
    private IBuildResultContext fBuildResultContext;
    private Object[] fChildren;
    private Image fImage;

    public BuildActivityNode(IBuildTreeNode parentNode, IBuildActivity buildActivity, IBuildResultContext buildResultContext) {
        ValidationHelper.validateNotNull((String)"parentNode", (Object)parentNode);
        ValidationHelper.validateNotNull((String)"buildActivity", (Object)buildActivity);
        this.fBuildActivity = buildActivity;
        this.fParentNode = parentNode;
        this.fBuildResultContext = buildResultContext;
    }

    @Override
    public Object[] getChildren() {
        if (this.fChildren == null && this.fBuildActivity.getChildActivityIds().size() > 0) {
            IBuildActivity[] childActivities = this.fBuildActivity.getChildActivities();
            this.fChildren = new Object[childActivities.length];
            int i = 0;
            while (i < this.fChildren.length) {
                this.fChildren[i] = new BuildActivityNode(this, childActivities[i], this.fBuildResultContext);
                ++i;
            }
        }
        return this.fChildren;
    }

    @Override
    public IBuildTreeNode getParentNode() {
        return this.fParentNode;
    }

    @Override
    public Image getColumnImage(int columnIndex) {
        Image image = null;
        if (columnIndex == 0) {
            if (this.fImage == null) {
                BuildState state = BuildState.COMPLETED;
                if (!this.fBuildActivity.isComplete()) {
                    state = this.fBuildResultContext.getBuildResult().getState() == BuildState.IN_PROGRESS ? BuildState.IN_PROGRESS : BuildState.INCOMPLETE;
                }
                this.fImage = BuildCompositeImageRegistry.getBuildActivityImage(state);
            }
            image = this.fImage;
        }
        return image;
    }

    @Override
    public String getColumnText(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.fBuildActivity.getLabel();
            }
            case 1: {
                return TimeFormatHelper.formatStopwatchTime((long)this.fBuildActivity.getStartTime());
            }
            case 2: {
                if (this.fBuildActivity.isComplete()) {
                    return TimeFormatHelper.formatAbbreviatedTime((long)this.fBuildActivity.getTimeTaken(), (boolean)false);
                }
                if (this.fBuildResultContext.getBuildResult().getState() == BuildState.IN_PROGRESS) {
                    long buildStartTime;
                    long currentTime = System.currentTimeMillis();
                    long buildDuration = currentTime > (buildStartTime = this.fBuildResultContext.getBuildResult().getBuildStartTime()) ? currentTime - buildStartTime : 0L;
                    long activityStartTime = this.fBuildActivity.getStartTime();
                    long activityDuration = buildDuration > activityStartTime ? buildDuration - activityStartTime : 0L;
                    return TimeFormatHelper.formatAbbreviatedTime((long)activityDuration, (boolean)false);
                }
                return Messages.BuildActivityNode_INCOMPLETE_ACTIVITY_DURATION_MESSAGE;
            }
        }
        return null;
    }

    @Override
    public Long getColumnAsLong(int columnIndex) {
        switch (columnIndex) {
            case 1: {
                return this.fBuildActivity.getStartTime();
            }
            case 2: {
                if (this.fBuildActivity.isComplete()) {
                    return this.fBuildActivity.getTimeTaken();
                }
                if (this.fBuildResultContext.getBuildResult().getState() == BuildState.IN_PROGRESS) {
                    long buildStartTime;
                    long currentTime = System.currentTimeMillis();
                    long buildDuration = currentTime > (buildStartTime = this.fBuildResultContext.getBuildResult().getBuildStartTime()) ? currentTime - buildStartTime : 0L;
                    long activityStartTime = this.fBuildActivity.getStartTime();
                    long activityDuration = buildDuration > activityStartTime ? buildDuration - activityStartTime : 0L;
                    return activityDuration;
                }
                return 0L;
            }
        }
        return null;
    }

    @Override
    public String getNodeName() {
        return this.fBuildActivity.getLabel();
    }

    public boolean isActivityComplete() {
        return this.fBuildActivity.isComplete();
    }
}

