/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.result.activities;

import com.ibm.team.build.common.model.BuildState;
import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildActivity;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.BuildCompositeImageRegistry;
import com.ibm.team.build.internal.ui.editors.result.BuildContentProvider;
import com.ibm.team.build.internal.ui.editors.result.BuildLabelProvider;
import com.ibm.team.build.internal.ui.editors.result.BuildResultPage;
import com.ibm.team.build.internal.ui.editors.result.BuildResultsTreeViewerComparator;
import com.ibm.team.build.internal.ui.editors.result.activities.BuildActivitiesRootNode;
import com.ibm.team.build.internal.ui.editors.result.activities.BuildActivityNode;
import com.ibm.team.build.internal.ui.editors.result.activities.Messages;
import com.ibm.team.build.ui.editors.result.AbstractBuildResultPage;
import com.ibm.team.build.ui.editors.result.IBuildResultContext;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class BuildActivitiesPage
extends BuildResultPage {
    public static final String CONTEXT_MENU_ID = "com.ibm.team.build.ui.buildActivitiesPageContextMenu";
    public static final int START_TIME_COLUMN_INDEX = 1;
    public static final int DURATION_COLUMN_INDEX = 2;
    private IBuildActivity[] fBuildActivities;
    protected BuildActivitiesRootNode fRootNode;
    protected TreeViewer fViewer;
    protected Tree fBuildActivitiesTree;
    protected boolean fShowCompletedActivities = true;
    protected ViewerFilter fCompletedActivitiesFilter = new ViewerFilter(){

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof BuildActivityNode) {
                BuildActivityNode node = (BuildActivityNode)element;
                return !node.isActivityComplete();
            }
            return false;
        }
    };

    public BuildActivitiesPage(FormEditor editor, String id, String title, IBuildResultContext buildResultContext, IBuildActivity[] buildActivities) {
        super(editor, id, title, new String[0], buildResultContext);
        this.fBuildActivities = buildActivities;
    }

    @Override
    public AbstractBuildResultPage.PageGroup getPageGroup() {
        return AbstractBuildResultPage.PageGroup.ACTIVITIES;
    }

    @Override
    protected BuildStatus getPageStatus() {
        if (this.getBuildResult().getState() == BuildState.COMPLETED && this.incompleteActivities(this.fBuildActivities)) {
            return BuildStatus.WARNING;
        }
        return BuildStatus.OK;
    }

    private boolean incompleteActivities(IBuildActivity[] buildActivities) {
        IBuildActivity[] iBuildActivityArray = buildActivities;
        int n = buildActivities.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildActivity activity = iBuildActivityArray[n2];
            boolean incompleteActivityFound = !activity.isComplete() ? true : this.incompleteActivities(activity.getChildActivities());
            if (incompleteActivityFound) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void setBuildActivities(IBuildActivity[] buildActivities) {
        ValidationHelper.validateNotNull((String)"buildActivities", (Object[])buildActivities);
        this.fBuildActivities = buildActivities;
    }

    @Override
    protected void doCreatePageContent(Composite parent) {
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        toolkit.setBorderStyle(2048);
        GridLayoutFactory.fillDefaults().applyTo(parent);
        this.addBuildActivitiesTree(parent, toolkit);
        this.createContextMenu(CONTEXT_MENU_ID, this.getSite());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.team.build.ui.editorpage_buildresultactivities");
    }

    private void addBuildActivitiesTree(Composite body, FormToolkit toolkit) {
        Section section = toolkit.createSection(body, 256);
        section.setText(Messages.BuildActivitiesPage_ACTIVITIES_SECTION_TITLE);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)section);
        ToolBar toolbar = this.createToolbar(toolkit, (Composite)section);
        section.setTextClient((Control)toolbar);
        Composite treeComposite = toolkit.createComposite(body);
        GridDataFactory.fillDefaults().grab(true, true).hint(300, 150).applyTo((Control)treeComposite);
        this.fBuildActivitiesTree = toolkit.createTree(treeComposite, 67586);
        this.fBuildActivitiesTree.setLinesVisible(true);
        this.fBuildActivitiesTree.setHeaderVisible(true);
        TreeColumnLayout treeColumnLayout = new TreeColumnLayout();
        this.createTreeColumn(this.fBuildActivitiesTree, treeColumnLayout, Messages.BuildActivitiesPage_ACTIVITY_LABEL_COLUMN_TITLE, 70, 16384, 0, Messages.BuildActivitiesPage_ACTIVITY_LABEL_COLUMN_TOOLTIP);
        this.createTreeColumn(this.fBuildActivitiesTree, treeColumnLayout, Messages.BuildActivitiesPage_ACTIVITY_START_TIME_COLUMN_TITLE, 15, 131072, 1, Messages.BuildActivitiesPage_ACTIVITY_START_TIME_COLUMN_TOOLTIP);
        this.createTreeColumn(this.fBuildActivitiesTree, treeColumnLayout, Messages.BuildActivitiesPage_ACTIVITY_DURATION_COLUMN_TITLE, 15, 131072, 2, Messages.BuildActivitiesPage_ACTIVITY_DURATION_COLUMN_TOOLTIP);
        treeComposite.setLayout((Layout)treeColumnLayout);
        this.fViewer = new TreeViewer(this.fBuildActivitiesTree);
        this.fViewer.setLabelProvider((IBaseLabelProvider)new BuildLabelProvider());
        this.fViewer.setContentProvider((IContentProvider)new BuildContentProvider());
        this.fViewer.setComparator((ViewerComparator)new BuildResultsTreeViewerComparator());
        TreeColumn startTimeColumn = this.fViewer.getTree().getColumn(1);
        this.fViewer.getTree().setSortColumn(startTimeColumn);
        this.fViewer.getTree().setSortDirection(128);
        Image showCompletedActivitiesIcon = BuildCompositeImageRegistry.getBuildActivityImage(BuildState.COMPLETED);
        this.createFilterButton(showCompletedActivitiesIcon, Messages.BuildActivitiesPage_FILTER_BUTTON_LABEL, toolbar, this.fCompletedActivitiesFilter, (StructuredViewer)this.fViewer, this.fShowCompletedActivities);
        this.fRootNode = new BuildActivitiesRootNode(this.fBuildActivities, this.getBuildResultContext());
        this.fViewer.setInput((Object)this.fRootNode);
    }

    @Override
    protected void toggleFilter(boolean buttonSelected, StructuredViewer viewer, ViewerFilter filter) {
        this.fShowCompletedActivities = buttonSelected;
        super.toggleFilter(buttonSelected, viewer, filter);
    }

    @Override
    protected Viewer getViewer() {
        return this.fViewer;
    }

    protected TreeColumn createTreeColumn(Tree tree, TreeColumnLayout treeColumnLayout, String columnName, int weight, int style, int index, String tooltip) {
        TreeColumn treeColumn = new TreeColumn(tree, style, index);
        treeColumn.setText(columnName);
        treeColumn.addSelectionListener(this.getColumnSelectionListener(tree, treeColumn));
        treeColumn.setToolTipText(tooltip);
        treeColumnLayout.setColumnData((Widget)treeColumn, (ColumnLayoutData)new ColumnWeightData(weight));
        return treeColumn;
    }

    @Override
    protected String getContextHelpId() {
        return "com.ibm.team.build.ui.editorpage_buildresultactivities";
    }
}

