/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.result.activities;

import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.common.model.BuildState;
import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildActivity;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.internal.ui.editors.result.activities.BuildActivitiesPage;
import com.ibm.team.build.internal.ui.editors.result.activities.Messages;
import com.ibm.team.build.ui.editors.result.AbstractBuildResultContributionProvider;
import com.ibm.team.build.ui.editors.result.AbstractBuildResultPage;
import com.ibm.team.build.ui.editors.result.IBuildResultContext;
import com.ibm.team.repository.client.ITeamRepository;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.forms.editor.FormEditor;

public class BuildActivitiesContributionProvider
extends AbstractBuildResultContributionProvider {
    private IBuildActivity[] fBuildActivities;
    private BuildActivitiesPage fActivitiesPage;
    private int fIncompleteActivityCount = 0;

    public BuildActivitiesContributionProvider(FormEditor buildEditor, String id, IBuildResultContext context) {
        super(buildEditor, id, context);
    }

    @Override
    public void initializeContributionProvider(IProgressMonitor monitor) throws Exception {
        this.fBuildActivities = this.getBuildActivities(monitor);
        this.fIncompleteActivityCount = 0;
        if (this.getBuildResultContext().getBuildResult().getState() == BuildState.COMPLETED) {
            this.fIncompleteActivityCount = this.countIncompleteActivities(this.fBuildActivities);
        }
        if (this.fActivitiesPage != null) {
            this.resetActivitiesInBuildActivitiesPage(this.fBuildActivities);
        }
    }

    private int countIncompleteActivities(IBuildActivity[] buildActivities) {
        int numIncomplete = 0;
        IBuildActivity[] iBuildActivityArray = buildActivities;
        int n = buildActivities.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildActivity activity = iBuildActivityArray[n2];
            int numIncompleteChildren = this.countIncompleteActivities(activity.getChildActivities());
            numIncomplete += numIncompleteChildren;
            if (numIncompleteChildren == 0 && !activity.isComplete()) {
                ++numIncomplete;
            }
            ++n2;
        }
        return numIncomplete;
    }

    protected IBuildActivity[] getBuildActivities(IProgressMonitor monitor) throws Exception {
        ITeamRepository teamRepository = this.getBuildResultContext().getTeamRepository();
        ITeamBuildClient teamBuildClient = (ITeamBuildClient)teamRepository.getClientLibrary(ITeamBuildClient.class);
        return teamBuildClient.getBuildActivities((IBuildResultHandle)this.getBuildResultContext().getBuildResult(), monitor);
    }

    protected void resetActivitiesInBuildActivitiesPage(IBuildActivity[] activities) {
        this.fActivitiesPage.setBuildActivities(activities);
    }

    @Override
    public boolean isContributionPresent() {
        return this.fBuildActivities == null ? false : this.fBuildActivities.length > 0;
    }

    @Override
    public BuildStatus getStatus() {
        return this.fIncompleteActivityCount == 0 ? BuildStatus.OK : BuildStatus.WARNING;
    }

    @Override
    public boolean shouldHideSummary() {
        return this.fIncompleteActivityCount == 0;
    }

    @Override
    public String getSummaryTitle() {
        return Messages.BuildActivitiesContributionProvider_SUMMARY_TITLE;
    }

    @Override
    public String getSummaryText() {
        return NLS.bind((String)Messages.BuildActivitiesContributionProvider_SUMMARY_TEXT, (Object)this.fIncompleteActivityCount);
    }

    @Override
    public boolean isSummaryLink() {
        return true;
    }

    @Override
    public void summaryLinkActivated() {
        this.getBuildResultEditor().setActivePage(this.getExtensionId());
    }

    @Override
    public String[] getExtendedContributionIds() {
        return new String[0];
    }

    @Override
    public AbstractBuildResultPage getBuildResultPage() {
        if (this.fActivitiesPage == null) {
            this.fActivitiesPage = new BuildActivitiesPage(this.getBuildResultEditor(), this.getExtensionId(), Messages.BuildActivitiesContributionProvider_PAGE_TITLE, this.getBuildResultContext(), this.fBuildActivities);
        }
        return this.fActivitiesPage;
    }
}

