/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.result;

import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.internal.ui.editors.result.BuildResultEditor;
import com.ibm.team.build.internal.ui.editors.result.BuildResultPage;
import com.ibm.team.build.ui.editors.result.IBuildResultContext;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class InternalBuildResultPage
extends FormPage {
    private Composite fContentContainer;
    private Composite fErrorDetailsArea;
    protected boolean fNeedsContentCreated = true;
    private boolean fDirty = false;
    private boolean fSaveSucceeded = false;
    protected String fPageErrorMessage;
    protected Exception fPageError;
    protected Label fErrorLabel;
    protected Text fErrorDetails;
    protected Button fDetailsButton;
    private final IBuildResultContext fBuildResultContext;
    private final String[] fContributionIds;
    private BuildResultEditor fBuildResultEditor;

    public InternalBuildResultPage(BuildResultEditor editor, String id, String title, String[] contributionIds, IBuildResultContext buildResultContext) {
        super((FormEditor)editor, id, title);
        this.fBuildResultEditor = editor;
        this.fContributionIds = contributionIds;
        this.fBuildResultContext = buildResultContext;
    }

    public void setPageError(String message, Exception exception) {
        this.fPageErrorMessage = message;
        this.fPageError = exception;
    }

    public IBuildResultContext getBuildResultContext() {
        return this.fBuildResultContext;
    }

    protected String[] getContributionIds() {
        return this.fContributionIds;
    }

    public void disposeContents() {
        if (this.fContentContainer != null) {
            this.fContentContainer.dispose();
            this.fContentContainer = null;
        }
        this.fDirty = false;
        this.fSaveSucceeded = false;
        this.fNeedsContentCreated = true;
        this.fPageError = null;
        this.fPageErrorMessage = null;
    }

    public boolean refreshContents() {
        if (!this.fNeedsContentCreated) {
            return false;
        }
        this.fContentContainer = this.createContentContainer();
        if (this.fPageErrorMessage != null) {
            this.createErrorContent(this.fContentContainer);
        } else {
            this.createPageContent(this.fContentContainer);
        }
        this.fNeedsContentCreated = false;
        return true;
    }

    public void setNeedsContentRefreshed(boolean needsRefreshed) {
        this.fNeedsContentCreated = needsRefreshed;
    }

    public final boolean needsContentCreated() {
        return this.fNeedsContentCreated;
    }

    protected final void createFormContent(IManagedForm managedForm) {
        if (this instanceof BuildResultPage) {
            GridLayoutFactory.swtDefaults().margins(10, 10).applyTo(managedForm.getForm().getBody());
        } else {
            GridLayoutFactory.swtDefaults().applyTo(managedForm.getForm().getBody());
        }
        this.refreshContents();
    }

    protected Composite getContentContainer() {
        return this.fContentContainer;
    }

    protected void createErrorContent(Composite parent) {
        parent.setLayout((Layout)new GridLayout(3, false));
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        Label imageLabel = new Label(parent, 0);
        imageLabel.setBackground(parent.getBackground());
        Image image = Display.getDefault().getSystemImage(1);
        if (image != null) {
            image.setBackground(imageLabel.getBackground());
            imageLabel.setImage(image);
            imageLabel.setLayoutData((Object)new GridData(66));
        }
        this.fErrorLabel = new Label(parent, 64);
        this.fErrorLabel.setBackground(parent.getBackground());
        this.fErrorLabel.setText(this.fPageErrorMessage);
        GridData data = new GridData(4, 1, true, false);
        data.horizontalIndent = 5;
        this.fErrorLabel.setLayoutData((Object)data);
        this.fDetailsButton = new Button(parent, 8);
        this.fDetailsButton.setText(IDialogConstants.SHOW_DETAILS_LABEL);
        this.fDetailsButton.setBackground(parent.getBackground());
        this.fDetailsButton.setLayoutData((Object)new GridData(0x1000008, 1, false, false));
        this.fDetailsButton.addSelectionListener(this.getDetailsButtonSelectionListener());
        this.fErrorDetailsArea = new Composite(parent, 0);
        data = new GridData(1808);
        data.horizontalSpan = 3;
        this.fErrorDetailsArea.setLayoutData((Object)data);
        this.fErrorDetailsArea.setBackground(parent.getBackground());
        this.fErrorDetailsArea.setLayout((Layout)new FillLayout());
    }

    protected SelectionListener getDetailsButtonSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InternalBuildResultPage.this.updateDetailsText();
            }
        };
    }

    private void updateDetailsText() {
        if (this.fErrorDetails == null) {
            this.fDetailsButton.setText(IDialogConstants.HIDE_DETAILS_LABEL);
            Text detailsText = new Text(this.fErrorDetailsArea, 2826);
            detailsText.setText(this.getStackTrace(this.fPageError));
            detailsText.setBackground(detailsText.getDisplay().getSystemColor(25));
            this.fErrorDetails = detailsText;
            this.fErrorDetailsArea.layout(true);
        } else {
            this.fErrorDetails.dispose();
            this.fErrorDetails = null;
            this.fDetailsButton.setText(IDialogConstants.SHOW_DETAILS_LABEL);
        }
    }

    protected String getStackTrace(Throwable throwable) {
        StringWriter swriter = new StringWriter();
        PrintWriter pwriter = new PrintWriter(swriter);
        throwable.printStackTrace(pwriter);
        pwriter.flush();
        pwriter.close();
        return swriter.toString();
    }

    protected abstract void createPageContent(Composite var1);

    private Composite createContentContainer() {
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        toolkit.setBorderStyle(2048);
        Composite container = toolkit.createComposite(this.getManagedForm().getForm().getBody());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)container);
        return container;
    }

    protected final void save(IProgressMonitor monitor) throws TeamRepositoryException {
        this.saveContributions(monitor);
        this.fDirty = false;
        this.fSaveSucceeded = true;
    }

    protected boolean checkSaveSuccessful() {
        boolean wasSaveSuccessful = this.fSaveSucceeded;
        this.fSaveSucceeded = false;
        return wasSaveSuccessful;
    }

    protected void saveContributions(IProgressMonitor monitor) throws TeamRepositoryException {
    }

    public void postSave() {
    }

    public boolean isDirty() {
        return this.fDirty;
    }

    public void setDirtyFlag() {
        this.fDirty = true;
        this.fBuildResultEditor.fireDirtyPropertyChangeEvent();
    }

    public boolean validate() {
        return true;
    }

    public IBuildResult getBuildResultWorkingCopy() {
        return this.fBuildResultContext.getBuildResultWorkingCopy();
    }

    protected void setHeaderBusy(boolean isBusy) {
        BuildResultEditor editor = (BuildResultEditor)this.getEditor();
        editor.setBusy(isBusy);
    }

    public void addWarningMessage(Object id, String message, Control control) {
        this.fBuildResultEditor.addWarningMessage(id, message, control, this.getIndex());
    }

    public void addErrorMessage(Object id, String message, Control control) {
        this.fBuildResultEditor.addErrorMessage(id, message, control, this.getIndex());
    }

    public void addErrorMessage(Object id, String message, IStatus status) {
        this.fBuildResultEditor.addErrorMessage(id, message, status);
    }

    public void removeErrorMessage(Object id, Control control) {
        this.removeMessage(id, control);
    }

    public void removeErrorMessage(Object id) {
        this.removeMessage(id);
    }

    public void removeMessage(Object id) {
        this.fBuildResultEditor.removeMessage(id);
    }

    public void removeMessage(Object id, Control control) {
        this.fBuildResultEditor.removeMessage(id, control);
    }
}

