/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.result;

import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.internal.ui.editors.result.BuildResultEditorMessages;
import com.ibm.team.build.internal.ui.helper.ClipboardHelper;
import com.ibm.team.build.ui.editors.result.AbstractBuildResultPage;
import com.ibm.team.build.ui.editors.result.IBuildResultContext;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.RetargetAction;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public abstract class BuildResultPage
extends AbstractBuildResultPage {
    private ActionFactory.IWorkbenchAction fCopyAction;
    public static final int NAME_COLUMN_INDEX = 0;
    private boolean fRemovingFilter;
    private boolean accessibleListenerAdded = false;
    protected boolean fDoRefreshWorkaroundOnPageCreation = true;

    public BuildResultPage(FormEditor editor, String id, String title, String[] contributionIds, IBuildResultContext buildResultContext) {
        super(editor, id, title, contributionIds, buildResultContext);
    }

    @Override
    protected void createPageContent(Composite parent) {
        if (this.fDoRefreshWorkaroundOnPageCreation) {
            this.fDoRefreshWorkaroundOnPageCreation = false;
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!BuildResultPage.this.getContentContainer().isDisposed()) {
                        BuildResultPage.this.disposeContents();
                        BuildResultPage.this.refreshContents();
                        BuildResultPage.this.getContentContainer().layout(true);
                        BuildResultPage.this.getManagedForm().reflow(true);
                    }
                }
            });
        } else {
            this.doCreatePageContent(parent);
        }
        this.addAccessibleListener(parent);
    }

    private void addAccessibleListener(Composite parent) {
        if (this.accessibleListenerAdded) {
            return;
        }
        this.accessibleListenerAdded = true;
        try {
            Composite tabFolderComposite = this.getPartControl().getParent();
            if (!(tabFolderComposite instanceof CTabFolder)) {
                return;
            }
            CTabFolder tabFolder = (CTabFolder)tabFolderComposite;
            BuildStatus status = this.getPageStatus();
            String fmt = BuildResultEditorMessages.BuildResultPage_ACC_OK;
            if (status == BuildStatus.ERROR) {
                fmt = BuildResultEditorMessages.BuildResultPage_ACC_ERROR;
            } else if (status == BuildStatus.WARNING) {
                fmt = BuildResultEditorMessages.BuildResultPage_ACC_WARNING;
            }
            final String accessibleTitle = NLS.bind((String)fmt, (Object)this.getTitle());
            final int pageID = this.getIndex();
            Accessible acc = tabFolder.getAccessible();
            acc.addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    if (e.childID == pageID) {
                        e.result = accessibleTitle;
                    }
                }
            });
        }
        finally {
            return;
        }
    }

    protected abstract void doCreatePageContent(Composite var1);

    protected ToolBar createToolbar(FormToolkit toolkit, Composite parent) {
        ToolBar toolbar = new ToolBar(parent, 0x800100);
        toolbar.setBackground(null);
        return toolbar;
    }

    protected ToolItem createFilterButton(Image image, String tooltip, ToolBar parent, ViewerFilter filter, StructuredViewer viewer, boolean buttonSelected) {
        ToolItem item = new ToolItem(parent, 32);
        item.setImage(image);
        item.setToolTipText(tooltip);
        item.setSelection(buttonSelected);
        this.toggleFilter(buttonSelected, viewer, filter);
        item.addSelectionListener(this.getFilterButtonSelectionListener(item, viewer, filter));
        return item;
    }

    protected SelectionListener getFilterButtonSelectionListener(final ToolItem item, final StructuredViewer viewer, final ViewerFilter filter) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildResultPage.this.toggleFilter(item.getSelection(), viewer, filter);
            }
        };
    }

    protected void toggleFilter(boolean buttonSelected, StructuredViewer viewer, ViewerFilter filter) {
        if (buttonSelected) {
            this.fRemovingFilter = true;
            viewer.removeFilter(filter);
            this.fRemovingFilter = false;
        } else {
            viewer.addFilter(filter);
        }
    }

    protected boolean inRemoveFilterCall() {
        return this.fRemovingFilter;
    }

    protected void createContextMenu(String contextMenuId, IWorkbenchPartSite site) {
        Viewer viewer = this.getViewer();
        if (viewer == null) {
            return;
        }
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(this.getMenuListener());
        Menu menu = menuMgr.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        site.registerContextMenu(contextMenuId, menuMgr, (ISelectionProvider)viewer);
        this.setCopyActionPart();
    }

    protected ActionFactory.IWorkbenchAction getCopyAction() {
        if (this.fCopyAction == null) {
            this.fCopyAction = ActionFactory.COPY.create(this.getEditor().getEditorSite().getWorkbenchWindow());
            this.fCopyAction.setEnabled(true);
        }
        return this.fCopyAction;
    }

    protected void setCopyActionPart() {
        if (this.getCopyAction() instanceof RetargetAction) {
            ((RetargetAction)this.getCopyAction()).partActivated((IWorkbenchPart)this.getEditor());
        }
    }

    protected CopyStrategy getCopyStrategy(Control control) {
        return CopyStrategy.DEFAULT;
    }

    protected String getCopyActionItemNameForSelectedItem(Control control) {
        return null;
    }

    protected IMenuListener getMenuListener() {
        return new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IContributionItem)new Separator());
                manager.add((IContributionItem)new GroupMarker("buildEditActions"));
                if (BuildResultPage.this.getCopyStrategy(BuildResultPage.this.getViewer().getControl()) != CopyStrategy.NONE) {
                    String columnName = BuildResultPage.this.getCopyActionItemNameForSelectedItem(BuildResultPage.this.getViewer().getControl());
                    if (columnName != null) {
                        BuildResultPage.this.getCopyAction().setText(NLS.bind((String)BuildResultEditorMessages.BuildResultPage_COPY_X, (Object)columnName));
                    } else {
                        BuildResultPage.this.getCopyAction().setText(BuildResultEditorMessages.BuildResultPage_COPY);
                    }
                    manager.add((IAction)BuildResultPage.this.getCopyAction());
                    BuildResultPage.this.getCopyAction().setEnabled(!BuildResultPage.this.getViewer().getControl().isDisposed() && !BuildResultPage.this.getViewer().getSelection().isEmpty());
                }
                manager.add((IContributionItem)new Separator());
                if (BuildResultPage.this.addActionsToContextMenu(manager)) {
                    manager.add((IContributionItem)new Separator());
                }
                manager.add((IContributionItem)new GroupMarker("additions"));
            }
        };
    }

    protected boolean addActionsToContextMenu(IMenuManager manager) {
        return false;
    }

    @Override
    public boolean performGlobalAction(String id) {
        Control focusControl = this.getFocusControl();
        if (focusControl instanceof Text) {
            Text textControl = (Text)focusControl;
            if (ActionFactory.SELECT_ALL.getId().equals(id)) {
                textControl.selectAll();
                return true;
            }
            if (ActionFactory.COPY.getId().equals(id)) {
                textControl.copy();
                return true;
            }
            if (ActionFactory.CUT.getId().equals(id) && textControl.getEditable()) {
                textControl.cut();
                return true;
            }
            if (ActionFactory.PASTE.getId().equals(id) && textControl.getEditable()) {
                textControl.paste();
                return true;
            }
        } else if (focusControl instanceof StyledText) {
            StyledText textControl = (StyledText)focusControl;
            if (ActionFactory.SELECT_ALL.getId().equals(id)) {
                textControl.selectAll();
                return true;
            }
            if (ActionFactory.COPY.getId().equals(id)) {
                textControl.copy();
                return true;
            }
            if (ActionFactory.CUT.getId().equals(id) && textControl.getEditable()) {
                textControl.cut();
                return true;
            }
            if (ActionFactory.PASTE.getId().equals(id) && textControl.getEditable()) {
                textControl.paste();
                return true;
            }
        } else if (focusControl instanceof Table) {
            Table focusTable = (Table)focusControl;
            if (ActionFactory.SELECT_ALL.getId().equals(id)) {
                if ((focusTable.getStyle() & 2) != 0) {
                    focusTable.selectAll();
                    return true;
                }
            } else if (ActionFactory.COPY.getId().equals(id)) {
                boolean copyFirstColumnOnly = this.getCopyStrategy(focusControl) == CopyStrategy.FIRST;
                String copyText = this.getCopyTextForTable(focusTable, copyFirstColumnOnly);
                this.copySelectionToClipboard(copyText, focusTable.getDisplay());
                return true;
            }
        } else if (focusControl instanceof Tree) {
            Tree focusTree = (Tree)focusControl;
            if (ActionFactory.SELECT_ALL.getId().equals(id)) {
                if ((focusTree.getStyle() & 2) != 0) {
                    focusTree.selectAll();
                    return true;
                }
            } else if (ActionFactory.COPY.getId().equals(id)) {
                boolean copyFirstColumnOnly = this.getCopyStrategy(focusControl) == CopyStrategy.FIRST;
                String copyText = this.getCopyTextForTree(focusTree, copyFirstColumnOnly);
                this.copySelectionToClipboard(copyText, focusTree.getDisplay());
                return true;
            }
        }
        return false;
    }

    protected String getCopyTextForTable(Table table, boolean copyFirstColumnOnly) {
        return ClipboardHelper.getDefault().getCopyTextForTable(table, copyFirstColumnOnly);
    }

    protected String getCopyTextForTree(Tree tree, boolean copyFirstColumnOnly) {
        return ClipboardHelper.getDefault().getCopyTextForTree(tree, copyFirstColumnOnly);
    }

    protected void copySelectionToClipboard(String copyText, Display display) {
        ClipboardHelper.getDefault().copyTextToClipboard(copyText, display);
    }

    protected Control getFocusControl() {
        IManagedForm form = this.getManagedForm();
        if (form == null) {
            return null;
        }
        ScrolledForm control = form.getForm();
        if (control == null || control.isDisposed()) {
            return null;
        }
        Display display = control.getDisplay();
        Control focusControl = this.getDisplayFocusControl(display);
        if (focusControl == null || focusControl.isDisposed()) {
            return null;
        }
        return focusControl;
    }

    protected Control getDisplayFocusControl(Display display) {
        return display.getFocusControl();
    }

    protected boolean containsFailures(IBuildResultContribution[] contributions) {
        int i = 0;
        while (i < contributions.length) {
            if (contributions[i].getStatus() == BuildStatus.ERROR) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected abstract Viewer getViewer();

    protected SelectionListener getColumnSelectionListener(final Tree tree, final TreeColumn treeColumn) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (tree.getSortColumn() == treeColumn) {
                    if (tree.getSortDirection() == 1024) {
                        tree.setSortDirection(128);
                    } else {
                        tree.setSortDirection(1024);
                    }
                } else {
                    tree.setSortColumn(treeColumn);
                    tree.setSortDirection(1024);
                }
                TreeViewer viewer = (TreeViewer)BuildResultPage.this.getViewer();
                Object[] expandedElements = viewer.getExpandedElements();
                viewer.refresh(false);
                viewer.setExpandedElements(expandedElements);
            }
        };
    }

    protected static enum CopyStrategy {
        NONE,
        DEFAULT,
        FIRST;

    }
}

