/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.result;

import com.ibm.team.build.internal.ui.BuildJob;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.editors.result.BuildResultEditorMessages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public abstract class BuildResultContributionProviderBase {
    private boolean fIsInitialized;
    private boolean fInitializationSucceeded;
    private Exception fInitializationError;
    private BuildJob fInitializationJob;
    private String fInitializationLock = new String("init lock");

    public boolean isInitialized() {
        return this.fIsInitialized;
    }

    public boolean initializationSucceeded() {
        return this.fInitializationSucceeded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws IllegalStateException {
        String string = this.fInitializationLock;
        synchronized (string) {
            if (this.fInitializationJob != null) {
                throw new IllegalStateException(BuildResultEditorMessages.BuildResultContributionProviderBase_BAD_STATE);
            }
            this.fIsInitialized = false;
            this.fInitializationSucceeded = false;
            this.fInitializationJob = new BuildJob(BuildResultEditorMessages.BuildResultContributionProviderBase_INITIALIZATION_JOB_NAME){

                protected IStatus run(IProgressMonitor monitor) {
                    return BuildResultContributionProviderBase.this.doInitialization(monitor);
                }
            };
        }
        this.fInitializationJob.setSystem(true);
        this.fInitializationJob.scheduleJob();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus doInitialization(IProgressMonitor monitor) {
        block14: {
            try {
                try {
                    this.initializeContributionProvider(monitor);
                    this.fInitializationSucceeded = true;
                }
                catch (Exception exception) {
                    this.fInitializationError = exception;
                    this.fInitializationSucceeded = false;
                    BuildUIPlugin.log(exception);
                    String string = this.fInitializationLock;
                    synchronized (string) {
                        this.fIsInitialized = true;
                        this.fInitializationJob = null;
                        this.fInitializationLock.notifyAll();
                        break block14;
                    }
                }
            }
            catch (Throwable throwable) {
                String string = this.fInitializationLock;
                synchronized (string) {
                    this.fIsInitialized = true;
                    this.fInitializationJob = null;
                    this.fInitializationLock.notifyAll();
                }
                throw throwable;
            }
            String string = this.fInitializationLock;
            synchronized (string) {
                this.fIsInitialized = true;
                this.fInitializationJob = null;
                this.fInitializationLock.notifyAll();
            }
        }
        return Status.OK_STATUS;
    }

    public Exception getInitializationError() {
        return this.fInitializationError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void waitForInitialization() {
        if (this.fIsInitialized) {
            return;
        }
        String string = this.fInitializationLock;
        synchronized (string) {
            while (true) {
                if (this.fIsInitialized) {
                    return;
                }
                try {
                    this.fInitializationLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public abstract void initializeContributionProvider(IProgressMonitor var1) throws Exception;
}

