/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.result;

import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.editors.result.BuildResultEditorMessages;
import com.ibm.team.build.internal.ui.editors.result.IDeferredBuildTreeNode;
import com.ibm.team.build.internal.ui.helper.BuildUIHelper;
import com.ibm.team.repository.common.TeamRepositoryException;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class AbstractBuildTreeNode
implements IDeferredBuildTreeNode {
    private IDeferredBuildTreeNode fParentNode;
    protected Object[] fChildren;

    public AbstractBuildTreeNode(IDeferredBuildTreeNode parentNode) {
        this.fParentNode = parentNode;
    }

    @Override
    public IDeferredBuildTreeNode getParentNode() {
        return this.fParentNode;
    }

    @Override
    public Object[] fetchChildren(IProgressMonitor monitor) {
        this.fChildren = null;
        try {
            this.fChildren = this.doFetchChildren(monitor);
        }
        catch (TeamRepositoryException exception) {
            this.showErrorDialog(BuildResultEditorMessages.ERROR_FETCHING_BUILD_RESULT_DATA, (Exception)((Object)exception));
            BuildUIPlugin.log(exception);
        }
        if (this.fChildren == null) {
            this.fChildren = new Object[0];
        }
        return this.fChildren;
    }

    protected abstract Object[] doFetchChildren(IProgressMonitor var1) throws TeamRepositoryException;

    @Override
    public Object[] getChildren() {
        return this.fChildren;
    }

    protected void showErrorDialog(String message, Exception exception) {
        BuildUIHelper.showErrorDialog(message, null, exception);
    }
}

