/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.buildengine;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.internal.common.helper.BuildEngineHelper;
import com.ibm.team.build.internal.common.model.dto.IBuildEngineStatusRecord;
import com.ibm.team.build.internal.common.registry.BuildEngineTemplateExtension;
import com.ibm.team.build.internal.common.registry.BuildEngineTemplateExtensionManager;
import com.ibm.team.build.internal.ui.AbstractBuildItemViewerComparator;
import com.ibm.team.build.internal.ui.BuildDefinitionLabelProvider;
import com.ibm.team.build.internal.ui.BuildPropertyControl;
import com.ibm.team.build.internal.ui.BuildUIMessages;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.IBuildPropertyControlListener;
import com.ibm.team.build.internal.ui.actions.EditBuildDefinitionActionDelegate;
import com.ibm.team.build.internal.ui.dialogs.AddBuildDefinitionsDialog;
import com.ibm.team.build.internal.ui.editors.builddefinition.BuildDefinitionEditorMessages;
import com.ibm.team.build.internal.ui.editors.buildengine.BuildEngineEditor;
import com.ibm.team.build.internal.ui.editors.buildengine.BuildEngineEditorMessages;
import com.ibm.team.build.internal.ui.helper.BuildUIHelper;
import com.ibm.team.build.ui.editors.buildengine.AbstractEngineConfigurationElementEditor;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class GeneralEngineConfigurationEditor
extends AbstractEngineConfigurationElementEditor {
    public static final String GENERAL_ENGINE_CONFIG_ELEMENT_ID = "com.ibm.team.build.engine.general";
    private static final String PROPERTIES_ENGINE_CONFIG_ELEMENT_ID = "com.ibm.team.build.engine.properties";
    private static final int MINIMUM_NUMBER_CHARACTERS_IN_BUILD_DEFINITIONS = 25;
    private static final int MINIMUM_NUMBER_BUILD_DEFINITIONS = 5;
    private static final String LAST_CONTACT_WARNING_ID = "last.contact.warning.id";
    private BuildEngineEditor fEditor;
    private IBuildEngine fBuildEngine;
    private FormToolkit fToolkit;
    private Composite fGeneralAndDefinitionsGroup;
    private Composite fGeneralGroup;
    private Section fGeneralSection;
    private Section fBuildDefinitionsSection;
    private Section fActivationSection;
    private Section fPropertiesSection;
    protected Text fDescriptionText;
    protected Button fEngineActiveButton;
    private Section fRequestProcessingSection;
    protected Button fMonitoringButton;
    protected Text fMonitoringThresholdText;
    protected Button fRequestProcessingButton;
    private IBuildPropertyControlListener fBuildPropertyListener = this.getPropertyListener();
    private BuildPropertyControl fBuildPropertyControl;
    protected TableViewer fBuildDefinitionsTableViewer;
    protected Button fAddBuildDefinitionsButton;
    protected Button fRemoveBuildDefinitionButton;
    private boolean fContentCreated = false;

    public GeneralEngineConfigurationEditor(String elementId, String title) {
        super(elementId, title);
    }

    @Override
    public void initialize(BuildEngineEditor editor) {
        super.initialize(editor);
        this.fEditor = editor;
    }

    @Override
    public void createContent(Composite parent, FormToolkit toolkit) {
        this.fToolkit = toolkit;
        FormLayout layout = new FormLayout();
        layout.spacing = 10;
        parent.setLayout((Layout)layout);
        if (this.fEditor.isRefreshed()) {
            this.createEditor(parent);
        }
    }

    private FormToolkit getToolkit() {
        return this.fToolkit;
    }

    private void createEditor(Composite parent) {
        this.fGeneralAndDefinitionsGroup = this.getToolkit().createComposite(parent);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.fGeneralAndDefinitionsGroup.setLayoutData((Object)data);
        FormLayout formLayout = new FormLayout();
        this.fGeneralAndDefinitionsGroup.setLayout((Layout)formLayout);
        this.fGeneralGroup = this.getToolkit().createComposite(this.fGeneralAndDefinitionsGroup, 0);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.bottom = new FormAttachment(100);
        data.right = new FormAttachment(50);
        this.fGeneralGroup.setLayoutData((Object)data);
        formLayout = new FormLayout();
        this.fGeneralGroup.setLayout((Layout)formLayout);
        this.createGeneralSection(this.fGeneralGroup);
        this.createActivationSection(this.fGeneralGroup);
        this.createRequestProcessingSection(this.fGeneralGroup);
        this.createBuildDefinitionsSection(this.fGeneralAndDefinitionsGroup);
        if (this.shouldShowProperties()) {
            this.createPropertiesSection(parent);
        }
        this.fContentCreated = true;
        this.validate();
        this.getManagedForm().reflow(true);
    }

    private boolean shouldShowProperties() {
        return this.fBuildEngine.getConfigurationElements().isEmpty() || this.fBuildEngine.getConfigurationElement(PROPERTIES_ENGINE_CONFIG_ELEMENT_ID) != null;
    }

    protected void createGeneralSection(Composite parent) {
        FormToolkit toolkit = this.getToolkit();
        this.fGeneralSection = toolkit.createSection(parent, 384);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 5);
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(100, -5);
        this.fGeneralSection.setLayoutData((Object)data);
        this.fGeneralSection.setText(BuildEngineEditorMessages.GENERAL_HEADER);
        this.fGeneralSection.setDescription(this.getEngineDescription());
        Composite composite = toolkit.createComposite((Composite)this.fGeneralSection);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.fGeneralSection.setClient((Control)composite);
        Label label = this.fToolkit.createLabel(composite, BuildDefinitionEditorMessages.BuildDefinitionEditor_DESCRIPTION_LABEL);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 128;
        label.setLayoutData((Object)gridData);
        this.fDescriptionText = this.fToolkit.createText(composite, this.fBuildEngine.getDescription(), 2626);
        gridData = new GridData(768);
        gridData.heightHint = 60;
        gridData.widthHint = 100;
        this.fDescriptionText.setLayoutData((Object)gridData);
        this.fDescriptionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GeneralEngineConfigurationEditor.this.fBuildEngine.setDescription(GeneralEngineConfigurationEditor.this.fDescriptionText.getText().trim());
                GeneralEngineConfigurationEditor.this.setDirty(true);
            }
        });
    }

    private String getEngineDescription() {
        String templateId;
        String description;
        IBuildProperty templateProperty = this.fBuildEngine.getProperty("com.ibm.team.build.internal.engine.template.id");
        if (templateProperty != null && (description = this.getEngineTemplateDescription(templateId = templateProperty.getValue())) != null && description.length() > 0) {
            return description;
        }
        description = this.getEngineTemplateDescription("com.ibm.team.build.engine.jbe");
        if (description != null && description.length() > 0) {
            return description;
        }
        return "";
    }

    private String getEngineTemplateDescription(String templateId) {
        BuildEngineTemplateExtension engineTemplate = BuildEngineTemplateExtensionManager.getInstance().getBuildEngineTemplate(templateId);
        if (engineTemplate != null) {
            return engineTemplate.getDescription();
        }
        return null;
    }

    private void createActivationSection(Composite parent) {
        this.fActivationSection = this.fToolkit.createSection(parent, 384);
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.fGeneralSection, 10);
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(100, -5);
        this.fActivationSection.setLayoutData((Object)data);
        this.fActivationSection.setText(BuildEngineEditorMessages.ACTIVATION_HEADER);
        this.fActivationSection.setDescription(BuildEngineEditorMessages.ACTIVATION_DESCRIPTION);
        Composite composite = this.fToolkit.createComposite((Composite)this.fActivationSection);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.fEngineActiveButton = this.fToolkit.createButton(composite, BuildEngineEditorMessages.ACTIVE_BUTTON, 32);
        this.fEngineActiveButton.setLayoutData((Object)new GridData());
        this.fEngineActiveButton.setSelection(this.fBuildEngine.isActive());
        this.fEngineActiveButton.addSelectionListener(this.getActiveButtonSelectionListener());
        this.fActivationSection.setClient((Control)composite);
    }

    private void createRequestProcessingSection(Composite parent) {
        this.fRequestProcessingSection = this.fToolkit.createSection(parent, 384);
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.fActivationSection, 10);
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(100, -5);
        data.bottom = new FormAttachment(100, -5);
        this.fRequestProcessingSection.setLayoutData((Object)data);
        this.fRequestProcessingSection.setText(BuildEngineEditorMessages.BuildEngineEditor_REQUEST_PROCESSING_SECTION);
        this.fRequestProcessingSection.setDescription(BuildEngineEditorMessages.BuildEngineEditor_REQUEST_PROCESSING_SECTION_DESCRIPTION);
        Composite composite = this.fToolkit.createComposite((Composite)this.fRequestProcessingSection);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        this.fRequestProcessingButton = this.fToolkit.createButton(composite, BuildEngineEditorMessages.BuildEngineEditor_REQUEST_PROCESSING_BUTTON, 32);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.fRequestProcessingButton.setLayoutData((Object)gridData);
        this.fRequestProcessingButton.setSelection(this.fBuildEngine.isRequestProcessingEnabled());
        this.fRequestProcessingButton.addSelectionListener(this.getRequestProcessingButtonSelectionListener());
        this.fRequestProcessingButton.setEnabled(this.fEngineActiveButton.getSelection());
        this.fMonitoringButton = this.fToolkit.createButton(composite, BuildEngineEditorMessages.BuildEngineEditor_MONITOR_BUTTON, 32);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.fMonitoringButton.setLayoutData((Object)gridData);
        this.fMonitoringButton.setSelection(this.isMonitoring());
        this.fMonitoringButton.addSelectionListener(this.getMonitoringButtonSelectionListener());
        this.fMonitoringButton.setEnabled(this.fEngineActiveButton.getSelection() && this.fRequestProcessingButton.getSelection());
        Label label = this.fToolkit.createLabel(composite, BuildEngineEditorMessages.BuildEngineEditor_THRESHOLD);
        gridData = new GridData();
        gridData.horizontalIndent = 15;
        label.setLayoutData((Object)gridData);
        this.fMonitoringThresholdText = this.fToolkit.createText(composite, this.getThresholdString());
        this.fMonitoringThresholdText.setLayoutData((Object)new GridData(768));
        this.fMonitoringThresholdText.addModifyListener(this.getMonitoringTextModifyListener());
        this.fMonitoringThresholdText.addListener(25, this.getIntegerInputListener());
        this.fMonitoringThresholdText.setEnabled(this.fEngineActiveButton.getSelection() && this.fRequestProcessingButton.getSelection() && this.fMonitoringButton.getSelection());
        this.fRequestProcessingSection.setClient((Control)composite);
    }

    private String getThresholdString() {
        String threshold = "";
        if (this.fBuildEngine.getMonitoringThreshold() > 0) {
            threshold = String.valueOf(this.fBuildEngine.getMonitoringThreshold());
        }
        return threshold;
    }

    protected ModifyListener getMonitoringTextModifyListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GeneralEngineConfigurationEditor.this.validate();
                if (GeneralEngineConfigurationEditor.this.isPositiveInteger(GeneralEngineConfigurationEditor.this.fMonitoringThresholdText.getText())) {
                    GeneralEngineConfigurationEditor.this.fBuildEngine.setMonitoringThreshold(Integer.parseInt(GeneralEngineConfigurationEditor.this.fMonitoringThresholdText.getText()));
                }
                GeneralEngineConfigurationEditor.this.setDirty(true);
            }
        };
    }

    protected Listener getIntegerInputListener() {
        return new Listener(){

            public void handleEvent(Event e) {
                char[] chars = e.text.toCharArray();
                int i = 0;
                while (i < chars.length) {
                    if (!Character.isDigit(chars[i])) {
                        e.doit = false;
                        return;
                    }
                    ++i;
                }
            }
        };
    }

    private boolean isMonitoring() {
        return this.fBuildEngine.getMonitoringThreshold() > 0;
    }

    protected SelectionListener getActiveButtonSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneralEngineConfigurationEditor.this.fBuildEngine.setActive(GeneralEngineConfigurationEditor.this.fEngineActiveButton.getSelection());
                GeneralEngineConfigurationEditor.this.fRequestProcessingButton.setEnabled(GeneralEngineConfigurationEditor.this.fEngineActiveButton.getSelection());
                GeneralEngineConfigurationEditor.this.fMonitoringButton.setEnabled(GeneralEngineConfigurationEditor.this.fEngineActiveButton.getSelection() && GeneralEngineConfigurationEditor.this.fRequestProcessingButton.getSelection());
                GeneralEngineConfigurationEditor.this.fMonitoringThresholdText.setEnabled(GeneralEngineConfigurationEditor.this.fEngineActiveButton.getSelection() && GeneralEngineConfigurationEditor.this.fRequestProcessingButton.getSelection() && GeneralEngineConfigurationEditor.this.fMonitoringButton.getSelection());
                GeneralEngineConfigurationEditor.this.setDirty(true);
            }
        };
    }

    protected SelectionListener getMonitoringButtonSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GeneralEngineConfigurationEditor.this.fMonitoringButton.getSelection()) {
                    if (GeneralEngineConfigurationEditor.this.fMonitoringThresholdText.getText().trim().length() > 0) {
                        GeneralEngineConfigurationEditor.this.fBuildEngine.setMonitoringThreshold(Integer.parseInt(GeneralEngineConfigurationEditor.this.fMonitoringThresholdText.getText().trim()));
                    }
                } else {
                    GeneralEngineConfigurationEditor.this.fBuildEngine.setMonitoringThreshold(0);
                }
                GeneralEngineConfigurationEditor.this.fMonitoringThresholdText.setEnabled(GeneralEngineConfigurationEditor.this.fMonitoringButton.getSelection());
                GeneralEngineConfigurationEditor.this.setDirty(true);
                GeneralEngineConfigurationEditor.this.validate();
            }
        };
    }

    protected SelectionListener getRequestProcessingButtonSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneralEngineConfigurationEditor.this.fBuildEngine.setRequestProcessingEnabled(GeneralEngineConfigurationEditor.this.fRequestProcessingButton.getSelection());
                GeneralEngineConfigurationEditor.this.fMonitoringButton.setSelection(GeneralEngineConfigurationEditor.this.fRequestProcessingButton.getSelection());
                GeneralEngineConfigurationEditor.this.getMonitoringButtonSelectionListener().widgetSelected(null);
                GeneralEngineConfigurationEditor.this.fMonitoringButton.setEnabled(GeneralEngineConfigurationEditor.this.fRequestProcessingButton.getSelection());
                GeneralEngineConfigurationEditor.this.fMonitoringThresholdText.setEnabled(GeneralEngineConfigurationEditor.this.fRequestProcessingButton.getSelection());
                GeneralEngineConfigurationEditor.this.setDirty(true);
                GeneralEngineConfigurationEditor.this.validate();
            }
        };
    }

    private void createPropertiesSection(Composite parent) {
        this.fPropertiesSection = this.fToolkit.createSection(parent, 384);
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.fGeneralAndDefinitionsGroup, 10);
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(100, -5);
        data.bottom = new FormAttachment(100, -5);
        this.fPropertiesSection.setLayoutData((Object)data);
        this.fPropertiesSection.setText(BuildEngineEditorMessages.BuildEngineEditor_PROPERTIES_SECTION);
        this.fPropertiesSection.setDescription(BuildEngineEditorMessages.BuildEngineEditor_PROPERTIES_DESCRIPTION);
        Composite composite = this.fToolkit.createComposite((Composite)this.fPropertiesSection);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.fBuildPropertyControl = this.createBuildPropertyControl(composite, this.copyProperties(this.fBuildEngine.getProperties()));
        GridDataFactory.fillDefaults().grab(true, false).hint(200, -1).applyTo((Control)this.fBuildPropertyControl.getComposite());
        this.fBuildPropertyControl.addListener(this.fBuildPropertyListener);
        this.fPropertiesSection.setClient((Control)composite);
    }

    protected BuildPropertyControl createBuildPropertyControl(Composite parent, List<IBuildProperty> buildProperties) {
        BuildPropertyControl buildPropertyControl = new BuildPropertyControl(parent, this.fToolkit, buildProperties, this.getTeamRepository(), true, BuildPropertyControl.LayoutSize.FULL, BuildEngineHelper.supportsHiddenProperty((IBuildEngine)this.fBuildEngine));
        buildPropertyControl.replaceGlobalActionsOnFocus(this.getEditorSite());
        buildPropertyControl.createAndRegisterDefaultContextMenu((IWorkbenchPartSite)this.getEditorSite());
        return buildPropertyControl;
    }

    private List copyProperties(List<IBuildProperty> properties) {
        LinkedList<IBuildProperty> propertyCopies = new LinkedList<IBuildProperty>();
        for (IBuildProperty buildProperty : properties) {
            propertyCopies.add(buildProperty.copyProperty());
        }
        return propertyCopies;
    }

    protected void createBuildDefinitionsSection(Composite parent) {
        FormToolkit toolkit = this.getToolkit();
        this.fBuildDefinitionsSection = toolkit.createSection(parent, 384);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 5);
        data.left = new FormAttachment((Control)this.fGeneralGroup, 5);
        data.right = new FormAttachment(100, -5);
        data.bottom = new FormAttachment(100, -5);
        this.fBuildDefinitionsSection.setLayoutData((Object)data);
        this.fBuildDefinitionsSection.setText(BuildEngineEditorMessages.BUILD_DEFINITIONS_HEADER);
        this.fBuildDefinitionsSection.setDescription(BuildEngineEditorMessages.BUILD_DEFINITIONS_DESCRIPTION);
        Composite composite = toolkit.createComposite((Composite)this.fBuildDefinitionsSection);
        toolkit.setBorderStyle(2048);
        composite.setLayout((Layout)new GridLayout(2, false));
        Table table = toolkit.createTable(composite, 66306);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.heightHint = table.getItemHeight() * 5;
        int width = this.getAverageCharacterWidth((Composite)table);
        gridData.widthHint = width * 25;
        table.setLayoutData((Object)gridData);
        this.fBuildDefinitionsTableViewer = new TableViewer(table);
        this.fBuildDefinitionsTableViewer.setComparator(this.getComparator());
        this.fBuildDefinitionsTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fBuildDefinitionsTableViewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.fBuildDefinitionsTableViewer.setInput((Object)this.getSupportedBuildDefinitions());
        this.fBuildDefinitionsTableViewer.addOpenListener(this.getOpenListener());
        this.createButtonBar(composite);
        this.fBuildDefinitionsSection.setClient((Control)composite);
    }

    private BuildDefinitionLabelProvider getLabelProvider() {
        return new BuildDefinitionLabelProvider(){

            @Override
            public void updateLabel(ViewerLabel label, Object element) {
                super.updateLabel(label, element);
                Object[] definitionObjects = this.getBuildDefinitionLabelObjects(element);
                if (definitionObjects[0] == null && definitionObjects[1] == null) {
                    String definitionId = (String)element;
                    String projectAreaName = GeneralEngineConfigurationEditor.this.getProjectAreaNameFromId(definitionId);
                    label.setText(GeneralEngineConfigurationEditor.this.formatText(definitionId, projectAreaName));
                } else if (definitionObjects[0] != null) {
                    String definitionId = (String)definitionObjects[0];
                    String projectAreaName = GeneralEngineConfigurationEditor.this.getProjectAreaNameFromId(definitionId);
                    label.setText(GeneralEngineConfigurationEditor.this.formatText(definitionId, projectAreaName));
                }
            }
        };
    }

    protected IBuildEngineStatusRecord getBuildEngineStatusRecord() {
        return this.fEditor.getBuildEngineStatusRecord();
    }

    protected Collection<IBuildDefinition> getBuildDefinitions() {
        return this.fEditor.getBuildDefinitions();
    }

    protected IBuildDefinition[] getSupportedBuildDefinitions() {
        return this.fEditor.getSupportedBuildDefinitions();
    }

    protected void setSupportedBuildDefinitions(IBuildDefinition[] supportedBuildDefinitions) {
        this.fEditor.setSupportedBuildDefinitions(supportedBuildDefinitions);
    }

    protected Map<IBuildDefinition, String> getBuildDefinitionToProjectAreaName() {
        return this.fEditor.getBuildDefinitionToProjectAreaName();
    }

    private String getProjectAreaNameFromId(String definitionId) {
        Map<IBuildDefinition, String> map = this.getBuildDefinitionToProjectAreaName();
        IBuildDefinition[] iBuildDefinitionArray = this.getSupportedBuildDefinitions();
        int n = iBuildDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildDefinition definition = iBuildDefinitionArray[n2];
            if (definition.getId().equals(definitionId)) {
                return map.get(definition);
            }
            ++n2;
        }
        return null;
    }

    protected String getProjectAreaName() {
        return this.fEditor.getProjectAreaName();
    }

    private String formatText(String definitionId, String projectAreaName) {
        if (definitionId != null) {
            if (projectAreaName != null) {
                if (projectAreaName.equals(this.getProjectAreaName())) {
                    return definitionId;
                }
                return NLS.bind((String)BuildUIMessages.EXTENDED_LABEL, (Object)definitionId, (Object)projectAreaName);
            }
            return NLS.bind((String)BuildUIMessages.EXTENDED_LABEL, (Object)definitionId, (Object)BuildUIMessages.UNKNOWN_PROJECT_AREA);
        }
        return null;
    }

    protected IOpenListener getOpenListener() {
        return new IOpenListener(){

            public void open(OpenEvent event) {
                IBuildDefinition definition;
                IStructuredSelection selection = (IStructuredSelection)GeneralEngineConfigurationEditor.this.fBuildDefinitionsTableViewer.getSelection();
                if (selection.size() == 1 && (definition = (IBuildDefinition)selection.getFirstElement()) != null) {
                    EditBuildDefinitionActionDelegate.run(definition, GeneralEngineConfigurationEditor.this.getSite().getPage());
                }
            }
        };
    }

    private int getAverageCharacterWidth(Composite composite) {
        int width;
        GC gc = null;
        try {
            try {
                gc = new GC((Drawable)composite);
                width = gc.getFontMetrics().getAverageCharWidth();
            }
            catch (Exception exception) {
                width = 20;
                if (gc != null) {
                    gc.dispose();
                }
            }
        }
        finally {
            if (gc != null) {
                gc.dispose();
            }
        }
        return width;
    }

    protected ViewerComparator getComparator() {
        return new AbstractBuildItemViewerComparator(){

            @Override
            protected String getProject(Object element) {
                return GeneralEngineConfigurationEditor.this.getBuildDefinitionToProjectAreaName().get(element);
            }

            @Override
            protected String getTopProject() {
                return GeneralEngineConfigurationEditor.this.getProjectAreaName();
            }
        };
    }

    private void createButtonBar(Composite parent) {
        FormToolkit toolkit = this.getToolkit();
        Composite buttonBar = toolkit.createComposite(parent);
        buttonBar.setLayoutData((Object)new GridData(131072, 4, false, true));
        buttonBar.setLayout((Layout)new GridLayout(1, false));
        this.fAddBuildDefinitionsButton = toolkit.createButton(buttonBar, BuildEngineEditorMessages.BUILD_DEFINITIONS_ADD_DEFINITIONS_LABEL, 8);
        this.fAddBuildDefinitionsButton.addSelectionListener((SelectionListener)this.getAddBuildDefinitionsListener());
        this.fRemoveBuildDefinitionButton = toolkit.createButton(buttonBar, BuildEngineEditorMessages.BUILD_DEFINITIONS_REMOVE_DEFINITION_LABEL, 8);
        this.fRemoveBuildDefinitionButton.addSelectionListener((SelectionListener)this.getRemoveBuildDefinitionListener());
        GridDataFactory.fillDefaults().hint(BuildUIHelper.getPreferredButtonWidth(this.fAddBuildDefinitionsButton), -1).grab(true, false).align(0x1000008, 0x1000000).applyTo((Control)this.fAddBuildDefinitionsButton);
        GridDataFactory.fillDefaults().hint(BuildUIHelper.getPreferredButtonWidth(this.fRemoveBuildDefinitionButton), -1).grab(true, false).align(0x1000008, 0x1000000).applyTo((Control)this.fRemoveBuildDefinitionButton);
    }

    protected SelectionAdapter getAddBuildDefinitionsListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GeneralEngineConfigurationEditor.this.fEditor.getAllDefinitionsSize() <= 0) {
                    GeneralEngineConfigurationEditor.this.openNoDefinitionsWarningDialog();
                } else if (GeneralEngineConfigurationEditor.this.fEditor.getAllDefinitionsSize() == GeneralEngineConfigurationEditor.this.getSupportedBuildDefinitions().length) {
                    GeneralEngineConfigurationEditor.this.openAllDefinitionsAlreadyAddedWarningDialog();
                } else if (!GeneralEngineConfigurationEditor.this.fEditor.isAllBuildDefinitionsFetched()) {
                    Job job = new Job(BuildEngineEditorMessages.BuildEngineEditor_FETCHING_BUILD_DEFINITIONS){

                        protected IStatus run(IProgressMonitor monitor) {
                            try {
                                IBuildDefinition[] allDefinitions = GeneralEngineConfigurationEditor.this.fEditor.fetchBuildDefinitions(monitor);
                                GeneralEngineConfigurationEditor.this.fEditor.setBuildDefinitionToProjectAreaName(GeneralEngineConfigurationEditor.this.fEditor.fetchDefinitionToProjectName(allDefinitions, monitor));
                                GeneralEngineConfigurationEditor.this.fEditor.setAllBuildDefinitionsFetched(true);
                                Display.getDefault().syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        AddBuildDefinitionsDialog dialog = GeneralEngineConfigurationEditor.this.getAddBuildDefinitionsDialog();
                                        if (dialog.open() == 0) {
                                            GeneralEngineConfigurationEditor.this.updateSupportedBuildDefinitions(dialog.getChangedBuildDefinitions());
                                            GeneralEngineConfigurationEditor.this.refreshTableView(GeneralEngineConfigurationEditor.this.getSupportedBuildDefinitions());
                                        }
                                    }
                                });
                            }
                            catch (TeamRepositoryException exception) {
                                BuildUIPlugin.log(exception);
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    job.schedule();
                } else {
                    AddBuildDefinitionsDialog dialog = GeneralEngineConfigurationEditor.this.getAddBuildDefinitionsDialog();
                    if (dialog.open() == 0) {
                        GeneralEngineConfigurationEditor.this.updateSupportedBuildDefinitions(dialog.getChangedBuildDefinitions());
                        GeneralEngineConfigurationEditor.this.refreshTableView(GeneralEngineConfigurationEditor.this.getSupportedBuildDefinitions());
                    }
                }
            }
        };
    }

    protected SelectionAdapter getRemoveBuildDefinitionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selectedDefinition = (IStructuredSelection)GeneralEngineConfigurationEditor.this.fBuildDefinitionsTableViewer.getSelection();
                if (selectedDefinition != null && selectedDefinition.size() > 0) {
                    HashSet<IBuildDefinition> selectedDefinitionSet = new HashSet<IBuildDefinition>();
                    Object[] objectArray = selectedDefinition.toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object selectedBuildDefinition = objectArray[n2];
                        IBuildDefinition[] iBuildDefinitionArray = GeneralEngineConfigurationEditor.this.getSupportedBuildDefinitions();
                        int n3 = iBuildDefinitionArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IBuildDefinition supportedDefinition = iBuildDefinitionArray[n4];
                            if (supportedDefinition.getItemId().equals((Object)((IBuildDefinition)selectedBuildDefinition).getItemId())) {
                                selectedDefinitionSet.add(supportedDefinition);
                                break;
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                    GeneralEngineConfigurationEditor.this.updateSupportedBuildDefinitions(selectedDefinitionSet);
                    GeneralEngineConfigurationEditor.this.refreshTableView(GeneralEngineConfigurationEditor.this.getSupportedBuildDefinitions());
                }
            }
        };
    }

    private void updateSupportedBuildDefinitions(Set<IBuildDefinition> changedDefinitions) {
        if (changedDefinitions.size() > 0) {
            this.setDirty(true);
            Set<IBuildDefinition> addedDefinitions = changedDefinitions;
            LinkedList<IBuildDefinition> updatedSupported = new LinkedList<IBuildDefinition>();
            IBuildDefinition[] iBuildDefinitionArray = this.getSupportedBuildDefinitions();
            int n = iBuildDefinitionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IBuildDefinition definition = iBuildDefinitionArray[n2];
                if (!addedDefinitions.remove(definition)) {
                    updatedSupported.add(definition);
                }
                ++n2;
            }
            for (IBuildDefinition definition : addedDefinitions) {
                updatedSupported.add(definition);
            }
            this.setSupportedBuildDefinitions(updatedSupported.toArray(new IBuildDefinition[updatedSupported.size()]));
        }
    }

    private void updateSupportedDefinitions() {
        if (this.fBuildDefinitionsTableViewer != null) {
            List supportedBuildDefinitions = this.fBuildEngine.getSupportedBuildDefinitions();
            supportedBuildDefinitions.clear();
            IBuildDefinition[] iBuildDefinitionArray = this.getSupportedBuildDefinitions();
            int n = iBuildDefinitionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IBuildDefinition definition = iBuildDefinitionArray[n2];
                supportedBuildDefinitions.add(definition);
                ++n2;
            }
        }
    }

    protected AddBuildDefinitionsDialog getAddBuildDefinitionsDialog() {
        return new AddBuildDefinitionsDialog(this.fAddBuildDefinitionsButton.getShell(), this.getBuildDefinitionToProjectAreaName(), this.getSupportedBuildDefinitions(), this.getProjectAreaName(), this.fEditor.getTeamRepository(), this.fEditor.getProjectAreaItemId());
    }

    protected void openNoDefinitionsWarningDialog() {
        MessageDialog.openWarning((Shell)this.fAddBuildDefinitionsButton.getShell(), (String)BuildEngineEditorMessages.BuildEngineEditor_NO_DEFS_WARNING_TITLE, (String)BuildEngineEditorMessages.BuildEngineEditor_NO_DEFS_WARNING_MESSAGE);
    }

    protected void openAllDefinitionsAlreadyAddedWarningDialog() {
        MessageDialog.openWarning((Shell)this.fAddBuildDefinitionsButton.getShell(), (String)BuildEngineEditorMessages.BuildEngineEditor_NO_DEFS_WARNING_TITLE, (String)BuildEngineEditorMessages.BuildEngineEditor_ALL_DEFS_ADDED_WARNING_MESSAGE);
    }

    private void refreshTableView(IBuildDefinition[] definitions) {
        this.fBuildDefinitionsTableViewer.setInput((Object)definitions);
        this.validate();
    }

    protected IBuildPropertyControlListener getPropertyListener() {
        return new IBuildPropertyControlListener(){

            @Override
            public void propertyAdded(IBuildProperty buildProperty) {
                GeneralEngineConfigurationEditor.this.handlePropertyAdded(buildProperty);
            }

            @Override
            public void propertyEdited(IBuildProperty buildProperty) {
                GeneralEngineConfigurationEditor.this.handlePropertyEdited(buildProperty);
            }

            @Override
            public void propertiesRemoved(IBuildProperty[] buildProperties) {
                GeneralEngineConfigurationEditor.this.handlePropertiesRemoved(buildProperties);
            }
        };
    }

    private void handlePropertyAdded(IBuildProperty buildProperty) {
        this.getManagedForm().reflow(true);
        this.setDirty(true);
    }

    private void handlePropertyEdited(IBuildProperty editedProperty) {
        this.setDirty(true);
    }

    private void handlePropertiesRemoved(IBuildProperty[] removedProperties) {
        this.getManagedForm().reflow(true);
        this.setDirty(true);
    }

    @Override
    public void setWorkingCopy(IBuildEngine engine) {
        this.fBuildEngine = engine;
    }

    @Override
    public boolean validate() {
        boolean isValid = true;
        boolean isWarning = false;
        if (!this.fContentCreated) {
            return false;
        }
        if (this.fMonitoringButton.getSelection() && !this.isPositiveInteger(this.fMonitoringThresholdText.getText())) {
            this.addErrorMessage((Object)BuildEngineEditorMessages.BuildEngineEditor_THRESHOLD_MUST_BE_POSITIVE_INTEGER, NLS.bind((String)BuildEngineEditorMessages.BuildEngineEditor_THRESHOLD_MUST_BE_POSITIVE_INTEGER, (Object)Integer.MAX_VALUE), (Control)this.fMonitoringThresholdText);
            isValid = false;
        } else {
            this.removeMessage(BuildEngineEditorMessages.BuildEngineEditor_THRESHOLD_MUST_BE_POSITIVE_INTEGER, (Control)this.fMonitoringThresholdText);
        }
        boolean isBuildForgeEngine = BuildEngineHelper.isBuildForgeEngine((IBuildEngine)this.fBuildEngine);
        boolean isBuildAgentEngine = BuildEngineHelper.isBuildAgentEngine((IBuildEngine)this.fBuildEngine);
        boolean isJazzBuildEngine = !isBuildForgeEngine && !isBuildAgentEngine;
        boolean isBuildForgeBasedBuildDefinitionExpected = false;
        boolean isBuildAgentBasedBuildDefinitionExpected = false;
        boolean isJazzBuildEngineBasedBuildDefinitionExpected = false;
        IBuildDefinition[] iBuildDefinitionArray = this.getSupportedBuildDefinitions();
        int n = iBuildDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            boolean isJazzBuildEngineBasedBuildDefinition;
            IBuildDefinition object;
            IBuildDefinition buildDefinition = object = iBuildDefinitionArray[n2];
            boolean isBuildForgeBasedBuildDefinition = BuildEngineHelper.isBuildForgeDefinition((IBuildDefinition)buildDefinition);
            boolean isBuildAgentBasedBuildDefinition = BuildEngineHelper.isBuildAgentDefinition((IBuildDefinition)buildDefinition);
            boolean bl = isJazzBuildEngineBasedBuildDefinition = !isBuildForgeBasedBuildDefinition && !isBuildAgentBasedBuildDefinition;
            if (isBuildForgeEngine && !isBuildForgeBasedBuildDefinition) {
                this.addWarningMessage(BuildEngineEditorMessages.BuildEngineEditor_BuildForgeBasedBuildDefinitionExpected, NLS.bind((String)BuildEngineEditorMessages.BuildEngineEditor_BuildForgeBasedBuildDefinitionExpected, (Object)buildDefinition.getId()), this.fBuildDefinitionsTableViewer.getControl());
                isBuildForgeBasedBuildDefinitionExpected = true;
                isWarning = true;
            } else if (isBuildAgentEngine && !isBuildAgentBasedBuildDefinition) {
                this.addWarningMessage(BuildEngineEditorMessages.BuildEngineEditor_BuildAgentBasedBuildDefinitionExpected, NLS.bind((String)BuildEngineEditorMessages.BuildEngineEditor_BuildAgentBasedBuildDefinitionExpected, (Object)buildDefinition.getId()), this.fBuildDefinitionsTableViewer.getControl());
                isBuildAgentBasedBuildDefinitionExpected = true;
                isWarning = true;
            } else if (isJazzBuildEngine && !isJazzBuildEngineBasedBuildDefinition) {
                this.addWarningMessage(BuildEngineEditorMessages.BuildEngineEditor_JazzBuildEngineBasedBuildDefinitionExpected, NLS.bind((String)BuildEngineEditorMessages.BuildEngineEditor_JazzBuildEngineBasedBuildDefinitionExpected, (Object)buildDefinition.getId()), this.fBuildDefinitionsTableViewer.getControl());
                isJazzBuildEngineBasedBuildDefinitionExpected = true;
                isWarning = true;
            }
            ++n2;
        }
        if (!isBuildForgeBasedBuildDefinitionExpected) {
            this.removeMessage(BuildEngineEditorMessages.BuildEngineEditor_BuildForgeBasedBuildDefinitionExpected, this.fBuildDefinitionsTableViewer.getControl());
        }
        if (!isBuildAgentBasedBuildDefinitionExpected) {
            this.removeMessage(BuildEngineEditorMessages.BuildEngineEditor_BuildAgentBasedBuildDefinitionExpected, this.fBuildDefinitionsTableViewer.getControl());
        }
        if (!isJazzBuildEngineBasedBuildDefinitionExpected) {
            this.removeMessage(BuildEngineEditorMessages.BuildEngineEditor_JazzBuildEngineBasedBuildDefinitionExpected, this.fBuildDefinitionsTableViewer.getControl());
        }
        this.validateLastContactTime();
        this.setPageStatusIndicator(!isValid, isWarning);
        return isValid;
    }

    private boolean isPositiveInteger(String number) {
        try {
            int i = Integer.parseInt(number);
            return i > 0;
        }
        catch (NumberFormatException exception) {
            return false;
        }
    }

    protected void validateLastContactTime() {
        IBuildEngineStatusRecord engineRecord = this.getBuildEngineStatusRecord();
        if (engineRecord != null) {
            if (engineRecord.isEngineInWarningState()) {
                if (engineRecord.getLastContactTime() == null) {
                    Status status = new Status(2, BuildUIPlugin.getUniqueIdentifier(), BuildEngineEditorMessages.BuildEngineEditor_NEVER_CONTACTED);
                    this.addErrorMessage((Object)LAST_CONTACT_WARNING_ID, BuildEngineEditorMessages.BuildEngineEditor_NOT_RUNNING, (IStatus)status);
                } else if (engineRecord.isMonitoringThresholdExceeded()) {
                    Status status = new Status(2, BuildUIPlugin.getUniqueIdentifier(), NLS.bind((String)BuildEngineEditorMessages.BuildEngineEditor_THRESHOLD_EXCEEDED, (Object)this.fBuildEngine.getMonitoringThreshold()));
                    this.addErrorMessage((Object)LAST_CONTACT_WARNING_ID, BuildEngineEditorMessages.BuildEngineEditor_NOT_RUNNING, (IStatus)status);
                }
            } else {
                this.removeMessage(LAST_CONTACT_WARNING_ID);
            }
        }
    }

    private void applyPropertyChanges() {
        Iterator iterator = this.fBuildEngine.getProperties().iterator();
        while (iterator.hasNext()) {
            IBuildProperty property = (IBuildProperty)iterator.next();
            if (!property.isGenericEditAllowed()) continue;
            iterator.remove();
        }
        for (Object object : this.fBuildPropertyControl.getBuildProperties()) {
            IBuildProperty property = (IBuildProperty)object;
            if (!property.isGenericEditAllowed()) continue;
            this.fBuildEngine.getProperties().add(property);
        }
    }

    public void preSave() {
        this.updateSupportedDefinitions();
        this.applyPropertyChanges();
    }

    public void postSave() {
        this.validateLastContactTime();
        this.fBuildPropertyControl.setBuildProperties(this.copyProperties(this.fBuildEngine.getProperties()));
    }

    protected Section getBuildDefinitionsSection() {
        return this.fBuildDefinitionsSection;
    }

    protected void setAllBuildDefinitionsSize(int allDefinitions) {
        this.fEditor.setAllDefinitionsSize(allDefinitions);
    }

    protected void setAllBuildDefinitionsFetched(boolean allDefinitions) {
        this.fEditor.setAllBuildDefinitionsFetched(allDefinitions);
    }
}

