/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.buildengine;

import com.ibm.team.build.client.ClientFactory;
import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.common.buildengine.IBuildEngineTemplate;
import com.ibm.team.build.common.model.IBuildConfigurationElement;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.common.model.IBuildEngineHandle;
import com.ibm.team.build.common.model.query.IBaseBuildDefinitionQueryModel;
import com.ibm.team.build.internal.client.ITeamBuildRecordClient;
import com.ibm.team.build.internal.client.iterator.ItemQueryIterator;
import com.ibm.team.build.internal.common.helper.ItemHandleAwareHashMap;
import com.ibm.team.build.internal.common.model.dto.IBuildEngineStatusRecord;
import com.ibm.team.build.internal.common.model.impl.BuildEngineImpl;
import com.ibm.team.build.internal.common.model.query.BaseBuildEngineQueryModel;
import com.ibm.team.build.internal.common.registry.BuildEngineTemplateExtension;
import com.ibm.team.build.internal.common.registry.BuildEngineTemplateExtensionManager;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.editors.BuildItemEditor;
import com.ibm.team.build.internal.ui.editors.buildengine.BuildEngineConfigurationElementEditorExtension;
import com.ibm.team.build.internal.ui.editors.buildengine.BuildEngineConfigurationElementEditorExtensionManager;
import com.ibm.team.build.internal.ui.editors.buildengine.BuildEngineEditorInput;
import com.ibm.team.build.internal.ui.editors.buildengine.BuildEngineEditorMessages;
import com.ibm.team.build.internal.ui.editors.buildengine.GeneralEngineConfigurationEditor;
import com.ibm.team.build.ui.editors.buildengine.AbstractEngineConfigurationElementEditor;
import com.ibm.team.build.ui.editors.buildengine.IEngineConfigurationElementEditorFactory;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.rcp.ui.ProcessAreaSelectionDialog;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IFetchResult;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.service.IQueryService;
import com.ibm.team.repository.common.util.NLS;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class BuildEngineEditor
extends BuildItemEditor {
    private boolean fDirty;
    protected ITeamRepository fTeamRepository;
    protected IBuildEngine fBuildEngine;
    private boolean fIsNewEngine;
    private IProcessArea fProcessArea;
    protected IBuildEngineStatusRecord fBuildEngineStatusRecord;
    private BuildEngineEditorInput fEditorInput;
    private String fProjectAreaName;
    private String fProjectAreaItemID;
    private IBuildDefinition[] fSupportedBuildDefinitions;
    private Map<IBuildDefinition, String> fBuildDefinitionToProjectAreaName;
    private List<IBuildDefinitionHandle> fHiddenBuildDefinitions;
    protected boolean fSaveAttempted;
    protected Text fIdText;
    protected Text fProcessAreaText;
    private Button fChangeProcessAreaButton;
    private ModifyListener fIdModifiedListener = this.getIdModifiedListener();
    private boolean fRefreshed = false;
    private Integer allDefinitionsSize = 0;
    private boolean allBuildDefinitionsFetched = false;

    public BuildEngineEditor() {
        this.fSupportedBuildDefinitions = new IBuildDefinition[0];
        this.fBuildDefinitionToProjectAreaName = new HashMap<IBuildDefinition, String>();
    }

    @Override
    protected void createHeaderContents(IManagedForm headerForm) {
        this.getToolkit().setBorderStyle(2048);
        super.createHeaderContents(headerForm);
        this.createHeaderSecondRow(headerForm);
    }

    private void createHeaderSecondRow(IManagedForm headerForm) {
        FormToolkit toolkit = this.getToolkit();
        Composite head = headerForm.getForm().getForm().getHead();
        Composite headClient = new Composite(head, 0);
        GridLayout layout = new GridLayout(6, false);
        headClient.setLayout((Layout)layout);
        GridData gridData = new GridData();
        headClient.setLayoutData((Object)gridData);
        Label label = toolkit.createLabel(headClient, BuildEngineEditorMessages.ID_LABEL);
        label.setBackground(null);
        BuildEngineEditorInput input = (BuildEngineEditorInput)this.getEditorInput();
        this.fIdText = toolkit.createText(headClient, TextProcessor.process((String)input.getBuildEngine().getId()));
        GridData layoutData = new GridData(768);
        layoutData.widthHint = 100;
        this.fIdText.setLayoutData((Object)layoutData);
        this.fIdText.addModifyListener(this.fIdModifiedListener);
        label = toolkit.createLabel(headClient, "");
        gridData = new GridData();
        gridData.widthHint = 5;
        label.setLayoutData((Object)gridData);
        label.setBackground(null);
        label = toolkit.createLabel(headClient, BuildEngineEditorMessages.PROCESS_AREA_LABEL);
        label.setBackground(null);
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.fProcessAreaText = toolkit.createText(headClient, TextProcessor.process((String)this.fProcessArea.getName()), 2052);
        this.fProcessAreaText.setLayoutData((Object)new GridData(768));
        this.fProcessAreaText.setEditable(false);
        this.fChangeProcessAreaButton = toolkit.createButton(headClient, BuildEngineEditorMessages.BUTTON_LABEL_ASSIGN_PROCESS_AREA, 8);
        this.fChangeProcessAreaButton.addSelectionListener((SelectionListener)this.getProcessAreaSelectionListener());
        this.setPartName();
        headerForm.getForm().setHeadClient((Control)headClient);
    }

    @Override
    public ITeamRepository getTeamRepository() {
        return this.fTeamRepository;
    }

    @Override
    protected String getHeaderTitleText() {
        return BuildEngineEditorMessages.BUILD_ENGINE_EDITOR_TITLE;
    }

    @Override
    protected Image getHeaderTitleImage() {
        return BuildUIPlugin.getImage("icons/obj16/bld_srvr.gif");
    }

    @Override
    public IItem getBuildItem() {
        return this.fBuildEngine;
    }

    protected void addPages() {
        try {
            Object[] configurationElements = this.fBuildEngine.getConfigurationElements().toArray();
            Arrays.sort(configurationElements, this.getConfigurationElementComparator());
            Object[] objectArray = configurationElements;
            int n = configurationElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                this.addPage(((IBuildConfigurationElement)object).getElementId());
                ++n2;
            }
            if (this.getPages().length == 0) {
                this.addPage("com.ibm.team.build.engine.general");
            }
        }
        catch (PartInitException exception) {
            this.logError((Exception)((Object)exception));
        }
        catch (IllegalArgumentException exception) {
            this.logError(exception);
        }
        catch (CoreException exception) {
            this.logError((Exception)((Object)exception));
        }
    }

    protected void createPages() {
        super.createPages();
        this.refreshBuildItem();
    }

    protected Comparator getConfigurationElementComparator() {
        return new Comparator(){

            public int compare(Object object1, Object object2) {
                IBuildConfigurationElement element1 = (IBuildConfigurationElement)object1;
                IBuildConfigurationElement element2 = (IBuildConfigurationElement)object2;
                return element1.getBuildPhase().ordinal() - element2.getBuildPhase().ordinal();
            }
        };
    }

    protected int addPage(String elementId) throws IllegalArgumentException, CoreException {
        IEngineConfigurationElementEditorFactory factory;
        AbstractEngineConfigurationElementEditor elementEditor;
        BuildEngineConfigurationElementEditorExtension editorExtension;
        int pageIndex = -1;
        if (this.getPage(elementId) == null && (editorExtension = BuildEngineConfigurationElementEditorExtensionManager.getInstance().getBuildConfigurationElementEditor(elementId)) != null && (elementEditor = (factory = editorExtension.createEditorFactory()).createElementEditor(editorExtension.getElementIdAttribute(), editorExtension.getNameAttribute())) != null) {
            elementEditor.initialize(this);
            elementEditor.setWorkingCopy(this.fBuildEngine);
            pageIndex = this.addPage((IFormPage)elementEditor);
            this.initializePage(this.getPages()[pageIndex]);
        }
        return pageIndex;
    }

    private void removePages(List<String> removedElementIds) {
        for (String elementId : removedElementIds) {
            IFormPage[] formPages = this.getPages();
            int index = -1;
            int i = 0;
            while (i < formPages.length) {
                if (formPages[i].getId().equals(elementId)) {
                    index = i;
                    break;
                }
                ++i;
            }
            if (index <= -1) continue;
            this.removePage(index);
        }
    }

    private IFormPage getPage(String elementId) {
        IFormPage[] formPages = this.getPages();
        int i = 0;
        while (i < formPages.length) {
            if (formPages[i].getId().equals(elementId)) {
                return formPages[i];
            }
            ++i;
        }
        return null;
    }

    protected void initializePage(IFormPage page) {
        page.createPartControl(this.getContainer());
        this.setControl(page.getIndex(), page.getPartControl());
        page.getPartControl().setMenu(this.getContainer().getMenu());
    }

    protected void logError(Exception exception) {
        BuildUIPlugin.log(exception);
    }

    protected ProcessAreaSelectionDialog getProcessAreaSelectionDialog() {
        ProcessAreaSelectionDialog dialog = new ProcessAreaSelectionDialog(this.getSite().getShell(), false);
        dialog.setAllowArchivedAreas(true);
        return dialog;
    }

    @Override
    protected void disposeEditorSections() {
    }

    @Override
    protected void refreshBuildItem(IProgressMonitor monitor) throws TeamRepositoryException {
        this.setAllBuildDefinitionsFetched(false);
        this.fSupportedBuildDefinitions = this.fetchSupportedBuildDefinitions(this.fBuildEngine, monitor);
        this.fBuildDefinitionToProjectAreaName = this.fetchDefinitionToProjectName(this.fSupportedBuildDefinitions, monitor);
        this.allDefinitionsSize = this.getAllBuildDefinitionsSize(monitor);
        if (!this.fIsNewEngine) {
            this.fBuildEngineStatusRecord = this.fetchBuildEngineStatusRecord((IBuildEngineHandle)this.fBuildEngine, monitor);
            this.fBuildEngine = this.fBuildEngineStatusRecord.getBuildEngine();
        }
        this.fBuildEngine = (IBuildEngine)this.fBuildEngine.getWorkingCopy();
        this.updatePageWorkingCopies(this.fBuildEngine);
        IProcessAreaHandle processAreaHandle = this.fBuildEngine.getProcessArea();
        if (processAreaHandle != null) {
            this.fProcessArea = (IProcessArea)this.fTeamRepository.itemManager().fetchCompleteItem((IItemHandle)processAreaHandle, 1, monitor);
        }
        this.setProjectAreaNameAndItemID(this.fProcessArea, monitor);
    }

    protected Integer getAllBuildDefinitionsSize(IProgressMonitor monitor) throws TeamRepositoryException {
        Integer size = 0;
        BaseBuildEngineQueryModel.BuildEngineQueryModel model = BaseBuildEngineQueryModel.BuildEngineQueryModel.ROOT;
        IItemQuery itemQuery = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
        ItemQueryIterator iter = new ItemQueryIterator(this.getBuildClient(), itemQuery, IQueryService.EMPTY_PARAMETERS);
        while (iter.hasNext(monitor)) {
            List definitionHandles = iter.next(512, monitor);
            size = size + definitionHandles.size();
        }
        return size;
    }

    public int getAllDefinitionsSize() {
        return this.allDefinitionsSize == null ? 0 : this.allDefinitionsSize;
    }

    protected void setAllDefinitionsSize(int allDefinitions) {
        this.allDefinitionsSize = new Integer(allDefinitions);
    }

    private ITeamBuildClient getBuildClient() {
        return ClientFactory.getTeamBuildClient((ITeamRepository)this.fTeamRepository);
    }

    protected IBuildDefinition[] fetchBuildDefinitions(IProgressMonitor monitor) throws TeamRepositoryException {
        IItemManager itemManager = this.fTeamRepository.itemManager();
        IItemQuery itemQuery = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)IBaseBuildDefinitionQueryModel.IBuildDefinitionQueryModel.ROOT);
        ItemQueryIterator iter = new ItemQueryIterator(this.getBuildClient(), itemQuery, IQueryService.EMPTY_PARAMETERS);
        LinkedList buildDefinitions = new LinkedList();
        while (iter.hasNext(monitor)) {
            List definitionHandles = iter.next(512, monitor);
            buildDefinitions.addAll(itemManager.fetchCompleteItems(definitionHandles, 0, monitor));
        }
        Iterator definitionsIter = buildDefinitions.iterator();
        while (definitionsIter.hasNext()) {
            Object next = definitionsIter.next();
            if (next != null) continue;
            definitionsIter.remove();
        }
        IBuildDefinition[] allDefinitions = new IBuildDefinition[buildDefinitions.size()];
        allDefinitions = buildDefinitions.toArray(allDefinitions);
        return allDefinitions;
    }

    protected IBuildEngineStatusRecord fetchBuildEngineStatusRecord(IBuildEngineHandle engine, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamBuildRecordClient client = (ITeamBuildRecordClient)this.fTeamRepository.getClientLibrary(ITeamBuildRecordClient.class);
        return client.getBuildEngineStatusRecord(engine, monitor);
    }

    protected IBuildDefinition[] fetchSupportedBuildDefinitions(IBuildEngine buildEngine, IProgressMonitor monitor) throws TeamRepositoryException {
        IFetchResult fetchResult = this.fTeamRepository.itemManager().fetchCompleteItemsPermissionAware(buildEngine.getSupportedBuildDefinitions(), 0, monitor);
        ArrayList visibleBuildDefinitions = new ArrayList();
        this.fHiddenBuildDefinitions = new ArrayList<IBuildDefinitionHandle>();
        if (fetchResult.getRetrievedItems().size() > 0) {
            visibleBuildDefinitions.addAll(fetchResult.getRetrievedItems());
        }
        if (!this.isNewItem() && fetchResult.getPermissionDeniedItems().size() > 0) {
            this.fHiddenBuildDefinitions.addAll(fetchResult.getPermissionDeniedItems());
        }
        return visibleBuildDefinitions.toArray(new IBuildDefinition[visibleBuildDefinitions.size()]);
    }

    public Map<IBuildDefinition, String> fetchDefinitionToProjectName(IBuildDefinition[] buildDefinitions, IProgressMonitor monitor) throws TeamRepositoryException {
        HashMap<IBuildDefinition, String> definitionToProjectName = new HashMap<IBuildDefinition, String>();
        if (buildDefinitions.length > 0) {
            ArrayList<ITeamAreaHandle> teamAreaHandles = new ArrayList<ITeamAreaHandle>();
            ArrayList<IProjectAreaHandle> projectAreaHandles = new ArrayList<IProjectAreaHandle>();
            IBuildDefinition[] iBuildDefinitionArray = buildDefinitions;
            int n = buildDefinitions.length;
            int n2 = 0;
            while (n2 < n) {
                IBuildDefinition definition = iBuildDefinitionArray[n2];
                IProcessAreaHandle handle = definition.getProcessArea();
                if (handle instanceof ITeamAreaHandle) {
                    teamAreaHandles.add((ITeamAreaHandle)handle);
                } else if (handle instanceof IProjectAreaHandle) {
                    projectAreaHandles.add((IProjectAreaHandle)handle);
                }
                ++n2;
            }
            ItemHandleAwareHashMap processAreaMap = new ItemHandleAwareHashMap();
            List teamAreas = this.getPartialItemList(teamAreaHandles, Collections.singletonList("projectArea"), monitor);
            for (ITeamArea teamArea : teamAreas) {
                if (teamArea == null) continue;
                processAreaMap.put((Object)teamArea, (Object)teamArea);
                if (teamArea.getProjectArea() == null) continue;
                projectAreaHandles.add(teamArea.getProjectArea());
            }
            List projectAreas = this.getPartialItemList(projectAreaHandles, Collections.singletonList("name"), monitor);
            for (IProjectArea projectArea : projectAreas) {
                if (projectArea == null) continue;
                processAreaMap.put((Object)projectArea, (Object)projectArea);
            }
            IBuildDefinition[] iBuildDefinitionArray2 = buildDefinitions;
            int n3 = buildDefinitions.length;
            int n4 = 0;
            while (n4 < n3) {
                IBuildDefinition definition = iBuildDefinitionArray2[n4];
                IProcessArea processArea = (IProcessArea)processAreaMap.get((Object)definition.getProcessArea());
                IProjectArea projectArea = processArea instanceof ITeamArea ? (IProjectArea)processAreaMap.get((Object)processArea.getProjectArea()) : (IProjectArea)processArea;
                String projectName = projectArea == null ? null : projectArea.getName();
                definitionToProjectName.put(definition, projectName);
                ++n4;
            }
        }
        return definitionToProjectName;
    }

    protected List getPartialItemList(List handles, List properties, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fTeamRepository.itemManager().fetchPartialItems(handles, 0, (Collection)properties, monitor);
    }

    protected void setProjectAreaNameAndItemID(IProcessArea processArea, IProgressMonitor monitor) throws TeamRepositoryException {
        if (processArea != null) {
            IProjectAreaHandle projectAreaHandle = processArea.getProjectArea();
            List<String> propertiesToFetch = new ArrayList<String>(Arrays.asList("name", IProjectArea.ITEM_ID_PROPERTY));
            propertiesToFetch = Collections.unmodifiableList(propertiesToFetch);
            IProjectArea partialProjectArea = (IProjectArea)this.getTeamRepository().itemManager().fetchPartialItem((IItemHandle)projectAreaHandle, 0, propertiesToFetch, monitor);
            this.fProjectAreaName = partialProjectArea.getName();
            this.fProjectAreaItemID = partialProjectArea.getItemId().getUuidValue();
        }
    }

    protected IMessageManager getMessageManager() {
        return this.fMessageManager;
    }

    @Override
    protected void handleRefreshComplete() {
        this.getMessageManager().removeAllMessages();
        int index = 0;
        while (index < this.getPages().length) {
            this.setPageImage(index, null);
            ++index;
        }
        boolean firstRefresh = !this.isRefreshed();
        this.fRefreshed = true;
        this.fIdText.removeModifyListener(this.fIdModifiedListener);
        this.fIdText.setText(TextProcessor.process((String)this.fBuildEngine.getId()));
        this.fIdText.addModifyListener(this.fIdModifiedListener);
        this.fProcessAreaText.setText(TextProcessor.process((String)this.fProcessArea.getName()));
        this.setPartName();
        if (firstRefresh) {
            this.addConfigElementsForConnectorEngines();
        }
        this.addPages();
        LinkedList<String> pageIdsToRemove = new LinkedList<String>();
        IFormPage[] formPages = this.getPages();
        int i = 0;
        while (i < formPages.length) {
            if (!(this.fBuildEngine.getConfigurationElement(formPages[i].getId()) != null || "com.ibm.team.build.engine.general".equals(formPages[i].getId()) && this.fBuildEngine.getConfigurationElements().isEmpty())) {
                pageIdsToRemove.add(formPages[i].getId());
            }
            ++i;
        }
        this.removePages(pageIdsToRemove);
        for (Object page : this.pages) {
            AbstractEngineConfigurationElementEditor editorPage = (AbstractEngineConfigurationElementEditor)((Object)page);
            editorPage.refresh();
            IManagedForm managedForm = editorPage.getManagedForm();
            if (managedForm == null) continue;
            managedForm.reflow(true);
        }
        if (!firstRefresh) {
            this.setDirty(false);
        }
    }

    protected boolean isRefreshed() {
        return this.fRefreshed;
    }

    protected GeneralEngineConfigurationEditor getGeneralPage() {
        IFormPage[] iFormPageArray = this.getPages();
        int n = iFormPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFormPage page = iFormPageArray[n2];
            if (page instanceof GeneralEngineConfigurationEditor) {
                return (GeneralEngineConfigurationEditor)page;
            }
            ++n2;
        }
        return null;
    }

    protected ModifyListener getIdModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BuildEngineEditor.this.fBuildEngine.setId(TextProcessor.deprocess((String)BuildEngineEditor.this.fIdText.getText()));
                BuildEngineEditor.this.setPartName();
                if (BuildEngineEditor.this.shouldValidate()) {
                    BuildEngineEditor.this.validate();
                }
                BuildEngineEditor.this.setDirty(true);
            }
        };
    }

    protected SelectionAdapter getProcessAreaSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProcessAreaSelectionDialog dialog = BuildEngineEditor.this.getProcessAreaSelectionDialog();
                dialog.setInput((Object)BuildEngineEditor.this.fTeamRepository);
                if (dialog.open() == 0) {
                    BuildEngineEditor.this.fProcessArea = dialog.getSelectedProcessArea();
                    BuildEngineEditor.this.fProcessAreaText.setText(TextProcessor.process((String)BuildEngineEditor.this.fProcessArea.getName()));
                    BuildEngineEditor.this.fBuildEngine.setProcessArea((IProcessAreaHandle)BuildEngineEditor.this.fProcessArea);
                    if (BuildEngineEditor.this.shouldValidate()) {
                        BuildEngineEditor.this.validate();
                    }
                    BuildEngineEditor.this.setDirty(true);
                }
            }
        };
    }

    public void setFocus() {
        int pageIndex = this.getActivePage();
        if (pageIndex != -1) {
            IFormPage page = (IFormPage)this.pages.get(pageIndex);
            page.setFocus();
        } else {
            super.setFocus();
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.fEditorInput = (BuildEngineEditorInput)input;
        this.fTeamRepository = this.fEditorInput.getTeamRepository();
        this.fIsNewEngine = this.fEditorInput.isNewBuildEngine();
        this.fBuildEngine = (IBuildEngine)this.fEditorInput.getBuildEngine().getWorkingCopy();
        this.fProcessArea = this.fEditorInput.getProcessArea();
        if (this.fIsNewEngine) {
            for (IBuildDefinitionHandle supportedDefinition : this.fEditorInput.getDefaultSupportedBuildDefinitions()) {
                this.fBuildEngine.getSupportedBuildDefinitions().add(supportedDefinition);
            }
            this.setDirty(true);
        }
    }

    private void addConfigElementsForConnectorEngines() {
        boolean modified = false;
        if ("RationalBuildForgeConnector".equals(this.fBuildEngine.getId())) {
            modified |= this.ensureEngineHasTemplate("com.ibm.rational.connector.buildforge.engine.template");
        }
        if ("RationalBuildAgent".equals(this.fBuildEngine.getId())) {
            modified |= this.ensureEngineHasTemplate("com.ibm.rational.buildforge.buildagent.engine");
        }
        if (modified) {
            this.setDirty(true);
        }
    }

    private boolean ensureEngineHasTemplate(String templateId) {
        BuildEngineTemplateExtension template;
        BuildEngineImpl engine = (BuildEngineImpl)this.fBuildEngine;
        if (engine.getTemplateId() == null && (template = BuildEngineTemplateExtensionManager.getInstance().getBuildEngineTemplate(templateId)) != null) {
            engine.initializeConfiguration((IBuildEngineTemplate)template);
            this.notifyAboutConfigurationChange(template);
            return true;
        }
        return false;
    }

    private void notifyAboutConfigurationChange(final BuildEngineTemplateExtension template) {
        this.getContainer().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!BuildEngineEditor.this.getContainer().isDisposed()) {
                    MessageDialog.openInformation((Shell)BuildEngineEditor.this.getContainer().getShell(), (String)BuildEngineEditorMessages.BuildEngineEditor_ENGINE_UPDATED_TITLE, (String)NLS.bind((String)BuildEngineEditorMessages.BuildEngineEditor_ENGINE_UPDATED_MESSAGE, (Object)template.getName(), (Object[])new Object[0]));
                }
            }
        });
    }

    @Override
    protected boolean isNewItem() {
        return this.fIsNewEngine;
    }

    public boolean isDirty() {
        if (this.fDirty) {
            return true;
        }
        for (Object page : this.pages) {
            AbstractEngineConfigurationElementEditor editorPage = (AbstractEngineConfigurationElementEditor)((Object)page);
            if (!editorPage.isDirty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSaveAsAllowed() {
        return false;
    }

    protected boolean validate() {
        this.fSaveAttempted = true;
        boolean isValid = true;
        if (TextProcessor.deprocess((String)this.fIdText.getText()).trim().equals("")) {
            this.addErrorMessage((Object)this.fIdText, BuildEngineEditorMessages.ID_MUST_NOT_BE_EMPTY, (Control)this.fIdText);
            isValid = false;
        } else {
            this.removeMessage(this.fIdText, (Control)this.fIdText);
        }
        if (TextProcessor.deprocess((String)this.fProcessAreaText.getText()).trim().equals("")) {
            this.addErrorMessage((Object)this.fProcessAreaText, BuildEngineEditorMessages.PROCESS_AREA_MUST_NOT_BE_EMPTY, (Control)this.fProcessAreaText);
            isValid = false;
        } else {
            this.removeMessage(this.fProcessAreaText, (Control)this.fProcessAreaText);
        }
        for (Object page : this.pages) {
            AbstractEngineConfigurationElementEditor editorPage = (AbstractEngineConfigurationElementEditor)((Object)page);
            if (editorPage.validate()) continue;
            isValid = false;
        }
        return isValid;
    }

    private boolean shouldValidate() {
        return !this.fIsNewEngine || this.fSaveAttempted;
    }

    private void setPartName() {
        String label = this.fBuildEngine.getId();
        if (label.equals("")) {
            label = BuildEngineEditorMessages.BuildEngineEditor_PART_NAME_NEW_ENGINE;
        }
        this.setPartName(label);
    }

    @Override
    protected String getBuildItemTypeName() {
        return BuildEngineEditorMessages.BuildEngineEditor_BUILD_ENGINE_ITEM_NAME;
    }

    @Override
    protected boolean preSave() {
        GeneralEngineConfigurationEditor generalPage;
        this.fSaveAttempted = true;
        boolean proceed = this.validate();
        if (proceed && (generalPage = this.getGeneralPage()) != null) {
            generalPage.preSave();
            if (!this.isNewItem()) {
                this.addHiddenBuildDefinitions();
            }
        }
        return proceed;
    }

    private void addHiddenBuildDefinitions() {
        if (this.fHiddenBuildDefinitions != null && this.fHiddenBuildDefinitions.size() > 0) {
            this.fBuildEngine.getSupportedBuildDefinitions().addAll(this.fHiddenBuildDefinitions);
        }
    }

    @Override
    protected void postSave(boolean saveSucceeded) {
        if (!saveSucceeded) {
            return;
        }
        GeneralEngineConfigurationEditor generalPage = this.getGeneralPage();
        if (generalPage != null) {
            generalPage.postSave();
        }
        this.setPartName();
        this.updatePageDirtyBits(false);
        this.setDirty(false);
    }

    @Override
    protected void performSave(IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask(BuildEngineEditorMessages.SAVING_MESSAGE, 2);
        try {
            IBuildEngine buildengine = this.getBuildClient().save(this.fBuildEngine, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.fBuildEngineStatusRecord = this.fetchBuildEngineStatusRecord((IBuildEngineHandle)buildengine, monitor);
            this.fBuildEngine = (IBuildEngine)this.fBuildEngineStatusRecord.getBuildEngine().getWorkingCopy();
            this.fIsNewEngine = false;
            this.updatePageWorkingCopies(this.fBuildEngine);
            this.fSupportedBuildDefinitions = this.fetchSupportedBuildDefinitions(this.fBuildEngine, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        finally {
            monitor.done();
        }
    }

    protected void updatePageWorkingCopies(IBuildEngine engine) {
        for (Object page : this.pages) {
            AbstractEngineConfigurationElementEditor editorPage = (AbstractEngineConfigurationElementEditor)((Object)page);
            editorPage.setWorkingCopy(engine);
        }
    }

    private void updatePageDirtyBits(boolean isDirty) {
        for (Object page : this.pages) {
            AbstractEngineConfigurationElementEditor editorPage = (AbstractEngineConfigurationElementEditor)((Object)page);
            editorPage.setDirty(isDirty);
        }
    }

    protected Map<IBuildDefinition, String> getBuildDefinitionToProjectAreaName() {
        return this.fBuildDefinitionToProjectAreaName;
    }

    protected Collection<IBuildDefinition> getBuildDefinitions() {
        return this.fBuildDefinitionToProjectAreaName.keySet();
    }

    protected IBuildDefinition[] getSupportedBuildDefinitions() {
        return this.fSupportedBuildDefinitions;
    }

    protected List<IBuildDefinitionHandle> getHiddenBuildDefinitions() {
        return this.fHiddenBuildDefinitions;
    }

    protected IBuildEngine getBuildEngine() {
        return this.fBuildEngine;
    }

    protected IBuildEngineStatusRecord getBuildEngineStatusRecord() {
        return this.fBuildEngineStatusRecord;
    }

    private void setDirty(boolean isDirty) {
        this.fDirty = isDirty;
        this.fireDirtyPropertyChangeEvent();
    }

    @Override
    protected String getHelpId() {
        return "com.ibm.team.build.ui.editor_buildengine";
    }

    protected Map<IBuildDefinition, String> getDefinitionToProjectAreaName() {
        return this.fBuildDefinitionToProjectAreaName;
    }

    protected String getProjectAreaName() {
        return this.fProjectAreaName;
    }

    protected String getProjectAreaItemId() {
        return this.fProjectAreaItemID;
    }

    protected IProcessArea getBuildProcessArea() {
        return this.fProcessArea;
    }

    protected void setBuildProcessArea(IProcessArea buildProcessArea) {
        this.fProcessArea = buildProcessArea;
    }

    protected void setBuildDefinitionToProjectAreaName(Map<IBuildDefinition, String> definitionToName) {
        this.fBuildDefinitionToProjectAreaName = definitionToName;
    }

    protected void setSupportedBuildDefinitions(IBuildDefinition[] supportedBuildDefinitions) {
        this.fSupportedBuildDefinitions = supportedBuildDefinitions;
    }

    protected void setHiddenBuildDefinitions(List<IBuildDefinitionHandle> hiddenBuildDefinitions) {
        this.fHiddenBuildDefinitions = hiddenBuildDefinitions;
    }

    public boolean isSaveAttempted() {
        return this.fSaveAttempted;
    }

    public void fireDirtyPropertyChangeEvent() {
        this.firePropertyChange(257);
    }

    public void setFocusInHeader() {
        if (this.fIdText != null) {
            this.fIdText.setFocus();
        }
    }

    public boolean isAllBuildDefinitionsFetched() {
        return this.allBuildDefinitionsFetched;
    }

    public void setAllBuildDefinitionsFetched(boolean allBuildDefinitionsFetched) {
        this.allBuildDefinitionsFetched = allBuildDefinitionsFetched;
    }
}

