/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.buildengine;

import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.editors.buildengine.BuildEngineConfigurationElementEditorExtension;
import com.ibm.team.build.internal.ui.editors.result.BuildResultEditorMessages;
import java.util.LinkedList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IActivity;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;

public class BuildEngineConfigurationElementEditorExtensionManager {
    public static final String EXTENSION_POINT_ID_BUILD_ENGINE_CONFIGURATION_ELEMENT_EDITORS = "com.ibm.team.build.ui.buildEngineConfigurationElementEditors";
    protected static BuildEngineConfigurationElementEditorExtensionManager fManager = null;
    private BuildEngineConfigurationElementEditorExtension[] fExtensions = this.loadBuildEngineConfigurationElementEditorExtensions();

    protected BuildEngineConfigurationElementEditorExtensionManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BuildEngineConfigurationElementEditorExtensionManager getInstance() {
        Class<BuildEngineConfigurationElementEditorExtensionManager> clazz = BuildEngineConfigurationElementEditorExtensionManager.class;
        synchronized (BuildEngineConfigurationElementEditorExtensionManager.class) {
            if (fManager == null) {
                fManager = new BuildEngineConfigurationElementEditorExtensionManager();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return fManager;
        }
    }

    public BuildEngineConfigurationElementEditorExtension[] getBuildConfigurationElementEditors() {
        return this.fExtensions;
    }

    public BuildEngineConfigurationElementEditorExtension getBuildConfigurationElementEditor(String elementId) {
        BuildEngineConfigurationElementEditorExtension[] buildEngineConfigurationElementEditorExtensionArray = this.fExtensions;
        int n = this.fExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            BuildEngineConfigurationElementEditorExtension extension = buildEngineConfigurationElementEditorExtensionArray[n2];
            if (extension.getElementIdAttribute().equals(elementId)) {
                return extension;
            }
            ++n2;
        }
        return null;
    }

    protected IConfigurationElement[] getConfigurationElements(IExtensionPoint extensionPoint) {
        return extensionPoint.getConfigurationElements();
    }

    private BuildEngineConfigurationElementEditorExtension[] loadBuildEngineConfigurationElementEditorExtensions() {
        LinkedList<BuildEngineConfigurationElementEditorExtension> extensions = new LinkedList<BuildEngineConfigurationElementEditorExtension>();
        IWorkbenchActivitySupport workbenchActivitySupport = PlatformUI.getWorkbench().getActivitySupport();
        IActivityManager activityManager = workbenchActivitySupport.getActivityManager();
        IExtensionPoint extensionPoint = RegistryFactory.getRegistry().getExtensionPoint(EXTENSION_POINT_ID_BUILD_ENGINE_CONFIGURATION_ELEMENT_EDITORS);
        if (extensionPoint != null) {
            IConfigurationElement[] configurationElements = this.getConfigurationElements(extensionPoint);
            int i = 0;
            while (i < configurationElements.length) {
                IActivity activity;
                IConfigurationElement configElement = configurationElements[i];
                String activityId = configElement.getAttribute("activityId");
                if (activityId == null || (activity = activityManager.getActivity(activityId)) != null && activity.isEnabled()) {
                    try {
                        BuildEngineConfigurationElementEditorExtension extension = new BuildEngineConfigurationElementEditorExtension(configElement);
                        if (!extensions.contains(extension)) {
                            extensions.add(extension);
                        } else {
                            this.handleDuplicateExtensions(configElement);
                        }
                    }
                    catch (IllegalArgumentException exception) {
                        this.handleIllegalArgumentException(exception, configElement);
                    }
                }
                ++i;
            }
        }
        return extensions.toArray(new BuildEngineConfigurationElementEditorExtension[extensions.size()]);
    }

    private void handleDuplicateExtensions(IConfigurationElement configElement) {
        Object[] params = new String[]{this.getExtensionFQN(configElement), configElement.getAttribute("configurationElementId"), configElement.getContributor().getName()};
        String message = NLS.bind((String)BuildResultEditorMessages.BuildContributionManager_DUPLICATE_EXTENSION_POINT, (Object[])params);
        BuildUIPlugin.log(message);
    }

    private void handleIllegalArgumentException(IllegalArgumentException exception, IConfigurationElement configElement) {
        Object[] params = new String[]{this.getExtensionFQN(configElement), configElement.getContributor().getName()};
        String message = NLS.bind((String)BuildResultEditorMessages.BuildContributionManager_MISSING_OR_INVALID, (Object[])params);
        BuildUIPlugin.log(message);
    }

    private String getExtensionFQN(IConfigurationElement configElement) {
        return String.valueOf(configElement.getNamespaceIdentifier()) + "." + configElement.getName();
    }
}

