/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.builddefinition;

import com.ibm.team.build.common.builddefinition.PasswordType;
import com.ibm.team.build.common.builddefinition.UDeployConfigurationElement;
import com.ibm.team.build.common.model.IBuildConfigurationElement;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.internal.PasswordHelper;
import com.ibm.team.build.internal.ui.editors.builddefinition.BasicConfigurationElementEditor;
import com.ibm.team.build.internal.ui.editors.builddefinition.BuildDefinitionEditorMessages;
import com.urbancode.ud.client.TestConnectionClient;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Locale;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.impl.EnglishReasonPhraseCatalog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class UDeployConfigurationEditor
extends BasicConfigurationElementEditor {
    private static final int SPACER_HEIGHT = 10;
    private static final String JBE_CREATE_PASSWORD_FILE = "jbe -createPasswordFile";
    public static final String DEFAULT_VERSION = "${buildLabel}";
    public static final String DEFAULT_LINKS = String.valueOf(BuildDefinitionEditorMessages.UDeployConfigurationEditor_LINKS_DEFAULT_VALUE_BUILD_RESULT_LABEL) + "=${repositoryAddress}resource/itemOid/com.ibm.team.build.BuildResult/${buildResultUUID}";
    protected Button fEnabledButton;
    protected Button fTriggerPolicyAlwaysButton;
    protected Button fTriggerPolicyNoErrorsButton;
    protected Button fTriggerPolicyNoWarningsButton;
    protected Button fAbortOnIncompleteActivityEnabledButton;
    protected Button fPersonalBuildsEnabledButton;
    protected Text fServerURIText;
    protected Text fUserText;
    protected Button fPasswordButton;
    protected Text fPasswordText;
    protected Button fPasswordFileButton;
    protected Text fPasswordFileText;
    protected Text fTestConnectionText;
    protected Button fTestConnectionButton;
    protected Text fComponentText;
    protected Text fVersionText;
    protected Text fBaseDirectoryText;
    protected Text fIncludeFilesText;
    protected Text fExcludeFilesText;
    protected Text fPropertiesText;
    protected Text fLinksText;
    protected Button fProcessEnabledButton;
    protected Text fApplicationText;
    protected Text fEnvironmentText;
    protected Text fProcessText;

    public UDeployConfigurationEditor(String elementId, String title) {
        super(elementId, title);
    }

    @Override
    public void setWorkingCopy(IBuildDefinition definition) {
        IBuildProperty property;
        super.setWorkingCopy(definition);
        String currentValue = this.getConfigProperty("team.udeploy.baseDirectory", "");
        if (currentValue.isEmpty()) {
            IBuildConfigurationElement jazzScmConfigurationElement;
            String baseDirectory = ".";
            if (this.fWorkingCopy.isNewItem() && (jazzScmConfigurationElement = this.fWorkingCopy.getConfigurationElement("com.ibm.team.build.jazzscm")) != null) {
                baseDirectory = String.format("${%s}", "team.scm.fetchDestination");
            }
            this.setConfigProperty("team.udeploy.baseDirectory", baseDirectory);
        }
        if (!this.fWorkingCopy.isNewItem() && (property = this.fWorkingCopy.getProperty("team.udeploy.personalBuilds")) != null) {
            property.setGenericEditAllowed(false);
        }
    }

    @Override
    public void createContent(Composite parent, FormToolkit toolkit) {
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        layout.horizontalSpacing = 10;
        parent.setLayout((Layout)layout);
        Section triggerSection = this.createSection(parent, BuildDefinitionEditorMessages.UDeployConfigurationEditor_TRIGGER_SECTION_TITLE, BuildDefinitionEditorMessages.UDeployConfigurationEditor_TRIGGER_SECTION_DESC, false);
        Composite triggerComposite = (Composite)triggerSection.getClient();
        triggerSection.setLayoutData((Object)new TableWrapData(128, 256, 1, 2));
        this.createTriggerWidgets(triggerComposite);
        Section serverSection = this.createSection(parent, BuildDefinitionEditorMessages.UDeployConfigurationEditor_SERVER_SECTION_TITLE, BuildDefinitionEditorMessages.UDeployConfigurationEditor_SERVER_SECTION_DESC, false, 3);
        Composite serverComposite = (Composite)serverSection.getClient();
        serverSection.setLayoutData((Object)new TableWrapData(128, 256, 1, 1));
        this.createServerWidgets(serverComposite);
        Section testConnectionSection = this.createSection(parent, BuildDefinitionEditorMessages.UDeployConfigurationEditor_TEST_CONNECTION_SECTION_TITLE, BuildDefinitionEditorMessages.UDeployConfigurationEditor_TEST_CONNECTION_SECTION_DESC, false);
        Composite testConnectionComposite = (Composite)testConnectionSection.getClient();
        testConnectionSection.setLayoutData((Object)new TableWrapData(256, 256, 1, 1));
        this.createTestConnectionWidgets(testConnectionComposite);
        Section publishSection = this.createSection(parent, BuildDefinitionEditorMessages.UDeployConfigurationEditor_PUBLISH_SECTION_TITLE, BuildDefinitionEditorMessages.UDeployConfigurationEditor_PUBLISH_SECTION_DESC, false);
        Composite publishComposite = (Composite)publishSection.getClient();
        publishSection.setLayoutData((Object)new TableWrapData(256, 256, 1, 2));
        this.createPublishWidgets(publishComposite);
        Section processSection = this.createSection(parent, BuildDefinitionEditorMessages.UDeployConfigurationEditor_PROCESS_SECTION_TITLE, BuildDefinitionEditorMessages.UDeployConfigurationEditor_PROCESS_SECTION_DESC, false);
        Composite processComposite = (Composite)processSection.getClient();
        processSection.setLayoutData((Object)new TableWrapData(256, 256, 1, 2));
        this.createProcessWidgets(processComposite);
        this.enableFields(this.fEnabledButton.getSelection());
    }

    private void createTriggerWidgets(Composite parent) {
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        this.fEnabledButton = this.createConfigPropertyCheckboxField(parent, "team.udeploy.enabled", true, BuildDefinitionEditorMessages.UDeployConfigurationEditor_ENABLED_LABEL, BuildDefinitionEditorMessages.UDeployConfigurationEditor_ENABLED_TEXT, null, true);
        this.fEnabledButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UDeployConfigurationEditor.this.enableFields(UDeployConfigurationEditor.this.fEnabledButton.getSelection());
            }
        });
        toolkit.createLabel(parent, BuildDefinitionEditorMessages.UDeployConfigurationEditor_TIGGER_POLICY_LABEL);
        Composite triggerPolicyComposite = new Composite(parent, 0);
        triggerPolicyComposite.setLayout((Layout)new TableWrapLayout());
        UDeployConfigurationElement.TriggerPolicy triggerPolicy = UDeployConfigurationElement.TriggerPolicy.ALWAYS;
        String triggerPolicyValue = this.getConfigProperty("team.udeploy.triggerPolicy", UDeployConfigurationElement.TriggerPolicy.ALWAYS.name());
        if (triggerPolicyValue.length() > 0) {
            try {
                triggerPolicy = UDeployConfigurationElement.TriggerPolicy.valueOf((String)triggerPolicyValue);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.fTriggerPolicyAlwaysButton = toolkit.createButton(triggerPolicyComposite, BuildDefinitionEditorMessages.UDeployConfigurationEditor_TRIGGER_POLICY_ALWAYS_LABEL, 16);
        this.fTriggerPolicyAlwaysButton.setData((Object)UDeployConfigurationElement.TriggerPolicy.ALWAYS);
        this.fTriggerPolicyAlwaysButton.setSelection(triggerPolicy.equals((Object)UDeployConfigurationElement.TriggerPolicy.ALWAYS));
        this.fTriggerPolicyAlwaysButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (UDeployConfigurationEditor.this.fTriggerPolicyAlwaysButton.getSelection()) {
                    UDeployConfigurationEditor.this.setConfigProperty("team.udeploy.triggerPolicy", ((UDeployConfigurationElement.TriggerPolicy)UDeployConfigurationEditor.this.fTriggerPolicyAlwaysButton.getData()).name());
                    UDeployConfigurationEditor.this.setDirty(true);
                    UDeployConfigurationEditor.this.validate();
                }
            }
        });
        this.fTriggerPolicyNoErrorsButton = toolkit.createButton(triggerPolicyComposite, BuildDefinitionEditorMessages.UDeployConfigurationEditor_TRIGGER_POLICY_NO_ERRORS_LABEL, 16);
        this.fTriggerPolicyNoErrorsButton.setData((Object)UDeployConfigurationElement.TriggerPolicy.NO_ERRORS);
        this.fTriggerPolicyNoErrorsButton.setSelection(triggerPolicy.equals((Object)UDeployConfigurationElement.TriggerPolicy.NO_ERRORS));
        this.fTriggerPolicyNoErrorsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (UDeployConfigurationEditor.this.fTriggerPolicyNoErrorsButton.getSelection()) {
                    UDeployConfigurationEditor.this.setConfigProperty("team.udeploy.triggerPolicy", ((UDeployConfigurationElement.TriggerPolicy)UDeployConfigurationEditor.this.fTriggerPolicyNoErrorsButton.getData()).name());
                    UDeployConfigurationEditor.this.setDirty(true);
                    UDeployConfigurationEditor.this.validate();
                }
            }
        });
        this.fTriggerPolicyNoWarningsButton = toolkit.createButton(triggerPolicyComposite, BuildDefinitionEditorMessages.UDeployConfigurationEditor_TRIGGER_POLICY_NO_WARNINGS_LABEL, 16);
        this.fTriggerPolicyNoWarningsButton.setData((Object)UDeployConfigurationElement.TriggerPolicy.NO_WARNINGS);
        this.fTriggerPolicyNoWarningsButton.setSelection(triggerPolicy.equals((Object)UDeployConfigurationElement.TriggerPolicy.NO_WARNINGS));
        this.fTriggerPolicyNoWarningsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (UDeployConfigurationEditor.this.fTriggerPolicyNoWarningsButton.getSelection()) {
                    UDeployConfigurationEditor.this.setConfigProperty("team.udeploy.triggerPolicy", ((UDeployConfigurationElement.TriggerPolicy)UDeployConfigurationEditor.this.fTriggerPolicyNoWarningsButton.getData()).name());
                    UDeployConfigurationEditor.this.setDirty(true);
                    UDeployConfigurationEditor.this.validate();
                }
            }
        });
        this.fAbortOnIncompleteActivityEnabledButton = this.createConfigPropertyCheckboxField(parent, "team.udeploy.abortOnIncompleteActivityEnabled", false, BuildDefinitionEditorMessages.UDeployConfigurationEditor_ABORT_ON_INCOMPLETE_ACTIVITY_ENABLED_LABEL, BuildDefinitionEditorMessages.UDeployConfigurationEditor_ABORT_ON_INCOMPLETE_ACTIVITY_ENABLED_TEXT, null, true);
        this.fPersonalBuildsEnabledButton = this.createPropertyCheckboxField(parent, "team.udeploy.personalBuilds", false, BuildDefinitionEditorMessages.UDeployConfigurationEditor_PERSONAL_BUILDS_ENABLED_LABEL, BuildDefinitionEditorMessages.UDeployConfigurationEditor_PERSONAL_BUILDS_ENABLED_TEXT, null, true);
    }

    private void createServerWidgets(Composite parent) {
        this.fServerURIText = this.createConfigPropertyTextField(parent, "team.udeploy.serverURI", BuildDefinitionEditorMessages.UDeployConfigurationEditor_SERVER_URI_LABEL, BuildDefinitionEditorMessages.UDeployConfigurationEditor_SERVER_URI_DESC, true, 2);
        this.createSpacer(parent, 10, 3);
        this.fUserText = this.createConfigPropertyTextField(parent, "team.udeploy.userName", BuildDefinitionEditorMessages.UDeployConfigurationEditor_USER_LABEL, BuildDefinitionEditorMessages.UDeployConfigurationEditor_USER_DESC, true, 2);
        this.createSpacer(parent, 10, 3);
        PasswordType passwordType = this.getPasswordType();
        this.fPasswordText = this.createPasswordRadioTextField(parent, "team.udeploy.password", PasswordType.PASSWORD, BuildDefinitionEditorMessages.UDeployConfigurationEditor_PASSWORD_LABEL, BuildDefinitionEditorMessages.UDeployConfigurationEditor_PASSWORD_DESC, 0x400000, passwordType);
        this.createSpacer(parent, 10, 3);
        this.fPasswordFileText = this.createPasswordRadioTextField(parent, "team.udeploy.passwordFile", PasswordType.PASSWORD_FILE, BuildDefinitionEditorMessages.UDeployConfigurationEditor_PASSWORD_FILE_LABEL, NLS.bind((String)BuildDefinitionEditorMessages.UDeployConfigurationEditor_PASSWORD_FILE_DESC, (Object)JBE_CREATE_PASSWORD_FILE), 4, passwordType);
        this.createSpacer(parent, 10, 3);
        this.fPasswordText.setEnabled(passwordType == PasswordType.PASSWORD);
        this.fPasswordFileText.setEnabled(passwordType == PasswordType.PASSWORD_FILE);
    }

    private Text createPasswordRadioTextField(Composite parent, final String propertyName, PasswordType passwordType, String labelText, String description, int style, PasswordType init) {
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        final Button button = toolkit.createButton(parent, null, 16);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (button.getSelection()) {
                    PasswordType data = (PasswordType)button.getData();
                    UDeployConfigurationEditor.this.setConfigProperty("team.udeploy.passwordType", data.name());
                    UDeployConfigurationEditor.this.fPasswordText.setEnabled(data == PasswordType.PASSWORD);
                    UDeployConfigurationEditor.this.fPasswordFileText.setEnabled(data == PasswordType.PASSWORD_FILE);
                    UDeployConfigurationEditor.this.setDirty(true);
                    UDeployConfigurationEditor.this.validate();
                }
            }
        });
        button.setSelection(init.equals((Object)passwordType));
        button.setData((Object)passwordType);
        button.setLayoutData((Object)new TableWrapData(2, 32));
        if (passwordType == PasswordType.PASSWORD) {
            this.fPasswordButton = button;
        } else {
            this.fPasswordFileButton = button;
        }
        String password = this.fWorkingCopy.getConfigurationPropertyValue(this.getId(), propertyName, "");
        Label label = toolkit.createLabel(parent, labelText);
        label.setLayoutData((Object)new TableWrapData(2, 32));
        label.setVisible(true);
        final Text passwordText = toolkit.createText(parent, password, style);
        TableWrapData layoutData = new TableWrapData(256);
        passwordText.setLayoutData((Object)layoutData);
        this.createSpacer(parent, -1, 2);
        Label descriptionLabel = toolkit.createLabel(parent, description, 64);
        descriptionLabel.setLayoutData((Object)new TableWrapData(256));
        descriptionLabel.setForeground(Display.getDefault().getSystemColor(16));
        passwordText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                UDeployConfigurationEditor.this.validate();
                UDeployConfigurationEditor.this.fWorkingCopy.setConfigurationProperty(UDeployConfigurationEditor.this.getId(), propertyName, passwordText.getText().trim());
                UDeployConfigurationEditor.this.setDirty(true);
            }
        });
        return passwordText;
    }

    private PasswordType getPasswordType() {
        PasswordType passwordType = PasswordType.PASSWORD;
        String propertyValue = this.getConfigProperty("team.udeploy.passwordType", PasswordType.PASSWORD.name());
        try {
            passwordType = PasswordType.valueOf((String)propertyValue);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return passwordType;
    }

    private void createTestConnectionWidgets(Composite parent) {
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        Composite testConnectionComposite = toolkit.createComposite(parent);
        testConnectionComposite.setLayoutData((Object)new TableWrapData(256, 256));
        testConnectionComposite.setLayout((Layout)new TableWrapLayout());
        this.fTestConnectionText = toolkit.createText(testConnectionComposite, null, 524874);
        this.fTestConnectionText.setLayoutData((Object)new TableWrapData(256, 256, 40, 1));
        this.fTestConnectionButton = toolkit.createButton(testConnectionComposite, BuildDefinitionEditorMessages.UDeployConfigurationEditor_TEST_CONNECTION_BUTTON, 8);
        this.fTestConnectionButton.setLayoutData((Object)new TableWrapData());
        this.fTestConnectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UDeployConfigurationEditor.this.testConnection();
            }
        });
    }

    private void createPublishWidgets(Composite parent) {
        this.fComponentText = this.createConfigPropertyTextField(parent, "team.udeploy.component", BuildDefinitionEditorMessages.UDeployConfigurationEditor_COMPONENT_LABEL, BuildDefinitionEditorMessages.UDeployConfigurationEditor_COMPONENT_DESC, true);
        this.createSpacer(parent, 10, 2);
        this.fVersionText = this.createConfigPropertyTextField(parent, "team.udeploy.version", BuildDefinitionEditorMessages.UDeployConfigurationEditor_VERSION_LABEL, NLS.bind((String)BuildDefinitionEditorMessages.UDeployConfigurationEditor_VERSION_DESC, (Object)DEFAULT_VERSION), true);
        this.createSpacer(parent, 10, 2);
        this.fBaseDirectoryText = this.createConfigPropertyTextField(parent, "team.udeploy.baseDirectory", BuildDefinitionEditorMessages.UDeployConfigurationEditor_BASE_DIRECTORY_LABEL, BuildDefinitionEditorMessages.UDeployConfigurationEditor_BASE_DIRECTORY_DESC, true);
        this.createSpacer(parent, 10, 2);
        this.fIncludeFilesText = this.createConfigPropertyTextField(parent, "team.udeploy.includeFiles", BuildDefinitionEditorMessages.UDeployConfigurationEditor_INCLUDE_FILES_LABEL, BuildDefinitionEditorMessages.UDeployConfigurationEditor_INCLUDE_FILES_DESC, true, 100, 514);
        this.fIncludeFilesText.addTraverseListener(this.createTabOutTraverseListener());
        this.createSpacer(parent, 10, 2);
        this.fExcludeFilesText = this.createConfigPropertyTextField(parent, "team.udeploy.excludeFiles", BuildDefinitionEditorMessages.UDeployConfigurationEditor_EXCLUDE_FILES_LABEL, BuildDefinitionEditorMessages.UDeployConfigurationEditor_EXCLUDE_FILES_DESC, true, 100, 514);
        this.fExcludeFilesText.addTraverseListener(this.createTabOutTraverseListener());
        this.createSpacer(parent, 10, 2);
        this.fPropertiesText = this.createConfigPropertyTextField(parent, "team.udeploy.properties", BuildDefinitionEditorMessages.UDeployConfigurationEditor_PROPERTIES_LABEL, BuildDefinitionEditorMessages.UDeployConfigurationEditor_PROPERTIES_DESC, true, 100, 514);
        this.fPropertiesText.addTraverseListener(this.createTabOutTraverseListener());
        this.createSpacer(parent, 10, 2);
        this.fLinksText = this.createConfigPropertyTextField(parent, "team.udeploy.links", BuildDefinitionEditorMessages.UDeployConfigurationEditor_LINKS_LABEL, NLS.bind((String)BuildDefinitionEditorMessages.UDeployConfigurationEditor_LINKS_DESC, (Object)DEFAULT_LINKS), true, 100, 514);
        this.fLinksText.addTraverseListener(this.createTabOutTraverseListener());
        this.createSpacer(parent, 10, 2);
    }

    private TraverseListener createTabOutTraverseListener() {
        return new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 16) {
                    e.doit = true;
                }
            }
        };
    }

    private void createProcessWidgets(Composite parent) {
        this.fProcessEnabledButton = this.createConfigPropertyCheckboxField(parent, "team.udeploy.deployEnabled", false, BuildDefinitionEditorMessages.UDeployConfigurationEditor_PROCESS_ENABLED_LABEL, BuildDefinitionEditorMessages.UDeployConfigurationEditor_PROCESS_ENABLED_TEXT, null, true);
        this.fProcessEnabledButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean processEnabled = UDeployConfigurationEditor.this.fProcessEnabledButton.getSelection();
                UDeployConfigurationEditor.this.setConfigProperty("team.udeploy.deployEnabled", Boolean.toString(processEnabled));
                UDeployConfigurationEditor.this.enableProcessFields(processEnabled);
                UDeployConfigurationEditor.this.setDirty(true);
            }
        });
        this.fApplicationText = this.createConfigPropertyTextField(parent, "team.udeploy.application", BuildDefinitionEditorMessages.UDeployConfigurationEditor_APPLICATION_LABEL, BuildDefinitionEditorMessages.UDeployConfigurationEditor_APPLICATION_DESC, true);
        this.createSpacer(parent, 10, 2);
        this.fEnvironmentText = this.createConfigPropertyTextField(parent, "team.udeploy.environment", BuildDefinitionEditorMessages.UDeployConfigurationEditor_ENVIRONMENT_LABEL, BuildDefinitionEditorMessages.UDeployConfigurationEditor_ENVIRONMENT_DESC, true);
        this.createSpacer(parent, 10, 2);
        this.fProcessText = this.createConfigPropertyTextField(parent, "team.udeploy.process", BuildDefinitionEditorMessages.UDeployConfigurationEditor_PROCESS_LABEL, BuildDefinitionEditorMessages.UDeployConfigurationEditor_PROCESS_DESC, true);
    }

    protected void testConnection() {
        boolean ok;
        this.fTestConnectionButton.setEnabled(false);
        if (this.fPasswordFileButton.getSelection() && !(ok = MessageDialog.openConfirm((Shell)this.fServerURIText.getShell(), (String)BuildDefinitionEditorMessages.UDeployConfigurationEditor_TEST_CONNECTION_PASSWORD_FILE_DIALOG_TITLE, (String)BuildDefinitionEditorMessages.UDeployConfigurationEditor_TEST_CONNECTION_PASSWORD_FILE_DIALOG_CONFIRM))) {
            return;
        }
        this.fTestConnectionText.setText(String.valueOf(BuildDefinitionEditorMessages.UDeployConfigurationEditor_TEST_CONNECTION_REQUESTED) + "\n");
        final String serverURI = this.fServerURIText.getText().trim();
        final String user = this.fUserText.getText().trim();
        final PasswordType passwordType = this.getPasswordType();
        final String pass = this.fPasswordText.getText().trim();
        final File passwordFile = new File(this.fPasswordFileText.getText().trim());
        Job job = new Job(BuildDefinitionEditorMessages.UDeployConfigurationEditor_TEST_CONNECTION_JOB_NAME){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    int statusCode = -1;
                    String password = null;
                    password = passwordType == PasswordType.PASSWORD ? pass : this.readPasswordFile();
                    if (password != null) {
                        try {
                            URI uri = new URI(serverURI);
                            String uriString = uri.resolve("/rest/state").toASCIIString();
                            new URL(uriString);
                            this.appendTestConnectionText(String.format("GET %s", uriString));
                            TestConnectionClient testConnectionClient = new TestConnectionClient(uri, user, password);
                            try {
                                statusCode = testConnectionClient.getState();
                            }
                            catch (ClientProtocolException e) {
                                this.appendTestConnectionText(BuildDefinitionEditorMessages.UDeployConfigurationEditor_TEST_CONNECTION_PROTOCOL_EXCEPTION);
                            }
                            catch (Exception e) {
                                this.appendTestConnectionText(e.getLocalizedMessage());
                            }
                        }
                        catch (URISyntaxException e) {
                            this.appendTestConnectionText(e.getLocalizedMessage());
                        }
                        catch (MalformedURLException e) {
                            this.appendTestConnectionText(e.getLocalizedMessage());
                        }
                    }
                    boolean ok = false;
                    if (statusCode != -1) {
                        this.appendTestConnectionText(EnglishReasonPhraseCatalog.INSTANCE.getReason(statusCode, Locale.getDefault()));
                        if (statusCode / 100 == 2) {
                            ok = true;
                        } else if (statusCode == 401) {
                            this.appendTestConnectionText(BuildDefinitionEditorMessages.UDeployConfigurationEditor_TEST_CONNECTION_UNAUTHORIZED);
                        }
                    }
                    if (ok) {
                        this.appendTestConnectionText(BuildDefinitionEditorMessages.UDeployConfigurationEditor_TEST_CONNECTION_SUCCEEDED);
                    } else {
                        this.appendTestConnectionText(BuildDefinitionEditorMessages.UDeployConfigurationEditor_TEST_CONNECTION_FAILED);
                    }
                }
                catch (Throwable throwable) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!(this).UDeployConfigurationEditor.this.fTestConnectionButton.isDisposed()) {
                                (this).UDeployConfigurationEditor.this.fTestConnectionButton.setEnabled(true);
                            }
                        }
                    });
                    throw throwable;
                }
                Display.getDefault().syncExec(new /* invalid duplicate definition of identical inner class */);
                return Status.OK_STATUS;
            }

            private String readPasswordFile() {
                String readPassword = null;
                try {
                    readPassword = PasswordHelper.getPassword((File)passwordFile);
                }
                catch (FileNotFoundException e) {
                    this.appendTestConnectionText(NLS.bind((String)BuildDefinitionEditorMessages.UDeployConfigurationEditor_TEST_CONNECTION_PASSWORD_FILE_NOT_FOUND, (Object)passwordFile.getAbsolutePath()));
                }
                catch (IOException e) {
                    this.appendTestConnectionText(NLS.bind((String)BuildDefinitionEditorMessages.UDeployConfigurationEditor_TEST_CONNECTION_PASSWORD_FILE_INVALID, (Object)passwordFile.getAbsolutePath()));
                }
                catch (IllegalArgumentException e) {
                    this.appendTestConnectionText(NLS.bind((String)BuildDefinitionEditorMessages.UDeployConfigurationEditor_TEST_CONNECTION_PASSWORD_FILE_INVALID, (Object)passwordFile.getAbsolutePath()));
                }
                catch (Exception e) {
                    this.appendTestConnectionText(NLS.bind((String)BuildDefinitionEditorMessages.UDeployConfigurationEditor_TEST_CONNECTION_PASSWORD_FILE_ERROR, (Object)passwordFile.getAbsolutePath()));
                }
                return readPassword;
            }

            private void appendTestConnectionText(final String text) {
                if (text != null) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!(this).UDeployConfigurationEditor.this.fTestConnectionText.isDisposed()) {
                                (this).UDeployConfigurationEditor.this.fTestConnectionText.append(String.valueOf(text) + "\n");
                            }
                        }
                    });
                }
            }
        };
        job.schedule();
    }

    private void enableFields(boolean enabled) {
        this.fTriggerPolicyAlwaysButton.setEnabled(enabled);
        this.fTriggerPolicyNoErrorsButton.setEnabled(enabled);
        this.fTriggerPolicyNoWarningsButton.setEnabled(enabled);
        this.fAbortOnIncompleteActivityEnabledButton.setEnabled(enabled);
        this.fPersonalBuildsEnabledButton.setEnabled(enabled);
        this.fServerURIText.setEnabled(enabled);
        this.fUserText.setEnabled(enabled);
        this.fPasswordButton.setEnabled(enabled);
        this.fPasswordText.setEnabled(enabled && this.fPasswordButton.getSelection());
        this.fPasswordFileButton.setEnabled(enabled);
        this.fPasswordFileText.setEnabled(enabled && this.fPasswordFileButton.getSelection());
        this.fTestConnectionText.setEnabled(enabled);
        this.fTestConnectionButton.setEnabled(enabled);
        this.fComponentText.setEnabled(enabled);
        this.fVersionText.setEnabled(enabled);
        this.fBaseDirectoryText.setEnabled(enabled);
        this.fIncludeFilesText.setEnabled(enabled);
        this.fExcludeFilesText.setEnabled(enabled);
        this.fPropertiesText.setEnabled(enabled);
        this.fLinksText.setEnabled(enabled);
        this.fProcessEnabledButton.setEnabled(enabled);
        this.enableProcessFields(enabled && this.fProcessEnabledButton.getSelection());
    }

    private void enableProcessFields(boolean deployEnabled) {
        this.fApplicationText.setEnabled(deployEnabled);
        this.fEnvironmentText.setEnabled(deployEnabled);
        this.fProcessText.setEnabled(deployEnabled);
    }

    @Override
    public boolean validate() {
        boolean isValid = true;
        if (this.fEnabledButton.getSelection()) {
            if (this.fServerURIText.getText().trim().isEmpty()) {
                this.addErrorMessageForRequiredField(this.fServerURIText, BuildDefinitionEditorMessages.UDeployConfigurationEditor_SERVER_URI_REQUIRED, (Control)this.fServerURIText);
                isValid = false;
            } else {
                this.removeMessage(this.fServerURIText, (Control)this.fServerURIText);
            }
            if (this.fUserText.getText().trim().isEmpty()) {
                this.addErrorMessageForRequiredField(this.fUserText, BuildDefinitionEditorMessages.UDeployConfigurationEditor_USER_REQUIRED, (Control)this.fUserText);
                isValid = false;
            } else {
                this.removeMessage(this.fUserText, (Control)this.fUserText);
            }
            if (this.fPasswordButton.getSelection() && this.fPasswordText.getText().trim().isEmpty()) {
                this.addErrorMessageForRequiredField(this.fPasswordText, BuildDefinitionEditorMessages.UDeployConfigurationEditor_PASSWORD_REQUIRED, (Control)this.fPasswordText);
                isValid = false;
            } else {
                this.removeMessage(this.fPasswordText, (Control)this.fPasswordText);
            }
            if (this.fPasswordFileButton.getSelection() && this.fPasswordFileText.getText().trim().isEmpty()) {
                this.addErrorMessageForRequiredField(this.fPasswordFileText, BuildDefinitionEditorMessages.UDeployConfigurationEditor_PASSWORD_FILE_REQUIRED, (Control)this.fPasswordFileText);
                isValid = false;
            } else {
                this.removeMessage(this.fPasswordFileText, (Control)this.fPasswordFileText);
            }
            if (this.fComponentText.getText().trim().isEmpty()) {
                this.addErrorMessageForRequiredField(this.fComponentText, BuildDefinitionEditorMessages.UDeployConfigurationEditor_COMPONENT_REQUIRED, (Control)this.fComponentText);
                isValid = false;
            } else {
                this.removeMessage(this.fComponentText, (Control)this.fComponentText);
            }
            if (this.fVersionText.getText().trim().isEmpty()) {
                this.addErrorMessageForRequiredField(this.fVersionText, BuildDefinitionEditorMessages.UDeployConfigurationEditor_VERSION_REQUIRED, (Control)this.fVersionText);
                isValid = false;
            } else {
                this.removeMessage(this.fVersionText, (Control)this.fVersionText);
            }
            if (this.fProcessEnabledButton.getSelection()) {
                if (this.fApplicationText.getText().trim().isEmpty()) {
                    this.addErrorMessageForRequiredField(this.fApplicationText, BuildDefinitionEditorMessages.UDeployConfigurationEditor_APPLICATION_REQUIRED, (Control)this.fApplicationText);
                    isValid = false;
                } else {
                    this.removeMessage(this.fApplicationText, (Control)this.fApplicationText);
                }
                if (this.fEnvironmentText.getText().trim().isEmpty()) {
                    this.addErrorMessageForRequiredField(this.fEnvironmentText, BuildDefinitionEditorMessages.UDeployConfigurationEditor_ENVIRONMENT_REQUIRED, (Control)this.fEnvironmentText);
                    isValid = false;
                } else {
                    this.removeMessage(this.fEnvironmentText, (Control)this.fEnvironmentText);
                }
                if (this.fProcessText.getText().trim().isEmpty()) {
                    this.addErrorMessageForRequiredField(this.fProcessText, BuildDefinitionEditorMessages.UDeployConfigurationEditor_PROCESS_REQUIRED, (Control)this.fProcessText);
                    isValid = false;
                } else {
                    this.removeMessage(this.fProcessText, (Control)this.fProcessText);
                }
            } else {
                this.removeMessage(this.fApplicationText, (Control)this.fApplicationText);
                this.removeMessage(this.fEnvironmentText, (Control)this.fEnvironmentText);
                this.removeMessage(this.fProcessText, (Control)this.fProcessText);
            }
        } else {
            this.removeMessage(this.fServerURIText, (Control)this.fServerURIText);
            this.removeMessage(this.fUserText, (Control)this.fUserText);
            this.removeMessage(this.fPasswordText, (Control)this.fPasswordText);
            this.removeMessage(this.fPasswordFileText, (Control)this.fPasswordFileText);
            this.removeMessage(this.fComponentText, (Control)this.fComponentText);
            this.removeMessage(this.fVersionText, (Control)this.fVersionText);
            this.removeMessage(this.fApplicationText, (Control)this.fApplicationText);
            this.removeMessage(this.fEnvironmentText, (Control)this.fEnvironmentText);
            this.removeMessage(this.fProcessText, (Control)this.fProcessText);
        }
        this.setPageStatusIndicator(!isValid, false);
        return isValid;
    }

    @Override
    public Control getFocusControl() {
        return this.fServerURIText;
    }

    @Override
    protected String getContextHelpId() {
        return "com.ibm.team.build.ui.editor_builddefinitionudeploy";
    }

    protected String getConfigProperty(String propertyName, String defaultValue) {
        return this.fWorkingCopy.getConfigurationPropertyValue(this.getId(), propertyName, defaultValue);
    }

    private void setConfigProperty(String propertyName, String value) {
        this.fWorkingCopy.setConfigurationProperty(this.getId(), propertyName, value);
    }

    protected Text createConfigPropertyTextField(Composite parent, final String propertyName, String label, String description, final boolean validateOnModify, int labelColSpan) {
        final String elementId = this.getId();
        String value = this.fWorkingCopy.getConfigurationPropertyValue(elementId, propertyName, "");
        final Text text = this.createLabeledText(parent, label, description, value, labelColSpan);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (validateOnModify) {
                    UDeployConfigurationEditor.this.validate();
                }
                UDeployConfigurationEditor.this.fWorkingCopy.setConfigurationProperty(elementId, propertyName, text.getText().trim());
                UDeployConfigurationEditor.this.setDirty(true);
            }
        });
        return text;
    }

    protected Text createLabeledText(Composite parent, String labelText, String description, String textValue, int labelColSpan) {
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        Label label = toolkit.createLabel(parent, labelText);
        label.setLayoutData((Object)new TableWrapData(2, 32, 1, labelColSpan));
        Text text = toolkit.createText(parent, textValue, 4);
        TableWrapData layoutData = new TableWrapData(256);
        layoutData.maxWidth = 200;
        layoutData.heightHint = -1;
        text.setLayoutData((Object)layoutData);
        if (description != null) {
            this.createSpacer(parent, -1, labelColSpan);
            Label descriptionLabel = toolkit.createLabel(parent, description, 64);
            descriptionLabel.setLayoutData((Object)new TableWrapData(256));
            descriptionLabel.setForeground(Display.getDefault().getSystemColor(16));
        }
        return text;
    }
}

