/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.builddefinition;

import com.ibm.icu.util.TimeZone;
import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.model.IBuildConfigurationElement;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.common.model.IBuildSchedule;
import com.ibm.team.build.common.model.IBuildScheduleEntry;
import com.ibm.team.build.internal.client.ITeamBuildRecordClient;
import com.ibm.team.build.internal.common.builddefinition.BuildConfigurationElementExtension;
import com.ibm.team.build.internal.common.builddefinition.BuildConfigurationElementExtensionManager;
import com.ibm.team.build.internal.common.helper.BuildEngineHelper;
import com.ibm.team.build.internal.common.helper.BuildScheduleHelper;
import com.ibm.team.build.internal.common.model.BuildProperty;
import com.ibm.team.build.internal.common.model.dto.IBuildScheduleRecord;
import com.ibm.team.build.internal.ui.BuildPropertyControl;
import com.ibm.team.build.internal.ui.BuildUIMessages;
import com.ibm.team.build.internal.ui.IBuildPropertyControlListener;
import com.ibm.team.build.internal.ui.dialogs.BuildPropertyDialog;
import com.ibm.team.build.internal.ui.editors.BuildItemEditor;
import com.ibm.team.build.internal.ui.editors.BuildItemEditorJob;
import com.ibm.team.build.internal.ui.editors.builddefinition.BasicConfigurationElementEditor;
import com.ibm.team.build.internal.ui.editors.builddefinition.BuildDaysContentProvider;
import com.ibm.team.build.internal.ui.editors.builddefinition.BuildDefinitionEditorMessages;
import com.ibm.team.build.internal.ui.helper.BuildScheduleTextHelper;
import com.ibm.team.build.ui.properties.AbstractBuildPropertyEditor;
import com.ibm.team.build.ui.properties.IBuildPropertyEditorContext;
import com.ibm.team.build.ui.properties.ISchedulePropertyEditor;
import com.ibm.team.repository.client.ITeamRepository;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class ScheduleConfigurationEditor
extends BasicConfigurationElementEditor {
    private static final int INTERVAL_MAX_NUM_CHARS = 4;
    private static final int MINUTES_MAX_NUM_CHARS = BuildDefinitionEditorMessages.BuildScheduleControl_BUILD_INTERVAL_EVERY_X_MINUTES.length();
    private static final int DAYS_MAX_NUM_CHARS = BuildDefinitionEditorMessages.BuildScheduleControl_BUILD_DAY_MON.length() * 6 + 10;
    private TimeZone fServerTimeZone;
    protected Button fScheduleEnabledButton;
    protected TableViewer fScheduleEntriesViewer;
    protected Button fAddButton;
    protected Button fRemoveButton;
    protected Button fAddPropertyButton;
    protected Button fEditPropertyButton;
    protected Button fRemovePropertyButton;
    protected Button fContinuousIntervalButton;
    protected Button fTimeButton;
    protected Text fContinuousIntervalText;
    protected DateTime fTimeWidget;
    protected Button fSelectAllDaysButton;
    protected Button fDeselectAllDaysButton;
    protected CheckboxTableViewer fBuildDaysTableViewer;
    private Section fScheduleSection;
    protected SchedulePropertyControl fSchedulePropertyControl;
    private FormToolkit fToolkit;
    private boolean fIgnore = false;
    private Label fTimeZoneLabel;

    public ScheduleConfigurationEditor(String elementId, String title) {
        super(elementId, title);
    }

    @Override
    public void setWorkingCopy(IBuildDefinition definition) {
        super.setWorkingCopy(definition);
    }

    @Override
    public void createContent(Composite parent, FormToolkit toolkit) {
        this.fToolkit = toolkit;
        parent.setLayout((Layout)new TableWrapLayout());
        this.fScheduleSection = this.createSection(parent, BuildDefinitionEditorMessages.BuildDefinitionEditor_SECTION_TITLE_SCHEDULE, BuildDefinitionEditorMessages.BuildDefinitionEditor_SECTION_DESCRIPTION_SCHEDULE, false);
        Composite composite = (Composite)this.fScheduleSection.getClient();
        this.createWidgets(composite);
        this.initializeWidgets();
        this.addListeners();
        this.fetchBuildSchedule();
    }

    private void createWidgets(Composite parent) {
        this.createScheduleEnablementButton(parent);
        this.createScheduleEntries(parent);
        this.createEntryPropertiesComposite(parent);
        this.createEntryPropertiesCompositeLower(parent);
    }

    private void initializeWidgets() {
        if (this.fServerTimeZone == null) {
            this.fScheduleEnabledButton.setSelection(false);
            this.fScheduleEnabledButton.setEnabled(false);
            this.fScheduleEntriesViewer.setInput(new ArrayList());
            this.setWidgetsEnabled(false);
        } else {
            boolean scheduleEnabled = this.fWorkingCopy.getBuildSchedule().isScheduleEnabled();
            this.fScheduleEnabledButton.setSelection(scheduleEnabled);
            this.fScheduleEnabledButton.setEnabled(true);
            this.fScheduleEntriesViewer.setInput(this.convertedScheduleEntries(this.fWorkingCopy.getBuildSchedule(), this.fServerTimeZone));
            this.setWidgetsEnabled(scheduleEnabled);
        }
        this.validate();
    }

    private List<IBuildScheduleEntry> convertedScheduleEntries(IBuildSchedule buildSchedule, TimeZone defaultTimeZone) {
        ArrayList<IBuildScheduleEntry> converted = new ArrayList<IBuildScheduleEntry>();
        for (Object o : buildSchedule.getBuildScheduleEntries()) {
            IBuildScheduleEntry entry = (IBuildScheduleEntry)o;
            converted.add(entry.toConfiguredTimeZoneFromGMT(defaultTimeZone));
        }
        return converted;
    }

    private void fetchBuildSchedule() {
        final IBuildDefinitionHandle definitionHandle = (IBuildDefinitionHandle)this.fWorkingCopy.getItemHandle();
        final Display display = this.fScheduleSection.getDisplay();
        new BuildItemEditorJob(BuildDefinitionEditorMessages.ScheduleConfigurationEditor_FETCH_JOB_NAME, true, (BuildItemEditor)this.getEditor()){

            @Override
            protected void internalRunProtected(IProgressMonitor monitor) throws Exception {
                ITeamBuildRecordClient client = (ITeamBuildRecordClient)ScheduleConfigurationEditor.this.getTeamRepository().getClientLibrary(ITeamBuildRecordClient.class);
                final IBuildScheduleRecord record = client.getBuildScheduleRecords(definitionHandle, new String[1], null, monitor)[0];
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ScheduleConfigurationEditor.this.fetchBuildScheduleCompleted(record);
                    }
                });
            }
        }.schedule();
    }

    protected void fetchBuildScheduleCompleted(IBuildScheduleRecord record) {
        this.fServerTimeZone = TimeZone.getTimeZone((String)record.getTimeZoneID());
        if (!this.fScheduleSection.isDisposed()) {
            this.initializeWidgets();
        }
    }

    private IBuildScheduleEntry getWorkingBuildScheduleEntry() {
        IStructuredSelection selection = (IStructuredSelection)this.fScheduleEntriesViewer.getSelection();
        if (selection.size() == 1) {
            return (IBuildScheduleEntry)selection.getFirstElement();
        }
        return null;
    }

    private void addListeners() {
        this.fScheduleEnabledButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScheduleConfigurationEditor.this.handleScheduleEnableButtonSelected();
            }
        });
        this.fScheduleEntriesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                ScheduleConfigurationEditor.this.handleScheduleEntriesViewerSelectionChanged();
            }
        });
        this.fAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScheduleConfigurationEditor.this.handleAddButtonSelected();
            }
        });
        this.fRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScheduleConfigurationEditor.this.handleRemoveButtonSelected();
            }
        });
        this.fContinuousIntervalButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScheduleConfigurationEditor.this.handleContinuousIntervalButtonSelected();
            }
        });
        this.fContinuousIntervalText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ScheduleConfigurationEditor.this.handleContinuousIntervalTextModified();
            }
        });
        this.fTimeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScheduleConfigurationEditor.this.handleTimeButtonSelected();
            }
        });
        this.fTimeWidget.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScheduleConfigurationEditor.this.handleTimeWidgetSelected();
            }
        });
        this.fBuildDaysTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent e) {
                ScheduleConfigurationEditor.this.handleDayCheckBoxSelected();
            }
        });
        this.fSelectAllDaysButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScheduleConfigurationEditor.this.handleSelectAllDaysButtonSelected();
            }
        });
        this.fDeselectAllDaysButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScheduleConfigurationEditor.this.handleDeselectAllDaysButtonSelected();
            }
        });
    }

    private void updateBuildDefinition() {
        IBuildScheduleEntry entry = this.getWorkingBuildScheduleEntry();
        if (entry != null) {
            if (this.fContinuousIntervalButton.getSelection()) {
                entry.setBuildInterval(this.getContinuousInterval());
            } else {
                entry.setBuildInterval(0);
                entry.setBuildHour(this.getBuildHour());
                entry.setBuildMinute(this.getBuildMinute());
            }
            entry.setBuildOnMonday(this.isBuildOnMonday());
            entry.setBuildOnTuesday(this.isBuildOnTuesday());
            entry.setBuildOnWednesday(this.isBuildOnWednesday());
            entry.setBuildOnThursday(this.isBuildOnThursday());
            entry.setBuildOnFriday(this.isBuildOnFriday());
            entry.setBuildOnSaturday(this.isBuildOnSaturday());
            entry.setBuildOnSunday(this.isBuildOnSunday());
        }
        List localEntries = (List)this.fScheduleEntriesViewer.getInput();
        ArrayList<IBuildScheduleEntry> repoEntries = new ArrayList<IBuildScheduleEntry>();
        for (IBuildScheduleEntry tzRelativeEntry : localEntries) {
            IBuildScheduleEntry repoEntry = tzRelativeEntry.toGMTFromConfiguredTimeZone(this.fServerTimeZone);
            repoEntries.add(repoEntry);
        }
        this.fWorkingCopy.getBuildSchedule().setBuildScheduleEntries(repoEntries);
        if (entry != null) {
            this.fScheduleEntriesViewer.update((Object)entry, null);
            this.updateTimeZoneInfo(entry);
        }
    }

    protected void handleScheduleEnableButtonSelected() {
        List entries;
        this.setDirty(true);
        boolean scheduleEnabled = this.fScheduleEnabledButton.getSelection();
        this.fWorkingCopy.getBuildSchedule().setScheduleEnabled(scheduleEnabled);
        if (scheduleEnabled && (entries = (List)this.fScheduleEntriesViewer.getInput()).isEmpty()) {
            this.addNewScheduleEntry();
            this.updateBuildDefinition();
        }
        this.setWidgetsEnabled(scheduleEnabled);
    }

    protected void handleScheduleEntriesViewerSelectionChanged() {
        this.handleScheduleEntriesViewerSelectionChanged(true);
    }

    private void handleScheduleEntriesViewerSelectionChanged(boolean scheduleEnabled) {
        IStructuredSelection selection = (IStructuredSelection)this.fScheduleEntriesViewer.getSelection();
        switch (selection.size()) {
            case 0: {
                this.setDetailsEnabled(false);
                this.fRemoveButton.setEnabled(false);
                this.updateTimeZoneInfo(null);
                break;
            }
            case 1: {
                this.initializeWidgetData();
                this.setDetailsEnabled(scheduleEnabled);
                this.fRemoveButton.setEnabled(scheduleEnabled);
                break;
            }
            default: {
                this.setDetailsEnabled(false);
                this.fRemoveButton.setEnabled(scheduleEnabled);
                this.updateTimeZoneInfo(null);
            }
        }
        this.validate();
    }

    private void setBuildAllDays(boolean build) {
        IStructuredSelection selection = (IStructuredSelection)this.fScheduleEntriesViewer.getSelection();
        IBuildScheduleEntry entry = (IBuildScheduleEntry)selection.getFirstElement();
        entry.setBuildOnMonday(build);
        entry.setBuildOnTuesday(build);
        entry.setBuildOnWednesday(build);
        entry.setBuildOnThursday(build);
        entry.setBuildOnFriday(build);
        entry.setBuildOnSaturday(build);
        entry.setBuildOnSunday(build);
    }

    protected void handleAddButtonSelected() {
        this.addNewScheduleEntry();
        this.setDirty(true);
        this.updateBuildDefinition();
        this.validate();
    }

    protected void handleRemoveButtonSelected() {
        Table entriesViewerTable = this.fScheduleEntriesViewer.getTable();
        int newSelectionIndex = 0;
        int originalSelectionIndex = entriesViewerTable.getSelectionIndex();
        int numberOfTableEntries = entriesViewerTable.getItemCount();
        if (entriesViewerTable.getItemCount() > 1) {
            newSelectionIndex = originalSelectionIndex == numberOfTableEntries - 1 ? numberOfTableEntries - 2 : originalSelectionIndex + 1;
        }
        Object newSelectionData = entriesViewerTable.getItem(newSelectionIndex).getData();
        IStructuredSelection selection = (IStructuredSelection)this.fScheduleEntriesViewer.getSelection();
        if (!selection.isEmpty()) {
            ((List)this.fScheduleEntriesViewer.getInput()).removeAll(selection.toList());
            this.fScheduleEntriesViewer.remove(selection.toArray());
            this.fScheduleEntriesViewer.setSelection((ISelection)new StructuredSelection(newSelectionData));
            this.setDirty(true);
            this.updateBuildDefinition();
        }
    }

    protected void handleContinuousIntervalButtonSelected() {
        this.setDirty(true);
        this.fContinuousIntervalText.setEnabled(true);
        if (this.fContinuousIntervalText.getText().equals("")) {
            this.fContinuousIntervalText.setText("30");
        }
        this.fContinuousIntervalText.setFocus();
        this.fContinuousIntervalText.selectAll();
        this.fTimeButton.setSelection(false);
        this.fTimeWidget.setEnabled(false);
        this.updateBuildDefinition();
        this.validate();
    }

    protected void handleContinuousIntervalTextModified() {
        if (!this.fIgnore) {
            this.setDirty(true);
            this.updateBuildDefinition();
            this.validate();
        }
    }

    protected void handleTimeButtonSelected() {
        this.setDirty(true);
        this.fTimeWidget.setEnabled(true);
        this.fContinuousIntervalButton.setSelection(false);
        this.fContinuousIntervalText.setEnabled(false);
        this.updateBuildDefinition();
        this.validate();
    }

    protected void handleTimeWidgetSelected() {
        this.setDirty(true);
        this.updateBuildDefinition();
        this.validate();
    }

    protected void handleSelectAllDaysButtonSelected() {
        this.setDirty(true);
        this.fBuildDaysTableViewer.setAllChecked(true);
        this.setBuildAllDays(true);
        this.updateBuildDefinition();
        this.validate();
    }

    protected void handleDeselectAllDaysButtonSelected() {
        this.setDirty(true);
        this.fBuildDaysTableViewer.setAllChecked(false);
        this.setBuildAllDays(false);
        this.updateBuildDefinition();
        this.validate();
    }

    protected void handleDayCheckBoxSelected() {
        this.setDirty(true);
        this.updateBuildDefinition();
        this.validate();
    }

    public boolean getScheduleEnabled() {
        return this.fScheduleEnabledButton.getSelection();
    }

    protected int getContinuousInterval() {
        if (this.fContinuousIntervalButton.getSelection()) {
            try {
                int interval = Integer.parseInt(this.fContinuousIntervalText.getText());
                return interval > 0 ? interval : -1;
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        return 0;
    }

    public int getBuildHour() {
        return this.fTimeWidget.getHours();
    }

    public int getBuildMinute() {
        return this.fTimeWidget.getMinutes();
    }

    public boolean isBuildOnMonday() {
        return this.fBuildDaysTableViewer.getChecked((Object)BuildScheduleTextHelper.MONDAY);
    }

    public boolean isBuildOnTuesday() {
        return this.fBuildDaysTableViewer.getChecked((Object)BuildScheduleTextHelper.TUESDAY);
    }

    public boolean isBuildOnWednesday() {
        return this.fBuildDaysTableViewer.getChecked((Object)BuildScheduleTextHelper.WEDNESDAY);
    }

    public boolean isBuildOnThursday() {
        return this.fBuildDaysTableViewer.getChecked((Object)BuildScheduleTextHelper.THURSDAY);
    }

    public boolean isBuildOnFriday() {
        return this.fBuildDaysTableViewer.getChecked((Object)BuildScheduleTextHelper.FRIDAY);
    }

    public boolean isBuildOnSaturday() {
        return this.fBuildDaysTableViewer.getChecked((Object)BuildScheduleTextHelper.SATURDAY);
    }

    public boolean isBuildOnSunday() {
        return this.fBuildDaysTableViewer.getChecked((Object)BuildScheduleTextHelper.SUNDAY);
    }

    private void createScheduleEnablementButton(Composite parent) {
        this.fScheduleEnabledButton = this.fToolkit.createButton(parent, BuildDefinitionEditorMessages.BuildScheduleControl_LABEL_USE_TEAM_SCHEDULER, 32);
        this.fScheduleEnabledButton.setLayoutData((Object)new TableWrapData(256, 32, 1, 2));
    }

    private void createScheduleEntries(Composite parent) {
        Composite scheduleEntriesComposite = this.fToolkit.createComposite(parent);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(scheduleEntriesComposite);
        scheduleEntriesComposite.setLayoutData((Object)new TableWrapData(256, 256));
        this.createScheduleEntriesViewer(scheduleEntriesComposite);
        this.createScheduleModificationButtons(scheduleEntriesComposite);
    }

    private void createScheduleEntriesViewer(Composite parent) {
        Table table = this.fToolkit.createTable(parent, 68354);
        this.fScheduleEntriesViewer = new TableViewer(table);
        int numChars = MINUTES_MAX_NUM_CHARS + DAYS_MAX_NUM_CHARS + 4;
        int tableWidth = this.getTextWidth((Control)table, numChars);
        GridDataFactory.fillDefaults().grab(true, true).span(1, 2).hint(tableWidth, 200).applyTo((Control)table);
        this.fScheduleEntriesViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.fScheduleEntriesViewer.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){
            Color RED;
            {
                this.RED = ScheduleConfigurationEditor.this.fScheduleEntriesViewer.getControl().getDisplay().getSystemColor(3);
            }

            public String getText(Object element) {
                IBuildScheduleEntry entry = (IBuildScheduleEntry)element;
                return BuildScheduleTextHelper.getScheduleEntryText(entry, ScheduleConfigurationEditor.this.fServerTimeZone);
            }

            public Color getForeground(Object element) {
                IBuildScheduleEntry entry = (IBuildScheduleEntry)element;
                return ScheduleConfigurationEditor.this.isDated(entry) ? null : this.RED;
            }
        });
    }

    private int getTextWidth(Control control, int numChars) {
        GC gc = new GC((Drawable)control);
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        return fontMetrics.getAverageCharWidth() * numChars;
    }

    private void createScheduleModificationButtons(Composite parent) {
        this.fAddButton = this.fToolkit.createButton(parent, BuildDefinitionEditorMessages.BuildScheduleControl_ADD_ENTRY_BUTTON, 8);
        this.fAddButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.fRemoveButton = this.fToolkit.createButton(parent, BuildDefinitionEditorMessages.BuildScheduleControl_REMOVE_ENTRY_BUTTON, 8);
        this.fRemoveButton.setLayoutData((Object)new GridData(4, 1, false, false));
    }

    private void createBuildTimeComposite(Composite parent) {
        Composite composite = this.fToolkit.createComposite(parent);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().applyTo(composite);
        this.fToolkit.createLabel(composite, BuildDefinitionEditorMessages.BuildScheduleControl_LABEL_BUILD_TIME);
        this.createContinuousContainer(composite);
        this.createTimeContainer(composite);
    }

    private void createContinuousContainer(Composite parent) {
        Composite composite = this.fToolkit.createComposite(parent);
        GridData gridData = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 8;
        composite.setLayout((Layout)layout);
        this.fContinuousIntervalButton = this.fToolkit.createButton(composite, BuildDefinitionEditorMessages.BuildScheduleControl_LABEL_CONTINUOUS_INTERVAL, 16);
        this.fContinuousIntervalText = this.fToolkit.createText(composite, "", 2048);
        int widthHint = this.getTextWidth((Control)this.fContinuousIntervalText, 4);
        widthHint = this.fContinuousIntervalText.computeTrim((int)0, (int)0, (int)widthHint, (int)-1).width;
        GridDataFactory.fillDefaults().hint(widthHint, -1).applyTo((Control)this.fContinuousIntervalText);
    }

    private void createTimeContainer(Composite parent) {
        Composite composite = this.fToolkit.createComposite(parent);
        GridData gridData = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(3, false);
        composite.setLayout((Layout)layout);
        this.fTimeButton = this.fToolkit.createButton(composite, BuildDefinitionEditorMessages.BuildScheduleControl_LABEL_AT, 16);
        this.fTimeWidget = new DateTime(composite, 34944);
        this.fToolkit.adapt((Control)this.fTimeWidget, true, false);
        this.fTimeZoneLabel = this.fToolkit.createLabel(composite, "");
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.fTimeZoneLabel);
    }

    private void createBuildDaysComposite(Composite parent) {
        Composite composite = this.fToolkit.createComposite(parent);
        GridDataFactory.fillDefaults().applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().applyTo(composite);
        this.fToolkit.createLabel(composite, BuildDefinitionEditorMessages.BuildScheduleControl_LABEL_BUILD_DAYS);
        this.createBuildDaysTable(composite);
    }

    private void createBuildDaysTable(Composite parent) {
        Composite composite = this.fToolkit.createComposite(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        Table table = this.fToolkit.createTable(composite, 68384);
        table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 2));
        this.fBuildDaysTableViewer = new CheckboxTableViewer(table);
        this.fBuildDaysTableViewer.setContentProvider((IContentProvider)new BuildDaysContentProvider());
        this.fBuildDaysTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.fBuildDaysTableViewer.setInput((Object)this);
        this.createDaySelectionButtons(composite);
    }

    private void createDaySelectionButtons(Composite parent) {
        this.fSelectAllDaysButton = this.fToolkit.createButton(parent, BuildDefinitionEditorMessages.BuildScheduleControl_LABEL_SELECT_ALL, 8);
        this.fSelectAllDaysButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.fDeselectAllDaysButton = this.fToolkit.createButton(parent, BuildDefinitionEditorMessages.BuildScheduleControl_LABEL_DESELECT_ALL, 8);
        this.fDeselectAllDaysButton.setLayoutData((Object)new GridData(4, 1, false, false));
    }

    private void createEntryPropertiesComposite(Composite parent) {
        Composite propertyComposite = this.fToolkit.createComposite(parent);
        propertyComposite.setLayoutData((Object)new TableWrapData(256, 16));
        GridLayoutFactory.fillDefaults().extendedMargins(5, 0, 0, 0).applyTo(propertyComposite);
        this.createBuildTimeComposite(propertyComposite);
        this.createBuildDaysComposite(propertyComposite);
    }

    private void createEntryPropertiesCompositeLower(Composite parent) {
        Composite propertyComposite = this.fToolkit.createComposite(parent);
        propertyComposite.setLayoutData((Object)new TableWrapData(256, 256, 1, 2));
        GridLayoutFactory.fillDefaults().applyTo(propertyComposite);
        this.createSchedulePropertiesComposite(propertyComposite);
    }

    private void createSchedulePropertiesComposite(Composite parent) {
        Composite composite = this.fToolkit.createComposite(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(2).extendedMargins(0, 0, 10, 0).applyTo(composite);
        Label scheduleLabel = this.fToolkit.createLabel(composite, BuildDefinitionEditorMessages.BuildScheduleControl_LABEL_SCHEDULE_PROPERTIES);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)scheduleLabel);
        this.createSchedulePropertiesViewer(composite);
    }

    private void createSchedulePropertiesViewer(Composite parent) {
        List<IBuildProperty> initialProperties = Collections.emptyList();
        this.fSchedulePropertyControl = new SchedulePropertyControl(parent, this.fToolkit, initialProperties, this.getTeamRepository(), true, BuildPropertyControl.LayoutSize.FULL);
        this.fSchedulePropertyControl.addListener(new IBuildPropertyControlListener(){

            @Override
            public void propertyAdded(IBuildProperty buildProperty) {
                ScheduleConfigurationEditor.this.setDirty(true);
                ScheduleConfigurationEditor.this.updateBuildDefinition();
            }

            @Override
            public void propertyEdited(IBuildProperty buildProperty) {
                ScheduleConfigurationEditor.this.setDirty(true);
                ScheduleConfigurationEditor.this.updateBuildDefinition();
                ScheduleConfigurationEditor.this.validate();
            }

            @Override
            public void propertiesRemoved(IBuildProperty[] buildProperties) {
                ScheduleConfigurationEditor.this.setDirty(true);
                ScheduleConfigurationEditor.this.updateBuildDefinition();
            }
        });
        this.fSchedulePropertyControl.replaceGlobalActionsOnFocus(this.getEditorSite());
        this.fSchedulePropertyControl.createAndRegisterDefaultContextMenu((IWorkbenchPartSite)this.getEditorSite());
    }

    @Override
    public boolean validate() {
        boolean isValid = true;
        this.removeMessage(this.fScheduleEntriesViewer, (Control)this.fScheduleEntriesViewer.getTable());
        this.removeMessage(this.fBuildDaysTableViewer, (Control)this.fBuildDaysTableViewer.getTable());
        this.removeMessage(this.fContinuousIntervalText, (Control)this.fContinuousIntervalText);
        if (this.fScheduleEnabledButton.getSelection()) {
            List entries = (List)this.fScheduleEntriesViewer.getInput();
            if (entries.isEmpty()) {
                this.addErrorMessage((Object)this.fScheduleEntriesViewer, BuildDefinitionEditorMessages.BuildScheduleControl_ERROR_NO_SCHEDULES, this.fScheduleEntriesViewer.getControl());
                isValid = false;
            } else {
                IStructuredSelection selection = (IStructuredSelection)this.fScheduleEntriesViewer.getSelection();
                Object element = selection.getFirstElement();
                int multipleIntervals = 0;
                boolean currentIsContinuous = false;
                for (Object object : entries) {
                    IBuildScheduleEntry entry = (IBuildScheduleEntry)object;
                    if (element == entry) {
                        if (!this.fContinuousIntervalButton.getSelection()) continue;
                        ++multipleIntervals;
                        currentIsContinuous = true;
                        continue;
                    }
                    if (entry.getBuildInterval() > 0) {
                        ++multipleIntervals;
                    }
                    if (!this.isDated(entry)) {
                        this.addErrorMessage((Object)this.fScheduleEntriesViewer, BuildDefinitionEditorMessages.BuildScheduleControl_ERROR_MULTIPLE_INVALID_SCHEDULES, (Control)this.fScheduleEntriesViewer.getTable());
                        isValid = false;
                        continue;
                    }
                    if (entry.getBuildInterval() >= 0) continue;
                    this.addErrorMessage((Object)this.fScheduleEntriesViewer, BuildDefinitionEditorMessages.BuildScheduleControl_ERROR_MULTIPLE_INVALID_SCHEDULES, (Control)this.fScheduleEntriesViewer.getTable());
                    isValid = false;
                }
                if (currentIsContinuous) {
                    if (multipleIntervals > 1) {
                        this.addErrorMessage((Object)this.fContinuousIntervalText, BuildDefinitionEditorMessages.BuildScheduleControl_ERROR_MULTIPLE_CONTINUOUS_INTERVAL_SCHEDULES, (Control)this.fContinuousIntervalText);
                        isValid = false;
                    } else if (!this.isPositiveInteger(this.fContinuousIntervalText.getText())) {
                        this.addErrorMessage((Object)this.fContinuousIntervalText, NLS.bind((String)BuildDefinitionEditorMessages.BuildScheduleControl_ERROR_INVALID_NUMBER, (Object)Integer.MAX_VALUE), (Control)this.fContinuousIntervalText);
                        isValid = false;
                    }
                } else if (multipleIntervals > 1) {
                    this.addErrorMessage((Object)this.fScheduleEntriesViewer, BuildDefinitionEditorMessages.BuildScheduleControl_ERROR_MULTIPLE_CONTINUOUS_INTERVAL_SCHEDULES, (Control)this.fScheduleEntriesViewer.getTable());
                    isValid = false;
                }
                if (element != null && this.fBuildDaysTableViewer.getCheckedElements().length < 1) {
                    this.addErrorMessage((Object)this.fBuildDaysTableViewer, BuildDefinitionEditorMessages.BuildScheduleControl_ERROR_NO_DAYS_SELECTED, (Control)this.fBuildDaysTableViewer.getTable());
                    isValid = false;
                }
            }
        }
        this.setPageStatusIndicator(!isValid, false);
        return isValid;
    }

    private boolean isDated(IBuildScheduleEntry entry) {
        return entry.isBuildOnMonday() || entry.isBuildOnTuesday() || entry.isBuildOnWednesday() || entry.isBuildOnThursday() || entry.isBuildOnFriday() || entry.isBuildOnSaturday() || entry.isBuildOnSunday();
    }

    private boolean isPositiveInteger(String number) {
        try {
            int i = Integer.parseInt(number);
            return i > 0;
        }
        catch (NumberFormatException exception) {
            return false;
        }
    }

    private void setWidgetsEnabled(boolean scheduleButtonSelected) {
        this.fScheduleEntriesViewer.getTable().setEnabled(scheduleButtonSelected);
        this.fSchedulePropertyControl.setEnabled(scheduleButtonSelected);
        this.fAddButton.setEnabled(scheduleButtonSelected);
        this.handleScheduleEntriesViewerSelectionChanged(scheduleButtonSelected);
    }

    private void setDetailsEnabled(boolean enabled) {
        this.fContinuousIntervalButton.setEnabled(enabled);
        this.fContinuousIntervalText.setEnabled(enabled ? this.fContinuousIntervalButton.getSelection() : false);
        this.fTimeButton.setEnabled(enabled);
        this.fTimeWidget.setEnabled(enabled ? this.fTimeButton.getSelection() : false);
        this.fBuildDaysTableViewer.getTable().setEnabled(enabled);
        this.fSchedulePropertyControl.setEnabled(enabled);
        this.fSelectAllDaysButton.setEnabled(enabled);
        this.fDeselectAllDaysButton.setEnabled(enabled);
    }

    private void initializeWidgetData() {
        IBuildScheduleEntry workingBuildScheduleEntry = this.getWorkingBuildScheduleEntry();
        if (workingBuildScheduleEntry == null) {
            return;
        }
        this.fTimeWidget.setDate(2012, 1, 1);
        this.fTimeWidget.setTime(workingBuildScheduleEntry.getBuildHour(), workingBuildScheduleEntry.getBuildMinute(), 0);
        String intervalText = "";
        int interval = workingBuildScheduleEntry.getBuildInterval();
        if (interval > 0 || interval == -1) {
            intervalText = String.valueOf(interval);
            this.fContinuousIntervalButton.setSelection(true);
            this.fTimeButton.setSelection(false);
        } else {
            this.fContinuousIntervalButton.setSelection(false);
            this.fTimeButton.setSelection(true);
        }
        try {
            this.fIgnore = true;
            this.fContinuousIntervalText.setText(intervalText);
        }
        finally {
            this.fIgnore = false;
        }
        this.fBuildDaysTableViewer.setChecked((Object)BuildScheduleTextHelper.MONDAY, workingBuildScheduleEntry.isBuildOnMonday());
        this.fBuildDaysTableViewer.setChecked((Object)BuildScheduleTextHelper.TUESDAY, workingBuildScheduleEntry.isBuildOnTuesday());
        this.fBuildDaysTableViewer.setChecked((Object)BuildScheduleTextHelper.WEDNESDAY, workingBuildScheduleEntry.isBuildOnWednesday());
        this.fBuildDaysTableViewer.setChecked((Object)BuildScheduleTextHelper.THURSDAY, workingBuildScheduleEntry.isBuildOnThursday());
        this.fBuildDaysTableViewer.setChecked((Object)BuildScheduleTextHelper.FRIDAY, workingBuildScheduleEntry.isBuildOnFriday());
        this.fBuildDaysTableViewer.setChecked((Object)BuildScheduleTextHelper.SATURDAY, workingBuildScheduleEntry.isBuildOnSaturday());
        this.fBuildDaysTableViewer.setChecked((Object)BuildScheduleTextHelper.SUNDAY, workingBuildScheduleEntry.isBuildOnSunday());
        this.updateTimeZoneInfo(workingBuildScheduleEntry);
        this.fSchedulePropertyControl.setBuildProperties(workingBuildScheduleEntry.getBuildScheduleProperties());
        this.fSchedulePropertyControl.getComposite().layout(true, true);
    }

    private void updateTimeZoneInfo(IBuildScheduleEntry scheduleEntry) {
        this.fTimeZoneLabel.setText(this.getTimeZoneText(scheduleEntry));
    }

    private String getTimeZoneText(IBuildScheduleEntry scheduleEntry) {
        if (scheduleEntry == null) {
            return "";
        }
        TimeZone entryZone = BuildScheduleHelper.getTimeZone((IBuildScheduleEntry)scheduleEntry, (TimeZone)this.fServerTimeZone);
        return entryZone.getDisplayName();
    }

    @Override
    protected String getContextHelpId() {
        return "com.ibm.team.build.ui.editor_builddefinitionschedule";
    }

    @Override
    public Control getFocusControl() {
        return this.fScheduleEnabledButton.getSelection() ? this.fScheduleEntriesViewer.getControl() : this.fScheduleEnabledButton;
    }

    private void addNewScheduleEntry() {
        IBuildScheduleEntry entry = BuildItemFactory.createBuildScheduleEntry();
        entry.setBuildHour(8);
        entry.setBuildMinute(0);
        entry.setBuildOnMonday(true);
        entry.setBuildOnTuesday(true);
        entry.setBuildOnWednesday(true);
        entry.setBuildOnThursday(true);
        entry.setBuildOnFriday(true);
        entry.setBuildOnSaturday(true);
        entry.setBuildOnSunday(true);
        entry.getBuildScheduleProperties().addAll(this.getNewEntryScheduleProperties());
        entry.setTimeZoneID(TimeZone.getDefault().getID());
        ((List)this.fScheduleEntriesViewer.getInput()).add(entry);
        this.fScheduleEntriesViewer.add((Object)entry);
        this.fScheduleEntriesViewer.setSelection((ISelection)new StructuredSelection((Object)entry), true);
    }

    private List<IBuildProperty> getNewEntryScheduleProperties() {
        BuildConfigurationElementExtensionManager extensionManager = BuildConfigurationElementExtensionManager.getInstance();
        ArrayList<BuildProperty> extensionScheduleProperties = new ArrayList<BuildProperty>();
        for (Object configurationElement : this.fWorkingCopy.getConfigurationElements()) {
            IBuildProperty[] configurationElementProperties;
            IBuildConfigurationElement currentConfigurationElement = (IBuildConfigurationElement)configurationElement;
            BuildConfigurationElementExtension extension = extensionManager.getBuildConfigurationElement(currentConfigurationElement.getElementId());
            IBuildProperty[] iBuildPropertyArray = configurationElementProperties = extension != null ? extension.getGenericProperties() : null;
            if (configurationElementProperties == null) continue;
            IBuildProperty[] iBuildPropertyArray2 = configurationElementProperties;
            int n = configurationElementProperties.length;
            int n2 = 0;
            while (n2 < n) {
                IBuildProperty elementProperty = iBuildPropertyArray2[n2];
                if (elementProperty.isScheduleOverride()) {
                    extensionScheduleProperties.add((BuildProperty)elementProperty.copyProperty());
                }
                ++n2;
            }
        }
        IBuildProperty currentProperty = null;
        HashMap<String, Object> currentProperties = new HashMap<String, Object>();
        for (Object property : this.fWorkingCopy.getProperties()) {
            currentProperty = (IBuildProperty)property;
            currentProperties.put(currentProperty.getName(), currentProperty.copyProperty());
        }
        for (BuildProperty extensionScheduleProperty : extensionScheduleProperties) {
            String extensionPropertyName = extensionScheduleProperty.getName();
            BuildProperty property = (BuildProperty)currentProperties.get(extensionPropertyName);
            if (property != null) {
                String extensionPropertyValue = extensionScheduleProperty.getValue();
                if (extensionScheduleProperty.isSetKind()) {
                    property.setKind(extensionScheduleProperty.getKind());
                }
                if (property.getValue().isEmpty() && extensionScheduleProperty.isSetValue() && !extensionPropertyValue.isEmpty()) {
                    property.setValue(extensionPropertyValue);
                }
                if (!property.isSetDescription() || property.getDescription().isEmpty() && extensionScheduleProperty.isSetDescription()) {
                    property.setDescription(extensionScheduleProperty.getDescription());
                }
                if (!property.isSetLabel() && extensionScheduleProperty.isSetLabel()) {
                    property.setLabel(extensionScheduleProperty.getLabel());
                }
                if (extensionScheduleProperty.isSetWellKnown()) {
                    property.setWellKnown(extensionScheduleProperty.isWellKnown());
                }
                property.setScheduleOverride(true);
                continue;
            }
            currentProperties.put(extensionPropertyName, extensionScheduleProperty);
        }
        ArrayList<IBuildProperty> newScheduleEntryProperties = new ArrayList<IBuildProperty>();
        for (IBuildProperty property : currentProperties.values()) {
            if (!property.isScheduleOverride()) continue;
            newScheduleEntryProperties.add(property);
        }
        return newScheduleEntryProperties;
    }

    public class SchedulePropertyControl
    extends BuildPropertyControl {
        public SchedulePropertyControl(Composite parent, FormToolkit toolkit, List<IBuildProperty> buildProperties, ITeamRepository teamRepository, boolean isEditable, BuildPropertyControl.LayoutSize layoutSize) {
            super(parent, toolkit, buildProperties, teamRepository, isEditable, layoutSize, BuildEngineHelper.supportsHiddenProperty((IBuildDefinition)ScheduleConfigurationEditor.this.fWorkingCopy));
            Object layoutData = this.getComposite().getLayoutData();
            if (layoutData instanceof GridData) {
                ((GridData)layoutData).heightHint = this.fTableViewer.getTable().getItemHeight() * 11;
            }
            this.fTableViewer.resetFilters();
        }

        @Override
        protected SelectionListener getEditPropertyListener() {
            return new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IBuildProperty buildProperty = SchedulePropertyControl.this.getSelectedProperty();
                    if (buildProperty != null) {
                        SchedulePropertyControl.this.editProperty(buildProperty);
                    }
                }
            };
        }

        private IBuildProperty getSelectedProperty() {
            IStructuredSelection selection = this.getCurrentPropertySelection();
            Object element = selection.getFirstElement();
            if (element instanceof IBuildProperty) {
                return (IBuildProperty)element;
            }
            return null;
        }

        @Override
        protected void handleOpen(OpenEvent event) {
            ISelection selection = event.getSelection();
            if (!(selection instanceof IStructuredSelection)) {
                return;
            }
            Object element = ((IStructuredSelection)selection).getFirstElement();
            if (element instanceof IBuildProperty) {
                IBuildProperty buildProperty = (IBuildProperty)element;
                this.editProperty(buildProperty);
            }
        }

        private void editProperty(final IBuildProperty buildProperty) {
            BuildPropertyDialog dialog = new BuildPropertyDialog(this.fParentShell, BuildUIMessages.BuildPropertyControl_EDIT_TITLE, buildProperty, this.fBuildProperties, false, this.fTeamRepository, BuildEngineHelper.supportsHiddenProperty((IBuildDefinition)ScheduleConfigurationEditor.this.fWorkingCopy) && BuildEngineHelper.doesPropertyKindSupportsHiddenProperty((IBuildProperty)buildProperty));
            if (buildProperty.isWellKnown()) {
                IBuildPropertyEditorContext context;
                AbstractBuildPropertyEditor fPropertyEditor = dialog.getPropertyEditor(buildProperty);
                if (fPropertyEditor instanceof ISchedulePropertyEditor) {
                    ((ISchedulePropertyEditor)((Object)fPropertyEditor)).setWorkingCopy(ScheduleConfigurationEditor.this.fWorkingCopy);
                }
                if (fPropertyEditor.editProperty(context = new IBuildPropertyEditorContext(){

                    @Override
                    public IBuildProperty getProperty() {
                        return buildProperty;
                    }

                    @Override
                    public Shell getShell() {
                        return SchedulePropertyControl.this.fParentShell;
                    }

                    @Override
                    public ITeamRepository getTeamRepository() {
                        return SchedulePropertyControl.this.fTeamRepository;
                    }
                })) {
                    this.fTableViewer.refresh();
                    this.notifyPropertyEdited(buildProperty);
                }
            } else if (dialog.open() == 0) {
                this.fTableViewer.refresh();
                this.notifyPropertyEdited(buildProperty);
            }
        }

        public boolean isEnabled() {
            return this.fAddPropertyButton.isEnabled() && this.fTableViewer.getTable().isEnabled();
        }

        public Button getAddPropertyButton() {
            return this.fAddPropertyButton;
        }

        public Button getEditPropertyButton() {
            return this.fEditPropertyButton;
        }

        public Button getRemovePropertyButton() {
            return this.fRemovePropertyButton;
        }

        public SelectionListener getEditPropertySelectionListener() {
            return this.getEditPropertyListener();
        }
    }
}

