/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.builddefinition;

import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.internal.common.helper.BuildEngineHelper;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.editors.builddefinition.BuildDefinitionEditorMessages;
import com.ibm.team.build.internal.ui.properties.BuildPropertyEditorExtension;
import com.ibm.team.build.internal.ui.properties.BuildPropertyEditorExtensionManager;
import com.ibm.team.build.internal.ui.properties.BuildPropertyLabelHelper;
import com.ibm.team.build.ui.properties.AbstractBuildPropertyEditor;
import com.ibm.team.build.ui.properties.IBuildPropertyEditorContext;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.util.NLS;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

public class PropertyTableLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private static final String EMPTY_STRING = "";
    protected TableViewer fTableViewer;
    protected ITeamRepository fTeamRepository;
    protected Map<String, String> fValueToLabelMap = new HashMap<String, String>();

    public PropertyTableLabelProvider(TableViewer tableViewer, ITeamRepository teamRepository) {
        this.fTableViewer = tableViewer;
        this.fTeamRepository = teamRepository;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof IBuildProperty) {
            IBuildProperty buildProperty = (IBuildProperty)element;
            switch (columnIndex) {
                case 0: {
                    String propertyName = buildProperty.getName();
                    String propertyLabel = buildProperty.getLabel();
                    if (propertyLabel != null && propertyLabel.length() > 0) {
                        propertyName = propertyLabel;
                    }
                    if (buildProperty.isRequired() && buildProperty.getKind().equals("com.ibm.team.build.property.readonly.string")) {
                        return NLS.bind((String)BuildDefinitionEditorMessages.PropertyTableLabelProvider_PROPERTY_LABEL_REQUIRED_READ_ONLY, (Object)propertyName, (Object[])new Object[0]);
                    }
                    if (buildProperty.getKind().equals("com.ibm.team.build.property.readonly.string")) {
                        return NLS.bind((String)BuildDefinitionEditorMessages.PropertyTableLabelProvider_PROPERTY_LABEL_READ_ONLY, (Object)propertyName, (Object[])new Object[0]);
                    }
                    if (buildProperty.isRequired()) {
                        return NLS.bind((String)BuildDefinitionEditorMessages.PropertyTableLabelProvider_PROPERTY_LABEL_REQUIRED, (Object)propertyName, (Object[])new Object[0]);
                    }
                    return propertyName;
                }
                case 1: {
                    if (buildProperty.isHidden()) {
                        return "*****";
                    }
                    AbstractBuildPropertyEditor editor = this.getPropertyEditor(buildProperty);
                    if (editor != null) {
                        String label = this.fValueToLabelMap.get(String.valueOf(buildProperty.getName()) + ":" + buildProperty.getValue());
                        if (label != null) {
                            return label;
                        }
                        BuildPropertyLabelHelper labelHelper = this.getLabelHelper();
                        IBuildPropertyEditorContext context = this.getPropertyEditorContext(buildProperty, this.fTableViewer.getTable().getShell(), this.fTeamRepository);
                        labelHelper.getPropertyValueLabelInBackground(editor, context);
                        return BuildDefinitionEditorMessages.PropertyTableLabelProvider_FETCH_PENDING_LABEL;
                    }
                    if (BuildEngineHelper.isBuildForgeHiddenProperty((IBuildProperty)buildProperty)) {
                        return "*****";
                    }
                    return buildProperty.getValue();
                }
                case 2: {
                    return buildProperty.getDescription();
                }
            }
        }
        return null;
    }

    protected BuildPropertyLabelHelper getLabelHelper() {
        return new BuildPropertyLabelHelper(){

            @Override
            public void labelAvailable(String label, IBuildProperty buildProperty) {
                if (!PropertyTableLabelProvider.this.fTableViewer.getTable().isDisposed()) {
                    PropertyTableLabelProvider.this.fValueToLabelMap.put(String.valueOf(buildProperty.getName()) + ":" + buildProperty.getValue(), label);
                    PropertyTableLabelProvider.this.fTableViewer.update((Object)buildProperty, null);
                }
            }
        };
    }

    protected IBuildPropertyEditorContext getPropertyEditorContext(final IBuildProperty buildProperty, Shell parent, ITeamRepository teamRepository) {
        return new IBuildPropertyEditorContext(){

            @Override
            public IBuildProperty getProperty() {
                return buildProperty;
            }

            @Override
            public Shell getShell() {
                return PropertyTableLabelProvider.this.fTableViewer.getTable().getShell();
            }

            @Override
            public ITeamRepository getTeamRepository() {
                return PropertyTableLabelProvider.this.fTeamRepository;
            }
        };
    }

    private AbstractBuildPropertyEditor getPropertyEditor(IBuildProperty buildProperty) {
        AbstractBuildPropertyEditor editor = null;
        try {
            BuildPropertyEditorExtension extension = BuildPropertyEditorExtensionManager.getInstance().getBuildPropertyEditor(buildProperty.getKind());
            if (extension != null) {
                editor = extension.createPropertyEditor();
            }
        }
        catch (CoreException exception) {
            this.handlePropertyEditorException(exception);
        }
        return editor;
    }

    private void handlePropertyEditorException(CoreException exception) {
        BuildUIPlugin.log(exception);
    }
}

