/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.builddefinition;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.internal.common.helper.BuildEngineHelper;
import com.ibm.team.build.internal.common.model.BuildDefinition;
import com.ibm.team.build.internal.common.model.BuildProperty;
import com.ibm.team.build.internal.ui.BuildPropertyControl;
import com.ibm.team.build.internal.ui.IBuildPropertyControlListener;
import com.ibm.team.build.internal.ui.editors.builddefinition.BasicConfigurationElementEditor;
import com.ibm.team.build.internal.ui.editors.builddefinition.BuildDefinitionEditorMessages;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class PropertiesConfigurationEditor
extends BasicConfigurationElementEditor {
    protected BuildPropertyControl fBuildPropertyControl;
    private Section fPropertiesSection;
    private Adapter fPropertyChangedAdapter = new EContentAdapter(){

        public void notifyChanged(Notification notification) {
            Object notifier = notification.getNotifier();
            if (notifier instanceof BuildProperty || notifier instanceof BuildDefinition) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        PropertiesConfigurationEditor.this.refreshBuildPropertyControl();
                    }
                });
            }
        }
    };
    private IBuildPropertyControlListener fBuildPropertyListener = this.getPropertyListener();

    public PropertiesConfigurationEditor(String elementId, String title) {
        super(elementId, title);
    }

    @Override
    public void createContent(Composite parent, FormToolkit toolkit) {
        if (parent.getParent() != null) {
            GridLayoutFactory.swtDefaults().applyTo(parent.getParent());
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)parent);
        }
        GridLayoutFactory.swtDefaults().applyTo(parent);
        this.fPropertiesSection = this.createSection(parent, BuildDefinitionEditorMessages.BuildDefinitionEditor_PROPERTIES_TITLE, null, false, 1);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fPropertiesSection);
        Composite composite = (Composite)this.fPropertiesSection.getClient();
        GridLayoutFactory.fillDefaults().extendedMargins(2, 0, 0, 5).applyTo(composite);
        this.fBuildPropertyControl = new BuildPropertyControl(composite, toolkit, this.fWorkingCopy.getProperties(), this.getTeamRepository(), true, BuildPropertyControl.LayoutSize.FULL, BuildEngineHelper.supportsHiddenProperty((IBuildDefinition)this.fWorkingCopy));
        int widthHint = 600;
        int heightHint = ((TableViewer)this.fBuildPropertyControl.getViewer()).getTable().getItemHeight() * 5;
        GridDataFactory.fillDefaults().grab(true, true).hint(widthHint, heightHint).applyTo((Control)this.fBuildPropertyControl.getComposite());
        this.fBuildPropertyControl.addListener(this.fBuildPropertyListener);
        this.fBuildPropertyControl.replaceGlobalActionsOnFocus(this.getEditorSite());
        this.fBuildPropertyControl.createAndRegisterDefaultContextMenu((IWorkbenchPartSite)this.getEditorSite());
    }

    protected IBuildPropertyControlListener getPropertyListener() {
        return new IBuildPropertyControlListener(){

            @Override
            public void propertyAdded(IBuildProperty buildProperty) {
                PropertiesConfigurationEditor.this.handlePropertyAdded(buildProperty);
            }

            @Override
            public void propertyEdited(IBuildProperty buildProperty) {
                PropertiesConfigurationEditor.this.handlePropertyEdited(buildProperty);
            }

            @Override
            public void propertiesRemoved(IBuildProperty[] buildProperties) {
                PropertiesConfigurationEditor.this.handlePropertiesRemoved(buildProperties);
            }
        };
    }

    @Override
    public boolean validate() {
        boolean isValid = true;
        List properties = this.fWorkingCopy.getProperties();
        for (Object object : properties) {
            IBuildProperty property = (IBuildProperty)object;
            if (!property.isRequired() || !property.isGenericEditAllowed()) continue;
            if (property.getValue().equals("")) {
                this.addErrorMessage((Object)property.getName(), NLS.bind((String)BuildDefinitionEditorMessages.PropertiesConfigurationEditor_PROPERTY_REQUIRED, (Object)property.getName()), (Control)this.fBuildPropertyControl.getComposite());
                isValid = false;
                continue;
            }
            this.removeMessage(property.getName(), (Control)this.fBuildPropertyControl.getComposite());
        }
        this.setPageStatusIndicator(!isValid, false);
        return isValid;
    }

    protected void handlePropertyAdded(IBuildProperty buildProperty) {
        this.getManagedForm().reflow(true);
        this.setDirty(true);
    }

    protected void handlePropertyEdited(IBuildProperty editedProperty) {
        this.setDirty(true);
        this.validate();
    }

    protected void handlePropertiesRemoved(IBuildProperty[] removedProperties) {
        this.getManagedForm().reflow(true);
        this.setDirty(true);
    }

    public void dispose() {
        super.dispose();
        if (this.fWorkingCopy != null) {
            ((BuildDefinition)this.fWorkingCopy).eAdapters().remove((Object)this.fPropertyChangedAdapter);
        }
        if (this.fBuildPropertyControl != null) {
            this.fBuildPropertyControl.removeListener(this.fBuildPropertyListener);
        }
    }

    @Override
    public void setWorkingCopy(IBuildDefinition definition) {
        if (this.fWorkingCopy != null) {
            ((BuildDefinition)this.fWorkingCopy).eAdapters().remove((Object)this.fPropertyChangedAdapter);
        }
        super.setWorkingCopy(definition);
        ((BuildDefinition)this.fWorkingCopy).eAdapters().add((Object)this.fPropertyChangedAdapter);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                PropertiesConfigurationEditor.this.handleSetWorkingCopyAsync();
            }
        });
    }

    protected void handleSetWorkingCopyAsync() {
        if (this.fBuildPropertyControl != null && !this.fBuildPropertyControl.getComposite().isDisposed()) {
            this.fBuildPropertyControl.setBuildProperties(this.fWorkingCopy.getProperties());
        }
    }

    @Override
    protected String getContextHelpId() {
        return "com.ibm.team.build.ui.editor_builddefinitionproperties";
    }

    @Override
    public Control getFocusControl() {
        return this.fBuildPropertyControl.getViewer().getControl();
    }

    protected void refreshBuildPropertyControl() {
        if (this.fBuildPropertyControl != null && !this.fBuildPropertyControl.getComposite().isDisposed()) {
            this.fBuildPropertyControl.refresh();
        }
    }
}

