/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.builddefinition;

import com.ibm.team.build.common.model.IBuildConfigurationElement;
import com.ibm.team.build.common.model.IConfigurationProperty;
import com.ibm.team.build.internal.common.MicrosoftBuildItem;
import com.ibm.team.build.internal.ui.BuildUIMessages;
import com.ibm.team.build.internal.ui.IMicrosoftBuildItemControlListener;
import com.ibm.team.build.internal.ui.MicrosoftBuildItemsTableControl;
import com.ibm.team.build.internal.ui.editors.builddefinition.BasicConfigurationElementEditor;
import com.ibm.team.build.internal.ui.editors.builddefinition.BuildDefinitionEditorMessages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class MicrosoftBuildConfigurationEditor
extends BasicConfigurationElementEditor {
    private static final int DOUBLE_FIELD_SPACING = 20;
    protected static final String DEVENV = "Devenv";
    protected static final String MSBUILD = "MSbuild";
    private static final String EMPTY = "";
    protected Shell fParentShell;
    protected Text fBldCmdPathText;
    protected Text fPropertiesFileText;
    protected Button fDevenvBuildButton;
    protected Button fMsBuildButton;
    protected Button fContinueBuildButton;
    private FormToolkit fToolkit;
    protected MicrosoftBuildItemsTableControl fSlnTableControl;
    private IMicrosoftBuildItemControlListener fBuildPropertyListener = this.getPropertyListener();

    public MicrosoftBuildConfigurationEditor(String elementId, String title) {
        super(elementId, title);
    }

    @Override
    public void createContent(Composite parent, FormToolkit toolkit) {
        this.fToolkit = toolkit;
        this.fParentShell = parent.getShell();
        parent.setLayout((Layout)new TableWrapLayout());
        Section section = this.createSection(parent, BuildDefinitionEditorMessages.MicrosoftBuildConfigurationEditor_SECTION_TITLE, BuildDefinitionEditorMessages.MicrosoftBuildConfigurationEditor_SECTION_DESC, false);
        Composite composite = (Composite)section.getClient();
        GridLayoutFactory.fillDefaults().applyTo(composite);
        this.createBldCmdPathWidgets(composite);
        this.createItemssToBuildWidgets(composite);
        this.createContinueBuildWidget(composite);
        this.createPropertiesFileWidgets(composite);
    }

    private void createItemssToBuildWidgets(Composite parent) {
        this.createSpacer(parent, 20, 2);
        this.fSlnTableControl = this.getBuildTableControl(parent, this.fToolkit, null);
        this.fSlnTableControl.setBuildProperties(this.getBuildItems());
        GridData gridData = new GridData(4, 4, true, true);
        gridData.widthHint = 600;
        this.fSlnTableControl.getComposite().setLayoutData((Object)gridData);
        this.fSlnTableControl.setChangeListener(this.fBuildPropertyListener);
    }

    private void createBldCmdPathWidgets(Composite parent) {
        IBuildConfigurationElement element = this.fWorkingCopy.getConfigurationElement("com.ibm.team.build.msbuild");
        IConfigurationProperty property = element.getConfigurationProperty("com.ibm.team.build.msbuild.buildCmd");
        this.createSpacer(parent, 20, 2);
        this.createBuildCmdComposite(parent, BuildDefinitionEditorMessages.MicrosoftBuildConfigurationEditor_BUILD_CMD_LABEL, BuildDefinitionEditorMessages.MicrosoftBuildConfigurationEditor_BUILD_CMD_DESC, property.getValue());
        this.createSpacer(parent, 20, 1);
        this.fBldCmdPathText = this.createConfigPropertyTextField(parent, "com.ibm.team.build.msbuild.buildCmdPath", BuildDefinitionEditorMessages.MicrosoftBuildConfigurationEditor_VS_PATH_LABEL, BuildDefinitionEditorMessages.MicrosoftBuildConfigurationEditor_VS_PATH_DESC, false);
    }

    private void createContinueBuildWidget(Composite parent) {
        this.fContinueBuildButton = this.fToolkit.createButton(parent, BuildUIMessages.MicrosoftBuildConfigurationEditor_CONTINUE_BUILD_LABEL, 32);
        this.fContinueBuildButton.setSize(-1, -1);
        this.fContinueBuildButton.setSelection(this.getContinueToBuildPropertyValue());
        this.fContinueBuildButton.addSelectionListener(this.getContinueToBuildSelectionListener());
    }

    private SelectionListener getContinueToBuildSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = MicrosoftBuildConfigurationEditor.this.fContinueBuildButton.getSelection();
                MicrosoftBuildConfigurationEditor.this.setConfigProperty("com.ibm.team.build.msbuild.continueBuild", Boolean.toString(selected));
                MicrosoftBuildConfigurationEditor.this.setDirty(true);
                MicrosoftBuildConfigurationEditor.this.validate();
            }
        };
    }

    private void createPropertiesFileWidgets(Composite parent) {
        this.createSpacer(parent, 20, 2);
        this.fPropertiesFileText = this.createConfigPropertyTextField(parent, "com.ibm.team.build.msbuild.propertiesFile", BuildDefinitionEditorMessages.MicrosoftBuildConfigurationEditor_PROPERTIES_LABEL, BuildDefinitionEditorMessages.MicrosoftBuildConfigurationEditor_PROPERTIES_DESC, false);
    }

    private SelectionListener getBuildCmdSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MicrosoftBuildConfigurationEditor.this.validate();
                IBuildConfigurationElement element = MicrosoftBuildConfigurationEditor.this.fWorkingCopy.getConfigurationElement("com.ibm.team.build.msbuild");
                IConfigurationProperty property = element.getConfigurationProperty("com.ibm.team.build.msbuild.buildCmd");
                if (MicrosoftBuildConfigurationEditor.this.fDevenvBuildButton.getSelection()) {
                    property.setValue(MicrosoftBuildConfigurationEditor.DEVENV);
                } else if (MicrosoftBuildConfigurationEditor.this.fMsBuildButton.getSelection()) {
                    property.setValue(MicrosoftBuildConfigurationEditor.MSBUILD);
                }
                MicrosoftBuildConfigurationEditor.this.setDirty(true);
            }
        };
    }

    private void createBuildCmdComposite(Composite parent, String label, String description, String textValue) {
        Composite radioComposite = this.fToolkit.createComposite(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)radioComposite);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(radioComposite);
        this.fToolkit.createLabel(radioComposite, label);
        this.fDevenvBuildButton = this.fToolkit.createButton(radioComposite, BuildDefinitionEditorMessages.MicrosoftBuildConfigurationEditor_BUILD_CMD_DEVENV, 16);
        this.fDevenvBuildButton.setSize(-1, -1);
        this.fMsBuildButton = this.fToolkit.createButton(radioComposite, BuildDefinitionEditorMessages.MicrosoftBuildConfigurationEditor_BUILD_CMD_MSBUILD, 16);
        this.fMsBuildButton.setSize(-1, -1);
        this.fDevenvBuildButton.addSelectionListener(this.getBuildCmdSelectionListener());
        this.fMsBuildButton.addSelectionListener(this.getBuildCmdSelectionListener());
        if (textValue.equals(DEVENV)) {
            this.fDevenvBuildButton.setSelection(true);
        } else {
            this.fMsBuildButton.setSelection(true);
        }
        Label descriptionLabel = this.fToolkit.createLabel(parent, description, 64);
        descriptionLabel.setForeground(Display.getDefault().getSystemColor(16));
    }

    @Override
    public Control getFocusControl() {
        return this.fSlnTableControl.getTableViewer().getControl();
    }

    @Override
    protected Text createLabeledText(Composite parent, String labelText, String description, String textValue) {
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        Composite composite = this.fToolkit.createComposite(parent);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        toolkit.createLabel(composite, labelText);
        Text text = toolkit.createText(composite, textValue);
        GridData gridData = new GridData(4, 4, true, true);
        text.setLayoutData((Object)gridData);
        Label descriptionLabel = toolkit.createLabel(parent, description, 64);
        GridData gData = new GridData();
        gData.grabExcessHorizontalSpace = false;
        gData.grabExcessVerticalSpace = true;
        gData.horizontalAlignment = 4;
        gData.verticalAlignment = 4;
        descriptionLabel.setLayoutData((Object)gData);
        descriptionLabel.setForeground(Display.getDefault().getSystemColor(16));
        return text;
    }

    @Override
    protected void createSpacer(Composite parent, int height, int horizontalSpan) {
        Label label = this.getManagedForm().getToolkit().createLabel(parent, EMPTY);
        GridData data = new GridData(768, 1040, true, true);
        data.horizontalSpan = horizontalSpan;
        data.heightHint = height;
        label.setLayoutData((Object)data);
    }

    protected MicrosoftBuildItemsTableControl getBuildTableControl(Composite parent, FormToolkit toolkit, List<MicrosoftBuildItem> buildItems) {
        return new MicrosoftBuildItemsTableControl(parent, toolkit, buildItems);
    }

    @Override
    protected String getContextHelpId() {
        return "com.ibm.team.build.ui.editor_builddefinitionmicrosoftbuild";
    }

    protected IMicrosoftBuildItemControlListener getPropertyListener() {
        return new IMicrosoftBuildItemControlListener(){

            @Override
            public void buildItemsChanged(List<MicrosoftBuildItem> buildItems) {
                MicrosoftBuildConfigurationEditor.this.handleBuildItemsChange(buildItems);
            }
        };
    }

    private void handleBuildItemsChange(List<MicrosoftBuildItem> buildItems) {
        String bldItems = MicrosoftBuildItem.getString(buildItems);
        if (bldItems != null && bldItems.trim().length() >= 1) {
            this.setConfigProperty("com.ibm.team.build.msbuild.buildItem", bldItems);
            this.setDirty(true);
            this.validate();
        }
    }

    private List<MicrosoftBuildItem> getBuildItems() {
        MicrosoftBuildItem oldBldItem = this.getBuildItemFromOldProperties();
        if (oldBldItem != null) {
            ArrayList<MicrosoftBuildItem> bldItems = new ArrayList<MicrosoftBuildItem>(1);
            bldItems.add(oldBldItem);
            this.nullifyOldProperties();
            this.handleBuildItemsChange(bldItems);
            return bldItems;
        }
        String bldItems = this.getConfigProperty("com.ibm.team.build.msbuild.buildItem", null);
        if (bldItems != null) {
            return MicrosoftBuildItem.getItems((String)bldItems);
        }
        return new ArrayList<MicrosoftBuildItem>(0);
    }

    private MicrosoftBuildItem getBuildItemFromOldProperties() {
        String slnName = this.getConfigProperty("com.ibm.team.build.msbuild.solutionFile", null);
        if (slnName != null && slnName.trim().length() >= 1) {
            String buildConfig = this.getConfigProperty("com.ibm.team.build.msbuild.buildConfiguration", null);
            String buildType = this.getConfigProperty("com.ibm.team.build.msbuild.buildType", null);
            String additionalArguments = this.getConfigProperty("com.ibm.team.build.msbuild.additionalArg", null);
            String buildLogFile = this.getConfigProperty("com.ibm.team.build.msbuild.buildOutput", null);
            String workingDir = this.getConfigProperty("com.ibm.team.build.msbuild.workingDir", null);
            this.addWarningMessage(this.fSlnTableControl.getTableViewer().getControl(), BuildDefinitionEditorMessages.MicrosoftBuildConfigurationEditor_MIGRATION_WARNING, this.fSlnTableControl.getTableViewer().getControl());
            return new MicrosoftBuildItem(slnName, buildConfig, buildType, additionalArguments, buildLogFile, workingDir);
        }
        return null;
    }

    private void nullifyOldProperties() {
        this.setConfigProperty("com.ibm.team.build.msbuild.solutionFile", EMPTY);
        this.setConfigProperty("com.ibm.team.build.msbuild.buildConfiguration", EMPTY);
        this.setConfigProperty("com.ibm.team.build.msbuild.buildType", EMPTY);
        this.setConfigProperty("com.ibm.team.build.msbuild.additionalArg", EMPTY);
        this.setConfigProperty("com.ibm.team.build.msbuild.buildOutput", EMPTY);
        this.setConfigProperty("com.ibm.team.build.msbuild.workingDir", EMPTY);
    }

    private boolean getContinueToBuildPropertyValue() {
        String value = this.getConfigProperty("com.ibm.team.build.msbuild.continueBuild", "false");
        return Boolean.valueOf(value);
    }

    private void setConfigProperty(String propertyName, String value) {
        this.fWorkingCopy.setConfigurationProperty(this.getId(), propertyName, value);
    }

    private String getConfigProperty(String propertyName, String value) {
        return this.fWorkingCopy.getConfigurationPropertyValue(this.getId(), propertyName, value);
    }

    @Override
    public boolean validate() {
        boolean isValid = true;
        isValid = this.isSolutionFileValid();
        this.setPageStatusIndicator(!isValid, false);
        return isValid;
    }

    private boolean isSolutionFileValid() {
        if (this.fSlnTableControl.getBuildProperties() == null || this.fSlnTableControl.getBuildProperties().size() == 0) {
            this.addErrorMessageForRequiredField(this.fSlnTableControl.getTableViewer().getControl(), BuildDefinitionEditorMessages.MicrosoftBuildConfigurationEditor_BUILD_FILE_REQUIRED, this.fSlnTableControl.getTableViewer().getControl());
            return false;
        }
        if (!this.validBuildConfigurations(this.fSlnTableControl.getBuildProperties())) {
            this.addErrorMessageForRequiredField(this.fSlnTableControl.getTableViewer().getControl(), BuildDefinitionEditorMessages.MicrosoftBuildConfigurationEditor_BUILD_CONFIG_REQUIRED, this.fSlnTableControl.getTableViewer().getControl());
            return false;
        }
        if (!this.validBuildTypes(this.fSlnTableControl.getBuildProperties())) {
            this.addErrorMessageForRequiredField(this.fSlnTableControl.getTableViewer().getControl(), BuildDefinitionEditorMessages.MicrosoftBuildConfigurationEditor_BUILD_TYPE_REQUIRED, this.fSlnTableControl.getTableViewer().getControl());
            return false;
        }
        this.removeMessage(this.fSlnTableControl.getTableViewer().getControl(), this.fSlnTableControl.getTableViewer().getControl());
        return true;
    }

    private boolean validBuildConfigurations(List buildProperties) {
        if (this.fMsBuildButton.getSelection()) {
            return true;
        }
        if (buildProperties != null && buildProperties.size() >= 1) {
            for (Object buildItem : buildProperties) {
                if (!(buildItem instanceof MicrosoftBuildItem) || ((MicrosoftBuildItem)buildItem).isValidBuildConfig()) continue;
                return false;
            }
        }
        return true;
    }

    private boolean validBuildTypes(List buildProperties) {
        if (this.fMsBuildButton.getSelection()) {
            return true;
        }
        if (buildProperties != null && buildProperties.size() >= 1) {
            for (Object buildItem : buildProperties) {
                if (!(buildItem instanceof MicrosoftBuildItem) || ((MicrosoftBuildItem)buildItem).isValidDevEnvBuildType()) continue;
                return false;
            }
        }
        return true;
    }
}

