/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.builddefinition;

import com.ibm.team.build.internal.ui.editors.builddefinition.BasicConfigurationElementEditor;
import com.ibm.team.build.internal.ui.editors.builddefinition.BuildDefinitionEditorMessages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class MavenConfigurationEditor
extends BasicConfigurationElementEditor {
    protected Text fProjectLocationText;
    protected Text fMavenHomeText;
    protected Text fMavenGoalsText;
    protected Text fJavaHomeText;
    protected Text fJavaArgsText;
    protected Text fPropertiesFileText;

    public MavenConfigurationEditor(String elementId, String title) {
        super(elementId, title);
    }

    @Override
    public void createContent(Composite parent, FormToolkit toolkit) {
        parent.setLayout((Layout)new TableWrapLayout());
        Section section = this.createSection(parent, BuildDefinitionEditorMessages.MavenConfigurationEditor_MAVEN_BUILD_SECTION, BuildDefinitionEditorMessages.MavenConfigurationEditor_MAVEN_BUILD_SECTION_DESCRIPTION, false);
        Composite composite = (Composite)section.getClient();
        this.createProjectLocationWidgets(composite);
        this.createMavenGoalsWidgets(composite);
        this.createSpacer(parent, 15, 1);
        section = this.createSection(parent, BuildDefinitionEditorMessages.MavenConfigurationEditor_MAVEN_CONFIG_SECTION, BuildDefinitionEditorMessages.MavenConfigurationEditor_MAVEN_CONFIG_SECTION_DESCRIPTION, true);
        composite = (Composite)section.getClient();
        this.createMavenHomeWidgets(composite);
        this.createJavaHomeWidgets(composite);
        this.createJavaArgsWidgets(composite);
        this.createPropertiesFileWidgets(composite);
    }

    private void createPropertiesFileWidgets(Composite parent) {
        this.createSpacer(parent, 10, 2);
        this.fPropertiesFileText = this.createConfigPropertyTextField(parent, "com.ibm.team.build.maven.propertiesFile", BuildDefinitionEditorMessages.MavenConfigurationEditor_PROPERTIES_FILE, BuildDefinitionEditorMessages.MavenConfigurationEditor_PROPERTIES_FILE_DESC, false);
    }

    private void createProjectLocationWidgets(Composite parent) {
        this.fProjectLocationText = this.createConfigPropertyTextField(parent, "com.ibm.team.build.maven.projectLocation", BuildDefinitionEditorMessages.MavenConfigurationEditor_PROJECT_LABEL, BuildDefinitionEditorMessages.MavenConfigurationEditor_PROJECT_DESCRIPTION, true);
    }

    private void createMavenHomeWidgets(Composite parent) {
        this.fMavenHomeText = this.createConfigPropertyTextField(parent, "com.ibm.team.build.maven.mavenHome", BuildDefinitionEditorMessages.MavenConfigurationEditor_MAVEN_HOME_LABEL, BuildDefinitionEditorMessages.MavenConfigurationEditor_MAVEN_HOME_DESCRIPTION, true);
    }

    private void createMavenGoalsWidgets(Composite parent) {
        this.createSpacer(parent, 10, 2);
        this.fMavenGoalsText = this.createConfigPropertyTextField(parent, "com.ibm.team.build.maven.mavenGoals", BuildDefinitionEditorMessages.MavenConfigurationEditor_GOALS_LABEL, BuildDefinitionEditorMessages.MavenConfigurationEditor_GOALS_DESCRIPTION, true);
    }

    private void createJavaHomeWidgets(Composite parent) {
        this.createSpacer(parent, 10, 2);
        this.fJavaHomeText = this.createConfigPropertyTextField(parent, "com.ibm.team.build.maven.javaHome", BuildDefinitionEditorMessages.MavenConfigurationEditor_JAVA_HOME_LABEL, BuildDefinitionEditorMessages.MavenConfigurationEditor_JAVA_HOME_DESCRIPTION, false);
    }

    private void createJavaArgsWidgets(Composite parent) {
        this.createSpacer(parent, 10, 2);
        this.fJavaArgsText = this.createConfigPropertyTextField(parent, "com.ibm.team.build.maven.javaVMArgs", BuildDefinitionEditorMessages.MavenConfigurationEditor_VM_ARGS, BuildDefinitionEditorMessages.MavenConfigurationEditor_VM_ARGS_DESCRIPTION, false);
    }

    @Override
    public boolean validate() {
        boolean isValid = true;
        if (this.fProjectLocationText.getText().trim().equals("")) {
            this.addErrorMessageForRequiredField(this.fProjectLocationText, BuildDefinitionEditorMessages.MavenConfigurationEditor_ERROR_PROJECT_REQUIRED, (Control)this.fProjectLocationText);
            isValid = false;
        } else {
            this.removeMessage(this.fProjectLocationText, (Control)this.fProjectLocationText);
        }
        if (this.fMavenGoalsText.getText().trim().equals("")) {
            this.addErrorMessageForRequiredField(this.fMavenGoalsText, BuildDefinitionEditorMessages.MavenConfigurationEditor_ERROR_GOAL_REQUIRED, (Control)this.fMavenGoalsText);
            isValid = false;
        } else {
            this.removeMessage(this.fMavenGoalsText, (Control)this.fMavenGoalsText);
        }
        if (this.fMavenHomeText.getText().trim().equals("")) {
            this.addErrorMessageForRequiredField(this.fMavenHomeText, BuildDefinitionEditorMessages.MavenConfigurationEditor_ERROR_MAVEN_HOME_REQUIRED, (Control)this.fMavenHomeText);
            isValid = false;
        } else {
            this.removeMessage(this.fMavenHomeText, (Control)this.fMavenHomeText);
        }
        this.setPageStatusIndicator(!isValid, false);
        return isValid;
    }

    @Override
    public Control getFocusControl() {
        return this.fProjectLocationText;
    }

    @Override
    protected String getContextHelpId() {
        return "com.ibm.team.build.ui.editor_builddefinitionmaven";
    }
}

