/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.builddefinition;

import com.ibm.team.build.internal.ui.editors.builddefinition.BasicConfigurationElementEditor;
import com.ibm.team.build.internal.ui.editors.builddefinition.BuildDefinitionEditorMessages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class MSTestConfigurationEditor
extends BasicConfigurationElementEditor {
    protected Text fMSTestFile;
    protected Text fMSTestDLLFile;
    protected Text fMSTestExePath;
    protected Text fMSTestResultFile;
    protected Text fAdditonalArgs;
    protected Text fWorkingDir;

    public MSTestConfigurationEditor(String elementId, String title) {
        super(elementId, title);
    }

    @Override
    public void createContent(Composite parent, FormToolkit toolkit) {
        parent.setLayout((Layout)new TableWrapLayout());
        Section section = this.createSection(parent, BuildDefinitionEditorMessages.MSTestConfigurationEditor_UNIT_TEST_SECTION_TITLE, BuildDefinitionEditorMessages.MSTestConfigurationEditor_UNIT_TEST_SECTION_DESC, false);
        Composite composite = (Composite)section.getClient();
        composite.setLayoutData((Object)new TableWrapData(256, 256));
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        this.createMSTestWidgets(composite);
        this.validate();
    }

    private void createMSTestWidgets(Composite parent) {
        this.fMSTestExePath = this.createConfigPropertyTextField(parent, "com.ibm.team.build.mstest.msTestPath", BuildDefinitionEditorMessages.MSTestConfigurationEditor_MSTEST_PATH_LABEL, BuildDefinitionEditorMessages.MSTestConfigurationEditor_MSTEST_PATH_DESC, false);
        this.fMSTestDLLFile = this.createConfigPropertyTextField(parent, "com.ibm.team.build.mstest.mstestDLLFile", BuildDefinitionEditorMessages.MSTestConfigurationEditor_RUN_MSTEST_DLL_FILE_LABEL, BuildDefinitionEditorMessages.MSTestConfigurationEditor_RUN_MSTEST_DLL_FILE_DESC, true);
        this.fMSTestFile = this.createConfigPropertyTextField(parent, "com.ibm.team.build.mstest.mstestFile", BuildDefinitionEditorMessages.MSTestConfigurationEditor_RUN_MSTEST_FILE_LABEL, BuildDefinitionEditorMessages.MSTestConfigurationEditor_RUN_MSTEST_FILE_DESC, true);
        this.fMSTestResultFile = this.createConfigPropertyTextField(parent, "com.ibm.team.build.mstest.mstestResultFile", BuildDefinitionEditorMessages.MSTestConfigurationEditor_MSTEST_RESULT_FILE_LABEL, BuildDefinitionEditorMessages.MSTestConfigurationEditor_MSTEST_RESULT_FILE_DESC, false);
        this.fAdditonalArgs = this.createConfigPropertyTextField(parent, "com.ibm.team.build.mstest.additionalArg", BuildDefinitionEditorMessages.MSTestConfigurationEditor_MSTEST_ADDITIONAL_ARG_LABEL, BuildDefinitionEditorMessages.MSTestConfigurationEditor_MSTEST_ADDITIONAL_ARG_DESC, false);
        this.fWorkingDir = this.createConfigPropertyTextField(parent, "com.ibm.team.build.mstest.workingDir", BuildDefinitionEditorMessages.MSTestConfigurationEditor_WORKING_DIR_LABEL, BuildDefinitionEditorMessages.MSTestConfigurationEditor_WORKING_DIR_DESC, false);
    }

    @Override
    public boolean validate() {
        String msTestFile = this.fMSTestFile.getText().trim();
        String dllTestFile = this.fMSTestDLLFile.getText().trim();
        boolean isWarning = false;
        this.removeMessage(this.fMSTestFile, (Control)this.fMSTestFile);
        this.removeMessage(this.fMSTestDLLFile, (Control)this.fMSTestDLLFile);
        if (msTestFile != null && msTestFile.length() > 0 && dllTestFile != null && dllTestFile.length() > 0) {
            this.addWarningMessage(this.fMSTestFile, BuildDefinitionEditorMessages.MSTestConfigurationEditor_RUN_MSTEST_MULTIPLE_FILES_WARNING, (Control)this.fMSTestFile);
            this.addWarningMessage(this.fMSTestDLLFile, BuildDefinitionEditorMessages.MSTestConfigurationEditor_RUN_MSTEST_MULTIPLE_FILES_WARNING, (Control)this.fMSTestDLLFile);
            isWarning = true;
        } else if (!(msTestFile != null && msTestFile.length() != 0 || dllTestFile != null && dllTestFile.length() != 0)) {
            this.addWarningMessage(this.fMSTestFile, BuildDefinitionEditorMessages.MSTestConfigurationEditor_RUN_MSTEST_NO_FILES_WARNING, (Control)this.fMSTestFile);
            this.addWarningMessage(this.fMSTestDLLFile, BuildDefinitionEditorMessages.MSTestConfigurationEditor_RUN_MSTEST_NO_FILES_WARNING, (Control)this.fMSTestDLLFile);
            isWarning = true;
        }
        this.setPageStatusIndicator(false, isWarning);
        return true;
    }

    @Override
    public Control getFocusControl() {
        return this.fMSTestFile;
    }

    @Override
    protected String getContextHelpId() {
        return "com.ibm.team.build.ui.editor_builddefinitionmstest";
    }
}

