/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.builddefinition;

import com.ibm.team.build.client.ClientFactory;
import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.internal.client.iterator.ItemQueryIterator;
import com.ibm.team.build.internal.common.model.query.BaseBuildDefinitionQueryModel;
import com.ibm.team.build.internal.scm.ComponentLoadRules;
import com.ibm.team.build.internal.scm.LoadComponents;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.editors.builddefinition.BasicConfigurationElementEditor;
import com.ibm.team.build.internal.ui.editors.builddefinition.BuildDefinitionEditorMessages;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.ui.FileSelectionDialog;
import com.ibm.team.filesystem.ui.WORKSPACES_OR_STREAMS;
import com.ibm.team.filesystem.ui.WorkspaceAndStreamSelectionDialog;
import com.ibm.team.filesystem.ui.WorkspaceComponentSelectionDialog;
import com.ibm.team.filesystem.ui.views.TeamPlaceEditorInput;
import com.ibm.team.filesystem.ui.views.TeamPlacePart2;
import com.ibm.team.filesystem.ui.wizards.newworkspace.NewWorkspaceWizard;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.internal.filesystem.ui.picker.RepositoryFilesPickerOutput;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.service.IQueryService;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.rcp.ui.parts.impl.IPartResult;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.ComponentNotInWorkspaceException;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IPrivateScope;
import com.ibm.team.scm.common.dto.IReadScope;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class JazzScmConfigurationEditor
extends BasicConfigurationElementEditor {
    public static final String PREFERENCE_SHOW_WORKSPACE_OWNER_WARNING = "showWorkspaceOwnerWarning";
    protected Text fFetchDestinationText;
    protected Button fAcceptBeforeFetchButton;
    protected Button fBuildOnlyIfChangesButton;
    protected Button fIncludeLinkInWorkItemsCheckbox;
    protected Button fFullLoadButton;
    protected Button fIncrementalLoadButton;
    protected Button fOptimizedIncrementalLoadButton;
    protected Button fCreateFoldersForComponentsButton;
    private FormToolkit fToolkit;
    protected Hyperlink fWorkspaceTitleHyperlink;
    protected Text fWorkspaceNameText;
    protected Button fSelectWorkspaceButton;
    protected Button fCreateWorkspaceButton;
    private IWorkspace fBuildWorkspace;
    protected Text fComponentLoadRulesText;
    protected Button fSelectComponentLoadRulesButton;
    protected Button fClearComponentLoadRulesButton;
    protected ComponentLoadRules fComponentLoadRules;
    protected Text fLoadComponentsText;
    protected Button fSelectLoadComponentsButton;
    protected Button fClearLoadComponentsButton;
    private LoadComponents fLoadComponents;
    protected Color fEnabledHyperlinkForegroundColor;
    protected Color fDisabledHyperlinkForegroundColor;
    protected Button fDontShowWarningButton;
    protected String fBuildDefinitionWithSameBuildWorkspace;
    protected int fWorkspacePrivateComponentCount;
    private boolean fShouldShowWorkspaceAlreadyInUseDialog = false;
    private boolean fDisplayLoadPolicy;
    private Button fSpecifyComponentsToLoadButton;
    private Composite fComponentsToLoadRadioGroup;
    private Button fLoadAllComponentsButton;
    protected Button fExcludeSomeComponentsButton;
    protected Button fUseLoadRulesButton;
    private Button fSwitchToNewFormatButton;
    private boolean fShouldConfirmSave = false;
    private boolean fWarningWorkspaceIsStream = false;
    private boolean fWarningMissingComponentInComponentsToExclude = false;
    private boolean fErrorLoadRulesNotInXMLFormat = false;

    public JazzScmConfigurationEditor(String elementId, String title) {
        super(elementId, title);
        BuildUIPlugin.getDefault().getPreferenceStore().setDefault(PREFERENCE_SHOW_WORKSPACE_OWNER_WARNING, true);
    }

    @Override
    public void createContent(Composite parent, FormToolkit toolkit) {
        this.fToolkit = toolkit;
        TableWrapLayout layout = new TableWrapLayout();
        layout.verticalSpacing = 20;
        parent.setLayout((Layout)layout);
        this.createWorkspaceNameWidgets(parent);
        this.createLoadOptionsWidgets(parent);
        this.createAcceptOptionsWidgets(parent);
    }

    private void createWorkspaceNameWidgets(Composite parent) {
        Section section = this.createSection(parent, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_SECTION_TEXT_REPOSITORY, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_DESCRIPTION, false, 4);
        Composite composite = (Composite)section.getClient();
        this.fWorkspaceTitleHyperlink = this.fToolkit.createHyperlink(composite, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_WORKSPACE_LABEL, 0);
        this.fWorkspaceTitleHyperlink.addHyperlinkListener(this.getWorkspaceHyperlinkListener());
        this.fEnabledHyperlinkForegroundColor = this.fWorkspaceTitleHyperlink.getForeground();
        this.fWorkspaceTitleHyperlink.setLayoutData((Object)new TableWrapData(2, 32));
        this.fWorkspaceTitleHyperlink.addHyperlinkListener(this.getWorkspaceHyperlinkListener());
        this.fWorkspaceNameText = this.fToolkit.createText(composite, "", 0);
        this.fDisabledHyperlinkForegroundColor = this.fWorkspaceNameText.getForeground();
        this.fWorkspaceNameText.setEnabled(false);
        this.fWorkspaceNameText.setEditable(false);
        TableWrapData layoutData = new TableWrapData(256, 32);
        this.fWorkspaceNameText.setLayoutData((Object)layoutData);
        this.fSelectWorkspaceButton = this.fToolkit.createButton(composite, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_SELECT_WORKSPACE_BUTTON_TITLE, 0);
        this.fSelectWorkspaceButton.addSelectionListener(this.getSelectWorkspaceListener());
        this.fSelectWorkspaceButton.setLayoutData((Object)new TableWrapData());
        this.fCreateWorkspaceButton = this.fToolkit.createButton(composite, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_CREATE_WORKSPACE_BUTTON_TITLE, 0);
        this.fCreateWorkspaceButton.addSelectionListener(this.getCreateWorkspaceListener());
        this.fCreateWorkspaceButton.setLayoutData((Object)new TableWrapData());
        this.createInfoLabel(composite, NLS.bind((String)BuildDefinitionEditorMessages.JazzScmConfigurationEditor_UUID_PROPERTY, (Object)"team.scm.workspaceUUID", (Object[])new Object[0]), 4, false, -1);
        String workspaceUUID = this.fWorkingCopy.getPropertyValue("team.scm.workspaceUUID", "");
        if (workspaceUUID == null || workspaceUUID.length() == 0) {
            this.setWorkspaceNameText("", false);
            return;
        }
        this.setWorkspaceNameText(BuildDefinitionEditorMessages.JazzScmConfigurationEditor_PENDING, false);
        final IWorkspaceHandle workspaceHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)workspaceUUID), null);
        String fetchWorkspaceJobName = BuildDefinitionEditorMessages.JazzScmConfigurationEditor_FETCHING_JOB_NAME;
        TeamBuildJob fetchWorkspaceJob = new TeamBuildJob(fetchWorkspaceJobName, true, this.getTeamRepository()){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                JazzScmConfigurationEditor.this.setBuildWorkspace(JazzScmConfigurationEditor.this.fetchWorkspace(workspaceHandle, (IProgressMonitor)subMonitor.newChild(10)));
                JazzScmConfigurationEditor.this.setWarningWorkspaceIsStream(JazzScmConfigurationEditor.this.getBuildWorkspace().isStream());
                JazzScmConfigurationEditor.this.handleUpdateWorkspaceText(JazzScmConfigurationEditor.this.getBuildWorkspace().getName());
                JazzScmConfigurationEditor.this.handleUpdateComponentLoadRulesButton(JazzScmConfigurationEditor.this.getBuildWorkspace());
                JazzScmConfigurationEditor.this.handleUpdateLoadComponentsButton(JazzScmConfigurationEditor.this.getBuildWorkspace());
                JazzScmConfigurationEditor.this.checkBuildWorkspace(JazzScmConfigurationEditor.this.getBuildWorkspace(), (IProgressMonitor)subMonitor.newChild(90));
                JazzScmConfigurationEditor.this.forceWorkspaceNameWarningUpdate();
                return Status.OK_STATUS;
            }

            @Override
            protected void jobFinished(IStatus status) {
                if (status.getSeverity() == 4) {
                    JazzScmConfigurationEditor.this.handleFetchBuildWorkspaceFailed(status);
                }
            }
        };
        fetchWorkspaceJob.schedule();
    }

    protected void checkBuildWorkspace(IWorkspace buildWorkspace, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        this.fetchBuildDefinitionWithSameBuildWorkspace(buildWorkspace, (IProgressMonitor)subMonitor.newChild(50));
        this.checkComponentVisibility(buildWorkspace, (IProgressMonitor)subMonitor.newChild(50));
    }

    private Label createLabel(Composite parent, String text, boolean indent, int indentLength) {
        Label label = this.fToolkit.createLabel(parent, text, 0);
        TableWrapData data = new TableWrapData(2, 32);
        if (indent) {
            data.indent = LayoutConstants.getMargins().x * indentLength;
        }
        label.setLayoutData((Object)data);
        return label;
    }

    private Label createIntroLabel(Composite parent, String text, int colSpan, boolean indent, int indentLength) {
        Label label = this.fToolkit.createLabel(parent, text, 64);
        label.setForeground(Display.getDefault().getSystemColor(21));
        TableWrapData data = new TableWrapData(2, 32, 1, colSpan);
        if (indent) {
            data.indent = LayoutConstants.getMargins().x * indentLength;
        }
        label.setLayoutData((Object)data);
        return label;
    }

    private Label createInfoLabel(Composite parent, String text, int colSpan, boolean indent, int indentLength) {
        Label label = this.fToolkit.createLabel(parent, text, 64);
        label.setForeground(Display.getDefault().getSystemColor(16));
        TableWrapData data = new TableWrapData(2, 32, 1, colSpan);
        if (indent) {
            data.indent = LayoutConstants.getMargins().x * indentLength;
        }
        label.setLayoutData((Object)data);
        return label;
    }

    protected void handleFetchBuildWorkspaceFailed(final IStatus status) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!JazzScmConfigurationEditor.this.fWorkspaceNameText.isDisposed()) {
                    String errorMessage = BuildDefinitionEditorMessages.JazzScmConfigurationEditor_ERROR_FETCHING;
                    if (status.getException() instanceof ItemNotFoundException) {
                        errorMessage = BuildDefinitionEditorMessages.JazzScmConfigurationEditor_WORKSPACE_DELETED;
                    } else if (status.getException() instanceof PermissionDeniedException) {
                        errorMessage = BuildDefinitionEditorMessages.JazzScmConfigurationEditor_NO_READ_ACCESS_TO_WORKSPACE;
                    }
                    JazzScmConfigurationEditor.this.setWorkspaceNameText(errorMessage, false);
                }
            }
        });
    }

    private void setWorkspaceTitleHyperlinkEnablement(boolean enabled) {
        this.fWorkspaceTitleHyperlink.setForeground(enabled ? this.fEnabledHyperlinkForegroundColor : this.fDisabledHyperlinkForegroundColor);
        this.fWorkspaceTitleHyperlink.setUnderlined(enabled);
        this.fWorkspaceTitleHyperlink.setEnabled(enabled);
    }

    private void setWorkspaceNameText(String text, boolean workspaceSet) {
        this.fWorkspaceNameText.setText(text);
        this.fWorkspaceNameText.setEnabled(workspaceSet);
        this.setWorkspaceTitleHyperlinkEnablement(workspaceSet);
    }

    private void createLoadOptionsWidgets(Composite parent) {
        Section section = this.createSection(parent, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_SECTION_TEXT_LOAD, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_SECTION_DESC_LOAD, true, 4);
        Composite composite = (Composite)section.getClient();
        String fetchDestination = this.fWorkingCopy.getPropertyValue("team.scm.fetchDestination", "");
        this.createLabel(composite, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_DESTINATION_LABEL, false, -1);
        this.fFetchDestinationText = this.fToolkit.createText(composite, fetchDestination);
        TableWrapData layoutData = new TableWrapData(256, 32, 1, 3);
        layoutData.maxWidth = 300;
        this.fFetchDestinationText.setLayoutData((Object)layoutData);
        this.fFetchDestinationText.addModifyListener(this.getFetchDestinationModifiedListener());
        this.createInfoLabel(composite, NLS.bind((String)BuildDefinitionEditorMessages.JazzScmConfigurationEditor_DESTINATION_DESC, (Object)"team.scm.fetchDestination", (Object[])new Object[0]), 4, false, -1);
        this.createIntroLabel(composite, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_LOAD_METHOD_SECTION_DESC, 4, false, -1);
        this.createInfoLabel(composite, NLS.bind((String)BuildDefinitionEditorMessages.JazzScmConfigurationEditor_LOAD_METHOD_DESC, (Object)"team.scm.loadMethod", (Object[])new Object[0]), 4, false, -1);
        Composite loadMethodRadioGroup = this.fToolkit.createComposite(composite);
        TableWrapLayout loadMethodCompositeLayout = new TableWrapLayout();
        loadMethodCompositeLayout.numColumns = 4;
        loadMethodCompositeLayout.leftMargin = 0;
        loadMethodCompositeLayout.rightMargin = 0;
        loadMethodRadioGroup.setLayout((Layout)loadMethodCompositeLayout);
        layoutData = new TableWrapData(256, 256, 1, 4);
        loadMethodRadioGroup.setLayoutData((Object)layoutData);
        String deleteBeforeFetch = this.fWorkingCopy.getPropertyValue("team.scm.deleteDestinationBeforeFetch", "false");
        String loadMethod = this.fWorkingCopy.getPropertyValue("team.scm.loadMethod", "");
        this.fFullLoadButton = this.fToolkit.createButton(loadMethodRadioGroup, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_FULL_LOAD_LABEL, 16);
        layoutData = new TableWrapData(2, 32, 1, 4);
        this.fFullLoadButton.setLayoutData((Object)layoutData);
        this.fFullLoadButton.setSelection(Boolean.valueOf(deleteBeforeFetch).booleanValue());
        this.fFullLoadButton.addSelectionListener(this.getLoadMethodSelectionListener());
        this.createInfoLabel(loadMethodRadioGroup, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_FULL_LOAD_DESC, 4, true, 1);
        this.fIncrementalLoadButton = this.fToolkit.createButton(loadMethodRadioGroup, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_INCREMENTAL_LOAD_LABEL, 16);
        layoutData = new TableWrapData(2, 32, 1, 4);
        this.fIncrementalLoadButton.setLayoutData((Object)layoutData);
        this.fIncrementalLoadButton.setSelection(Boolean.valueOf(deleteBeforeFetch) == false && (loadMethod == null || loadMethod.trim().length() == 0 || !this.isLoadMethodValidWhenNotDoingFullLoad(loadMethod) || "incrementalLoad".equals(loadMethod)));
        this.fIncrementalLoadButton.addSelectionListener(this.getLoadMethodSelectionListener());
        this.createInfoLabel(loadMethodRadioGroup, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_INCREMENTAL_LOAD_DESC, 4, true, 1);
        this.fOptimizedIncrementalLoadButton = this.fToolkit.createButton(loadMethodRadioGroup, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_OPTIMIZED_INCREMENTAL_LOAD_LABEL, 16);
        layoutData = new TableWrapData(2, 32, 1, 4);
        this.fOptimizedIncrementalLoadButton.setLayoutData((Object)layoutData);
        this.fOptimizedIncrementalLoadButton.setSelection(Boolean.valueOf(deleteBeforeFetch) == false && loadMethod != null && loadMethod.trim().length() != 0 && "optimizedIncrementalLoad".equals(loadMethod));
        this.fOptimizedIncrementalLoadButton.addSelectionListener(this.getLoadMethodSelectionListener());
        this.createInfoLabel(loadMethodRadioGroup, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_OPTIMIZED_INCREMENTAL_LOAD_DESC, 4, true, 1);
        String loadPolicy = this.fWorkingCopy.getPropertyValue("team.scm.loadPolicy", "");
        boolean bl = this.fDisplayLoadPolicy = this.fWorkingCopy.isNewItem() && !this.isBuildDefinitionCreatedUsingTemplate() || loadPolicy != null && loadPolicy.trim().length() != 0 || this.isAddedThroughEditConfiguration();
        if (this.fDisplayLoadPolicy) {
            this.createSpacer(composite, 10, 4);
            Label label = this.fToolkit.createLabel(composite, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_LOAD_POLICY_LABEL, 0);
            layoutData = new TableWrapData(2, 32, 1, 4);
            label.setLayoutData((Object)layoutData);
            this.createIntroLabel(composite, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_LOAD_POLICY_DESC, 4, false, -1);
            this.fSpecifyComponentsToLoadButton = this.fToolkit.createButton(composite, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_SPECIFY_COMPONENTS_TO_LOAD_DESC, 16);
            layoutData = new TableWrapData(2, 32, 1, 4);
            this.fSpecifyComponentsToLoadButton.setLayoutData((Object)layoutData);
            this.fSpecifyComponentsToLoadButton.setSelection(loadPolicy == null || loadPolicy.trim().length() == 0 || loadPolicy.equals("useComponentLoadConfig"));
            this.fSpecifyComponentsToLoadButton.addSelectionListener(this.getSpecifyComponentsToLoadListener());
        }
        if (!this.fDisplayLoadPolicy) {
            this.createSpacer(composite, 10, 4);
        }
        String createFoldersForComponents = this.fWorkingCopy.getPropertyValue("team.scm.createFoldersForComponents", "false");
        this.fCreateFoldersForComponentsButton = this.fToolkit.createButton(composite, NLS.bind((String)BuildDefinitionEditorMessages.JazzScmConfigurationEditor_CREATE_FOLDERS_FOR_COMPONENTS_DESC, (Object)"team.scm.createFoldersForComponents", (Object[])new Object[0]), 32);
        layoutData = new TableWrapData(2, 32, 1, 4);
        if (this.fDisplayLoadPolicy) {
            layoutData.indent = LayoutConstants.getMargins().x * 2;
        }
        this.fCreateFoldersForComponentsButton.setLayoutData((Object)layoutData);
        this.fCreateFoldersForComponentsButton.setSelection(Boolean.valueOf(createFoldersForComponents).booleanValue());
        this.fCreateFoldersForComponentsButton.addSelectionListener(this.getCreateFoldersForComponentsSelectionListener());
        this.fCreateFoldersForComponentsButton.setEnabled(!this.fDisplayLoadPolicy || this.fSpecifyComponentsToLoadButton.getSelection());
        this.createInfoLabel(composite, NLS.bind((String)BuildDefinitionEditorMessages.JazzScmConfigurationEditor_CREATE_FOLDERS_FOR_COMPONENTS_PROPERTY, (Object)"team.scm.createFoldersForComponents", (Object[])new Object[0]), 4, this.fDisplayLoadPolicy, 2);
        if (this.fDisplayLoadPolicy) {
            String componentLoadConfig = this.fWorkingCopy.getPropertyValue("team.scm.componentLoadConfig", "");
            Label label = this.fToolkit.createLabel(composite, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_COMPONENTS_TO_LOAD_LABEL, 0);
            layoutData = new TableWrapData(2, 32, 1, 4);
            layoutData.indent = LayoutConstants.getMargins().x * 2;
            label.setLayoutData((Object)layoutData);
            this.fComponentsToLoadRadioGroup = this.fToolkit.createComposite(composite);
            TableWrapLayout layout = new TableWrapLayout();
            layout.numColumns = 4;
            this.fComponentsToLoadRadioGroup.setLayout((Layout)layout);
            layoutData = new TableWrapData(256, 256, 1, 4);
            layoutData.indent = LayoutConstants.getMargins().x * 2;
            this.fComponentsToLoadRadioGroup.setLayoutData((Object)layoutData);
            this.fLoadAllComponentsButton = this.fToolkit.createButton(this.fComponentsToLoadRadioGroup, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_LOAD_ALL_COMPONENTS_DESC, 16);
            layoutData = new TableWrapData(2, 32, 1, 4);
            this.fLoadAllComponentsButton.setLayoutData((Object)layoutData);
            this.fLoadAllComponentsButton.setSelection(componentLoadConfig == null || componentLoadConfig.trim().length() == 0 || componentLoadConfig.equals("loadAllComponents"));
            this.fLoadAllComponentsButton.setEnabled(this.fSpecifyComponentsToLoadButton.getSelection());
            this.fLoadAllComponentsButton.addSelectionListener(this.getLoadAllComponentsSelectionListener());
            this.fExcludeSomeComponentsButton = this.fToolkit.createButton(this.fComponentsToLoadRadioGroup, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_EXCLUDE_SOME_COMPONENTS_DESC, 16);
            layoutData = new TableWrapData(2, 32, 1, 4);
            this.fExcludeSomeComponentsButton.setLayoutData((Object)layoutData);
            this.fExcludeSomeComponentsButton.setSelection("excludeSomeComponents".equals(componentLoadConfig));
            this.fExcludeSomeComponentsButton.setEnabled(this.fSpecifyComponentsToLoadButton.getSelection());
            this.fExcludeSomeComponentsButton.addSelectionListener(this.getExcludeSomeComponentsSelectionListener());
        }
        String loadComponentsValue = this.fWorkingCopy.getPropertyValue("team.scm.loadComponents", "");
        this.setLoadComponents(new LoadComponents(this.getTeamRepository(), loadComponentsValue));
        if (!this.fDisplayLoadPolicy) {
            this.createSpacer(composite, 10, 4);
        }
        this.createIntroLabel(composite, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_LOAD_COMPONENTS_DESC, 4, this.fDisplayLoadPolicy, 4);
        this.createLabel(composite, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_LOAD_COMPONENTS_LABEL, this.fDisplayLoadPolicy, 4);
        this.fLoadComponentsText = this.fToolkit.createText(composite, loadComponentsValue, 0);
        this.fLoadComponentsText.setEnabled(false);
        this.fLoadComponentsText.setEditable(false);
        layoutData = new TableWrapData(256, 32);
        layoutData.maxWidth = 200;
        this.fLoadComponentsText.setLayoutData((Object)layoutData);
        this.fSelectLoadComponentsButton = this.fToolkit.createButton(composite, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_SELECT_LOAD_COMPONENTS_BUTTON_TITLE, 0);
        this.fSelectLoadComponentsButton.addSelectionListener(this.getSelectLoadComponentsListener());
        this.fSelectLoadComponentsButton.setEnabled(this.getBuildWorkspace() != null && (!this.fDisplayLoadPolicy || this.fSpecifyComponentsToLoadButton.getSelection() && this.fExcludeSomeComponentsButton.getSelection()));
        this.fClearLoadComponentsButton = this.fToolkit.createButton(composite, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_CLEAR_LOAD_COMPONENTS_BUTTON, 0);
        this.fClearLoadComponentsButton.addSelectionListener(this.getClearLoadComponentsListener());
        this.updateLoadComponents();
        this.createInfoLabel(composite, NLS.bind((String)BuildDefinitionEditorMessages.JazzScmConfigurationEditor_LOAD_COMPONENTS_PROPERTY, (Object)"team.scm.loadComponents", (Object[])new Object[0]), 4, this.fDisplayLoadPolicy, 4);
        if (this.fDisplayLoadPolicy) {
            this.fUseLoadRulesButton = this.fToolkit.createButton(composite, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_USE_LOAD_RULES_DESC, 16);
            layoutData = new TableWrapData(2, 32, 1, 4);
            this.fUseLoadRulesButton.setLayoutData((Object)layoutData);
            this.fUseLoadRulesButton.setSelection("useLoadRules".equals(loadPolicy));
            this.fUseLoadRulesButton.addSelectionListener(this.getUseLoadRulesSelectionListener());
        }
        if (!this.fDisplayLoadPolicy) {
            this.createSpacer(composite, 10, 4);
        }
        String componentLoadRulesValue = this.fWorkingCopy.getPropertyValue("team.scm.componentLoadRules", "");
        this.fComponentLoadRules = new ComponentLoadRules(componentLoadRulesValue);
        this.createIntroLabel(composite, this.fDisplayLoadPolicy ? BuildDefinitionEditorMessages.JazzScmConfigurationEditor_LOAD_RULE_FILE_DESC : BuildDefinitionEditorMessages.JazzScmConfigurationEditor_LOAD_RULES_DESC, 4, this.fDisplayLoadPolicy, 2);
        this.createLabel(composite, this.fDisplayLoadPolicy ? BuildDefinitionEditorMessages.JazzScmConfigurationEditor_LOAD_RULE_FILE_LABEL : BuildDefinitionEditorMessages.JazzScmConfigurationEditor_LOAD_RULES_LABEL, this.fDisplayLoadPolicy, 2);
        this.fComponentLoadRulesText = this.fToolkit.createText(composite, componentLoadRulesValue, 0);
        this.fComponentLoadRulesText.setEnabled(false);
        this.fComponentLoadRulesText.setEditable(false);
        layoutData = new TableWrapData(256, 32);
        layoutData.maxWidth = 200;
        if (this.fDisplayLoadPolicy) {
            layoutData.indent = LayoutConstants.getMargins().x * 2;
        }
        this.fComponentLoadRulesText.setLayoutData((Object)layoutData);
        this.fSelectComponentLoadRulesButton = this.fToolkit.createButton(composite, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_SELECT_LOAD_RULES_BUTTON_TITLE, 0);
        this.fSelectComponentLoadRulesButton.addSelectionListener(this.getSelectComponentLoadRulesListener());
        this.fSelectComponentLoadRulesButton.setEnabled(this.getBuildWorkspace() != null && (!this.fDisplayLoadPolicy || this.fUseLoadRulesButton.getSelection()));
        this.fClearComponentLoadRulesButton = this.fToolkit.createButton(composite, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_CLEAR_LOAD_RULES_BUTTON, 0);
        this.fClearComponentLoadRulesButton.addSelectionListener(this.getClearComponentLoadRulesListener());
        this.updateComponentLoadRules(this.fComponentLoadRules);
        this.createInfoLabel(composite, NLS.bind((String)(this.fDisplayLoadPolicy ? BuildDefinitionEditorMessages.JazzScmConfigurationEditor_LOAD_RULE_FILE_PROPERTY : BuildDefinitionEditorMessages.JazzScmConfigurationEditor_LOAD_RULES_PROPERTY), (Object)"team.scm.componentLoadRules", (Object[])new Object[0]), 4, this.fDisplayLoadPolicy, 2);
        if (!this.fDisplayLoadPolicy) {
            this.createSpacer(composite, 10, 4);
            this.fSwitchToNewFormatButton = this.fToolkit.createButton(composite, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_SWITCH_TO_NEW_FORMAT_DESC, 32);
            layoutData = new TableWrapData(2, 32, 1, 4);
            this.fSwitchToNewFormatButton.setLayoutData((Object)layoutData);
            this.fSwitchToNewFormatButton.setSelection(false);
            this.fSwitchToNewFormatButton.addSelectionListener(this.getSwitchToNewFormatSelectionListener());
            this.fSwitchToNewFormatButton.setEnabled(true);
            this.createInfoLabel(composite, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_SWITCH_TO_NEW_FORMAT_DETAILED_DESC, 4, false, -1);
        }
        if (this.fWorkingCopy.isNewItem() && !this.isBuildDefinitionCreatedUsingTemplate() || this.isAddedThroughEditConfiguration()) {
            this.updateLoadPolicyAndComponentLoadConfig();
        }
        this.createJobToVerifyComponentsToExclude();
        if (this.fDisplayLoadPolicy) {
            this.createJobToVerifyLoadRules();
        }
    }

    private boolean isLoadMethodValidWhenNotDoingFullLoad(String loadMethod) {
        switch (loadMethod) {
            case "incrementalLoad": 
            case "optimizedIncrementalLoad": {
                return true;
            }
        }
        return false;
    }

    private boolean shouldEnableCreateFoldersForComponentsButton() {
        return !this.fDisplayLoadPolicy || this.fSpecifyComponentsToLoadButton.getSelection();
    }

    private boolean shouldEnableSelectLoadComponentsButton(IWorkspace workspace) {
        return workspace != null && (!this.fDisplayLoadPolicy || this.fSpecifyComponentsToLoadButton.getSelection() && this.fExcludeSomeComponentsButton.getSelection());
    }

    private boolean shouldEnableSelectComponentLoadRulesButton(IWorkspace workspace) {
        return workspace != null && (!this.fDisplayLoadPolicy || this.fUseLoadRulesButton.getSelection());
    }

    private boolean shouldEnableExcludeSomeComponentsButton() {
        return this.fSpecifyComponentsToLoadButton.getSelection();
    }

    private void createJobToVerifyComponentsToExclude() {
        final LoadComponents componentsToExclude = this.getLoadComponents();
        if (componentsToExclude != null && componentsToExclude.getComponentHandles().size() > 0) {
            TeamBuildJob verifyingComponentsToExcludeJob = new TeamBuildJob(BuildDefinitionEditorMessages.JazzScmConfigurationEditor_VERIFY_COMPONENTS_TO_EXCLUDE_JOB_NAME, false, this.getTeamRepository()){

                protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                    ITeamRepository repo = JazzScmConfigurationEditor.this.getTeamRepository();
                    IWorkspace buildWorkspace = JazzScmConfigurationEditor.this.getBuildWorkspace();
                    if (repo != null && buildWorkspace != null) {
                        JazzScmConfigurationEditor.this.verifyComponentsToExcludeList(repo, buildWorkspace, componentsToExclude.getComponentHandles(), monitor);
                    }
                    return Status.OK_STATUS;
                }
            };
            verifyingComponentsToExcludeJob.schedule();
        } else {
            this.setWarningMissingComponentInComponentsToExclude(false);
        }
    }

    protected void verifyComponentsToExcludeList(ITeamRepository repo, IWorkspace workspace, Collection<IComponentHandle> currentComponentsToExcludeList, IProgressMonitor progress) {
        boolean missingComponents = false;
        if (currentComponentsToExcludeList != null && currentComponentsToExcludeList.size() > 0) {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
            try {
                IWorkspaceConnection connection = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnection((IWorkspaceHandle)workspace, (IProgressMonitor)monitor.newChild(10));
                for (IComponentHandle componentHandle : currentComponentsToExcludeList) {
                    try {
                        connection.getComponentInfo(componentHandle);
                    }
                    catch (ComponentNotInWorkspaceException exception) {
                        missingComponents = true;
                        break;
                    }
                }
            }
            catch (TeamRepositoryException e) {
                BuildUIPlugin.log(e);
            }
        }
        this.setWarningMissingComponentInComponentsToExclude(missingComponents);
        this.handleUpdateToMissingComponentInComponentsToExcludeList();
    }

    private void handleUpdateToMissingComponentInComponentsToExcludeList() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!JazzScmConfigurationEditor.this.fLoadComponentsText.isDisposed()) {
                    JazzScmConfigurationEditor.this.validate();
                }
            }
        });
    }

    private void createJobToVerifyLoadRules() {
        final ComponentLoadRules componentLoadRules = this.fComponentLoadRules;
        if (componentLoadRules != null && componentLoadRules.getLoadRuleFiles().values().size() == 1) {
            TeamBuildJob verifyLoadRulesJob = new TeamBuildJob(BuildDefinitionEditorMessages.JazzScmConfigurationEditor_VERIFY_LOAD_RULES_JOB_NAME, false, this.getTeamRepository()){

                protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                    JazzScmConfigurationEditor.this.verifyLoadRulesFormat(JazzScmConfigurationEditor.this.getTeamRepository(), JazzScmConfigurationEditor.this.getBuildWorkspace(), componentLoadRules, monitor);
                    return Status.OK_STATUS;
                }
            };
            verifyLoadRulesJob.schedule();
        } else {
            this.setErrorLoadRulesNotInXMLFormat(false);
        }
    }

    protected void verifyLoadRulesFormat(ITeamRepository repo, IWorkspace workspace, ComponentLoadRules currentComponentLoadRules, IProgressMonitor progress) {
        boolean isLoadRulesNotInXMLFormat = false;
        if (workspace != null && currentComponentLoadRules != null && currentComponentLoadRules.getLoadRuleFiles().values().size() > 0) {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
            try {
                IWorkspaceConnection connection = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnection((IWorkspaceHandle)workspace, (IProgressMonitor)monitor.newChild(10));
                isLoadRulesNotInXMLFormat = !currentComponentLoadRules.isLoadRulesInXMLFormat(connection, (IProgressMonitor)monitor);
            }
            catch (Exception e) {
                BuildUIPlugin.log(e);
            }
        }
        this.setErrorLoadRulesNotInXMLFormat(isLoadRulesNotInXMLFormat);
        this.handleUpdateToLoadRulesNotInXMLFormat();
    }

    private void handleUpdateToLoadRulesNotInXMLFormat() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!JazzScmConfigurationEditor.this.fComponentLoadRulesText.isDisposed()) {
                    JazzScmConfigurationEditor.this.validate();
                }
            }
        });
    }

    protected void createJobToValidateBuildWorkspace() {
        if (this.fWorkspaceNameText.getText().trim().length() != 0) {
            String validateBuildWorkspaceJobName = BuildDefinitionEditorMessages.JazzScmConfigurationEditor_VALIDATE_BUILD_WORKSPACE_JOB_NAME;
            TeamBuildJob validateBuildWorkspaceJob = new TeamBuildJob(validateBuildWorkspaceJobName, true, this.getTeamRepository()){

                protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                    JazzScmConfigurationEditor.this.checkBuildWorkspace(JazzScmConfigurationEditor.this.getBuildWorkspace(), monitor);
                    JazzScmConfigurationEditor.this.forceWorkspaceNameWarningUpdate();
                    return Status.OK_STATUS;
                }
            };
            validateBuildWorkspaceJob.schedule();
        } else {
            this.setBuildDefinitionWithSameBuildWorkspace(null);
            this.setWorkspacePrivateComponentCount(0);
        }
    }

    protected void checkComponentVisibility(IWorkspace buildWorkspace, IProgressMonitor monitor) {
        if (buildWorkspace != null) {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            int privateComponentCount = 0;
            IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)this.getTeamRepository());
            try {
                try {
                    IWorkspaceConnection workspaceConnection = workspaceManager.getWorkspaceConnection((IWorkspaceHandle)buildWorkspace, (IProgressMonitor)subMonitor.newChild(10));
                    List components = workspaceConnection.getComponents();
                    if (!components.isEmpty()) {
                        List readScopes = workspaceManager.findReadScopeForComponents(components, (IProgressMonitor)subMonitor.newChild(90));
                        for (IReadScope readScope : readScopes) {
                            if (!(readScope instanceof IPrivateScope)) continue;
                            ++privateComponentCount;
                        }
                    }
                }
                catch (TeamRepositoryException exception) {
                    BuildUIPlugin.log(exception);
                    this.setWorkspacePrivateComponentCount(privateComponentCount);
                }
            }
            finally {
                this.setWorkspacePrivateComponentCount(privateComponentCount);
            }
        }
    }

    protected void fetchBuildDefinitionWithSameBuildWorkspace(IWorkspace buildWorkspace, IProgressMonitor monitor) {
        if (buildWorkspace != null) {
            String buildDefinitionIDWithSameBuildWorkspace = null;
            this.setBuildDefinitionWithSameBuildWorkspace(null);
            try {
                ITeamBuildClient buildClient = ClientFactory.getTeamBuildClient((ITeamRepository)this.getTeamRepository());
                IItemManager itemManager = this.getTeamRepository().itemManager();
                BaseBuildDefinitionQueryModel.BuildDefinitionQueryModel buildDefQueryModel = BaseBuildDefinitionQueryModel.BuildDefinitionQueryModel.ROOT;
                IItemQuery itemQuery = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)buildDefQueryModel);
                itemQuery.filter(buildDefQueryModel.configurationElements().elementId()._eq("com.ibm.team.build.jazzscm"));
                ItemQueryIterator iter = new ItemQueryIterator(buildClient, itemQuery, IQueryService.EMPTY_PARAMETERS);
                block2: while (buildDefinitionIDWithSameBuildWorkspace == null && iter.hasNext(monitor)) {
                    List definitionHandles = iter.next(512, monitor);
                    ArrayList<String> properties = new ArrayList<String>();
                    properties.add(IBuildDefinition.PROPERTY_ID);
                    properties.add(IBuildDefinition.PROPERTY_PROPERTIES);
                    List items = itemManager.fetchPartialItems(definitionHandles, 1, properties, monitor);
                    for (IBuildDefinition item : items) {
                        IBuildProperty otherWorkspaceProperty;
                        if (item == null || (otherWorkspaceProperty = item.getProperty("team.scm.workspaceUUID")) == null || !buildWorkspace.getItemId().getUuidValue().equals(otherWorkspaceProperty.getValue()) || item.sameItemId((IItemHandle)this.fWorkingCopy)) continue;
                        buildDefinitionIDWithSameBuildWorkspace = item.getId();
                        continue block2;
                    }
                }
                this.setBuildDefinitionWithSameBuildWorkspace(buildDefinitionIDWithSameBuildWorkspace);
                if (buildDefinitionIDWithSameBuildWorkspace != null) {
                    this.handleUpdatesToShowDuplicateWorkspaceWarningDialog();
                }
            }
            catch (TeamRepositoryException exception) {
                BuildUIPlugin.log(exception);
            }
        }
    }

    protected void forceWorkspaceNameWarningUpdate() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!JazzScmConfigurationEditor.this.fWorkspaceNameText.isDisposed()) {
                    JazzScmConfigurationEditor.this.validate();
                }
            }
        });
    }

    private void createAcceptOptionsWidgets(Composite parent) {
        Section section = this.createSection(parent, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_SECTION_TEXT_ACCEPT, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_SECTION_DESC_ACCEPT, true);
        Composite composite = (Composite)section.getClient();
        String acceptBeforeFetch = this.fWorkingCopy.getPropertyValue("team.scm.acceptBeforeFetch", "false");
        this.fAcceptBeforeFetchButton = this.fToolkit.createButton(composite, NLS.bind((String)BuildDefinitionEditorMessages.JazzScmConfigurationEditor_ACCEPT_DESC, (Object)"team.scm.acceptBeforeFetch", (Object[])new Object[0]), 32);
        TableWrapData layoutData = new TableWrapData(2, 32, 1, 2);
        this.fAcceptBeforeFetchButton.setLayoutData((Object)layoutData);
        this.fAcceptBeforeFetchButton.setSelection(Boolean.valueOf(acceptBeforeFetch).booleanValue());
        this.fAcceptBeforeFetchButton.addSelectionListener(this.getAcceptBeforeFetchSelectionListener());
        String buildOnlyIfChanges = this.fWorkingCopy.getPropertyValue("team.scm.buildOnlyIfChanges", "false");
        this.fBuildOnlyIfChangesButton = this.fToolkit.createButton(composite, NLS.bind((String)BuildDefinitionEditorMessages.JazzScmConfigurationEditor_CHANGES_DESC, (Object)"team.scm.buildOnlyIfChanges", (Object[])new Object[0]), 32);
        layoutData = new TableWrapData(2, 32, 1, 2);
        this.fBuildOnlyIfChangesButton.setLayoutData((Object)layoutData);
        this.fBuildOnlyIfChangesButton.setSelection(Boolean.valueOf(buildOnlyIfChanges).booleanValue());
        this.fBuildOnlyIfChangesButton.addSelectionListener(this.getBuildOnlyIfChangesSelectionListener());
        this.fBuildOnlyIfChangesButton.setEnabled(this.fAcceptBeforeFetchButton.getSelection());
        String includeLinkInWorkItems = this.fWorkingCopy.getPropertyValue("team.build.createWorkItemIncludeLinks", "true");
        this.fIncludeLinkInWorkItemsCheckbox = this.fToolkit.createButton(composite, NLS.bind((String)BuildDefinitionEditorMessages.JazzScmConfigurationEditor_INCLUDE_IN_WORKITEMS_DESC, (Object)"team.build.createWorkItemIncludeLinks", (Object[])new Object[0]), 32);
        layoutData = new TableWrapData(2, 32, 1, 2);
        this.fIncludeLinkInWorkItemsCheckbox.setLayoutData((Object)layoutData);
        this.fIncludeLinkInWorkItemsCheckbox.setSelection(Boolean.valueOf(includeLinkInWorkItems).booleanValue());
        this.fIncludeLinkInWorkItemsCheckbox.addSelectionListener(this.getIncludeLinkInWorkItemsSelectionListener());
        this.createInfoLabel(composite, NLS.bind((String)BuildDefinitionEditorMessages.JazzScmConfigurationEditor_ACCEPT_PROPERTY, (Object[])new Object[]{"team.scm.acceptBeforeFetch", "team.scm.buildOnlyIfChanges", "team.build.createWorkItemIncludeLinks", "team.scm.snapshotUUID", "team.scm.changesAccepted"}, (Object[])new Object[0]), 2, false, -1);
    }

    protected IHyperlinkListener getWorkspaceHyperlinkListener() {
        return new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                JazzScmConfigurationEditor.this.openWorkspaceEditor();
            }
        };
    }

    protected void openWorkspaceEditor() {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            TeamPlacePart2.open((IWorkbenchPage)page, (TeamPlaceEditorInput)TeamPlaceEditorInput.newForEdit((AbstractPlaceWrapper)AbstractPlaceWrapper.newWrapper((IWorkspace)this.getBuildWorkspace())));
        }
    }

    protected IWorkspace fetchWorkspace(IWorkspaceHandle workspaceHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return (IWorkspace)this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)workspaceHandle, 0, monitor);
    }

    protected void handleUpdateWorkspaceText(final String workspaceName) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!JazzScmConfigurationEditor.this.fWorkspaceNameText.isDisposed()) {
                    JazzScmConfigurationEditor.this.setWorkspaceNameText(workspaceName, true);
                }
            }
        });
    }

    private void handleUpdateComponentLoadRulesButton(final IWorkspace workspace) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (JazzScmConfigurationEditor.this.fSelectComponentLoadRulesButton != null && !JazzScmConfigurationEditor.this.fSelectComponentLoadRulesButton.isDisposed()) {
                    JazzScmConfigurationEditor.this.fSelectComponentLoadRulesButton.setEnabled(JazzScmConfigurationEditor.this.shouldEnableSelectComponentLoadRulesButton(workspace));
                }
            }
        });
    }

    private void handleUpdateLoadComponentsButton(final IWorkspace workspace) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (JazzScmConfigurationEditor.this.fSelectLoadComponentsButton != null && !JazzScmConfigurationEditor.this.fSelectLoadComponentsButton.isDisposed()) {
                    JazzScmConfigurationEditor.this.fSelectLoadComponentsButton.setEnabled(JazzScmConfigurationEditor.this.shouldEnableSelectLoadComponentsButton(workspace));
                }
            }
        });
    }

    @Override
    public boolean validate() {
        boolean isValid = true;
        boolean isWarning = false;
        if (this.fWorkspaceNameText.getText().trim().length() == 0) {
            this.addErrorMessageForRequiredField(this.fWorkspaceNameText, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_WORKSPACE_REQUIRED, (Control)this.fWorkspaceNameText);
            isValid = false;
        } else if (this.getBuildDefinitionWithSameBuildWorkspace() != null) {
            isWarning = true;
            this.addWarningMessage(this.fWorkspaceNameText, NLS.bind((String)BuildDefinitionEditorMessages.JazzScmConfigurationEditor_SAME_WORKSPACE_ACROSS_MULTIPLE_DEFINITIONS, (Object)this.getBuildDefinitionWithSameBuildWorkspace(), (Object[])new Object[0]), (Control)this.fWorkspaceNameText);
        } else if (this.getWarningWorkspaceIsStream()) {
            isWarning = true;
            this.addWarningMessage(this.fWorkspaceNameText, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_WARNING_WORKSPACE_IS_STREAM, (Control)this.fWorkspaceNameText);
        } else if (this.getWorkspacePrivateComponentCount() > 0) {
            isWarning = true;
            this.addWarningMessage(this.fWorkspaceNameText, NLS.bind((String)BuildDefinitionEditorMessages.JazzScmConfigurationEditor_WARNING_PRIVATE_COMPONENTS, (Object)this.getWorkspacePrivateComponentCount(), (Object[])new Object[0]), (Control)this.fWorkspaceNameText);
        } else {
            this.removeMessage(this.fWorkspaceNameText, (Control)this.fWorkspaceNameText);
        }
        if (this.fAcceptBeforeFetchButton.getSelection() && this.getWarningWorkspaceIsStream()) {
            this.addErrorMessage((Object)this.fAcceptBeforeFetchButton, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_ERROR_ACCEPT_AND_STREAM_SELECTED, (Control)this.fAcceptBeforeFetchButton);
            isValid = false;
        } else {
            this.removeMessage(this.fAcceptBeforeFetchButton, (Control)this.fAcceptBeforeFetchButton);
        }
        if (this.fFetchDestinationText.getText().trim().length() == 0) {
            this.addErrorMessageForRequiredField(this.fFetchDestinationText, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_LOAD_DIRECTORY_REQUIRED, (Control)this.fFetchDestinationText);
            isValid = false;
        } else {
            this.removeMessage(this.fFetchDestinationText, (Control)this.fFetchDestinationText);
        }
        if (!this.fDisplayLoadPolicy) {
            Collection referencedExcludedComponents = this.getLoadComponents().getIntersectingComponents(this.fComponentLoadRules.getLoadRuleFiles().keySet());
            if (!referencedExcludedComponents.isEmpty()) {
                String message = referencedExcludedComponents.size() == 1 ? NLS.bind((String)BuildDefinitionEditorMessages.JazzScmConfigurationEditor_EXCLUDED_COMPONENTS_REFERENCED, (Object)referencedExcludedComponents.size(), (Object[])new Object[0]) : NLS.bind((String)BuildDefinitionEditorMessages.JazzScmConfigurationEditor_EXCLUDED_COMPONENTS_REFERENCED_MULTI, (Object)referencedExcludedComponents.size(), (Object[])new Object[0]);
                this.addWarningMessage(this.fComponentLoadRulesText, message, (Control)this.fComponentLoadRulesText);
            } else {
                this.removeMessage(this.fComponentLoadRulesText, (Control)this.fComponentLoadRulesText);
            }
        } else if (this.fUseLoadRulesButton.getSelection() && this.fComponentLoadRules.getLoadRuleFiles().values().size() > 1) {
            this.addErrorMessage((Object)this.fComponentLoadRulesText, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_ERROR_MULTIPLE_LOAD_RULE_FILE, (Control)this.fComponentLoadRulesText);
            isValid = false;
        } else if (this.fUseLoadRulesButton.getSelection() && this.fComponentLoadRules.getLoadRuleFiles().values().size() == 0) {
            this.addErrorMessageForRequiredField(this.fComponentLoadRulesText, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_ERROR_SPECIFY_LOAD_RULE_FILE, (Control)this.fComponentLoadRulesText);
            isValid = false;
        } else if (this.fUseLoadRulesButton.getSelection() && this.getErrorLoadRulesNotInXMLFormat()) {
            this.addErrorMessage((Object)this.fComponentLoadRulesText, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_ERROR_LOAD_RULES_NOT_XML, (Control)this.fComponentLoadRulesText);
            isValid = false;
        } else {
            this.removeMessage(this.fComponentLoadRulesText, (Control)this.fComponentLoadRulesText);
        }
        if (this.getWarningMissingComponentInComponentsToExclude() && (!this.fDisplayLoadPolicy || this.fSpecifyComponentsToLoadButton.getSelection() && this.fExcludeSomeComponentsButton.getSelection())) {
            isWarning = true;
            this.addWarningMessage(this.fLoadComponentsText, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_WARNING_MISSING_COMPONENT_IN_COMPONENTS_TO_EXCLUDE, (Control)this.fLoadComponentsText);
        } else {
            this.removeMessage(this.fLoadComponentsText, (Control)this.fLoadComponentsText);
        }
        this.setPageStatusIndicator(!isValid, isWarning);
        return isValid;
    }

    private ModifyListener getFetchDestinationModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JazzScmConfigurationEditor.this.validate();
                String destination = JazzScmConfigurationEditor.this.fFetchDestinationText.getText().trim();
                JazzScmConfigurationEditor.this.fWorkingCopy.setProperty("team.scm.fetchDestination", destination);
                JazzScmConfigurationEditor.this.setDirty(true);
            }
        };
    }

    protected SelectionListener getSelectWorkspaceListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IWorkspace workspace = JazzScmConfigurationEditor.this.openWorkspaceChooserDialog(JazzScmConfigurationEditor.this.fWorkspaceTitleHyperlink.getShell(), JazzScmConfigurationEditor.this.getTeamRepository());
                if (workspace != null && (!workspace.isStream() || JazzScmConfigurationEditor.this.confirmStreamSelection())) {
                    JazzScmConfigurationEditor.this.setWorkspace(workspace);
                }
            }
        };
    }

    protected boolean confirmStreamSelection() {
        return MessageDialog.openQuestion((Shell)this.fWorkspaceTitleHyperlink.getShell(), (String)BuildDefinitionEditorMessages.JazzScmConfigurationEditor_CONFIRM_STREAM_SELECTION_DIALOG_TITLE, (String)BuildDefinitionEditorMessages.JazzScmConfigurationEditor_CONFIRM_STREAM_SELECTION_DIALOG_DESCRIPTION);
    }

    protected SelectionListener getCreateWorkspaceListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JazzScmConfigurationEditor.this.openWorkspaceCreationDialog();
            }
        };
    }

    protected SelectionListener getClearComponentLoadRulesListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IBuildProperty property;
                if (JazzScmConfigurationEditor.this.confirmClearComponentLoadRules() && (property = JazzScmConfigurationEditor.this.fWorkingCopy.getProperty("team.scm.componentLoadRules")) != null) {
                    property.setValue("");
                    JazzScmConfigurationEditor.this.fComponentLoadRules = new ComponentLoadRules("");
                    JazzScmConfigurationEditor.this.updateComponentLoadRules(JazzScmConfigurationEditor.this.fComponentLoadRules);
                    JazzScmConfigurationEditor.this.validate();
                    JazzScmConfigurationEditor.this.setDirty(true);
                }
            }
        };
    }

    protected boolean confirmClearComponentLoadRules() {
        return MessageDialog.openConfirm((Shell)this.fClearComponentLoadRulesButton.getShell(), (String)BuildDefinitionEditorMessages.JazzScmConfigurationEditor_CLEAR_LOAD_RULES_CONFIRM_TITLE, (String)BuildDefinitionEditorMessages.JazzScmConfigurationEditor_CLEAR_LOAD_RULES_CONFIRM_TEXT);
    }

    protected SelectionListener getSelectComponentLoadRulesListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Map initialSelection = JazzScmConfigurationEditor.this.fComponentLoadRules != null ? JazzScmConfigurationEditor.this.fComponentLoadRules.getLoadRuleFiles() : Collections.EMPTY_MAP;
                Map<IComponentHandle, IFileItemHandle> componentLoadRuleFiles = JazzScmConfigurationEditor.this.openComponentLoadRulesSelector(initialSelection);
                JazzScmConfigurationEditor.this.setComponentLoadRules(componentLoadRuleFiles);
            }
        };
    }

    protected Map<IComponentHandle, IFileItemHandle> openComponentLoadRulesSelector(Map<IComponentHandle, IFileItemHandle> initialSelection) {
        HashMap<IComponentHandle, IFileItemHandle> componentLoadRuleFiles = null;
        if (this.fDisplayLoadPolicy) {
            SiloedItemId siloedItem;
            RepositoryFilesPickerOutput pickerOutput = FileSelectionDialog.pickFile((Shell)this.fWorkspaceTitleHyperlink.getShell(), (ITeamRepository)this.getTeamRepository(), (IWorkspace)this.getBuildWorkspace(), (String)BuildDefinitionEditorMessages.JazzScmConfigurationEditor_PICK_LOAD_RULE_FILE_DIALOG_DESCRIPTION, initialSelection, (boolean)false);
            if (pickerOutput != null && pickerOutput.getItemIds() != null && pickerOutput.getItemIds().size() > 0 && (siloedItem = (SiloedItemId)pickerOutput.getItemIds().iterator().next()).toHandle() instanceof IFileItemHandle) {
                componentLoadRuleFiles = new HashMap<IComponentHandle, IFileItemHandle>(1);
                componentLoadRuleFiles.put(siloedItem.getComponentHandle(), (IFileItemHandle)siloedItem.toHandle());
            }
        } else {
            componentLoadRuleFiles = FileSelectionDialog.pickFilePerComponent((Shell)this.fWorkspaceTitleHyperlink.getShell(), (ITeamRepository)this.getTeamRepository(), (IWorkspace)this.getBuildWorkspace(), (String)BuildDefinitionEditorMessages.JazzScmConfigurationEditor_PICK_LOAD_RULES_DIALOG_DESCRIPTION, initialSelection);
        }
        return componentLoadRuleFiles;
    }

    protected void setComponentLoadRules(Map<IComponentHandle, IFileItemHandle> componentLoadRuleFiles) {
        if (componentLoadRuleFiles != null) {
            this.fComponentLoadRules = new ComponentLoadRules(componentLoadRuleFiles);
            String componentLoadRulesProperty = this.fComponentLoadRules.getBuildPropertySetting();
            this.fWorkingCopy.setProperty("team.scm.componentLoadRules", componentLoadRulesProperty);
            this.updateComponentLoadRules(this.fComponentLoadRules);
            this.validate();
            this.setDirty(true);
            if (this.fDisplayLoadPolicy) {
                this.createJobToVerifyLoadRules();
            }
        }
    }

    protected void updateComponentLoadRules(ComponentLoadRules rules) {
        int numLoadRules = this.fComponentLoadRules.getLoadRuleFiles().values().size();
        if (numLoadRules == 0) {
            this.setErrorLoadRulesNotInXMLFormat(false);
            this.fComponentLoadRulesText.setText("");
        } else {
            String messageId = numLoadRules > 1 ? BuildDefinitionEditorMessages.JazzScmConfigurationEditor_NUMBER_OF_LOADRULE_FILES_TEXT_MULTI : BuildDefinitionEditorMessages.JazzScmConfigurationEditor_NUMBER_OF_LOADRULE_FILES_TEXT;
            this.fComponentLoadRulesText.setText(NLS.bind((String)messageId, (Object)numLoadRules, (Object[])new Object[0]));
        }
        this.fClearComponentLoadRulesButton.setEnabled(numLoadRules > 0 && (!this.fDisplayLoadPolicy || this.fUseLoadRulesButton.getSelection()));
    }

    protected SelectionListener getSelectLoadComponentsListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Collection<IComponentHandle> loadComponents;
                LoadComponents initialSelection = JazzScmConfigurationEditor.this.getLoadComponents();
                Collection initialHandleSelection = initialSelection == null ? Collections.EMPTY_LIST : initialSelection.getComponentHandles();
                if (initialHandleSelection != (loadComponents = JazzScmConfigurationEditor.this.openLoadComponentsSelector(initialHandleSelection))) {
                    JazzScmConfigurationEditor.this.setWarningMissingComponentInComponentsToExclude(false);
                    JazzScmConfigurationEditor.this.createNewLoadComponents(loadComponents);
                }
            }
        };
    }

    protected Collection<IComponentHandle> openLoadComponentsSelector(Collection<IComponentHandle> initialSelection) {
        try {
            Collection loadComponents = WorkspaceComponentSelectionDialog.pickWorkspaceComponents((Shell)this.fWorkspaceTitleHyperlink.getShell(), (ITeamRepository)this.getTeamRepository(), (IWorkspace)this.getBuildWorkspace(), (String)BuildDefinitionEditorMessages.JazzScmConfigurationEditor_PICK_LOAD_COMPONENTS_TITLE, (String)BuildDefinitionEditorMessages.JazzScmConfigurationEditor_PICK_LOAD_COMPONENTS, initialSelection, null);
            return loadComponents;
        }
        catch (TeamRepositoryException e) {
            BuildUIPlugin.log(e);
            return initialSelection;
        }
    }

    protected SelectionListener getClearLoadComponentsListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IBuildProperty property;
                if (JazzScmConfigurationEditor.this.confirmClearLoadComponents() && (property = JazzScmConfigurationEditor.this.fWorkingCopy.getProperty("team.scm.loadComponents")) != null) {
                    property.setValue("");
                    JazzScmConfigurationEditor.this.setLoadComponents(new LoadComponents((Collection)Collections.EMPTY_LIST));
                    JazzScmConfigurationEditor.this.updateLoadComponents();
                    JazzScmConfigurationEditor.this.validate();
                    JazzScmConfigurationEditor.this.setDirty(true);
                }
            }
        };
    }

    protected boolean confirmClearLoadComponents() {
        return MessageDialog.openConfirm((Shell)this.fClearComponentLoadRulesButton.getShell(), (String)BuildDefinitionEditorMessages.JazzScmConfigurationEditor_CLEAR_LOAD_COMPONENTS_CONFIRM_TITLE, (String)BuildDefinitionEditorMessages.JazzScmConfigurationEditor_CLEAR_LOAD_COMPONENTS_CONFIRM_TEXT);
    }

    protected void updateLoadComponents() {
        int numLoadComponents = this.getLoadComponents().getComponentHandles().size();
        if (numLoadComponents == 0) {
            this.setWarningMissingComponentInComponentsToExclude(false);
            this.fLoadComponentsText.setText("");
        } else {
            String messageId = numLoadComponents > 1 ? BuildDefinitionEditorMessages.JazzScmConfigurationEditor_NUMBER_OF_LOAD_COMPONENTS_TEXT_MULTI : BuildDefinitionEditorMessages.JazzScmConfigurationEditor_NUMBER_OF_LOAD_COMPONENTS_TEXT;
            this.fLoadComponentsText.setText(NLS.bind((String)messageId, (Object)numLoadComponents, (Object[])new Object[0]));
        }
        this.fClearLoadComponentsButton.setEnabled(numLoadComponents > 0 && (!this.fDisplayLoadPolicy || this.fSpecifyComponentsToLoadButton.getSelection() && this.fExcludeSomeComponentsButton.getSelection()));
    }

    protected void createNewLoadComponents(Collection<IComponentHandle> loadComponents) {
        if (loadComponents != null) {
            LoadComponents componentsToExclude = new LoadComponents(loadComponents);
            this.setLoadComponents(componentsToExclude);
            String loadComponentsProperty = componentsToExclude.getBuildProperty();
            this.fWorkingCopy.setProperty("team.scm.loadComponents", loadComponentsProperty);
            this.updateLoadComponents();
            this.validate();
            this.setDirty(true);
        }
    }

    protected void handleUpdatesToShowDuplicateWorkspaceWarningDialog() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                String buildDefinitionID = JazzScmConfigurationEditor.this.getBuildDefinitionWithSameBuildWorkspace();
                if (!JazzScmConfigurationEditor.this.fWorkspaceNameText.isDisposed() && buildDefinitionID != null && JazzScmConfigurationEditor.this.getShouldShowWorkspaceAlreadyInUseWarning()) {
                    JazzScmConfigurationEditor.this.setShouldShowWorkspaceAlreadyInUseWarning(false);
                    Dialog workspaceAlreadyInUseWarningDialog = JazzScmConfigurationEditor.this.getWorkspaceAlreadyInUseWarningDialog(buildDefinitionID);
                    int result = workspaceAlreadyInUseWarningDialog.open();
                    if (result == 0) {
                        workspaceAlreadyInUseWarningDialog.close();
                    }
                }
            }
        });
    }

    protected void setWorkspace(IWorkspace workspace) {
        if (workspace != null) {
            Dialog dialog;
            int result;
            this.setBuildWorkspace(workspace);
            this.setWarningWorkspaceIsStream(workspace.isStream());
            this.fWorkingCopy.setProperty("team.scm.workspaceUUID", workspace.getItemId().getUuidValue());
            this.setWorkspaceNameText(workspace.getName(), true);
            this.validate();
            this.setDirty(true);
            if (this.shouldShowWorkspaceOwnerWarning() && (result = (dialog = this.getWorkspaceOwnerWarningDialog()).open()) == 0) {
                this.openWorkspaceEditor();
            }
            this.setShouldShowWorkspaceAlreadyInUseWarning(true);
            this.createJobToValidateBuildWorkspace();
            if (this.fSelectComponentLoadRulesButton != null && !this.fSelectComponentLoadRulesButton.isDisposed()) {
                this.fSelectComponentLoadRulesButton.setEnabled(this.shouldEnableSelectComponentLoadRulesButton(workspace));
            }
            if (this.fSelectLoadComponentsButton != null && !this.fSelectLoadComponentsButton.isDisposed()) {
                this.fSelectLoadComponentsButton.setEnabled(this.shouldEnableSelectLoadComponentsButton(workspace));
            }
            if (this.fDisplayLoadPolicy) {
                this.createJobToVerifyLoadRules();
            }
        }
    }

    private boolean shouldShowWorkspaceOwnerWarning() {
        return BuildUIPlugin.getDefault().getPreferenceStore().getBoolean(PREFERENCE_SHOW_WORKSPACE_OWNER_WARNING);
    }

    protected Dialog getWorkspaceOwnerWarningDialog() {
        return new MessageDialog(this.fWorkspaceTitleHyperlink.getShell(), BuildDefinitionEditorMessages.JazzScmConfigurationEditor_WORKSPACE_OWNER_WARNING_TITLE, null, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_WORKSPACE_OWNER_WARNING_MESSAGE, 2, new String[]{BuildDefinitionEditorMessages.JazzScmConfigurationEditor_OPEN_WORKSPACE_BUTTON, IDialogConstants.OK_LABEL}, 1){

            protected Control createCustomArea(Composite parent) {
                new Label(parent, 0);
                JazzScmConfigurationEditor.this.fDontShowWarningButton = new Button(parent, 32);
                JazzScmConfigurationEditor.this.fDontShowWarningButton.setText(BuildDefinitionEditorMessages.JazzScmConfigurationEditor_DONT_SHOW_WARNING_AGAIN);
                JazzScmConfigurationEditor.this.fDontShowWarningButton.addSelectionListener(JazzScmConfigurationEditor.this.getDontShowWarningButtonListener());
                return JazzScmConfigurationEditor.this.fDontShowWarningButton;
            }
        };
    }

    protected Dialog getWorkspaceAlreadyInUseWarningDialog(String buildDefinitionID) {
        return new MessageDialog(this.fWorkspaceTitleHyperlink.getShell(), BuildDefinitionEditorMessages.JazzScmConfigurationEditor_SAME_WORKSPACE_WARNING_TITLE, null, NLS.bind((String)BuildDefinitionEditorMessages.JazzScmConfigurationEditor_SAME_WORKSPACE_WARNING_MESSAGE, (Object)this.fWorkspaceNameText.getText(), (Object[])new Object[]{buildDefinitionID}), 4, new String[]{IDialogConstants.OK_LABEL}, 1);
    }

    protected SelectionListener getDontShowWarningButtonListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildUIPlugin.getDefault().getPreferenceStore().setValue(JazzScmConfigurationEditor.PREFERENCE_SHOW_WORKSPACE_OWNER_WARNING, !JazzScmConfigurationEditor.this.fDontShowWarningButton.getSelection());
                BuildUIPlugin.getDefault().savePluginPreferences();
            }
        };
    }

    protected SelectionListener getLoadMethodSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JazzScmConfigurationEditor.this.validate();
                JazzScmConfigurationEditor.this.fWorkingCopy.setProperty("team.scm.deleteDestinationBeforeFetch", Boolean.toString(JazzScmConfigurationEditor.this.fFullLoadButton.getSelection()));
                String loadMethod = null;
                if (JazzScmConfigurationEditor.this.fFullLoadButton.getSelection()) {
                    loadMethod = "fullLoad";
                } else if (JazzScmConfigurationEditor.this.fIncrementalLoadButton.getSelection()) {
                    loadMethod = "incrementalLoad";
                } else if (JazzScmConfigurationEditor.this.fOptimizedIncrementalLoadButton.getSelection()) {
                    loadMethod = "optimizedIncrementalLoad";
                }
                JazzScmConfigurationEditor.this.fWorkingCopy.setProperty("team.scm.loadMethod", loadMethod);
                IBuildProperty loadMethodProperty = JazzScmConfigurationEditor.this.fWorkingCopy.getProperty("team.scm.loadMethod");
                if (loadMethodProperty != null) {
                    loadMethodProperty.setGenericEditAllowed(false);
                }
                JazzScmConfigurationEditor.this.setDirty(true);
            }
        };
    }

    protected SelectionListener getCreateFoldersForComponentsSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JazzScmConfigurationEditor.this.validate();
                JazzScmConfigurationEditor.this.fWorkingCopy.setProperty("team.scm.createFoldersForComponents", Boolean.toString(JazzScmConfigurationEditor.this.fCreateFoldersForComponentsButton.getSelection()));
                JazzScmConfigurationEditor.this.setDirty(true);
            }
        };
    }

    protected SelectionListener getSpecifyComponentsToLoadListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JazzScmConfigurationEditor.this.validate();
                JazzScmConfigurationEditor.this.setDirty(true);
                JazzScmConfigurationEditor.this.fSelectComponentLoadRulesButton.setEnabled(false);
                JazzScmConfigurationEditor.this.fClearComponentLoadRulesButton.setEnabled(false);
                JazzScmConfigurationEditor.this.fCreateFoldersForComponentsButton.setEnabled(JazzScmConfigurationEditor.this.shouldEnableCreateFoldersForComponentsButton());
                JazzScmConfigurationEditor.this.fLoadAllComponentsButton.setEnabled(true);
                JazzScmConfigurationEditor.this.fExcludeSomeComponentsButton.setEnabled(JazzScmConfigurationEditor.this.shouldEnableExcludeSomeComponentsButton());
                JazzScmConfigurationEditor.this.fSelectLoadComponentsButton.setEnabled(JazzScmConfigurationEditor.this.shouldEnableSelectLoadComponentsButton(JazzScmConfigurationEditor.this.getBuildWorkspace()));
                JazzScmConfigurationEditor.this.fClearLoadComponentsButton.setEnabled(JazzScmConfigurationEditor.this.fLoadComponents.getComponentHandles().size() > 0 && JazzScmConfigurationEditor.this.fExcludeSomeComponentsButton.getSelection());
                JazzScmConfigurationEditor.this.updateLoadPolicyAndComponentLoadConfig();
            }
        };
    }

    protected SelectionListener getUseLoadRulesSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JazzScmConfigurationEditor.this.validate();
                JazzScmConfigurationEditor.this.setDirty(true);
                JazzScmConfigurationEditor.this.fCreateFoldersForComponentsButton.setEnabled(false);
                JazzScmConfigurationEditor.this.fLoadAllComponentsButton.setEnabled(false);
                JazzScmConfigurationEditor.this.fExcludeSomeComponentsButton.setEnabled(false);
                JazzScmConfigurationEditor.this.fSelectLoadComponentsButton.setEnabled(false);
                JazzScmConfigurationEditor.this.fClearLoadComponentsButton.setEnabled(false);
                JazzScmConfigurationEditor.this.fSelectComponentLoadRulesButton.setEnabled(JazzScmConfigurationEditor.this.getBuildWorkspace() != null);
                JazzScmConfigurationEditor.this.fClearComponentLoadRulesButton.setEnabled(JazzScmConfigurationEditor.this.fComponentLoadRules.getLoadRuleFiles().values().size() > 0);
                JazzScmConfigurationEditor.this.updateLoadPolicyAndComponentLoadConfig();
            }
        };
    }

    protected SelectionListener getLoadAllComponentsSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JazzScmConfigurationEditor.this.validate();
                JazzScmConfigurationEditor.this.setDirty(true);
                JazzScmConfigurationEditor.this.fSelectLoadComponentsButton.setEnabled(false);
                JazzScmConfigurationEditor.this.fClearLoadComponentsButton.setEnabled(false);
                JazzScmConfigurationEditor.this.updateLoadPolicyAndComponentLoadConfig();
            }
        };
    }

    protected SelectionListener getExcludeSomeComponentsSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JazzScmConfigurationEditor.this.validate();
                JazzScmConfigurationEditor.this.setDirty(true);
                JazzScmConfigurationEditor.this.fSelectLoadComponentsButton.setEnabled(JazzScmConfigurationEditor.this.getBuildWorkspace() != null);
                JazzScmConfigurationEditor.this.fClearLoadComponentsButton.setEnabled(JazzScmConfigurationEditor.this.fLoadComponents.getComponentHandles().size() > 0);
                JazzScmConfigurationEditor.this.updateLoadPolicyAndComponentLoadConfig();
            }
        };
    }

    protected SelectionListener getSwitchToNewFormatSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (JazzScmConfigurationEditor.this.fSwitchToNewFormatButton.getSelection()) {
                    JazzScmConfigurationEditor.this.fWorkingCopy.setProperty("team.scm.loadPolicy", "useComponentLoadConfig");
                    if (JazzScmConfigurationEditor.this.fLoadComponents.getComponentHandles().size() > 0) {
                        JazzScmConfigurationEditor.this.fWorkingCopy.setProperty("team.scm.componentLoadConfig", "excludeSomeComponents");
                    } else {
                        JazzScmConfigurationEditor.this.fWorkingCopy.setProperty("team.scm.componentLoadConfig", "loadAllComponents");
                    }
                    if (JazzScmConfigurationEditor.this.fComponentLoadRules.getLoadRuleFiles().values().size() > 0) {
                        JazzScmConfigurationEditor.this.fWorkingCopy.setProperty("team.scm.loadPolicy", "useLoadRules");
                    }
                    JazzScmConfigurationEditor.this.fWorkingCopy.getProperty("team.scm.loadPolicy").setGenericEditAllowed(false);
                    JazzScmConfigurationEditor.this.fWorkingCopy.getProperty("team.scm.componentLoadConfig").setGenericEditAllowed(false);
                    JazzScmConfigurationEditor.this.removeMessage(JazzScmConfigurationEditor.this.fWorkspaceNameText, (Control)JazzScmConfigurationEditor.this.fWorkspaceNameText);
                    JazzScmConfigurationEditor.this.removeMessage(JazzScmConfigurationEditor.this.fAcceptBeforeFetchButton, (Control)JazzScmConfigurationEditor.this.fAcceptBeforeFetchButton);
                    JazzScmConfigurationEditor.this.removeMessage(JazzScmConfigurationEditor.this.fFetchDestinationText, (Control)JazzScmConfigurationEditor.this.fFetchDestinationText);
                    JazzScmConfigurationEditor.this.removeMessage(JazzScmConfigurationEditor.this.fComponentLoadRulesText, (Control)JazzScmConfigurationEditor.this.fComponentLoadRulesText);
                    JazzScmConfigurationEditor.this.removeMessage(JazzScmConfigurationEditor.this.fLoadComponentsText, (Control)JazzScmConfigurationEditor.this.fLoadComponentsText);
                    JazzScmConfigurationEditor.this.refresh();
                    IManagedForm managedForm = JazzScmConfigurationEditor.this.getManagedForm();
                    if (managedForm != null) {
                        managedForm.reflow(true);
                    }
                    JazzScmConfigurationEditor.this.setDirty(true);
                    JazzScmConfigurationEditor.this.fShouldConfirmSave = true;
                }
            }
        };
    }

    protected SelectionListener getAcceptBeforeFetchSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JazzScmConfigurationEditor.this.validate();
                JazzScmConfigurationEditor.this.fWorkingCopy.setProperty("team.scm.acceptBeforeFetch", Boolean.toString(JazzScmConfigurationEditor.this.fAcceptBeforeFetchButton.getSelection()));
                JazzScmConfigurationEditor.this.fBuildOnlyIfChangesButton.setSelection(JazzScmConfigurationEditor.this.fAcceptBeforeFetchButton.getSelection());
                JazzScmConfigurationEditor.this.fBuildOnlyIfChangesButton.setEnabled(JazzScmConfigurationEditor.this.fAcceptBeforeFetchButton.getSelection());
                JazzScmConfigurationEditor.this.getBuildOnlyIfChangesSelectionListener().widgetSelected(null);
                JazzScmConfigurationEditor.this.setDirty(true);
            }
        };
    }

    protected SelectionListener getBuildOnlyIfChangesSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JazzScmConfigurationEditor.this.validate();
                JazzScmConfigurationEditor.this.fWorkingCopy.setProperty("team.scm.buildOnlyIfChanges", Boolean.toString(JazzScmConfigurationEditor.this.fBuildOnlyIfChangesButton.getSelection()));
                JazzScmConfigurationEditor.this.setDirty(true);
            }
        };
    }

    protected SelectionListener getIncludeLinkInWorkItemsSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JazzScmConfigurationEditor.this.validate();
                JazzScmConfigurationEditor.this.fWorkingCopy.setProperty("team.build.createWorkItemIncludeLinks", Boolean.toString(JazzScmConfigurationEditor.this.fIncludeLinkInWorkItemsCheckbox.getSelection()));
                JazzScmConfigurationEditor.this.fWorkingCopy.getProperty("team.build.createWorkItemIncludeLinks").setGenericEditAllowed(false);
                JazzScmConfigurationEditor.this.setDirty(true);
            }
        };
    }

    protected void updateLoadPolicyAndComponentLoadConfig() {
        String loadPolicy = "useLoadRules";
        if (this.fSpecifyComponentsToLoadButton.getSelection()) {
            loadPolicy = "useComponentLoadConfig";
            this.fWorkingCopy.setProperty("team.scm.componentLoadConfig", this.fLoadAllComponentsButton.getSelection() ? "loadAllComponents" : "excludeSomeComponents");
        }
        this.fWorkingCopy.setProperty("team.scm.loadPolicy", loadPolicy);
    }

    protected IWorkspace openWorkspaceChooserDialog(Shell shell, ITeamRepository teamRepository) {
        AbstractPlaceWrapper wrapper = WorkspaceAndStreamSelectionDialog.getWorkspaceOrStream((Shell)shell, (ITeamRepository)teamRepository, null, (WORKSPACES_OR_STREAMS)WORKSPACES_OR_STREAMS.WORKSPACES, null);
        if (wrapper != null) {
            return wrapper.getWorkspace();
        }
        return null;
    }

    protected void openWorkspaceCreationDialog() {
        NewWorkspaceWizard wizard = new NewWorkspaceWizard(UIContext.createPartContext((IWorkbenchPart)this), this.getTeamRepository(), false, (IPartResult)new IPartResult<AbstractPlaceWrapper>(){

            public void setResult(AbstractPlaceWrapper result) {
                JazzScmConfigurationEditor.this.setWorkspace(result.getWorkspace());
            }
        }, true, (IReadScope)IReadScope.FACTORY.createPublicScope());
        new WizardDialog(this.fWorkspaceTitleHyperlink.getShell(), (IWizard)wizard).open();
    }

    @Override
    public Control getFocusControl() {
        return this.fSelectWorkspaceButton;
    }

    @Override
    public boolean proceedWithSave() {
        boolean proceedWithSave = true;
        if (this.fDisplayLoadPolicy && this.fShouldConfirmSave) {
            proceedWithSave = MessageDialog.openQuestion((Shell)this.fSpecifyComponentsToLoadButton.getShell(), (String)BuildDefinitionEditorMessages.JazzScmConfigurationEditor_WARNING_SAVE_CHANGES_TITLE, (String)BuildDefinitionEditorMessages.JazzScmConfigurationEditor_WARNING_SAVE_CHANGES);
            this.fShouldConfirmSave = false;
        }
        return proceedWithSave;
    }

    @Override
    protected String getContextHelpId() {
        return "com.ibm.team.build.ui.editor_builddefinitionjazzscm";
    }

    private synchronized boolean getWarningWorkspaceIsStream() {
        return this.fWarningWorkspaceIsStream;
    }

    private synchronized void setWarningWorkspaceIsStream(boolean isStream) {
        this.fWarningWorkspaceIsStream = isStream;
    }

    private synchronized boolean getWarningMissingComponentInComponentsToExclude() {
        return this.fWarningMissingComponentInComponentsToExclude;
    }

    private synchronized void setWarningMissingComponentInComponentsToExclude(boolean usesMissingComponents) {
        this.fWarningMissingComponentInComponentsToExclude = usesMissingComponents;
    }

    private synchronized boolean getErrorLoadRulesNotInXMLFormat() {
        return this.fErrorLoadRulesNotInXMLFormat;
    }

    protected synchronized void setErrorLoadRulesNotInXMLFormat(boolean loadRulesNotInXMLFormat) {
        this.fErrorLoadRulesNotInXMLFormat = loadRulesNotInXMLFormat;
    }

    private synchronized void setBuildDefinitionWithSameBuildWorkspace(String buildDefinitionName) {
        this.fBuildDefinitionWithSameBuildWorkspace = buildDefinitionName;
    }

    protected synchronized String getBuildDefinitionWithSameBuildWorkspace() {
        return this.fBuildDefinitionWithSameBuildWorkspace;
    }

    protected synchronized void setWorkspacePrivateComponentCount(int count) {
        this.fWorkspacePrivateComponentCount = count;
    }

    protected synchronized int getWorkspacePrivateComponentCount() {
        return this.fWorkspacePrivateComponentCount;
    }

    private void setShouldShowWorkspaceAlreadyInUseWarning(boolean shouldShowDialog) {
        this.fShouldShowWorkspaceAlreadyInUseDialog = shouldShowDialog;
    }

    private boolean getShouldShowWorkspaceAlreadyInUseWarning() {
        return this.fShouldShowWorkspaceAlreadyInUseDialog;
    }

    protected synchronized IWorkspace getBuildWorkspace() {
        return this.fBuildWorkspace;
    }

    protected synchronized void setBuildWorkspace(IWorkspace workspace) {
        if (workspace != null && !workspace.sameItemId((IItemHandle)this.fBuildWorkspace)) {
            this.createJobToVerifyComponentsToExclude();
        }
        this.fBuildWorkspace = workspace;
    }

    protected synchronized LoadComponents getLoadComponents() {
        return this.fLoadComponents;
    }

    protected synchronized void setLoadComponents(LoadComponents loadComponents) {
        this.fLoadComponents = loadComponents;
    }
}

