/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.builddefinition;

import com.ibm.team.build.client.ClientFactory;
import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.common.model.IBuildResultPruningPolicy;
import com.ibm.team.build.common.model.query.IBaseBuildEngineQueryModel;
import com.ibm.team.build.internal.client.iterator.ItemQueryIterator;
import com.ibm.team.build.internal.common.helper.BuildEngineHelper;
import com.ibm.team.build.internal.common.helper.ItemHandleAwareHashMap;
import com.ibm.team.build.internal.common.model.dto.IBuildItemNamePair;
import com.ibm.team.build.internal.ui.AbstractBuildItemViewerComparator;
import com.ibm.team.build.internal.ui.BuildUIMessages;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.actions.EditBuildEngineActionDelegate;
import com.ibm.team.build.internal.ui.dialogs.AddBuildEnginesDialog2;
import com.ibm.team.build.internal.ui.domain.Messages;
import com.ibm.team.build.internal.ui.editors.builddefinition.BasicConfigurationElementEditor;
import com.ibm.team.build.internal.ui.editors.builddefinition.BuildDefinitionEditor;
import com.ibm.team.build.internal.ui.editors.builddefinition.BuildDefinitionEditorMessages;
import com.ibm.team.build.internal.ui.helper.BuildUIHelper;
import com.ibm.team.build.internal.ui.helper.EnterpriseHelper;
import com.ibm.team.build.internal.ui.wizards.buildengine.NewBuildEngineWizard;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.service.IQueryService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class GeneralConfigurationEditor
extends BasicConfigurationElementEditor {
    private static final int MONITORING_THRESHOLD_DEFAULT = 3;
    private static final int TEXT_FIELD_WIDTH_NUMBER = 25;
    private Section fGeneralSection;
    private Section fPruningSection;
    private Section fBuildEnginesSection;
    protected Text fDescriptionText;
    protected Label fSuccessfulResultsToKeepLabel;
    protected Text fSuccessfulResultsToKeepText;
    protected Label fFailedResultsToKeepLabel;
    protected Text fFailedResultsToKeepText;
    protected Button fPruneButton;
    protected Button fIgnoreWarningsButton;
    protected TableViewer fBuildEnginesTableViewer;
    protected Button fAddBuildEnginesButton;
    protected Button fCreateEngineButton;
    protected Button fRemoveBuildEngineButton;
    protected String fBuildProjectAreaName;
    protected String fBuildProjectAreaItemId = null;
    private FormToolkit fToolkit;
    private CLabel fProjectAreaFolderLabel;
    private IBuildItemNamePair[] fFolderPairs;
    private int fTotalEnginesSize = 0;
    private boolean allBuildEnginesFetched = false;
    private boolean fFolderWarningState;
    protected Map<String, IBuildEngine> fBuildEngines = new HashMap<String, IBuildEngine>();
    private Map<String, IBuildEngine> fChangedBuildEngines = new HashMap<String, IBuildEngine>();
    private Map<String, String> fEngineIdToProject = new HashMap<String, String>();
    private List<String> fSupportingBuildEngineIds;
    private Composite fFolderComposite;

    public GeneralConfigurationEditor(String elementId, String title) {
        super(elementId, title);
    }

    @Override
    public void createContent(Composite parent, FormToolkit toolkit) {
        this.fToolkit = toolkit;
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 10;
        layout.verticalSpacing = 15;
        parent.setLayout((Layout)layout);
        this.createGeneralSection(parent);
        this.createBuildEngineSection(parent);
        this.createPruningPolicySection(parent);
    }

    @Override
    protected Section createSection(Composite parent, String text, String description, boolean expandable, int numColumns) {
        Section section = super.createSection(parent, text, description, expandable, numColumns);
        GridLayoutFactory.fillDefaults().numColumns(numColumns).extendedMargins(5, 5, 12, 5).spacing(7, 5).applyTo((Composite)section.getClient());
        return section;
    }

    protected void setFolderParentPairs(IBuildItemNamePair[] pairs) {
        this.fFolderPairs = pairs;
    }

    private void createGeneralSection(Composite parent) {
        this.fGeneralSection = this.createSection(parent, BuildDefinitionEditorMessages.BuildDefinitionEditor_GENERAL_INFORMATION_TITLE, BuildDefinitionEditorMessages.BuildDefinitionEditor_GENERAL_INFORMATION_DESCRIPTION, false, 3);
        Composite composite = (Composite)this.fGeneralSection.getClient();
        this.fGeneralSection.setLayoutData((Object)new TableWrapData(256, 256, 1, 2));
        GridData gridData = new GridData();
        gridData.verticalAlignment = 128;
        gridData.horizontalSpan = 2;
        gridData.widthHint = 200;
        IPreferenceStore store = BuildUIPlugin.getDefault().getPreferenceStore();
        boolean showFolders = store.getBoolean("show_build_folders");
        if (showFolders && !EnterpriseHelper.isEnterpriseDefinition(this.fWorkingCopy)) {
            Label folderLabel = this.fToolkit.createLabel(composite, BuildDefinitionEditorMessages.BuildDefinitionEditor_CONTAINING_FOLDER_LABEL);
            folderLabel.setLayoutData((Object)gridData);
            this.fFolderComposite = this.fToolkit.createComposite(composite);
            this.fFolderComposite.setBackground(null);
            GridData folderCompositeGridData = new GridData();
            folderCompositeGridData.horizontalSpan = 6;
            folderCompositeGridData.widthHint = 700;
            this.fFolderComposite.setLayoutData((Object)folderCompositeGridData);
            RowLayout rowLayout = new RowLayout(256);
            rowLayout.center = true;
            this.fFolderComposite.setLayout((Layout)rowLayout);
            this.createFolderComposite();
        }
        Label label = this.fToolkit.createLabel(composite, BuildDefinitionEditorMessages.BuildDefinitionEditor_DESCRIPTION_LABEL);
        gridData = new GridData();
        gridData.verticalAlignment = 128;
        label.setLayoutData((Object)gridData);
        this.fDescriptionText = this.fToolkit.createText(composite, this.fWorkingCopy.getDescription(), 2626);
        gridData = new GridData(768);
        gridData.widthHint = 200;
        gridData.heightHint = 60;
        gridData.horizontalSpan = 2;
        this.fDescriptionText.setLayoutData((Object)gridData);
        this.fDescriptionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GeneralConfigurationEditor.this.fWorkingCopy.setDescription(GeneralConfigurationEditor.this.fDescriptionText.getText().trim());
                GeneralConfigurationEditor.this.setDirty(true);
            }
        });
        Label spacingLabel = this.fToolkit.createLabel(composite, "");
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        spacingLabel.setLayoutData((Object)gridData);
        this.fIgnoreWarningsButton = this.fToolkit.createButton(composite, BuildDefinitionEditorMessages.BuildDefinitionEditor_IGNORE_WARNINGS, 32);
        this.fIgnoreWarningsButton.setToolTipText(BuildDefinitionEditorMessages.BuildDefinitionEditor_IGNORE_WARNINGS_TOOLTIP);
        this.fIgnoreWarningsButton.setSelection(this.fWorkingCopy.isIgnoreWarnings());
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.fIgnoreWarningsButton.setLayoutData((Object)gridData);
        this.fIgnoreWarningsButton.addSelectionListener(this.getIgnoreWarningsButtonListener());
    }

    private CLabel createRightArrowLabel(Composite composite) {
        CLabel pALabel = new CLabel(this.fFolderComposite, 0);
        pALabel.setImage(BuildUIPlugin.getImage("icons/obj16/arrow_right_obj.gif"));
        return pALabel;
    }

    private void createFolderComposite() {
        Control[] controlArray = this.fFolderComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        this.fProjectAreaFolderLabel = new CLabel(this.fFolderComposite, 0);
        if (this.fFolderPairs != null) {
            this.fProjectAreaFolderLabel.setImage(BuildUIPlugin.getImage("icons/obj16/projectarea_obj.gif"));
            this.fProjectAreaFolderLabel.setText(this.fBuildProjectAreaName);
            this.createRightArrowLabel(this.fFolderComposite);
            CLabel buildsLabel = new CLabel(this.fFolderComposite, 0);
            buildsLabel.setImage(BuildUIPlugin.getImage("icons/obj16/builds_obj.gif"));
            buildsLabel.setText(Messages.BuildDomainContentProvider_BUILD_DOMAIN_NODE);
            if (this.fFolderPairs.length > 0) {
                this.createRightArrowLabel(this.fFolderComposite);
                int i = this.fFolderPairs.length - 1;
                while (i >= 0) {
                    CLabel folderLabel = new CLabel(this.fFolderComposite, 0);
                    folderLabel.setImage(BuildUIPlugin.getImage("icons/obj16/mybuilds_obj.gif"));
                    folderLabel.setText(this.fFolderPairs[i].getName());
                    if (i > 0) {
                        this.createRightArrowLabel(this.fFolderComposite);
                    }
                    --i;
                }
            }
        } else {
            this.fProjectAreaFolderLabel.setText(BuildUIMessages.PendingUpdateAdapter_PENDING);
        }
        if (this.fFolderWarningState) {
            this.addWarningMessage(BuildDefinitionEditorMessages.GeneralConfigurationEditor_UNCATEGORIZED_DECORATOR_WARNING_MESSAGE, BuildDefinitionEditorMessages.GeneralConfigurationEditor_UNCATEGORIZED_DECORATOR_WARNING_MESSAGE, (Control)this.fProjectAreaFolderLabel);
        } else {
            this.removeMessage(BuildDefinitionEditorMessages.GeneralConfigurationEditor_UNCATEGORIZED_DECORATOR_WARNING_MESSAGE, (Control)this.fProjectAreaFolderLabel);
        }
        this.fFolderComposite.layout(true);
    }

    protected void refreshFolderComposite() {
        if (this.fFolderComposite != null && !this.fFolderComposite.isDisposed()) {
            this.createFolderComposite();
        }
    }

    protected void createBuildEngineSection(Composite parent) {
        this.fBuildEnginesSection = this.createSection(parent, BuildDefinitionEditorMessages.GeneralConfigurationEditor_SUPPORTING_ENGINES_TITLE, BuildDefinitionEditorMessages.GeneralConfigurationEditor_SUPPORTING_ENGINES_DESC, false, 2);
        Composite composite = (Composite)this.fBuildEnginesSection.getClient();
        this.fToolkit.setBorderStyle(2048);
        Table table = this.fToolkit.createTable(composite, 66306);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).hint(120, table.getItemHeight() * 10).applyTo((Control)table);
        this.fBuildEnginesTableViewer = new TableViewer(table);
        this.fBuildEnginesTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fBuildEnginesTableViewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.fBuildEnginesTableViewer.setComparator(this.getComparator());
        this.fBuildEnginesTableViewer.setInput(this.getSupportingEngineIds());
        this.fBuildEnginesTableViewer.addOpenListener(this.getOpenListener());
        this.createButtonBar(composite);
    }

    protected ViewerComparator getComparator() {
        return new AbstractBuildItemViewerComparator(){

            @Override
            protected String getProject(Object element) {
                return (String)GeneralConfigurationEditor.this.fEngineIdToProject.get(element);
            }

            @Override
            protected String getTopProject() {
                return GeneralConfigurationEditor.this.fBuildProjectAreaName;
            }
        };
    }

    protected LabelProvider getLabelProvider() {
        return new LabelProvider(){

            public Image getImage(Object element) {
                return BuildUIPlugin.getImage("icons/obj16/build_engine_obj.gif");
            }

            public String getText(Object element) {
                if (element instanceof String) {
                    String engineId = (String)element;
                    String projectAreaName = (String)GeneralConfigurationEditor.this.fEngineIdToProject.get(engineId);
                    return GeneralConfigurationEditor.this.formatText(engineId, projectAreaName);
                }
                return super.getText(element);
            }
        };
    }

    private String formatText(String engineId, String projectAreaName) {
        if (engineId != null) {
            if (projectAreaName != null) {
                if (projectAreaName.equals(this.fBuildProjectAreaName)) {
                    return engineId;
                }
                return NLS.bind((String)BuildUIMessages.EXTENDED_LABEL, (Object)engineId, (Object)projectAreaName);
            }
            return NLS.bind((String)BuildUIMessages.EXTENDED_LABEL, (Object)engineId, (Object)BuildUIMessages.UNKNOWN_PROJECT_AREA);
        }
        return null;
    }

    protected IOpenListener getOpenListener() {
        return new IOpenListener(){

            public void open(OpenEvent event) {
                String engineId;
                IBuildEngine buildEngine;
                IStructuredSelection selection = (IStructuredSelection)GeneralConfigurationEditor.this.fBuildEnginesTableViewer.getSelection();
                if (selection.size() == 1 && (buildEngine = GeneralConfigurationEditor.this.fBuildEngines.get(engineId = (String)selection.getFirstElement())) != null && !buildEngine.isNewItem()) {
                    EditBuildEngineActionDelegate.run(buildEngine, GeneralConfigurationEditor.this.getSite().getPage());
                }
            }
        };
    }

    private void createPruningPolicySection(Composite parent) {
        this.fPruningSection = this.createSection(parent, BuildDefinitionEditorMessages.BuildDefinitionEditor_PRUNING_POLICY_TITLE, BuildDefinitionEditorMessages.BuildDefinitionEditor_PRUNING_POLICY_DESCRIPTION, false, 2);
        Composite composite = (Composite)this.fPruningSection.getClient();
        IBuildResultPruningPolicy policy = this.fWorkingCopy.getBuildResultPruningPolicy();
        this.fPruneButton = this.fToolkit.createButton(composite, BuildDefinitionEditorMessages.BuildDefinitionEditor_PRUNE_BUILD_RESULTS_CHECKBOX_LABEL, 32);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.fPruneButton.setLayoutData((Object)gridData);
        this.fPruneButton.setSelection(policy.isEnabled());
        this.fPruneButton.addSelectionListener(this.getPruningButtonListener());
        this.fSuccessfulResultsToKeepLabel = this.fToolkit.createLabel(composite, BuildDefinitionEditorMessages.BuildDefinitionEditor_SUCCESSFUL_BUILDS_LABEL);
        gridData = new GridData();
        gridData.horizontalIndent = 15;
        this.fSuccessfulResultsToKeepLabel.setLayoutData((Object)gridData);
        this.fSuccessfulResultsToKeepLabel.setEnabled(this.fPruneButton.getSelection());
        this.fSuccessfulResultsToKeepText = this.fToolkit.createText(composite, String.valueOf(policy.getSuccessfulResultsToKeep()), 2052);
        gridData = new GridData(25, -1);
        this.fSuccessfulResultsToKeepText.setLayoutData((Object)gridData);
        this.fSuccessfulResultsToKeepText.setEnabled(this.fPruneButton.getSelection());
        this.fSuccessfulResultsToKeepText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GeneralConfigurationEditor.this.validate();
                if (GeneralConfigurationEditor.this.isPositiveInteger(GeneralConfigurationEditor.this.fSuccessfulResultsToKeepText.getText())) {
                    GeneralConfigurationEditor.this.fWorkingCopy.getBuildResultPruningPolicy().setSuccessfulResultsToKeep(Integer.parseInt(GeneralConfigurationEditor.this.fSuccessfulResultsToKeepText.getText()));
                }
                GeneralConfigurationEditor.this.setDirty(true);
            }
        });
        this.fFailedResultsToKeepLabel = this.fToolkit.createLabel(composite, BuildDefinitionEditorMessages.BuildDefinitionEditor_FAILED_BUILDS_LABEL);
        gridData = new GridData();
        gridData.horizontalIndent = 15;
        this.fFailedResultsToKeepLabel.setLayoutData((Object)gridData);
        this.fFailedResultsToKeepLabel.setEnabled(this.fPruneButton.getSelection());
        this.fFailedResultsToKeepText = this.fToolkit.createText(composite, String.valueOf(policy.getFailedResultsToKeep()), 2052);
        gridData = new GridData(25, -1);
        this.fFailedResultsToKeepText.setLayoutData((Object)gridData);
        this.fFailedResultsToKeepText.setEnabled(this.fPruneButton.getSelection());
        this.fFailedResultsToKeepText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GeneralConfigurationEditor.this.validate();
                if (GeneralConfigurationEditor.this.isPositiveInteger(GeneralConfigurationEditor.this.fFailedResultsToKeepText.getText())) {
                    GeneralConfigurationEditor.this.fWorkingCopy.getBuildResultPruningPolicy().setFailedResultsToKeep(Integer.parseInt(GeneralConfigurationEditor.this.fFailedResultsToKeepText.getText()));
                }
                GeneralConfigurationEditor.this.setDirty(true);
            }
        });
    }

    protected IBuildEngine[] getBuildEnginesToSave() {
        LinkedList<IBuildEngine> enginesToSave = new LinkedList<IBuildEngine>();
        enginesToSave.addAll(this.fChangedBuildEngines.values());
        return enginesToSave.toArray(new IBuildEngine[enginesToSave.size()]);
    }

    private IBuildDefinitionHandle getSupportedDefinition(IBuildEngine engine, IBuildDefinitionHandle buildDefinitionHandle) {
        for (Object object : engine.getSupportedBuildDefinitions()) {
            IBuildDefinitionHandle supportedDefinition = (IBuildDefinitionHandle)object;
            if (!supportedDefinition.getItemId().equals((Object)buildDefinitionHandle.getItemId())) continue;
            return supportedDefinition;
        }
        return null;
    }

    protected void updateChangedBuildEngines(Set<String> changedIds) {
        if (changedIds.size() > 0) {
            for (String engineId : changedIds) {
                if (this.fBuildEngines.get(engineId) == null) continue;
                IBuildEngine engine = (IBuildEngine)this.fBuildEngines.get(engineId).getWorkingCopy();
                IBuildDefinitionHandle supportedDefinition = this.getSupportedDefinition(engine, (IBuildDefinitionHandle)this.fWorkingCopy);
                if (supportedDefinition == null) {
                    engine.getSupportedBuildDefinitions().add(this.fWorkingCopy);
                    this.fChangedBuildEngines.put(engineId, engine);
                    this.fSupportingBuildEngineIds.add(engineId);
                    this.fBuildEnginesTableViewer.add((Object)engineId);
                } else {
                    engine.getSupportedBuildDefinitions().remove(supportedDefinition);
                    if (engine.isNewItem()) {
                        this.fChangedBuildEngines.remove(engineId);
                    } else {
                        this.fChangedBuildEngines.put(engineId, engine);
                    }
                    this.fSupportingBuildEngineIds.remove(engineId);
                    this.fBuildEnginesTableViewer.remove((Object)engineId);
                }
                this.fBuildEngines.put(engineId, engine);
            }
            this.setDirty(true);
            this.validate();
        }
    }

    protected List<String> getSupportingEngineIds() {
        this.fSupportingBuildEngineIds = new LinkedList<String>();
        for (IBuildEngine engine : this.getSupportingEngines()) {
            this.fSupportingBuildEngineIds.add(engine.getId());
        }
        return this.fSupportingBuildEngineIds;
    }

    public List<IBuildEngine> getSupportingEngines() {
        LinkedList<IBuildEngine> supportingBuildEngines = new LinkedList<IBuildEngine>();
        for (IBuildEngine engine : this.fBuildEngines.values()) {
            for (Object object : engine.getSupportedBuildDefinitions()) {
                IBuildDefinitionHandle definition = (IBuildDefinitionHandle)object;
                if (!definition.getItemId().equals((Object)this.fWorkingCopy.getItemId())) continue;
                supportingBuildEngines.add(engine);
            }
        }
        return supportingBuildEngines;
    }

    private void createButtonBar(Composite parent) {
        Composite buttonBar = this.fToolkit.createComposite(parent);
        buttonBar.setLayoutData((Object)new GridData(131072, 4, false, true));
        buttonBar.setLayout((Layout)new GridLayout(1, false));
        this.fCreateEngineButton = this.fToolkit.createButton(buttonBar, BuildDefinitionEditorMessages.GeneralConfigurationEditor_CREATE_ENGINE, 8);
        this.fCreateEngineButton.addSelectionListener((SelectionListener)this.getCreateNewEngineListener());
        this.fCreateEngineButton.setEnabled(false);
        this.fAddBuildEnginesButton = this.fToolkit.createButton(buttonBar, BuildDefinitionEditorMessages.GeneralConfigurationEditor_ADD_ENGINES, 8);
        this.fAddBuildEnginesButton.setEnabled(false);
        this.fAddBuildEnginesButton.addSelectionListener((SelectionListener)this.getAddBuildEnginesListener());
        this.fRemoveBuildEngineButton = this.fToolkit.createButton(buttonBar, BuildDefinitionEditorMessages.GeneralConfigurationEditor_REMOVE_ENGINE, 8);
        this.fRemoveBuildEngineButton.addSelectionListener((SelectionListener)this.getRemoveEngineListener());
        this.fRemoveBuildEngineButton.setEnabled(false);
        GridDataFactory.fillDefaults().hint(BuildUIHelper.getPreferredButtonWidth(this.fCreateEngineButton), -1).grab(true, false).align(0x1000008, 0x1000000).applyTo((Control)this.fCreateEngineButton);
        GridDataFactory.fillDefaults().hint(BuildUIHelper.getPreferredButtonWidth(this.fAddBuildEnginesButton), -1).grab(true, false).align(0x1000008, 0x1000000).applyTo((Control)this.fAddBuildEnginesButton);
        GridDataFactory.fillDefaults().hint(BuildUIHelper.getPreferredButtonWidth(this.fRemoveBuildEngineButton), -1).grab(true, false).align(0x1000008, 0x1000000).applyTo((Control)this.fRemoveBuildEngineButton);
    }

    protected SelectionAdapter getRemoveEngineListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selectedEngines = (IStructuredSelection)GeneralConfigurationEditor.this.fBuildEnginesTableViewer.getSelection();
                if (selectedEngines != null && selectedEngines.size() > 0) {
                    HashSet<Object> selectedEnginesSet = new HashSet<Object>(Arrays.asList(selectedEngines.toArray()));
                    GeneralConfigurationEditor.this.updateChangedBuildEngines(selectedEnginesSet);
                }
            }
        };
    }

    protected SelectionAdapter getAddBuildEnginesListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GeneralConfigurationEditor.this.fTotalEnginesSize <= 0) {
                    GeneralConfigurationEditor.this.openNoBuildEnginesWarningDialog();
                } else if (GeneralConfigurationEditor.this.fTotalEnginesSize == GeneralConfigurationEditor.this.fSupportingBuildEngineIds.size()) {
                    GeneralConfigurationEditor.this.openAllBuildEnginesAlreadyAddedWarningDialog();
                } else if (!GeneralConfigurationEditor.this.allBuildEnginesFetched) {
                    Job job = new Job(BuildDefinitionEditorMessages.BuildDefinitionEditor_FETCHING_BUILD_ENGINES){

                        protected IStatus run(IProgressMonitor monitor) {
                            GeneralConfigurationEditor.this.fetchBuildProjectAreaItemId(monitor);
                            GeneralConfigurationEditor.this.fetchAllBuildEngines(monitor);
                            Display.getDefault().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    AddBuildEnginesDialog2 dialog = GeneralConfigurationEditor.this.getAddBuildEnginesDialog(((this).this).GeneralConfigurationEditor.this.fBuildProjectAreaItemId);
                                    if (dialog.open() == 0) {
                                        GeneralConfigurationEditor.this.updateChangedBuildEngines(dialog.getChangedBuildEngineIds());
                                    }
                                }
                            });
                            return Status.OK_STATUS;
                        }
                    };
                    job.schedule();
                } else {
                    AddBuildEnginesDialog2 dialog = GeneralConfigurationEditor.this.getAddBuildEnginesDialog(GeneralConfigurationEditor.this.fBuildProjectAreaItemId);
                    if (dialog.open() == 0) {
                        GeneralConfigurationEditor.this.updateChangedBuildEngines(dialog.getChangedBuildEngineIds());
                    }
                }
            }
        };
    }

    protected void fetchBuildProjectAreaItemId(IProgressMonitor monitor) {
        IProjectAreaHandle projectHandle;
        IProcessArea processArea = null;
        try {
            processArea = (IProcessArea)this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)this.fWorkingCopy.getProcessArea(), 0, null);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            // empty catch block
        }
        if (processArea != null && (projectHandle = processArea.getProjectArea()) != null) {
            this.fBuildProjectAreaItemId = projectHandle.getItemId().getUuidValue();
        }
    }

    protected void fetchAllBuildEngines(IProgressMonitor monitor) {
        this.allBuildEnginesFetched = true;
        IItemManager itemManager = this.getTeamRepository().itemManager();
        IItemQuery itemQuery = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)IBaseBuildEngineQueryModel.IBuildEngineQueryModel.ROOT);
        ItemQueryIterator iter = new ItemQueryIterator(this.getBuildClient(), itemQuery, IQueryService.EMPTY_PARAMETERS);
        LinkedList buildEngines = new LinkedList();
        try {
            while (iter.hasNext(monitor)) {
                List engineHandles = iter.next(512, monitor);
                buildEngines.addAll(itemManager.fetchCompleteItems(engineHandles, 1, monitor));
            }
        }
        catch (TeamRepositoryException exception) {
            BuildUIPlugin.log(exception);
        }
        Iterator enginesIter = buildEngines.iterator();
        while (enginesIter.hasNext()) {
            Object next = enginesIter.next();
            if (next != null) continue;
            enginesIter.remove();
        }
        for (IBuildEngine engine : buildEngines) {
            this.fBuildEngines.put(engine.getId(), engine);
        }
        try {
            this.fEngineIdToProject.putAll(this.fetchIdToProjectName(this.fBuildEngines, monitor));
        }
        catch (TeamRepositoryException exception) {
            BuildUIPlugin.log(exception);
            exception.printStackTrace();
        }
    }

    private ITeamBuildClient getBuildClient() {
        return ClientFactory.getTeamBuildClient((ITeamRepository)this.getTeamRepository());
    }

    protected SelectionAdapter getCreateNewEngineListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IProcessArea processArea = null;
                try {
                    processArea = (IProcessArea)GeneralConfigurationEditor.this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)GeneralConfigurationEditor.this.fWorkingCopy.getProcessArea(), 0, null);
                }
                catch (TeamRepositoryException teamRepositoryException) {
                    // empty catch block
                }
                if (processArea != null) {
                    NewBuildEngineWizard wizard = GeneralConfigurationEditor.this.createNewBuildEngineWizard(processArea);
                    WizardDialog dialog = GeneralConfigurationEditor.this.createNewBuildEngineWizardDialog(GeneralConfigurationEditor.this.fCreateEngineButton.getShell(), wizard);
                    if (dialog.open() == 0) {
                        GeneralConfigurationEditor.this.addBuildEngine(wizard.getBuildEngine());
                    }
                }
            }
        };
    }

    protected IBuildEngine createBuildEngine(String engineId) {
        IBuildEngine engine = BuildItemFactory.createBuildEngine();
        engine.setId(engineId);
        engine.setProcessArea(this.fWorkingCopy.getProcessArea());
        engine.setActive(true);
        engine.setMonitoringThreshold(3);
        this.addBuildEngine(engine);
        return engine;
    }

    private void addBuildEngine(IBuildEngine engine) {
        engine.getSupportedBuildDefinitions().add(this.fWorkingCopy);
        this.fBuildEngines.put(engine.getId(), engine);
        this.fChangedBuildEngines.put(engine.getId(), engine);
        this.fEngineIdToProject.put(engine.getId(), this.getCurrentProjectAreaName());
        this.fSupportingBuildEngineIds.add(engine.getId());
        this.fBuildEnginesTableViewer.add((Object)engine.getId());
        this.setDirty(true);
        this.validate();
    }

    private IBuildEngine addSupportedDefinition(String engineId) {
        IBuildEngine workingCopy = (IBuildEngine)this.fBuildEngines.get(engineId).getWorkingCopy();
        workingCopy.getSupportedBuildDefinitions().add(this.fWorkingCopy);
        this.fBuildEngines.put(workingCopy.getId(), workingCopy);
        this.fChangedBuildEngines.put(workingCopy.getId(), workingCopy);
        this.fBuildEnginesTableViewer.add((Object)workingCopy.getId());
        this.setDirty(true);
        return workingCopy;
    }

    protected AddBuildEnginesDialog2 getAddBuildEnginesDialog(String processAreaItemId) {
        return new AddBuildEnginesDialog2(this.fCreateEngineButton.getShell(), this.fEngineIdToProject, this.fSupportingBuildEngineIds, this.getCurrentProjectAreaName(), this.fBuildEngines, this.getTeamRepository(), processAreaItemId);
    }

    protected void openNoBuildEnginesWarningDialog() {
        MessageDialog.openWarning((Shell)this.fCreateEngineButton.getShell(), (String)BuildDefinitionEditorMessages.GeneralConfigurationEditor_NO_ENGINES_WARNING_TITLE, (String)BuildDefinitionEditorMessages.GeneralConfigurationEditor_NO_ENGINES_WARNING_MESSAGE);
    }

    protected void openAllBuildEnginesAlreadyAddedWarningDialog() {
        MessageDialog.openWarning((Shell)this.fCreateEngineButton.getShell(), (String)BuildDefinitionEditorMessages.GeneralConfigurationEditor_NO_ENGINES_WARNING_TITLE, (String)BuildDefinitionEditorMessages.GeneralConfigurationEditor_ALL_ENGINES_ADDED_WARNING_MESSAGE);
    }

    @Override
    public boolean validate() {
        boolean isValid = true;
        boolean isWarning = false;
        if (!this.fPruneButton.getSelection()) {
            this.removeMessage(BuildDefinitionEditorMessages.BuildDefinitionEditor_MUST_BE_POSITIVE_INTEGER, (Control)this.fSuccessfulResultsToKeepText);
            this.removeMessage(BuildDefinitionEditorMessages.BuildDefinitionEditor_MUST_BE_POSITIVE_INTEGER, (Control)this.fFailedResultsToKeepText);
        }
        if (this.isPositiveInteger(this.fSuccessfulResultsToKeepText.getText())) {
            this.removeMessage(BuildDefinitionEditorMessages.BuildDefinitionEditor_MUST_BE_POSITIVE_INTEGER, (Control)this.fSuccessfulResultsToKeepText);
        } else {
            this.addErrorMessage((Object)BuildDefinitionEditorMessages.BuildDefinitionEditor_MUST_BE_POSITIVE_INTEGER, NLS.bind((String)BuildDefinitionEditorMessages.BuildDefinitionEditor_MUST_BE_POSITIVE_INTEGER, (Object)Integer.MAX_VALUE), (Control)this.fSuccessfulResultsToKeepText);
            isValid = false;
        }
        if (this.isPositiveInteger(this.fFailedResultsToKeepText.getText())) {
            this.removeMessage(BuildDefinitionEditorMessages.BuildDefinitionEditor_MUST_BE_POSITIVE_INTEGER, (Control)this.fFailedResultsToKeepText);
        } else {
            this.addErrorMessage((Object)BuildDefinitionEditorMessages.BuildDefinitionEditor_MUST_BE_POSITIVE_INTEGER, NLS.bind((String)BuildDefinitionEditorMessages.BuildDefinitionEditor_MUST_BE_POSITIVE_INTEGER, (Object)Integer.MAX_VALUE), (Control)this.fFailedResultsToKeepText);
            isValid = false;
        }
        if (this.fSupportingBuildEngineIds == null || this.fSupportingBuildEngineIds.size() == 0) {
            this.addWarningMessage(BuildDefinitionEditorMessages.BuildDefinitionEditor_WARNING_NO_SUPPORTING_BUILD_ENGINES, BuildDefinitionEditorMessages.BuildDefinitionEditor_WARNING_NO_SUPPORTING_BUILD_ENGINES, this.fBuildEnginesTableViewer.getControl());
            isWarning = true;
        } else {
            this.removeMessage(BuildDefinitionEditorMessages.BuildDefinitionEditor_WARNING_NO_SUPPORTING_BUILD_ENGINES, this.fBuildEnginesTableViewer.getControl());
        }
        boolean isBuildForgeDefinition = BuildEngineHelper.isBuildForgeDefinition((IBuildDefinition)this.fWorkingCopy);
        boolean isBuildAgentDefinition = BuildEngineHelper.isBuildAgentDefinition((IBuildDefinition)this.fWorkingCopy);
        boolean isHudsonDefinition = BuildEngineHelper.isHudsonDefinition((IBuildDefinition)this.fWorkingCopy);
        boolean isJazzBuildDefinition = !isBuildForgeDefinition && !isBuildAgentDefinition && !isHudsonDefinition;
        boolean isBuildForgeEngineExpected = false;
        boolean isBuildAgentEngineExpected = false;
        boolean isHudsonEngineExpected = false;
        boolean isJazzBuildEngineExpected = false;
        for (String buildEngineId : this.fSupportingBuildEngineIds) {
            boolean isJazzBuildEngine;
            IBuildEngine buildEngine = this.fBuildEngines.get(buildEngineId);
            boolean isBuildForgeEngine = BuildEngineHelper.isBuildForgeEngine((IBuildEngine)buildEngine);
            boolean isBuildAgentEngine = BuildEngineHelper.isBuildAgentEngine((IBuildEngine)buildEngine);
            boolean isHudsonEngine = BuildEngineHelper.isHudsonEngine((IBuildEngine)buildEngine);
            boolean bl = isJazzBuildEngine = !isBuildForgeEngine && !isBuildAgentEngine && !isHudsonEngine;
            if (isBuildForgeDefinition && !isBuildForgeEngine) {
                this.addWarningMessage(BuildDefinitionEditorMessages.GeneralConfigurationEditor_BuildForgeEngineExpected, NLS.bind((String)BuildDefinitionEditorMessages.GeneralConfigurationEditor_BuildForgeEngineExpected, (Object)buildEngine.getId()), this.fBuildEnginesTableViewer.getControl());
                isBuildForgeEngineExpected = true;
                isWarning = true;
                continue;
            }
            if (isBuildAgentDefinition && !isBuildAgentEngine) {
                this.addWarningMessage(BuildDefinitionEditorMessages.GeneralConfigurationEditor_BuildAgentEngineExpected, NLS.bind((String)BuildDefinitionEditorMessages.GeneralConfigurationEditor_BuildAgentEngineExpected, (Object)buildEngine.getId()), this.fBuildEnginesTableViewer.getControl());
                isBuildAgentEngineExpected = true;
                isWarning = true;
                continue;
            }
            if (isHudsonDefinition && !isHudsonEngine) {
                this.addWarningMessage(BuildDefinitionEditorMessages.GeneralConfigurationEditor_HudsonEngineExpected, NLS.bind((String)BuildDefinitionEditorMessages.GeneralConfigurationEditor_HudsonEngineExpected, (Object)buildEngine.getId()), this.fBuildEnginesTableViewer.getControl());
                isHudsonEngineExpected = true;
                isWarning = true;
                continue;
            }
            if (!isJazzBuildDefinition || isJazzBuildEngine) continue;
            this.addWarningMessage(BuildDefinitionEditorMessages.GeneralConfigurationEditor_JazzBuildEngineExpected, NLS.bind((String)BuildDefinitionEditorMessages.GeneralConfigurationEditor_JazzBuildEngineExpected, (Object)buildEngine.getId()), this.fBuildEnginesTableViewer.getControl());
            isJazzBuildEngineExpected = true;
            isWarning = true;
        }
        if (!isBuildForgeEngineExpected) {
            this.removeMessage(BuildDefinitionEditorMessages.GeneralConfigurationEditor_BuildForgeEngineExpected, this.fBuildEnginesTableViewer.getControl());
        }
        if (!isBuildAgentEngineExpected) {
            this.removeMessage(BuildDefinitionEditorMessages.GeneralConfigurationEditor_BuildAgentEngineExpected, this.fBuildEnginesTableViewer.getControl());
        }
        if (!isHudsonEngineExpected) {
            this.removeMessage(BuildDefinitionEditorMessages.GeneralConfigurationEditor_HudsonEngineExpected, this.fBuildEnginesTableViewer.getControl());
        }
        if (!isJazzBuildEngineExpected) {
            this.removeMessage(BuildDefinitionEditorMessages.GeneralConfigurationEditor_JazzBuildEngineExpected, this.fBuildEnginesTableViewer.getControl());
        }
        this.setPageStatusIndicator(!isValid, isWarning);
        return isValid;
    }

    protected SelectionListener getPruningButtonListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneralConfigurationEditor.this.fWorkingCopy.getBuildResultPruningPolicy().setEnabled(GeneralConfigurationEditor.this.fPruneButton.getSelection());
                GeneralConfigurationEditor.this.validate();
                GeneralConfigurationEditor.this.setDirty(true);
                GeneralConfigurationEditor.this.fSuccessfulResultsToKeepLabel.setEnabled(GeneralConfigurationEditor.this.fPruneButton.getSelection());
                GeneralConfigurationEditor.this.fSuccessfulResultsToKeepText.setEnabled(GeneralConfigurationEditor.this.fPruneButton.getSelection());
                GeneralConfigurationEditor.this.fFailedResultsToKeepLabel.setEnabled(GeneralConfigurationEditor.this.fPruneButton.getSelection());
                GeneralConfigurationEditor.this.fFailedResultsToKeepText.setEnabled(GeneralConfigurationEditor.this.fPruneButton.getSelection());
            }
        };
    }

    protected SelectionListener getIgnoreWarningsButtonListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneralConfigurationEditor.this.fWorkingCopy.setIgnoreWarnings(GeneralConfigurationEditor.this.fIgnoreWarningsButton.getSelection());
                GeneralConfigurationEditor.this.setDirty(true);
            }
        };
    }

    private boolean isPositiveInteger(String number) {
        try {
            int i = Integer.parseInt(number);
            return i > 0;
        }
        catch (NumberFormatException exception) {
            return false;
        }
    }

    protected void initializeBuildEngines(Collection<IBuildEngine> buildEngines, Map<String, String> engineIdToProjectName, String projectAreaName, boolean isFromScratchOrTemplate, int allEnginesSize) {
        this.fBuildEngines.clear();
        this.fChangedBuildEngines.clear();
        this.allBuildEnginesFetched = false;
        this.fTotalEnginesSize = allEnginesSize;
        for (IBuildEngine buildEngine : buildEngines) {
            this.fBuildEngines.put(buildEngine.getId(), buildEngine);
        }
        this.fEngineIdToProject = engineIdToProjectName;
        if (this.fBuildEnginesTableViewer != null && !this.fBuildEnginesTableViewer.getTable().isDisposed()) {
            this.fBuildProjectAreaName = projectAreaName;
            if (isFromScratchOrTemplate) {
                this.createOrAssociateDefaultBuildEngine();
            }
            this.fBuildEnginesTableViewer.setInput(this.getSupportingEngineIds());
            this.fAddBuildEnginesButton.setEnabled(true);
            this.fCreateEngineButton.setEnabled(true);
            this.fRemoveBuildEngineButton.setEnabled(true);
            this.validate();
        }
    }

    protected Map<String, String> fetchIdToProjectName(Map<String, IBuildEngine> buildEngineIdToItem, IProgressMonitor monitor) throws TeamRepositoryException {
        HashMap<String, String> idToProjectName = new HashMap<String, String>();
        if (buildEngineIdToItem.size() > 0) {
            ArrayList<ITeamAreaHandle> teamAreaHandles = new ArrayList<ITeamAreaHandle>();
            ArrayList<IProjectAreaHandle> projectAreaHandles = new ArrayList<IProjectAreaHandle>();
            for (IBuildEngine engine : buildEngineIdToItem.values()) {
                IProcessAreaHandle handle = engine.getProcessArea();
                if (handle instanceof ITeamAreaHandle) {
                    teamAreaHandles.add((ITeamAreaHandle)handle);
                    continue;
                }
                if (!(handle instanceof IProjectAreaHandle)) continue;
                projectAreaHandles.add((IProjectAreaHandle)handle);
            }
            ItemHandleAwareHashMap processAreaMap = new ItemHandleAwareHashMap();
            List teamAreas = this.getPartialItemList(teamAreaHandles, Collections.singletonList("projectArea"), monitor);
            for (ITeamArea teamArea : teamAreas) {
                if (teamArea == null) continue;
                processAreaMap.put((Object)teamArea, (Object)teamArea);
                if (teamArea.getProjectArea() == null) continue;
                projectAreaHandles.add(teamArea.getProjectArea());
            }
            List projectAreas = this.getPartialItemList(projectAreaHandles, Collections.singletonList("name"), monitor);
            for (IProjectArea projectArea : projectAreas) {
                if (projectArea == null) continue;
                processAreaMap.put((Object)projectArea, (Object)projectArea);
            }
            for (IBuildEngine engine : buildEngineIdToItem.values()) {
                IProcessArea processArea = (IProcessArea)processAreaMap.get((Object)engine.getProcessArea());
                IProjectArea projectArea = processArea instanceof ITeamArea ? (IProjectArea)processAreaMap.get((Object)processArea.getProjectArea()) : (IProjectArea)processArea;
                String projectName = projectArea == null ? null : projectArea.getName();
                idToProjectName.put(engine.getId(), projectName);
            }
        }
        return idToProjectName;
    }

    protected List getPartialItemList(List handles, List properties, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getTeamRepository().itemManager().fetchPartialItems(handles, 0, (Collection)properties, monitor);
    }

    public void setProjectAreaName(BuildDefinitionEditor editor, String newProjectAreaName) {
        if (editor.getGeneralPage() == this) {
            this.fBuildProjectAreaName = newProjectAreaName;
        }
    }

    private void createOrAssociateDefaultBuildEngine() {
        IBuildEngine defaultEngine = this.fBuildEngines.get(IBuildEngine.DEFAULT_ENGINE_ID);
        if (this.fTotalEnginesSize == 0) {
            IBuildEngine buildEngine = this.createBuildEngine(IBuildEngine.DEFAULT_ENGINE_ID);
            this.fBuildEngines.put(buildEngine.getId(), buildEngine);
            this.fChangedBuildEngines.put(buildEngine.getId(), buildEngine);
        } else if (this.fTotalEnginesSize == 1 && defaultEngine != null) {
            defaultEngine = this.addSupportedDefinition(defaultEngine.getId());
            this.fChangedBuildEngines.put(defaultEngine.getId(), defaultEngine);
        }
    }

    protected void buildEngineSaved(IBuildEngine buildEngine) {
        this.fBuildEngines.put(buildEngine.getId(), buildEngine);
        Iterator<Map.Entry<String, IBuildEngine>> iterator = this.fChangedBuildEngines.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, IBuildEngine> entry = iterator.next();
            IBuildEngine changedEngine = entry.getValue();
            if (!changedEngine.getItemId().equals((Object)buildEngine.getItemId())) continue;
            iterator.remove();
            break;
        }
    }

    protected String getCurrentProjectAreaName() {
        return this.fBuildProjectAreaName;
    }

    protected boolean isUncategorizedWarningState() {
        return this.fFolderWarningState;
    }

    protected void setUncategorizedWarningState(boolean state) {
        this.fFolderWarningState = state;
    }

    @Override
    protected String getContextHelpId() {
        return "com.ibm.team.build.ui.editor_builddefinitiongeneral";
    }

    @Override
    public Control getFocusControl() {
        return this.fIgnoreWarningsButton;
    }

    protected Button getCreateBuildEngineButton() {
        return this.fCreateEngineButton;
    }

    protected Button getAddBuildEnginesButton() {
        return this.fAddBuildEnginesButton;
    }

    protected Button getRemoveBuildEngineButton() {
        return this.fRemoveBuildEngineButton;
    }

    public Map<String, String> getEngineIdToProject() {
        return this.fEngineIdToProject;
    }

    public Map<String, IBuildEngine> getBuildEngines() {
        return this.fBuildEngines;
    }

    public Map<String, IBuildEngine> getChangedBuildEngines() {
        return this.fChangedBuildEngines;
    }

    protected NewBuildEngineWizard createNewBuildEngineWizard(IProcessArea processArea) {
        IBuildEngine[] existingEngines = this.fBuildEngines.values().toArray(new IBuildEngine[this.fBuildEngines.size()]);
        NewBuildEngineWizard wizard = new NewBuildEngineWizard(processArea, existingEngines){

            @Override
            protected boolean openEditorOnFinish() {
                return false;
            }
        };
        return wizard;
    }

    protected WizardDialog createNewBuildEngineWizardDialog(Shell shell, NewBuildEngineWizard wizard) {
        return new WizardDialog(shell, (IWizard)wizard);
    }

    protected void setAllBuildEnginesFetched(boolean allEnginesFetched) {
        this.allBuildEnginesFetched = allEnginesFetched;
    }
}

