/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.builddefinition;

import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IExpectedContribution;
import com.ibm.team.build.internal.ui.editors.builddefinition.BuildDefinitionEditorMessages;
import com.ibm.team.build.internal.ui.editors.result.BuildResultContributionExtension;
import com.ibm.team.build.internal.ui.editors.result.BuildResultContributionExtensionManager;
import com.ibm.team.build.ui.editors.builddefinition.AbstractConfigurationElementEditor;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class ExpectedContributionsConfigurationEditor
extends AbstractConfigurationElementEditor {
    protected Table fExpectedContributionsTable;
    protected Table fAvailableContributionsTable;
    protected Button fAddContributionButton;
    protected Button fRemoveContributionButton;
    protected HashSet<BuildResultContributionExtension> fExpectedContributions = new HashSet();
    protected List<BuildResultContributionExtension> fAvailableContributions = new LinkedList<BuildResultContributionExtension>();
    private IBuildDefinition fBuildDefinitionWorkingCopy;
    private Section fSection;

    public ExpectedContributionsConfigurationEditor(String elementId, String title) {
        super(elementId, title);
    }

    @Override
    public void createContent(Composite parent, FormToolkit toolkit) {
        this.initialize();
        parent.setLayout((Layout)new GridLayout());
        this.fSection = toolkit.createSection(parent, 384);
        this.fSection.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fSection.setLayout((Layout)new GridLayout(1, false));
        this.fSection.setText(BuildDefinitionEditorMessages.BuildDefinitionEditor_EXPECTED_CONTRIBUTIONS_TITLE);
        this.fSection.setDescription(BuildDefinitionEditorMessages.BuildDefinitionEditor_EXPECTED_CONTRIBUTIONS_DESCRIPTION);
        Composite composite = toolkit.createComposite((Composite)this.fSection);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(3, false);
        composite.setLayout((Layout)layout);
        this.createWidgets(composite);
        this.fSection.setClient((Control)composite);
    }

    private void initialize() {
        BuildResultContributionExtension[] availableExtensions;
        this.fExpectedContributions.clear();
        this.fAvailableContributions.clear();
        BuildResultContributionExtension[] buildResultContributionExtensionArray = availableExtensions = BuildResultContributionExtensionManager.getInstance().getContributionExtensions();
        int n = availableExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            BuildResultContributionExtension extension = buildResultContributionExtensionArray[n2];
            if (extension.getExpectableAttribute()) {
                this.fAvailableContributions.add(extension);
            }
            ++n2;
        }
        List expectedContributions = this.fBuildDefinitionWorkingCopy.getExpectedContributions();
        for (IExpectedContribution contribution : expectedContributions) {
            boolean foundExtension = false;
            for (BuildResultContributionExtension extension : this.fAvailableContributions) {
                if (!extension.getIdAttribute().equals(contribution.getContributionId())) continue;
                foundExtension = true;
                this.fExpectedContributions.add(extension);
                this.fAvailableContributions.remove(extension);
                break;
            }
            if (foundExtension) continue;
            this.fExpectedContributions.add(new BuildResultContributionExtension(contribution.getContributionId(), contribution.getContributionId(), null));
        }
    }

    private void createWidgets(Composite parent) {
        Group availableContributionsGroup = new Group(parent, 0);
        availableContributionsGroup.setText(BuildDefinitionEditorMessages.BuildDefinitionEditor_AVAILABLE_CONTRIBUTION_TYPES);
        availableContributionsGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        availableContributionsGroup.setLayout((Layout)new GridLayout(1, false));
        this.fAvailableContributionsTable = new Table((Composite)availableContributionsGroup, 2050);
        this.fAvailableContributionsTable.setLinesVisible(false);
        this.fAvailableContributionsTable.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fAvailableContributionsTable.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ExpectedContributionsConfigurationEditor.this.fExpectedContributionsTable.deselectAll();
                ExpectedContributionsConfigurationEditor.this.updateExpectedContributionButtons();
            }
        });
        for (BuildResultContributionExtension extension : this.fAvailableContributions) {
            this.addExtensionToTable(extension, this.fAvailableContributionsTable, false);
        }
        Composite buttonComposite = new Composite(parent, 0);
        buttonComposite.setLayoutData((Object)new GridData(-1, 0x1000000, false, true));
        buttonComposite.setLayout((Layout)new GridLayout(1, false));
        this.fAddContributionButton = new Button(buttonComposite, 0);
        this.fAddContributionButton.setText(" > ");
        this.fAddContributionButton.setEnabled(false);
        this.fAddContributionButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TableItem[] items = ExpectedContributionsConfigurationEditor.this.fAvailableContributionsTable.getSelection();
                int index = ExpectedContributionsConfigurationEditor.this.fAvailableContributionsTable.indexOf(items[0]);
                TableItem[] tableItemArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    BuildResultContributionExtension extension = (BuildResultContributionExtension)item.getData();
                    item.dispose();
                    ExpectedContributionsConfigurationEditor.this.fExpectedContributions.add(extension);
                    ExpectedContributionsConfigurationEditor.this.addExtensionToTable(extension, ExpectedContributionsConfigurationEditor.this.fExpectedContributionsTable, true);
                    ++n2;
                }
                if (index < ExpectedContributionsConfigurationEditor.this.fAvailableContributionsTable.getItemCount()) {
                    ExpectedContributionsConfigurationEditor.this.fAvailableContributionsTable.select(index);
                } else if (index > 0 && ExpectedContributionsConfigurationEditor.this.fAvailableContributionsTable.getItemCount() > index - 1) {
                    ExpectedContributionsConfigurationEditor.this.fAvailableContributionsTable.select(index - 1);
                }
                ExpectedContributionsConfigurationEditor.this.updateExpectedContributionButtons();
                ExpectedContributionsConfigurationEditor.this.updateDefinition();
                ExpectedContributionsConfigurationEditor.this.setDirty(true);
            }
        });
        this.fRemoveContributionButton = new Button(buttonComposite, 0);
        this.fRemoveContributionButton.setText(" < ");
        this.fRemoveContributionButton.setEnabled(false);
        this.fRemoveContributionButton.setLayoutData((Object)new GridData(4, -1, true, false));
        this.fRemoveContributionButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TableItem[] items = ExpectedContributionsConfigurationEditor.this.fExpectedContributionsTable.getSelection();
                int index = ExpectedContributionsConfigurationEditor.this.fExpectedContributionsTable.indexOf(items[0]);
                TableItem[] tableItemArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    BuildResultContributionExtension extension = (BuildResultContributionExtension)item.getData();
                    item.dispose();
                    ExpectedContributionsConfigurationEditor.this.fExpectedContributions.remove(extension);
                    ExpectedContributionsConfigurationEditor.this.addExtensionToTable(extension, ExpectedContributionsConfigurationEditor.this.fAvailableContributionsTable, true);
                    ++n2;
                }
                if (index < ExpectedContributionsConfigurationEditor.this.fExpectedContributionsTable.getItemCount()) {
                    ExpectedContributionsConfigurationEditor.this.fExpectedContributionsTable.select(index);
                } else if (index > 0 && ExpectedContributionsConfigurationEditor.this.fExpectedContributionsTable.getItemCount() > index - 1) {
                    ExpectedContributionsConfigurationEditor.this.fExpectedContributionsTable.select(index - 1);
                }
                ExpectedContributionsConfigurationEditor.this.updateExpectedContributionButtons();
                ExpectedContributionsConfigurationEditor.this.updateDefinition();
                ExpectedContributionsConfigurationEditor.this.setDirty(true);
            }
        });
        Group expectedContributionsGroup = new Group(parent, 0);
        expectedContributionsGroup.setText(BuildDefinitionEditorMessages.BuildDefinitionEditor_EXPECTED_CONTRIBUTION_TYPES);
        expectedContributionsGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        expectedContributionsGroup.setLayout((Layout)new GridLayout(1, false));
        this.fExpectedContributionsTable = new Table((Composite)expectedContributionsGroup, 2050);
        this.fExpectedContributionsTable.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fExpectedContributionsTable.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ExpectedContributionsConfigurationEditor.this.fAvailableContributionsTable.deselectAll();
                ExpectedContributionsConfigurationEditor.this.updateExpectedContributionButtons();
            }
        });
        for (BuildResultContributionExtension extension : this.fExpectedContributions) {
            this.addExtensionToTable(extension, this.fExpectedContributionsTable, false);
        }
    }

    private void updateDefinition() {
        List expectedContributions = this.fBuildDefinitionWorkingCopy.getExpectedContributions();
        expectedContributions.clear();
        for (BuildResultContributionExtension extension : this.fExpectedContributions) {
            IExpectedContribution contribution = BuildItemFactory.createExpectedContribution();
            contribution.setContributionId(extension.getIdAttribute());
            expectedContributions.add(contribution);
        }
    }

    @Override
    public boolean validate() {
        return true;
    }

    private void updateExpectedContributionButtons() {
        if (this.fAvailableContributionsTable.getSelectionIndex() != -1) {
            this.fAddContributionButton.setEnabled(true);
            this.fRemoveContributionButton.setEnabled(false);
        } else {
            this.fAddContributionButton.setEnabled(false);
            this.fRemoveContributionButton.setEnabled(this.fExpectedContributionsTable.getSelectionIndex() != -1);
        }
    }

    private void addExtensionToTable(BuildResultContributionExtension extension, Table table, boolean isModification) {
        TableItem item = new TableItem(table, 0);
        item.setText(extension.getNameAttribute());
        item.setData((Object)extension);
    }

    @Override
    public void setWorkingCopy(IBuildDefinition definition) {
        this.fBuildDefinitionWorkingCopy = definition;
    }

    @Override
    public Control getFocusControl() {
        if (this.getAvailableContributionsTable().getItemCount() > 0) {
            return this.fAvailableContributionsTable;
        }
        return this.fExpectedContributionsTable;
    }

    protected Table getAvailableContributionsTable() {
        return this.fAvailableContributionsTable;
    }

    @Override
    protected String getContextHelpId() {
        return "com.ibm.team.build.ui.editor_builddefinitioncontributions";
    }
}

