/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.builddefinition;

import com.ibm.team.build.common.builddefinition.BuildConfigurationRegistry;
import com.ibm.team.build.common.model.IBuildConfigurationElement;
import com.ibm.team.build.internal.ui.editors.builddefinition.BuildConfigurationElementEditorExtension;
import com.ibm.team.build.internal.ui.editors.builddefinition.BuildConfigurationElementEditorExtensionManager;
import com.ibm.team.build.internal.ui.editors.builddefinition.BuildDefinitionEditorMessages;
import com.ibm.team.build.internal.ui.editors.builddefinition.IConfigurationListener;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class ConfigurationEditingControl {
    protected ListenerList fListeners = new ListenerList();
    protected Button fUpButton;
    protected Button fDownButton;
    protected Label fDescriptionLabel;
    protected CheckboxTableViewer fTableViewer;
    private List<String> fAvailableElementIds;
    private List<String> fSelectedElementIds;
    private List<String> fEditableAvailableElementIds;
    private List<String> fEditableSelectedElementIds;
    protected boolean fAllowReordering;
    private Composite fContainer;

    public ConfigurationEditingControl(Composite parent, boolean allowReordering) {
        this.fAllowReordering = allowReordering;
        this.fContainer = this.createContent(parent);
    }

    public Composite getControl() {
        return this.fContainer;
    }

    private Composite createContent(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        container.setLayout((Layout)gridLayout);
        container.setLayoutData((Object)new GridData(1808));
        this.createConfigElementTable(container);
        if (this.fAllowReordering) {
            this.createButtonBar(container);
        }
        this.createDescriptionControl(container);
        return container;
    }

    public void initialize(List<String> availableElementIds, List<String> selectedElementIds) {
        this.fAvailableElementIds = availableElementIds;
        this.fSelectedElementIds = selectedElementIds;
        this.fEditableAvailableElementIds = this.getEditableElementIds(availableElementIds);
        this.fEditableSelectedElementIds = this.getEditableElementIds(selectedElementIds);
        this.fTableViewer.setInput(this.fEditableAvailableElementIds);
        for (String elementId : this.fEditableSelectedElementIds) {
            this.fTableViewer.setChecked((Object)elementId, true);
        }
    }

    public void addListener(IConfigurationListener listener) {
        this.fListeners.add((Object)listener);
    }

    public void removeListener(IConfigurationListener listener) {
        this.fListeners.remove((Object)listener);
    }

    private void createConfigElementTable(Composite parent) {
        this.fTableViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)2052);
        this.fTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object object) {
                String text = super.getText(object);
                IBuildConfigurationElement element = BuildConfigurationRegistry.getInstance().getBuildConfigurationElement((String)object);
                if (element != null) {
                    text = element.getName();
                }
                return text;
            }
        });
        this.fTableViewer.addCheckStateListener(this.getCheckStateListener());
        this.fTableViewer.addSelectionChangedListener(this.getSelectionChangedListener());
        this.fTableViewer.getTable().setEnabled(true);
        this.fTableViewer.setAllChecked(true);
        GridData gridData = new GridData(1808);
        if (!this.fAllowReordering) {
            gridData.horizontalSpan = 2;
        }
        this.fTableViewer.getTable().setLayoutData((Object)gridData);
        this.fTableViewer.getTable().pack(true);
    }

    protected ISelectionChangedListener getSelectionChangedListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ConfigurationEditingControl.this.handleConfigElementSelectionChanged(event.getSelection());
            }
        };
    }

    protected ICheckStateListener getCheckStateListener() {
        return new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getChecked()) {
                    ConfigurationEditingControl.this.fSelectedElementIds.add((String)event.getElement());
                    ConfigurationEditingControl.this.fEditableSelectedElementIds.add((String)event.getElement());
                } else {
                    ConfigurationEditingControl.this.fSelectedElementIds.remove(event.getElement());
                    ConfigurationEditingControl.this.fEditableSelectedElementIds.remove(event.getElement());
                }
                ConfigurationEditingControl.this.fTableViewer.setSelection((ISelection)new StructuredSelection(event.getElement()));
                Object[] objectArray = ConfigurationEditingControl.this.fListeners.getListeners();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    IConfigurationListener listener = (IConfigurationListener)object;
                    listener.configurationChanged();
                    ++n2;
                }
            }
        };
    }

    private void createButtonBar(Composite parent) {
        Composite buttonBar = new Composite(parent, 0);
        GridData gridData = new GridData(131072, -1, false, false);
        buttonBar.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        buttonBar.setLayout((Layout)gridLayout);
        this.fUpButton = new Button(buttonBar, 8);
        this.fUpButton.setText(BuildDefinitionEditorMessages.ConfigurationEditingControl_MOVE_UP);
        this.fUpButton.addSelectionListener(this.getUpButtonListener());
        this.fUpButton.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fDownButton = new Button(buttonBar, 8);
        this.fDownButton.setText(BuildDefinitionEditorMessages.ConfigurationEditingControl_MOVE_DOWN);
        this.fDownButton.addSelectionListener(this.getDownButtonListener());
        this.fDownButton.setLayoutData((Object)new GridData(4, 4, true, true));
    }

    protected SelectionListener getDownButtonListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigurationEditingControl.this.moveConfigElement(false);
            }
        };
    }

    protected SelectionListener getUpButtonListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigurationEditingControl.this.moveConfigElement(true);
            }
        };
    }

    private void updateButtons() {
        if (this.fAllowReordering) {
            Table table = this.fTableViewer.getTable();
            int itemCount = table.getItemCount();
            int selectionCount = table.getSelectionCount();
            int selectionIndex = table.getSelectionIndex();
            this.fUpButton.setEnabled(selectionCount == 1 && selectionIndex > 0);
            this.fDownButton.setEnabled(selectionCount == 1 && selectionIndex < itemCount - 1);
        }
    }

    private Control createDescriptionControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().applyTo(container);
        Label label = new Label(container, 0);
        label.setLayoutData((Object)new GridData(16384, 128, false, false));
        label.setText(BuildDefinitionEditorMessages.ConfigurationEditingControl_DESCRIPTION);
        this.fDescriptionLabel = new Label(container, 64);
        GridDataFactory.fillDefaults().indent(10, 0).grab(true, false).applyTo((Control)this.fDescriptionLabel);
        return container;
    }

    private void moveConfigElement(boolean up) {
        Table table = this.fTableViewer.getTable();
        int origin = table.getSelectionIndex();
        String elementId = (String)this.fTableViewer.getElementAt(origin);
        if (up) {
            this.moveUp(elementId, this.fAvailableElementIds);
            this.moveUp(elementId, this.fEditableAvailableElementIds);
        } else {
            this.moveDown(elementId, this.fAvailableElementIds);
            this.moveDown(elementId, this.fEditableAvailableElementIds);
        }
        this.fTableViewer.refresh();
        this.updateButtons();
        Object[] objectArray = this.fListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            IConfigurationListener listener = (IConfigurationListener)object;
            listener.configurationChanged();
            ++n2;
        }
    }

    private void moveUp(String elementId, List<String> elementIds) {
        int index = elementIds.indexOf(elementId);
        if (index > 0) {
            elementIds.remove(elementId);
            elementIds.add(index - 1, elementId);
        }
    }

    private void moveDown(String elementId, List<String> elementIds) {
        int index = elementIds.indexOf(elementId);
        if (index < elementIds.size() - 1) {
            elementIds.remove(elementId);
            elementIds.add(index + 1, elementId);
        }
    }

    private void handleConfigElementSelectionChanged(ISelection selection) {
        if (this.fDescriptionLabel != null && !this.fDescriptionLabel.isDisposed()) {
            IBuildConfigurationElement element;
            Object object;
            IStructuredSelection structuredSelection;
            String description = null;
            if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1 && (object = structuredSelection.getFirstElement()) instanceof String && (element = BuildConfigurationRegistry.getInstance().getBuildConfigurationElement((String)object)) != null) {
                description = element.getDescription();
            }
            this.fDescriptionLabel.setText(description == null ? "" : description);
            this.fDescriptionLabel.getParent().getParent().layout(true);
        }
        this.updateButtons();
    }

    private List<String> getEditableElementIds(List<String> availableElementIds) {
        LinkedList<String> editableElementIds = new LinkedList<String>();
        for (String elementId : availableElementIds) {
            BuildConfigurationElementEditorExtension editorExtension = BuildConfigurationElementEditorExtensionManager.getInstance().getBuildConfigurationElementEditor(elementId);
            if (editorExtension == null) continue;
            editableElementIds.add(elementId);
        }
        return editableElementIds;
    }
}

