/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.builddefinition;

import com.ibm.team.build.common.builddefinition.EnvironmentVariablePolicy;
import com.ibm.team.build.internal.ui.editors.builddefinition.BasicConfigurationElementEditor;
import com.ibm.team.build.internal.ui.editors.builddefinition.BuildDefinitionEditorMessages;
import java.util.Locale;
import javax.swing.ButtonGroup;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class CommandLineConfigurationEditor
extends BasicConfigurationElementEditor {
    protected Text fCommandLineText;
    protected Text fArgumentsText;
    protected Text fWorkingDirText;
    protected Text fEnvironmentVariablePrefix;
    protected Button noEnvVarsButton;
    protected Button addEnvVarsButton;
    protected Button overrideEnvVarsButton;
    protected Button replaceEnvVarsButton;
    protected ButtonGroup fEnvironmentVarsGroup;
    protected Text fPropertiesFileText;

    public CommandLineConfigurationEditor(String elementId, String title) {
        super(elementId, title);
    }

    @Override
    public void createContent(Composite parent, FormToolkit toolkit) {
        parent.setLayout((Layout)new TableWrapLayout());
        Section section = this.createSection(parent, BuildDefinitionEditorMessages.CommandLineConfigurationEditor_SECTION_TITLE, BuildDefinitionEditorMessages.CommandLineConfigurationEditor_SECTION_DESC, false);
        Composite composite = (Composite)section.getClient();
        this.createCommandWidgets(composite);
        this.createArgumentsWidgets(composite);
        this.createWorkingDirWidgets(composite);
        this.createPropertiesFileWidgets(composite);
        this.createEnvironmentVariablesWidgets(composite);
    }

    private void createCommandWidgets(Composite parent) {
        this.fCommandLineText = this.createConfigPropertyTextField(parent, "com.ibm.team.build.cmdline.command", BuildDefinitionEditorMessages.CommandLineConfigurationEditor_COMMAND_LABEL, BuildDefinitionEditorMessages.CommandLineConfigurationEditor_COMMAND_DESC, true);
    }

    private void createArgumentsWidgets(Composite parent) {
        this.createSpacer(parent, 10, 2);
        this.fArgumentsText = this.createConfigPropertyTextField(parent, "com.ibm.team.build.cmdline.arguments", BuildDefinitionEditorMessages.CommandLineConfigurationEditor_ARGUMENTS_LABEL, BuildDefinitionEditorMessages.CommandLineConfigurationEditor_ARGUMENTS_DESCRIPTION, false);
    }

    private void createWorkingDirWidgets(Composite parent) {
        this.createSpacer(parent, 10, 2);
        this.fWorkingDirText = this.createConfigPropertyTextField(parent, "com.ibm.team.build.cmdline.workingDir", BuildDefinitionEditorMessages.CommandLineConfigurationEditor_WORKING_DIR_LABEL, BuildDefinitionEditorMessages.CommandLineConfigurationEditor_WORKING_DIR_DESC, false);
    }

    private void createEnvironmentVariablesWidgets(Composite parent) {
        this.createSpacer(parent, 4, 2);
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        Composite labelComposite = toolkit.createComposite(parent);
        GridLayoutFactory.fillDefaults().applyTo(labelComposite);
        labelComposite.setLayoutData((Object)new TableWrapData(2, 16));
        Label groupLabel = toolkit.createLabel(labelComposite, BuildDefinitionEditorMessages.CommandLineConfigurationEditor_ENVIRONMENT_VARIABLES_LABEL);
        Composite group = new Composite(parent, 0);
        group.setLayout((Layout)new TableWrapLayout());
        group.setLayoutData((Object)new TableWrapData(256, 256, 1, 1));
        GridDataFactory.fillDefaults().indent(0, group.getClientArea().y + 6).applyTo((Control)groupLabel);
        EnvironmentVariablePolicy policy = this.getEnvironmentVariablePolicy();
        this.noEnvVarsButton = toolkit.createButton(group, BuildDefinitionEditorMessages.CommandLineConfigurationEditor_ENVIRONMENT_VARIABLES_NONE_BUTTON, 16);
        this.noEnvVarsButton.setSelection(policy.equals((Object)EnvironmentVariablePolicy.NONE));
        this.noEnvVarsButton.addSelectionListener(this.getNoneEnvironmentVariablesListener());
        this.noEnvVarsButton.setData((Object)EnvironmentVariablePolicy.NONE);
        this.noEnvVarsButton.setLayoutData((Object)new TableWrapData());
        this.addEnvVarsButton = toolkit.createButton(group, BuildDefinitionEditorMessages.CommandLineConfigurationEditor_ENVIRONMENT_VARIABLES_ADD_BUTTON, 16);
        this.addEnvVarsButton.setSelection(policy.equals((Object)EnvironmentVariablePolicy.ADD) || policy.equals((Object)EnvironmentVariablePolicy.OVERRIDE));
        this.addEnvVarsButton.addSelectionListener(this.getAddEnvironmentVariablesListener());
        this.addEnvVarsButton.setData((Object)EnvironmentVariablePolicy.ADD);
        this.addEnvVarsButton.setLayoutData((Object)new TableWrapData());
        this.overrideEnvVarsButton = toolkit.createButton(group, BuildDefinitionEditorMessages.CommandLineConfigurationEditor_ENVIRONMENT_VARIABLES_OVERRIDE_BUTTON, 32);
        this.overrideEnvVarsButton.setSelection(policy.equals((Object)EnvironmentVariablePolicy.OVERRIDE));
        this.overrideEnvVarsButton.setEnabled(policy.equals((Object)EnvironmentVariablePolicy.ADD) || policy.equals((Object)EnvironmentVariablePolicy.OVERRIDE));
        this.overrideEnvVarsButton.addSelectionListener(this.getOverrideEnvironmentVariablesListener());
        this.overrideEnvVarsButton.setData((Object)EnvironmentVariablePolicy.OVERRIDE);
        TableWrapData data = new TableWrapData();
        data.indent = LayoutConstants.getMargins().x * 2;
        this.overrideEnvVarsButton.setLayoutData((Object)data);
        this.replaceEnvVarsButton = toolkit.createButton(group, BuildDefinitionEditorMessages.CommandLineConfigurationEditor_ENVIRONMENT_VARIABLES_REPLACE_BUTTON, 16);
        this.replaceEnvVarsButton.setSelection(policy.equals((Object)EnvironmentVariablePolicy.REPLACE));
        this.replaceEnvVarsButton.setData((Object)EnvironmentVariablePolicy.REPLACE);
        this.replaceEnvVarsButton.addSelectionListener(this.getReplaceEnvironmentVariablesListener());
        this.replaceEnvVarsButton.setLayoutData((Object)new TableWrapData());
        this.createSpacer(parent, -1, 1);
        Label descriptionLabel = toolkit.createLabel(parent, BuildDefinitionEditorMessages.CommandLineConfigurationEditor_ENVIRONMENT_VARIABLES_DESC, 64);
        descriptionLabel.setLayoutData((Object)new TableWrapData(256));
        descriptionLabel.setForeground(Display.getDefault().getSystemColor(16));
        this.createSpacer(parent, 10, 2);
        this.fEnvironmentVariablePrefix = this.createConfigPropertyTextField(parent, "com.ibm.team.build.cmdline.environmentVariablePrefix", "", BuildDefinitionEditorMessages.CommandLineConfigurationEditor_ENVIRONMENT_VARIABLES_PREFIX_DESC, false);
    }

    protected SelectionListener getNoneEnvironmentVariablesListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CommandLineConfigurationEditor.this.noEnvVarsButton.getSelection()) {
                    CommandLineConfigurationEditor.this.saveEnvironmentPolicyToProperty((EnvironmentVariablePolicy)CommandLineConfigurationEditor.this.noEnvVarsButton.getData());
                    CommandLineConfigurationEditor.this.setDirty(true);
                }
            }
        };
    }

    protected SelectionListener getAddEnvironmentVariablesListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CommandLineConfigurationEditor.this.addEnvVarsButton.getSelection()) {
                    CommandLineConfigurationEditor.this.overrideEnvVarsButton.setEnabled(true);
                    CommandLineConfigurationEditor.this.saveAddEnvironmentProperty();
                    CommandLineConfigurationEditor.this.setDirty(true);
                } else {
                    CommandLineConfigurationEditor.this.overrideEnvVarsButton.setEnabled(false);
                }
            }
        };
    }

    protected SelectionListener getOverrideEnvironmentVariablesListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommandLineConfigurationEditor.this.saveAddEnvironmentProperty();
                CommandLineConfigurationEditor.this.setDirty(true);
            }
        };
    }

    private void saveAddEnvironmentProperty() {
        if (this.overrideEnvVarsButton.getSelection()) {
            this.saveEnvironmentPolicyToProperty((EnvironmentVariablePolicy)this.overrideEnvVarsButton.getData());
        } else {
            this.saveEnvironmentPolicyToProperty((EnvironmentVariablePolicy)this.addEnvVarsButton.getData());
        }
    }

    protected SelectionListener getReplaceEnvironmentVariablesListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CommandLineConfigurationEditor.this.replaceEnvVarsButton.getSelection()) {
                    CommandLineConfigurationEditor.this.saveEnvironmentPolicyToProperty((EnvironmentVariablePolicy)CommandLineConfigurationEditor.this.replaceEnvVarsButton.getData());
                    CommandLineConfigurationEditor.this.setDirty(true);
                }
            }
        };
    }

    private void saveEnvironmentPolicyToProperty(EnvironmentVariablePolicy policy) {
        this.fWorkingCopy.setConfigurationProperty("com.ibm.team.build.cmdline", "com.ibm.team.build.cmdline.environmentVariablePolicy", policy.name());
    }

    private void createPropertiesFileWidgets(Composite parent) {
        this.createSpacer(parent, 10, 2);
        this.fPropertiesFileText = this.createConfigPropertyTextField(parent, "com.ibm.team.build.cmdline.propertiesFile", BuildDefinitionEditorMessages.CommandLineConfigurationEditor_PROPERTIES_LABEL, BuildDefinitionEditorMessages.CommandLineConfigurationEditor_PROPERTIES_DESC, false);
    }

    @Override
    public boolean validate() {
        boolean isValid = true;
        if (this.fCommandLineText.getText().trim().equals("")) {
            this.addErrorMessageForRequiredField(this.fCommandLineText, BuildDefinitionEditorMessages.CommandLineConfigurationEditor_COMMAND_REQUIRED, (Control)this.fCommandLineText);
            isValid = false;
        } else {
            this.removeMessage(this.fCommandLineText, (Control)this.fCommandLineText);
        }
        this.setPageStatusIndicator(!isValid, false);
        return isValid;
    }

    @Override
    public Control getFocusControl() {
        return this.fCommandLineText;
    }

    @Override
    protected String getContextHelpId() {
        return "com.ibm.team.build.ui.editor_builddefinitioncommand";
    }

    protected EnvironmentVariablePolicy getEnvironmentVariablePolicy() {
        EnvironmentVariablePolicy policy = EnvironmentVariablePolicy.NONE;
        String environmentVariablesPolicyValue = this.fWorkingCopy.getConfigurationPropertyValue("com.ibm.team.build.cmdline", "com.ibm.team.build.cmdline.environmentVariablePolicy", String.valueOf(EnvironmentVariablePolicy.NONE));
        try {
            policy = EnvironmentVariablePolicy.valueOf((String)environmentVariablesPolicyValue.trim().toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return policy;
    }
}

