/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.builddefinition;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildFolderHandle;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.repository.client.ITeamRepository;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

public class BuildDefinitionEditorInput
implements IEditorInput {
    private IBuildDefinition fBuildDefinition;
    private boolean fNewBuildDefinition;
    private ITeamRepository fTeamRepository;
    private IProcessArea fProcessArea;
    private IBuildFolderHandle fParentBuildFolderHandle;
    private String fInitialPageId;
    private IBuildDefinitionHandle fBuildDefinitionTemplate;

    public BuildDefinitionEditorInput(IBuildDefinition buildDefinition, IProcessArea processArea, ITeamRepository teamRepository, boolean isNew) {
        this(buildDefinition, processArea, teamRepository, null, isNew);
    }

    public BuildDefinitionEditorInput(IBuildDefinition buildDefinition, IProcessArea processArea, ITeamRepository teamRepository, IBuildFolderHandle parentBuildFolderHandle, boolean isNew) {
        this.fTeamRepository = teamRepository;
        this.fProcessArea = processArea;
        this.fNewBuildDefinition = isNew;
        this.fBuildDefinition = buildDefinition;
        this.fParentBuildFolderHandle = parentBuildFolderHandle;
    }

    public boolean isNewBuildDefinition() {
        return this.fNewBuildDefinition;
    }

    public IBuildDefinition getBuildDefinition() {
        return this.fBuildDefinition;
    }

    public ITeamRepository getTeamRepository() {
        return this.fTeamRepository;
    }

    public IBuildFolderHandle getParentFolder() {
        return this.fParentBuildFolderHandle;
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return BuildUIPlugin.getImageDescriptor("icons/obj16/build_type_obj.gif");
    }

    public String getName() {
        return this.fBuildDefinition.getId();
    }

    public String getToolTipText() {
        return this.fBuildDefinition.getId();
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public IProcessArea getProcessArea() {
        return this.fProcessArea;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BuildDefinitionEditorInput)) {
            return false;
        }
        BuildDefinitionEditorInput input = (BuildDefinitionEditorInput)obj;
        return this.getBuildDefinition().getItemId().equals((Object)input.getBuildDefinition().getItemId());
    }

    public int hashCode() {
        return this.getBuildDefinition().getItemId().hashCode();
    }

    public String getInitialPageId() {
        return this.fInitialPageId;
    }

    public void setInitialPageId(String pageId) {
        this.fInitialPageId = pageId;
    }

    public IBuildDefinitionHandle getBuildDefinitionTemplate() {
        return this.fBuildDefinitionTemplate;
    }

    public void setBuildDefinitionTemplate(IBuildDefinitionHandle buildDefinitionTemplate) {
        this.fBuildDefinitionTemplate = buildDefinitionTemplate;
    }
}

