/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.builddefinition;

import com.ibm.team.build.client.ClientFactory;
import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.common.builddefinition.BuildConfigurationRegistry;
import com.ibm.team.build.common.model.BuildPhase;
import com.ibm.team.build.common.model.IBuildConfigurationElement;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.common.model.IBuildEngineHandle;
import com.ibm.team.build.common.model.IBuildFolder;
import com.ibm.team.build.common.model.IBuildFolderHandle;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.common.model.query.IBaseBuildEngineQueryModel;
import com.ibm.team.build.internal.client.ITeamBuildRecordClient;
import com.ibm.team.build.internal.client.iterator.ItemQueryIterator;
import com.ibm.team.build.internal.common.builddefinition.BuildConfigurationElementExtension;
import com.ibm.team.build.internal.common.builddefinition.BuildConfigurationElementExtensionManager;
import com.ibm.team.build.internal.common.model.dto.DtoFactory;
import com.ibm.team.build.internal.common.model.dto.IBuildItemNamePair;
import com.ibm.team.build.internal.common.model.dto.impl.BuildItemNamePairImpl;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.dialogs.RequestBuildDialog;
import com.ibm.team.build.internal.ui.domain.ConnectedProjectAreaRegistryHelper;
import com.ibm.team.build.internal.ui.editors.BuildItemEditor;
import com.ibm.team.build.internal.ui.editors.BuildItemEditorJob;
import com.ibm.team.build.internal.ui.editors.builddefinition.BuildConfigurationElementEditorExtension;
import com.ibm.team.build.internal.ui.editors.builddefinition.BuildConfigurationElementEditorExtensionManager;
import com.ibm.team.build.internal.ui.editors.builddefinition.BuildDefinitionEditorInput;
import com.ibm.team.build.internal.ui.editors.builddefinition.BuildDefinitionEditorMessages;
import com.ibm.team.build.internal.ui.editors.builddefinition.EditConfigurationDialog;
import com.ibm.team.build.internal.ui.editors.builddefinition.GeneralConfigurationEditor;
import com.ibm.team.build.internal.ui.helper.BuildUIHelper;
import com.ibm.team.build.internal.ui.helper.EnterpriseHelper;
import com.ibm.team.build.internal.ui.wizards.builddefinition.Messages;
import com.ibm.team.build.ui.editors.builddefinition.AbstractConfigurationElementEditor;
import com.ibm.team.build.ui.editors.builddefinition.IConfigurationElementEditorFactory;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.advice.IOperationReport;
import com.ibm.team.process.common.advice.TeamOperationCanceledException;
import com.ibm.team.process.rcp.ui.ProcessAreaSelectionDialog;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.service.IQueryService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class BuildDefinitionEditor
extends BuildItemEditor {
    public static final String TOPIC_BUILD_ENGINE_FETCH = "com/ibm/team/build/internal/ui/editors/builddefinition/BuildDefinitionEditor/AsyncBuildEngineFetchSuccessful";
    private BuildDefinitionEditorInput fEditorInput;
    protected IBuildDefinition fBuildDefinition;
    protected IProcessArea fProcessArea;
    private int fAllEnginesSize = 0;
    private IBuildItemNamePair[] fParentFolders;
    private IBuildFolderHandle fParentFolderHandle;
    protected Text fIdText;
    private Text fProcessAreaText;
    private Button fChangeProcessAreaButton;
    protected boolean fIsNewDefinition;
    protected boolean fDirty;
    protected Map<String, IBuildEngine> fBuildEngineIdToItem = new HashMap<String, IBuildEngine>();
    protected Map<String, String> fBuildEngineIdToProjectAreaName = new HashMap<String, String>();
    private String fProjectAreaName;
    protected Action fRequestBuildAction;
    private ModifyListener fIdModifiedListener = this.getIdModifiedListener();
    protected boolean fSaveAttempted;

    @Override
    protected void createHeaderContents(IManagedForm headerForm) {
        this.getToolkit().setBorderStyle(2048);
        this.fRequestBuildAction = this.createRequestBuildAction();
        if (this.fIsNewDefinition) {
            this.fRequestBuildAction.setEnabled(false);
        } else {
            this.fRequestBuildAction.setEnabled(true);
        }
        IToolBarManager toolBarManager = headerForm.getForm().getForm().getToolBarManager();
        if (EnterpriseHelper.canRequestFromBaseBuildUI(this.fBuildDefinition)) {
            toolBarManager.add((IAction)this.fRequestBuildAction);
        }
        headerForm.getForm().getForm().updateToolBar();
        this.createContextMenu(headerForm.getForm().getForm());
        super.createHeaderContents(headerForm);
        this.createHeaderSecondRow(headerForm);
    }

    protected void createContextMenu(Form form) {
        IMenuManager menuMgr = form.getMenuManager();
        menuMgr.add((IContributionItem)new Separator("additions"));
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(this.getMenuListener());
    }

    protected IMenuListener getMenuListener() {
        return new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add(BuildDefinitionEditor.this.getConfigureAction());
            }
        };
    }

    protected IAction getConfigureAction() {
        return new Action(BuildDefinitionEditorMessages.BuildDefinitionEditor_EDIT_CONFIGURATION_ACTION){

            public void runWithEvent(Event event) {
                EditConfigurationDialog dialog = BuildDefinitionEditor.this.getEditConfigurationDialog();
                if (event != null && (event.stateMask & 0x40000) != 0) {
                    dialog.setIgnoreTemplate(true);
                }
                if (dialog.open() == 0) {
                    BuildDefinitionEditor.this.updateDefinitionAndPages(dialog.getOrderedSelectedElementIds(BuildPhase.UNSPECIFIED), dialog.getOrderedSelectedElementIds(BuildPhase.PRE_BUILD), dialog.getOrderedSelectedElementIds(BuildPhase.POST_BUILD));
                    BuildDefinitionEditor.this.fDirty = true;
                    BuildDefinitionEditor.this.fireDirtyPropertyChangeEvent();
                }
            }

            public void run() {
                this.runWithEvent(null);
            }
        };
    }

    protected EditConfigurationDialog getEditConfigurationDialog() {
        return new EditConfigurationDialog(this.getSite().getShell(), this.fBuildDefinition);
    }

    protected void updateDefinitionAndPages(List<String> selectedUnspecifiedElementIds, List<String> selectedPreBuildElementIds, List<String> selectedPostBuildElementIds) {
        LinkedHashMap<String, IBuildConfigurationElement> originalElements = new LinkedHashMap<String, IBuildConfigurationElement>();
        Iterator iterator = this.fBuildDefinition.getConfigurationElements().iterator();
        while (iterator.hasNext()) {
            IBuildConfigurationElement element = (IBuildConfigurationElement)iterator.next();
            originalElements.put(element.getElementId(), element);
            iterator.remove();
        }
        this.addOriginalAndNewElements(originalElements, selectedUnspecifiedElementIds);
        this.addOriginalAndNewElements(originalElements, selectedPreBuildElementIds);
        for (IBuildConfigurationElement element : originalElements.values()) {
            if (element.getBuildPhase() != BuildPhase.BUILD) continue;
            this.fBuildDefinition.getConfigurationElements().add(element);
        }
        this.addOriginalAndNewElements(originalElements, selectedPostBuildElementIds);
        ArrayList<String> removedElementIds = new ArrayList<String>();
        for (String originalElementId : originalElements.keySet()) {
            if (this.fBuildDefinition.getConfigurationElement(originalElementId) != null) continue;
            removedElementIds.add(originalElementId);
        }
        ArrayList<String> addedElementIds = new ArrayList<String>();
        for (Object object : this.fBuildDefinition.getConfigurationElements()) {
            IBuildConfigurationElement currentElement = (IBuildConfigurationElement)object;
            if (originalElements.containsKey(currentElement.getElementId())) continue;
            addedElementIds.add(currentElement.getElementId());
        }
        this.removeBuiltInSettings(this.fBuildDefinition, removedElementIds);
        this.removePages(removedElementIds);
        this.addPages(addedElementIds, true);
        if (this.getPages().length == 1) {
            this.setActivePage(0);
        }
        if (removedElementIds.size() > 0) {
            this.getMessageManager().removeAllMessages();
            int i = 0;
            while (i < this.getPages().length) {
                this.setPageImage(i, null);
                ++i;
            }
        }
    }

    protected IMessageManager getMessageManager() {
        return this.fMessageManager;
    }

    private void removeBuiltInSettings(IBuildDefinition buildDefinition, List<String> removedElementIds) {
        for (String elementId : removedElementIds) {
            this.removeGenericPropertiesForElement(buildDefinition, elementId);
            if (elementId.equals("com.ibm.team.build.schedule")) {
                buildDefinition.getBuildSchedule().setScheduleEnabled(false);
                continue;
            }
            if (elementId.equals("com.ibm.team.build.expectedContributions")) {
                buildDefinition.getExpectedContributions().clear();
                continue;
            }
            if (elementId.equals("com.ibm.team.build.properties")) {
                this.removeEditableProperties(buildDefinition);
                continue;
            }
            if (!elementId.equals("com.ibm.team.build.general")) continue;
            buildDefinition.getBuildResultPruningPolicy().setEnabled(false);
        }
    }

    private void removeEditableProperties(IBuildDefinition buildDefinition) {
        Iterator iterator = buildDefinition.getProperties().iterator();
        while (iterator.hasNext()) {
            IBuildProperty property = (IBuildProperty)iterator.next();
            if (!property.isGenericEditAllowed()) continue;
            iterator.remove();
        }
    }

    private void removeGenericPropertiesForElement(IBuildDefinition buildDefinition, String elementId) {
        BuildConfigurationElementExtension elementExtension = BuildConfigurationElementExtensionManager.getInstance().getBuildConfigurationElement(elementId);
        if (elementExtension != null) {
            IBuildProperty[] elementGenericProperties;
            IBuildProperty[] iBuildPropertyArray = elementGenericProperties = elementExtension.getGenericProperties();
            int n = elementGenericProperties.length;
            int n2 = 0;
            while (n2 < n) {
                IBuildProperty elementProperty = iBuildPropertyArray[n2];
                IBuildProperty definitionProperty = buildDefinition.getProperty(elementProperty.getName());
                if (definitionProperty != null) {
                    buildDefinition.getProperties().remove(definitionProperty);
                }
                ++n2;
            }
        }
    }

    protected void addPages(List<String> addedElementIds) {
        this.addPages(addedElementIds, false);
    }

    protected void addPages(List<String> addedElementIds, boolean isAddedThroughEditConfiguration) {
        for (String elementId : addedElementIds) {
            try {
                this.addPage(elementId, isAddedThroughEditConfiguration);
            }
            catch (CoreException exception) {
                MessageDialog dialog = this.getErrorDialog(BuildDefinitionEditorMessages.BuildDefinitionEditor_ERROR_ADDING_PAGES);
                dialog.open();
                BuildUIPlugin.log(exception);
            }
        }
    }

    protected MessageDialog getErrorDialog(String message) {
        return new MessageDialog(this.getSite().getShell(), BuildDefinitionEditorMessages.BuildDefinitionEditor_ERROR, null, message, 1, new String[]{IDialogConstants.OK_LABEL}, 0);
    }

    private void removePages(List<String> removedElementIds) {
        for (String elementId : removedElementIds) {
            IFormPage[] formPages = this.getPages();
            int index = -1;
            int i = 0;
            while (i < formPages.length) {
                if (formPages[i].getId().equals(elementId)) {
                    index = i;
                    break;
                }
                ++i;
            }
            if (index <= -1) continue;
            this.removePage(index);
        }
    }

    private void addOriginalAndNewElements(Map<String, IBuildConfigurationElement> originalElements, List<String> selectedElementIds) {
        for (String elementId : selectedElementIds) {
            IBuildConfigurationElement element = originalElements.get(elementId);
            if (element != null) {
                this.fBuildDefinition.getConfigurationElements().add(element);
                continue;
            }
            element = BuildConfigurationRegistry.getInstance().getBuildConfigurationElement(elementId);
            if (element == null) continue;
            this.fBuildDefinition.initializeConfiguration(element);
        }
    }

    protected Action createRequestBuildAction() {
        return new Action(BuildDefinitionEditorMessages.BuildDefinitionEditor_REQUEST_BUILD, 1){

            public ImageDescriptor getImageDescriptor() {
                return BuildUIPlugin.getImageDescriptor("icons/elcl16/rquebuild.gif");
            }

            public void run() {
                BuildDefinitionEditor.this.handleRequestBuild();
            }
        };
    }

    private void createHeaderSecondRow(IManagedForm headerForm) {
        FormToolkit toolkit = this.getToolkit();
        Composite head = headerForm.getForm().getForm().getHead();
        Composite headClient = new Composite(head, 0);
        GridLayout layout = new GridLayout(6, false);
        layout.horizontalSpacing = 7;
        headClient.setLayout((Layout)layout);
        GridData gridData = new GridData();
        headClient.setLayoutData((Object)gridData);
        Label label = toolkit.createLabel(headClient, BuildDefinitionEditorMessages.BuildDefinitionEditor_ID_LABEL);
        label.setBackground(null);
        BuildDefinitionEditorInput input = (BuildDefinitionEditorInput)this.getEditorInput();
        this.fIdText = toolkit.createText(headClient, TextProcessor.process((String)input.getBuildDefinition().getId()));
        GridData layoutData = new GridData(768);
        layoutData.widthHint = 100;
        this.fIdText.setLayoutData((Object)layoutData);
        this.fIdText.addModifyListener(this.fIdModifiedListener);
        label = toolkit.createLabel(headClient, "");
        gridData = new GridData();
        gridData.widthHint = 5;
        label.setLayoutData((Object)gridData);
        label.setBackground(null);
        label = this.getToolkit().createLabel(headClient, BuildDefinitionEditorMessages.BuildDefinitionEditor_FIELD_TITLE_PROCESS_AREA);
        label.setBackground(null);
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.fProcessAreaText = this.getToolkit().createText(headClient, TextProcessor.process((String)this.fProcessArea.getName()), 2052);
        this.fProcessAreaText.setLayoutData((Object)new GridData(768));
        this.fProcessAreaText.setEditable(false);
        this.fChangeProcessAreaButton = this.getToolkit().createButton(headClient, BuildDefinitionEditorMessages.BuildDefinitionEditor_BUTTON_LABEL_CHANGE_PROCESS_AREA, 8);
        this.fChangeProcessAreaButton.addSelectionListener(this.getProcessAreaSelectionListener());
        this.setPartName(input.getBuildDefinition().getId());
        headerForm.getForm().setHeadClient((Control)headClient);
    }

    protected void handleRequestBuild() {
        RequestBuildDialog dialog = this.createRequestBuildDialog();
        dialog.open();
    }

    protected RequestBuildDialog createRequestBuildDialog() {
        RequestBuildDialog requestBuildDialog = new RequestBuildDialog(this.getEditorSite().getShell(), (IBuildDefinitionHandle)this.fBuildDefinition);
        requestBuildDialog.setWorkbenchPartSite(this.getSite());
        return requestBuildDialog;
    }

    @Override
    protected String getHeaderTitleText() {
        if (this.fBuildDefinition != null) {
            String templateId = EnterpriseHelper.getTemplateId(this.fBuildDefinition);
            if (EnterpriseHelper.isPackagingTemplate(templateId)) {
                return BuildDefinitionEditorMessages.PackageDefinitionEditor_HEADER_TITLE;
            }
            if (EnterpriseHelper.isDeploymentTemplate(templateId)) {
                return BuildDefinitionEditorMessages.DeploymentDefinitionEditor_HEADER_TITLE;
            }
            if (EnterpriseHelper.isPromotionTemplate(templateId)) {
                return BuildDefinitionEditorMessages.PromotionDefinitionEditor_HEADER_TITLE;
            }
        }
        return BuildDefinitionEditorMessages.BuildDefinitionEditor_HEADER_TITLE;
    }

    @Override
    protected Image getHeaderTitleImage() {
        return BuildUIPlugin.getImage("icons/obj16/build_type_obj.gif");
    }

    @Override
    public IItem getBuildItem() {
        return this.fBuildDefinition;
    }

    @Override
    public ITeamRepository getTeamRepository() {
        return this.fEditorInput.getTeamRepository();
    }

    public boolean isBuildDefinitionCreatedUsingTemplate() {
        return this.fEditorInput.isNewBuildDefinition() && this.fEditorInput.getBuildDefinitionTemplate() != null;
    }

    protected void addPages() {
        try {
            Object[] configurationElements = this.fBuildDefinition.getConfigurationElements().toArray();
            Arrays.sort(configurationElements, this.getConfigurationElementComparator());
            Object[] objectArray = configurationElements;
            int n = configurationElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                this.addPage(((IBuildConfigurationElement)object).getElementId());
                ++n2;
            }
        }
        catch (PartInitException exception) {
            this.logError((Exception)((Object)exception));
        }
        catch (IllegalArgumentException exception) {
            this.logError(exception);
        }
        catch (CoreException exception) {
            this.logError((Exception)((Object)exception));
        }
    }

    protected void initializePage(IFormPage page) {
        page.createPartControl(this.getContainer());
        this.setControl(page.getIndex(), page.getPartControl());
        page.getPartControl().setMenu(this.getContainer().getMenu());
    }

    protected int addPage(String elementId) throws IllegalArgumentException, CoreException {
        return this.addPage(elementId, false);
    }

    protected int addPage(String elementId, boolean isAddedThroughEditConfiguration) throws IllegalArgumentException, CoreException {
        IConfigurationElementEditorFactory factory;
        AbstractConfigurationElementEditor elementEditor;
        BuildConfigurationElementEditorExtension editorExtension;
        int pageIndex = -1;
        if (this.getPage(elementId) == null && (editorExtension = BuildConfigurationElementEditorExtensionManager.getInstance().getBuildConfigurationElementEditor(elementId)) != null && (elementEditor = (factory = editorExtension.createEditorFactory()).createElementEditor(editorExtension.getElementIdAttribute(), editorExtension.getNameAttribute())) != null) {
            elementEditor.initialize(this);
            elementEditor.setWorkingCopy(this.fBuildDefinition);
            elementEditor.setIsAddedThroughEditConfiguration(isAddedThroughEditConfiguration);
            pageIndex = this.addPage((IFormPage)elementEditor);
            if (elementEditor instanceof GeneralConfigurationEditor) {
                ((GeneralConfigurationEditor)elementEditor).setFolderParentPairs(this.fParentFolders);
                ((GeneralConfigurationEditor)elementEditor).setProjectAreaName(this, ConnectedProjectAreaRegistryHelper.getProjectAreaName(this.fProcessArea.getProjectArea()));
            }
            this.initializePage(this.getPages()[pageIndex]);
            if (elementEditor instanceof GeneralConfigurationEditor) {
                this.fetchBuildEngines((GeneralConfigurationEditor)elementEditor);
                if (!EnterpriseHelper.isEnterpriseDefinition(this.fBuildDefinition)) {
                    this.fetchAncestorFolders((GeneralConfigurationEditor)elementEditor);
                }
            }
        }
        return pageIndex;
    }

    private IFormPage getPage(String elementId) {
        IFormPage[] formPages = this.getPages();
        int i = 0;
        while (i < formPages.length) {
            if (formPages[i].getId().equals(elementId)) {
                return formPages[i];
            }
            ++i;
        }
        return null;
    }

    protected void createPages() {
        IBuildDefinition buildDefinition = this.fEditorInput.getBuildDefinition();
        if (!buildDefinition.getConfigurationElements().isEmpty()) {
            super.createPages();
            String initialPageId = this.fEditorInput.getInitialPageId();
            if (initialPageId != null) {
                for (Object object : this.pages) {
                    IFormPage page = (IFormPage)object;
                    if (!page.getId().equals(initialPageId)) continue;
                    this.setActivePage(initialPageId);
                    return;
                }
            }
        } else {
            MessageDialog dialog = this.getErrorDialog(BuildDefinitionEditorMessages.BuildDefinitionEditor_NO_CONFIG_ELEMENTS);
            dialog.open();
        }
    }

    private void fetchBuildEngines(GeneralConfigurationEditor generalPage) {
        BuildItemEditorJob job = this.getFetchBuildEnginesJob(generalPage);
        job.setWarnOnError();
        job.schedule();
    }

    private void fetchAncestorFolders(GeneralConfigurationEditor generalPage) {
        BuildItemEditorJob job = this.getFetchAncestorFoldersJob(generalPage);
        job.setWarnOnError();
        job.schedule();
    }

    protected BuildItemEditorJob getFetchBuildEnginesJob(final GeneralConfigurationEditor generalPage) {
        String jobName = BuildDefinitionEditorMessages.BuildDefinitionEditor_FETCHING_BUILD_ENGINES;
        return new BuildItemEditorJob(jobName, true, this){

            @Override
            protected void internalRunProtected(IProgressMonitor monitor) throws Exception {
                ITeamBuildClient client;
                IBuildEngine defaultEngine;
                List<IBuildEngine> supportingEngines;
                ArrayList<IBuildEngine> buildEngines = new ArrayList<IBuildEngine>();
                if (!BuildDefinitionEditor.this.isNewItem() && (supportingEngines = BuildDefinitionEditor.this.getBuildEngines((IBuildDefinitionHandle)BuildDefinitionEditor.this.fBuildDefinition.getItemHandle(), (IProgressMonitor)new SubProgressMonitor(monitor, 1))) != null) {
                    buildEngines.addAll(supportingEngines);
                }
                if ((defaultEngine = (client = (ITeamBuildClient)BuildDefinitionEditor.this.getTeamRepository().getClientLibrary(ITeamBuildClient.class)).getBuildEngine(IBuildEngine.DEFAULT_ENGINE_ID, monitor)) != null) {
                    buildEngines.add(defaultEngine);
                }
                BuildDefinitionEditor.this.fAllEnginesSize = BuildDefinitionEditor.this.getAllBuildEnginesSize((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                BuildDefinitionEditor.this.fProjectAreaName = BuildDefinitionEditor.this.fetchProjectAreaName(BuildDefinitionEditor.this.fProcessArea, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                List enginesToAdd = BuildDefinitionEditor.this.getBuildEnginesToAdd(BuildDefinitionEditor.this.fEditorInput.getBuildDefinitionTemplate(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                final HashSet<String> engineIdsToAdd = new HashSet<String>();
                for (IBuildEngine engine : enginesToAdd) {
                    engineIdsToAdd.add(engine.getId());
                }
                HashMap<String, IBuildEngine> engineIdToItem = new HashMap<String, IBuildEngine>();
                buildEngines.addAll(enginesToAdd);
                for (IBuildEngine engine : buildEngines) {
                    engineIdToItem.put(engine.getId(), engine);
                    BuildDefinitionEditor.this.fBuildEngineIdToItem.put(engine.getItemId().getUuidValue(), engine);
                }
                BuildDefinitionEditor.this.fBuildEngineIdToProjectAreaName = BuildDefinitionEditor.this.getEngineIdToProjectName(generalPage, engineIdToItem, monitor);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!BuildDefinitionEditor.this.isDisposed()) {
                            BuildDefinitionEditor.this.handleAsyncBuildEngineFetchSuccessful(generalPage, engineIdsToAdd);
                        }
                    }
                });
            }
        };
    }

    private Map<String, String> getEngineIdToProjectName(GeneralConfigurationEditor generalPage, Map<String, IBuildEngine> engineIdToItem, IProgressMonitor monitor) throws TeamRepositoryException {
        HashMap<String, String> engineIdToProjectNameMap = new HashMap<String, String>();
        if (generalPage != null) {
            engineIdToProjectNameMap.putAll(generalPage.fetchIdToProjectName(engineIdToItem, monitor));
        }
        return engineIdToProjectNameMap;
    }

    protected BuildItemEditorJob getFetchAncestorFoldersJob(final GeneralConfigurationEditor generalPage) {
        String jobName = BuildDefinitionEditorMessages.BuildDefinitionEditor_RETRIEVING_ANCESTOR_FOLDERS;
        return new BuildItemEditorJob(jobName, true, this){

            @Override
            protected void internalRunProtected(IProgressMonitor monitor) throws Exception {
                try {
                    IBuildItemNamePair[] pairs = new IBuildItemNamePair[]{};
                    try {
                        if (BuildDefinitionEditor.this.isNewItem() && BuildDefinitionEditor.this.fParentFolderHandle != null) {
                            IBuildFolder parentFolder = (IBuildFolder)BuildDefinitionEditor.this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)BuildDefinitionEditor.this.fParentFolderHandle, 1, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            BuildItemNamePairImpl parentPair = (BuildItemNamePairImpl)DtoFactory.eINSTANCE.createBuildItemNamePair();
                            parentPair.setName(parentFolder.getName());
                            parentPair.setItem((IItemHandle)parentFolder);
                            IBuildItemNamePair[] folderAncestors = BuildDefinitionEditor.this.getBuildClient().getAncestorFolders((IItemHandle)BuildDefinitionEditor.this.fParentFolderHandle, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            pairs = new IBuildItemNamePair[folderAncestors.length + 1];
                            System.arraycopy(folderAncestors, 0, pairs, 1, folderAncestors.length);
                            pairs[0] = parentPair;
                        } else {
                            pairs = BuildDefinitionEditor.this.getBuildClient().getAncestorFolders((IItemHandle)BuildDefinitionEditor.this.fBuildDefinition, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        }
                    }
                    catch (TeamRepositoryException e) {
                        BuildUIPlugin.log(e);
                    }
                    final IBuildItemNamePair[] parentPairs = pairs;
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!BuildDefinitionEditor.this.isDisposed()) {
                                BuildDefinitionEditor.this.handleAsyncAncestorFoldersFetchSuccessful(generalPage, parentPairs);
                            }
                        }
                    });
                }
                finally {
                    monitor.done();
                }
            }
        };
    }

    private List<IBuildEngine> getBuildEnginesToAdd(IBuildDefinitionHandle buildDefinitionHandle, IProgressMonitor monitor) {
        List<IBuildEngine> enginesToAdd = new ArrayList<IBuildEngine>();
        if (this.isNewItem() && buildDefinitionHandle != null) {
            try {
                enginesToAdd = this.getBuildEngines(buildDefinitionHandle, monitor);
            }
            catch (TeamRepositoryException exception) {
                BuildUIPlugin.log(exception);
            }
        }
        return enginesToAdd;
    }

    protected int getAllBuildEnginesSize(IProgressMonitor monitor) throws TeamRepositoryException {
        int size = 0;
        IBaseBuildEngineQueryModel.IBuildEngineQueryModel model = IBaseBuildEngineQueryModel.IBuildEngineQueryModel.ROOT;
        IItemQuery itemQuery = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
        ItemQueryIterator iter = new ItemQueryIterator(this.getBuildClient(), itemQuery, IQueryService.EMPTY_PARAMETERS);
        while (iter.hasNext(monitor)) {
            List engineHandles = iter.next(512, monitor);
            size += engineHandles.size();
        }
        return size;
    }

    protected List<IBuildEngine> getBuildEngines(IBuildDefinitionHandle buildDefinitionHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        IItemManager itemManager = this.fEditorInput.getTeamRepository().itemManager();
        IBaseBuildEngineQueryModel.IBuildEngineQueryModel model = IBaseBuildEngineQueryModel.IBuildEngineQueryModel.ROOT;
        IItemQuery itemQuery = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
        itemQuery.filter(model.supportedBuildDefinitions()._contains(itemQuery.newItemHandleArg()));
        ItemQueryIterator iter = new ItemQueryIterator(this.getBuildClient(), itemQuery, new Object[]{buildDefinitionHandle});
        LinkedList<IBuildEngine> buildEngines = new LinkedList<IBuildEngine>();
        while (iter.hasNext(monitor)) {
            List engineHandles = iter.next(512, monitor);
            buildEngines.addAll(itemManager.fetchCompleteItems(engineHandles, 1, monitor));
        }
        Iterator enginesIter = buildEngines.iterator();
        while (enginesIter.hasNext()) {
            Object next = enginesIter.next();
            if (next != null) continue;
            enginesIter.remove();
        }
        return buildEngines;
    }

    protected String fetchProjectAreaName(IProcessArea processArea, IProgressMonitor monitor) throws TeamRepositoryException {
        if (processArea != null) {
            IProjectAreaHandle projectAreaHandle = processArea.getProjectArea();
            IProjectArea partialProjectArea = (IProjectArea)this.getTeamRepository().itemManager().fetchPartialItem((IItemHandle)projectAreaHandle, 0, Collections.singletonList("name"), monitor);
            return partialProjectArea.getName();
        }
        return null;
    }

    protected void handleAsyncBuildEngineFetchSuccessful(GeneralConfigurationEditor generalPage, Set<String> enginesToAdd) {
        generalPage.initializeBuildEngines(this.fBuildEngineIdToItem.values(), this.fBuildEngineIdToProjectAreaName, this.fProjectAreaName, this.fIsNewDefinition & this.fEditorInput.getBuildDefinitionTemplate() == null, this.fAllEnginesSize);
        generalPage.updateChangedBuildEngines(enginesToAdd);
        IEventBroker service = (IEventBroker)PlatformUI.getWorkbench().getService(IEventBroker.class);
        service.post(TOPIC_BUILD_ENGINE_FETCH, null);
    }

    protected void handleAsyncAncestorFoldersFetchSuccessful(GeneralConfigurationEditor generalPage, IBuildItemNamePair[] pairs) {
        if (this.fParentFolderHandle != null && pairs.length == 0) {
            generalPage.setUncategorizedWarningState(true);
        }
        generalPage.setFolderParentPairs(pairs);
        generalPage.refreshFolderComposite();
    }

    protected Comparator getConfigurationElementComparator() {
        return new Comparator(){

            public int compare(Object object1, Object object2) {
                IBuildConfigurationElement element1 = (IBuildConfigurationElement)object1;
                IBuildConfigurationElement element2 = (IBuildConfigurationElement)object2;
                return element1.getBuildPhase().ordinal() - element2.getBuildPhase().ordinal();
            }
        };
    }

    protected void logError(Exception exception) {
        BuildUIPlugin.log(exception);
    }

    @Override
    protected void refreshBuildItem(IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository teamRepository = this.fEditorInput.getTeamRepository();
        this.fBuildDefinition = (IBuildDefinition)teamRepository.itemManager().fetchCompleteItem((IItemHandle)this.fBuildDefinition, 1, monitor);
        this.fBuildDefinition = (IBuildDefinition)this.fBuildDefinition.getWorkingCopy();
        this.updatePageWorkingCopies(this.fBuildDefinition);
        IProcessAreaHandle processAreaHandle = this.fBuildDefinition.getProcessArea();
        if (processAreaHandle != null) {
            this.fProcessArea = (IProcessArea)teamRepository.itemManager().fetchCompleteItem((IItemHandle)processAreaHandle, 1, monitor);
        }
        this.fProjectAreaName = this.fetchProjectAreaName(this.fProcessArea, monitor);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                BuildDefinitionEditor.this.handleAsyncDisableEngineButtons();
            }
        });
        this.fBuildEngineIdToItem.clear();
        List<IBuildEngine> buildEngines = this.getBuildEngines((IBuildDefinitionHandle)this.fBuildDefinition.getItemHandle(), monitor);
        ITeamBuildClient client = (ITeamBuildClient)this.getTeamRepository().getClientLibrary(ITeamBuildClient.class);
        IBuildEngine defaultEngine = client.getBuildEngine(IBuildEngine.DEFAULT_ENGINE_ID, monitor);
        if (defaultEngine != null) {
            buildEngines.add(defaultEngine);
        }
        this.fAllEnginesSize = this.getAllBuildEnginesSize((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        for (IBuildEngine buildEngine : buildEngines) {
            this.fBuildEngineIdToItem.put(buildEngine.getItemId().getUuidValue(), buildEngine);
        }
        GeneralConfigurationEditor generalPage = this.getGeneralPage();
        if (generalPage != null) {
            HashMap<String, IBuildEngine> engineIdToItem = new HashMap<String, IBuildEngine>();
            for (IBuildEngine engine : buildEngines) {
                engineIdToItem.put(engine.getId(), engine);
            }
            this.fBuildEngineIdToProjectAreaName = this.getEngineIdToProjectName(generalPage, engineIdToItem, monitor);
        }
        IBuildItemNamePair[] parentFolders = this.getBuildClient().getAncestorFolders((IItemHandle)this.fBuildDefinition, monitor);
        this.fParentFolders = parentFolders;
    }

    protected void handleAsyncDisableEngineButtons() {
        GeneralConfigurationEditor generalPage;
        if (!this.isDisposed() && (generalPage = this.getGeneralPage()) != null) {
            Button button = generalPage.getCreateBuildEngineButton();
            if (button != null) {
                button.setEnabled(false);
            }
            if ((button = generalPage.getAddBuildEnginesButton()) != null) {
                button.setEnabled(false);
            }
            if ((button = generalPage.getRemoveBuildEngineButton()) != null) {
                button.setEnabled(false);
            }
        }
    }

    @Override
    protected void disposeEditorSections() {
    }

    @Override
    protected void handleRefreshComplete() {
        this.getMessageManager().removeAllMessages();
        int index = 0;
        while (index < this.getPages().length) {
            this.setPageImage(index, null);
            ++index;
        }
        this.fIdText.removeModifyListener(this.fIdModifiedListener);
        this.fIdText.setText(TextProcessor.process((String)this.fBuildDefinition.getId()));
        this.fIdText.addModifyListener(this.fIdModifiedListener);
        this.fProcessAreaText.setText(TextProcessor.process((String)this.fProcessArea.getName()));
        this.addPages();
        LinkedList<String> pageIdsToRemove = new LinkedList<String>();
        IFormPage[] formPages = this.getPages();
        int i = 0;
        while (i < formPages.length) {
            if (this.fBuildDefinition.getConfigurationElement(formPages[i].getId()) == null) {
                pageIdsToRemove.add(formPages[i].getId());
            }
            ++i;
        }
        this.removePages(pageIdsToRemove);
        for (Object page : this.pages) {
            AbstractConfigurationElementEditor editorPage = (AbstractConfigurationElementEditor)((Object)page);
            if (editorPage instanceof GeneralConfigurationEditor) {
                ((GeneralConfigurationEditor)editorPage).setFolderParentPairs(this.fParentFolders);
                ((GeneralConfigurationEditor)editorPage).refreshFolderComposite();
            }
            editorPage.refresh();
            IManagedForm managedForm = editorPage.getManagedForm();
            if (managedForm == null) continue;
            managedForm.reflow(true);
        }
        this.setPartName(this.fBuildDefinition.getId());
        this.fDirty = false;
        this.fireDirtyPropertyChangeEvent();
        GeneralConfigurationEditor generalPage = this.getGeneralPage();
        if (generalPage != null) {
            generalPage.initializeBuildEngines(this.fBuildEngineIdToItem.values(), this.fBuildEngineIdToProjectAreaName, this.fProjectAreaName, this.fIsNewDefinition, this.fAllEnginesSize);
        }
    }

    @Override
    protected boolean preSave() {
        this.fSaveAttempted = true;
        boolean isValid = this.validateId();
        for (Object page : this.pages) {
            AbstractConfigurationElementEditor editorPage = (AbstractConfigurationElementEditor)((Object)page);
            if (editorPage.validate()) continue;
            isValid = false;
        }
        return isValid;
    }

    @Override
    protected boolean proceedWithSave() {
        boolean proceedWithSave = true;
        for (Object page : this.pages) {
            AbstractConfigurationElementEditor editorPage = (AbstractConfigurationElementEditor)((Object)page);
            if (editorPage.proceedWithSave()) continue;
            proceedWithSave = false;
            break;
        }
        return proceedWithSave;
    }

    @Override
    protected void postSave(boolean saveSucceeded) {
        GeneralConfigurationEditor generalPage;
        this.performPagePostSave(saveSucceeded);
        if (!saveSucceeded) {
            return;
        }
        this.fDirty = false;
        this.fRequestBuildAction.setEnabled(true);
        this.updatePageDirtyBits(false);
        this.fireDirtyPropertyChangeEvent();
        if (this.fIsNewDefinition) {
            this.fIsNewDefinition = false;
            List<Object> supportingEngines = new ArrayList();
            supportingEngines = this.getSupportingEngines(this.fBuildEngineIdToItem.values(), this.fBuildDefinition);
            if (supportingEngines.isEmpty()) {
                IEditorSite site = this.getEditorSite();
                Display.getDefault().asyncExec(new Runnable((IWorkbenchSite)site){
                    private final /* synthetic */ IWorkbenchSite val$site;
                    {
                        this.val$site = iWorkbenchSite;
                    }

                    @Override
                    public void run() {
                        BuildDefinitionEditor.this.handleAsyncPromptForEngine(this.val$site);
                    }
                });
            }
        }
        if ((generalPage = this.getGeneralPage()) != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (generalPage.isUncategorizedWarningState()) {
                        BuildDefinitionEditor.this.handleAsyncPromptForWarningState((IWorkbenchSite)BuildDefinitionEditor.this.getEditorSite());
                        generalPage.setUncategorizedWarningState(false);
                    }
                    generalPage.setFolderParentPairs(BuildDefinitionEditor.this.fParentFolders);
                    generalPage.refreshFolderComposite();
                }
            });
        }
    }

    private void performPagePostSave(boolean saveSucceeded) {
        for (Object page : this.pages) {
            AbstractConfigurationElementEditor editorPage = (AbstractConfigurationElementEditor)((Object)page);
            editorPage.postSave(saveSucceeded);
        }
    }

    protected void updatePageWorkingCopies(IBuildDefinition definition) {
        for (Object page : this.pages) {
            AbstractConfigurationElementEditor editorPage = (AbstractConfigurationElementEditor)((Object)page);
            editorPage.setWorkingCopy(definition);
        }
    }

    private void updatePageDirtyBits(boolean isDirty) {
        for (Object page : this.pages) {
            AbstractConfigurationElementEditor editorPage = (AbstractConfigurationElementEditor)((Object)page);
            editorPage.setDirty(isDirty);
        }
    }

    @Override
    protected void performSave(IProgressMonitor monitor) throws TeamRepositoryException {
        LinkedList<IBuildEngine> existingBuildEnginesToSave = new LinkedList<IBuildEngine>();
        LinkedList<IBuildEngine> newBuildEnginesToSave = new LinkedList<IBuildEngine>();
        GeneralConfigurationEditor generalPage = this.getGeneralPage();
        if (generalPage != null) {
            IBuildEngine[] buildEnginesToSave;
            IBuildEngine[] iBuildEngineArray = buildEnginesToSave = generalPage.getBuildEnginesToSave();
            int n = buildEnginesToSave.length;
            int n2 = 0;
            while (n2 < n) {
                IBuildEngine buildEngine = iBuildEngineArray[n2];
                if (buildEngine.isNewItem()) {
                    newBuildEnginesToSave.add(buildEngine);
                } else {
                    existingBuildEnginesToSave.add(buildEngine);
                }
                ++n2;
            }
        }
        int[] isSupported = new int[existingBuildEnginesToSave.size()];
        Iterator iter = existingBuildEnginesToSave.iterator();
        int currentEngine = 0;
        while (iter.hasNext()) {
            IBuildEngine buildEngine = (IBuildEngine)iter.next();
            int n = isSupported[currentEngine++] = buildEngine.supportsBuildDefinition((IBuildDefinitionHandle)this.fBuildDefinition) ? 1 : 0;
        }
        try {
            ITeamBuildRecordClient recordClient = (ITeamBuildRecordClient)this.fEditorInput.getTeamRepository().getClientLibrary(ITeamBuildRecordClient.class);
            IItem[] savedItems = recordClient.save(this.fBuildDefinition, (IBuildEngineHandle[])existingBuildEnginesToSave.toArray(new IBuildEngine[existingBuildEnginesToSave.size()]), isSupported, newBuildEnginesToSave.toArray(new IBuildEngine[newBuildEnginesToSave.size()]), monitor);
            this.performPageSaves(monitor);
            this.performPageSaves(savedItems, monitor);
            if (this.fParentFolderHandle != null && this.isNewItem()) {
                try {
                    this.getBuildClient().moveItemsToFolder((IItemHandle[])new IBuildDefinitionHandle[]{this.fBuildDefinition}, this.fParentFolderHandle, monitor);
                }
                catch (TeamRepositoryException e) {
                    BuildUIPlugin.log(e);
                }
            }
            this.fParentFolders = this.getBuildClient().getAncestorFolders((IItemHandle)this.fBuildDefinition, monitor);
            this.fBuildDefinition = (IBuildDefinition)savedItems[0].getWorkingCopy();
            this.updatePageWorkingCopies(this.fBuildDefinition);
            int i = 1;
            while (i < savedItems.length) {
                IBuildEngine buildEngine = (IBuildEngine)savedItems[i];
                generalPage.buildEngineSaved(buildEngine);
                this.fBuildEngineIdToItem.put(buildEngine.getItemId().getUuidValue(), buildEngine);
                ++i;
            }
        }
        catch (TeamOperationCanceledException exception) {
            IOperationReport report = exception.getReport();
            if (!report.getOperationId().equals("com.ibm.team.build.server.saveBuildDefinition")) {
                this.fBuildDefinition = (IBuildDefinition)this.fEditorInput.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)this.fBuildDefinition, 1, monitor);
                this.fBuildDefinition = (IBuildDefinition)this.fBuildDefinition.getWorkingCopy();
                this.updatePageWorkingCopies(this.fBuildDefinition);
            }
            throw exception;
        }
    }

    private void performPageSaves(IProgressMonitor monitor) {
        for (Object page : this.pages) {
            AbstractConfigurationElementEditor editorPage = (AbstractConfigurationElementEditor)((Object)page);
            editorPage.performExtraSave(monitor);
        }
    }

    private void performPageSaves(IItem[] savedItems, IProgressMonitor monitor) {
        for (Object page : this.pages) {
            AbstractConfigurationElementEditor editorPage = (AbstractConfigurationElementEditor)((Object)page);
            editorPage.performExtraSave(savedItems, monitor);
        }
    }

    protected void handleExceptionUpdatingBuildEngine(TeamRepositoryException exception, IBuildEngine buildEngine, IBuildDefinition buildDefinition) {
        BuildUIPlugin.log(NLS.bind((String)BuildDefinitionEditorMessages.BuildDefinitionEditor_ERROR_UPDATING_ENGINE, (Object)buildEngine.getId(), (Object)buildDefinition.getId()));
        BuildUIPlugin.log(exception);
    }

    private ITeamBuildClient getBuildClient() {
        return ClientFactory.getTeamBuildClient((ITeamRepository)this.fEditorInput.getTeamRepository());
    }

    @Override
    protected String getBuildItemTypeName() {
        return BuildDefinitionEditorMessages.BuildDefinitionEditor_BUILD_DEFINITION_ITEM_NAME;
    }

    @Override
    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.fEditorInput = (BuildDefinitionEditorInput)input;
        this.fDirty = this.fEditorInput.isNewBuildDefinition();
        this.fIsNewDefinition = this.fEditorInput.isNewBuildDefinition();
        this.fProcessArea = this.fEditorInput.getProcessArea();
        this.fBuildDefinition = (IBuildDefinition)this.fEditorInput.getBuildDefinition().getWorkingCopy();
        this.fParentFolderHandle = this.fEditorInput.getParentFolder();
    }

    @Override
    protected boolean isNewItem() {
        return this.fIsNewDefinition;
    }

    public boolean isDirty() {
        if (this.fDirty) {
            return true;
        }
        for (Object page : this.pages) {
            AbstractConfigurationElementEditor editorPage = (AbstractConfigurationElementEditor)((Object)page);
            if (!editorPage.isDirty()) continue;
            return true;
        }
        return false;
    }

    public void fireDirtyPropertyChangeEvent() {
        this.firePropertyChange(257);
    }

    @Override
    public boolean isSaveAsAllowed() {
        return false;
    }

    private void handleIdModification() {
        this.setPartName(this.getIdValue());
        this.fDirty = true;
        this.fireDirtyPropertyChangeEvent();
    }

    private boolean validateId() {
        if (this.getIdValue().equals("")) {
            this.addErrorMessage((Object)BuildDefinitionEditorMessages.BuildDefinitionEditor_NON_EMPTY_ID, BuildDefinitionEditorMessages.BuildDefinitionEditor_NON_EMPTY_ID, (Control)this.fIdText);
            return false;
        }
        this.removeMessage(BuildDefinitionEditorMessages.BuildDefinitionEditor_NON_EMPTY_ID, (Control)this.fIdText);
        return true;
    }

    public void setFocus() {
        int pageIndex = this.getActivePage();
        if (pageIndex != -1) {
            IFormPage page = (IFormPage)this.pages.get(pageIndex);
            page.setFocus();
        } else {
            super.setFocus();
        }
    }

    protected ProcessAreaSelectionDialog getProcessAreaSelectionDialog() {
        ProcessAreaSelectionDialog dialog = new ProcessAreaSelectionDialog(this.getSite().getShell(), false);
        dialog.setAllowArchivedAreas(true);
        return dialog;
    }

    private List<IBuildEngine> getSupportingEngines(Collection<IBuildEngine> buildEngines, IBuildDefinition buildDefinition) {
        ArrayList<IBuildEngine> supportingEngines = new ArrayList<IBuildEngine>();
        block0: for (IBuildEngine buildEngine : buildEngines) {
            List supportedDefinitions = buildEngine.getSupportedBuildDefinitions();
            for (Object object : supportedDefinitions) {
                IBuildDefinitionHandle supportedDefinition = (IBuildDefinitionHandle)object;
                if (!supportedDefinition.getItemId().equals((Object)buildDefinition.getItemId())) continue;
                supportingEngines.add(buildEngine);
                continue block0;
            }
        }
        return supportingEngines;
    }

    protected void handleAsyncPromptForEngine(IWorkbenchSite site) {
        if (!site.getShell().isDisposed()) {
            MessageDialog dialog = this.getWarningDialog(site.getShell(), BuildDefinitionEditorMessages.BuildDefinitionEditor_ENGINE_WARNING_TITLE, BuildDefinitionEditorMessages.BuildDefinitionEditor_ENGINE_WARNING_MESSAGE);
            dialog.open();
        }
    }

    protected void handleAsyncPromptForWarningState(IWorkbenchSite site) {
        if (!site.getShell().isDisposed()) {
            BuildUIHelper.showInfoDialog(site.getShell(), Messages.ProcessAreaSelectionPage_BUILD_FOLDER_NOT_FOUND_TITLE, Messages.ProcessAreaSelectionPage_BUILD_FOLDER_NOT_FOUND_MESSAGE);
        }
    }

    protected MessageDialog getWarningDialog(Shell shell, String title, String message) {
        return new MessageDialog(shell, title, null, message, 4, new String[]{IDialogConstants.OK_LABEL}, 0);
    }

    protected SelectionListener getProcessAreaSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IProcessArea processArea;
                ProcessAreaSelectionDialog dialog = BuildDefinitionEditor.this.getProcessAreaSelectionDialog();
                if (BuildDefinitionEditor.this.fEditorInput.getParentFolder() != null && BuildDefinitionEditor.this.fEditorInput.isNewBuildDefinition()) {
                    dialog.addFilter(new ViewerFilter(){

                        public boolean select(Viewer viewer, Object parentElement, Object element) {
                            if (element instanceof IProcessArea) {
                                IProcessArea processArea = (IProcessArea)element;
                                return processArea.getProjectArea().sameItemId((IItemHandle)(this).BuildDefinitionEditor.this.fProcessArea.getProjectArea());
                            }
                            return true;
                        }
                    });
                }
                dialog.setInput((Object)BuildDefinitionEditor.this.getTeamRepository());
                if (dialog.open() == 0 && (processArea = dialog.getSelectedProcessArea()) != null) {
                    BuildDefinitionEditor.this.fProcessArea = processArea;
                    BuildDefinitionEditor.this.fBuildDefinition.setProcessArea((IProcessAreaHandle)processArea);
                    BuildDefinitionEditor.this.fProcessAreaText.setText(processArea.getName());
                    BuildDefinitionEditor.this.fDirty = true;
                    BuildDefinitionEditor.this.fireDirtyPropertyChangeEvent();
                }
            }
        };
    }

    protected ModifyListener getIdModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (BuildDefinitionEditor.this.validateId()) {
                    BuildDefinitionEditor.this.fBuildDefinition.setId(BuildDefinitionEditor.this.getIdValue());
                }
                BuildDefinitionEditor.this.handleIdModification();
            }
        };
    }

    protected GeneralConfigurationEditor getGeneralPage() {
        GeneralConfigurationEditor generalPage = null;
        for (IFormPage page : this.pages) {
            if (!(page instanceof GeneralConfigurationEditor)) continue;
            generalPage = (GeneralConfigurationEditor)page;
            break;
        }
        return generalPage;
    }

    public void setFocusInHeader() {
        if (this.fIdText != null) {
            this.fIdText.setFocus();
        }
    }

    public Text getIdText() {
        return this.fIdText;
    }

    @Override
    protected String getHelpId() {
        return "com.ibm.team.build.ui.editor_builddefinition";
    }

    public boolean isSaveAttempted() {
        return this.fSaveAttempted;
    }

    private String getIdValue() {
        return TextProcessor.deprocess((String)this.fIdText.getText().trim());
    }

    public String getProjectAreaName() {
        return this.fProjectAreaName;
    }

    public IProcessArea getProcessArea() {
        return this.fProcessArea;
    }

    protected void setProjectAreaName(String projectAreaName) {
        this.fProjectAreaName = projectAreaName;
    }

    public List<IBuildEngine> getSupportingEngines() {
        GeneralConfigurationEditor generalPage = this.getGeneralPage();
        if (generalPage != null) {
            return generalPage.getSupportingEngines();
        }
        return Collections.emptyList();
    }

    public Map<String, String> getEngineIdToProject() {
        GeneralConfigurationEditor generalPage = this.getGeneralPage();
        if (generalPage != null) {
            return generalPage.getEngineIdToProject();
        }
        return Collections.emptyMap();
    }

    public Map<String, IBuildEngine> getBuildEngines() {
        GeneralConfigurationEditor generalPage = this.getGeneralPage();
        if (generalPage != null) {
            return generalPage.getBuildEngines();
        }
        return Collections.emptyMap();
    }

    public Map<String, IBuildEngine> getChangedBuildEngines() {
        GeneralConfigurationEditor generalPage = this.getGeneralPage();
        if (generalPage != null) {
            return generalPage.getChangedBuildEngines();
        }
        return Collections.emptyMap();
    }
}

