/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.builddefinition;

import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.ui.editors.builddefinition.IConfigurationElementEditorFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class BuildConfigurationElementEditorExtension {
    public static final String ACTIVITYID_ATTRIBUTE = "activityId";
    public static final String ID_ATTRIBUTE = "configurationElementId";
    public static final String CLASS_ATTRIBUTE = "class";
    public static final String NAME_ATTRIBUTE = "name";
    private String fActivityIdAttribute;
    private String fIdAttribute;
    private String fClassAttribute;
    private String fNameAttribute;
    private IConfigurationElement fPluginConfigurationElement;

    public BuildConfigurationElementEditorExtension(IConfigurationElement pluginConfigurationElement) {
        ValidationHelper.validateNotNull((String)"configElement", (Object)pluginConfigurationElement);
        this.fPluginConfigurationElement = pluginConfigurationElement;
        this.fActivityIdAttribute = pluginConfigurationElement.getAttribute(ACTIVITYID_ATTRIBUTE);
        this.fIdAttribute = pluginConfigurationElement.getAttribute(ID_ATTRIBUTE);
        this.fClassAttribute = pluginConfigurationElement.getAttribute(CLASS_ATTRIBUTE);
        this.fNameAttribute = pluginConfigurationElement.getAttribute(NAME_ATTRIBUTE);
        this.validateAttributes();
    }

    public String getActivityIdAttribute() {
        return this.fActivityIdAttribute;
    }

    public String getClassAttribute() {
        return this.fClassAttribute;
    }

    public String getElementIdAttribute() {
        return this.fIdAttribute;
    }

    public String getNameAttribute() {
        return this.fNameAttribute;
    }

    public IConfigurationElementEditorFactory createEditorFactory() throws IllegalArgumentException, CoreException {
        return this.createExecutableExtension();
    }

    public int hashCode() {
        return this.fIdAttribute.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BuildConfigurationElementEditorExtension other = (BuildConfigurationElementEditorExtension)obj;
        return this.fIdAttribute.equals(other.fIdAttribute);
    }

    public String toString() {
        return this.fNameAttribute;
    }

    private void validateAttributes() {
        ValidationHelper.validateNotNull((String)ID_ATTRIBUTE, (Object)this.fIdAttribute);
        ValidationHelper.validateNotEmpty((String)ID_ATTRIBUTE, (String)this.fIdAttribute.trim());
        ValidationHelper.validateNotNull((String)CLASS_ATTRIBUTE, (Object)this.fClassAttribute);
        ValidationHelper.validateNotEmpty((String)CLASS_ATTRIBUTE, (String)this.fClassAttribute.trim());
        ValidationHelper.validateNotNull((String)NAME_ATTRIBUTE, (Object)this.fNameAttribute);
        ValidationHelper.validateNotEmpty((String)NAME_ATTRIBUTE, (String)this.fNameAttribute.trim());
    }

    private IConfigurationElementEditorFactory createExecutableExtension() throws CoreException, IllegalArgumentException {
        Object executableExtension = this.fPluginConfigurationElement.createExecutableExtension(CLASS_ATTRIBUTE);
        ValidationHelper.validateIsType((String)CLASS_ATTRIBUTE, IConfigurationElementEditorFactory.class, (Object)executableExtension);
        return (IConfigurationElementEditorFactory)executableExtension;
    }
}

