/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.builddefinition;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.ui.editors.builddefinition.AbstractConfigurationElementEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public abstract class BasicConfigurationElementEditor
extends AbstractConfigurationElementEditor {
    public static final int FIELD_SPACING = 10;
    protected IBuildDefinition fWorkingCopy;

    public BasicConfigurationElementEditor(String elementId, String title) {
        super(elementId, title);
    }

    @Override
    public void setWorkingCopy(IBuildDefinition definition) {
        this.fWorkingCopy = definition;
    }

    @Override
    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        this.getManagedForm().reflow(false);
    }

    protected Section createSection(Composite parent, String text, String description, boolean expandable) {
        return this.createSection(parent, text, description, expandable, 2);
    }

    protected Section createSection(Composite parent, String text, String description, boolean expandable, int numColumns) {
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        int style = 384;
        if (expandable) {
            style |= 0x42;
        }
        Section section = toolkit.createSection(parent, style);
        section.setLayoutData((Object)new TableWrapData(256, 256));
        section.setText(text);
        if (description != null) {
            section.setDescription(description);
        }
        Composite composite = toolkit.createComposite((Composite)section);
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = numColumns;
        layout.topMargin = 12;
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        section.setClient((Control)composite);
        return section;
    }

    protected Text createConfigPropertyTextField(Composite parent, String propertyName, String label, String description, boolean validateOnModify) {
        return this.createConfigPropertyTextField(parent, propertyName, label, description, validateOnModify, -1, 4);
    }

    protected Text createConfigPropertyTextField(Composite parent, final String propertyName, String label, String description, final boolean validateOnModify, int heightHint, int style) {
        final String elementId = this.getId();
        String value = this.fWorkingCopy.getConfigurationPropertyValue(elementId, propertyName, "");
        final Text text = heightHint == -1 && style == 4 ? this.createLabeledText(parent, label, description, value) : this.createLabeledText(parent, label, description, value, heightHint, style);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (validateOnModify) {
                    BasicConfigurationElementEditor.this.validate();
                }
                BasicConfigurationElementEditor.this.fWorkingCopy.setConfigurationProperty(elementId, propertyName, text.getText().trim());
                BasicConfigurationElementEditor.this.setDirty(true);
            }
        });
        return text;
    }

    protected Button createConfigPropertyCheckboxField(Composite parent, final String propertyName, boolean defaultValue, String label, String text, String description, final boolean validateOnModify) {
        final String elementId = this.getId();
        boolean value = Boolean.valueOf(this.fWorkingCopy.getConfigurationPropertyValue(elementId, propertyName, Boolean.toString(defaultValue)));
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        toolkit.createLabel(parent, label);
        final Button button = toolkit.createButton(parent, text, 32);
        button.setLayoutData((Object)new TableWrapData());
        button.setSelection(value);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (validateOnModify) {
                    BasicConfigurationElementEditor.this.validate();
                }
                BasicConfigurationElementEditor.this.fWorkingCopy.setConfigurationProperty(elementId, propertyName, Boolean.toString(button.getSelection()));
                BasicConfigurationElementEditor.this.setDirty(true);
            }
        });
        if (description != null) {
            this.createSpacer(parent, -1, 1);
            Label descriptionLabel = toolkit.createLabel(parent, description, 64);
            descriptionLabel.setLayoutData((Object)new TableWrapData(256));
            descriptionLabel.setForeground(Display.getDefault().getSystemColor(16));
        }
        return button;
    }

    protected Button createPropertyCheckboxField(Composite parent, final String propertyName, boolean defaultValue, String label, String text, String description, final boolean validateOnModify) {
        boolean value = Boolean.valueOf(this.fWorkingCopy.getPropertyValue(propertyName, Boolean.toString(defaultValue)));
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        toolkit.createLabel(parent, label);
        final Button button = toolkit.createButton(parent, text, 32);
        button.setLayoutData((Object)new TableWrapData());
        button.setSelection(value);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (validateOnModify) {
                    BasicConfigurationElementEditor.this.validate();
                }
                BasicConfigurationElementEditor.this.fWorkingCopy.setProperty(propertyName, Boolean.toString(button.getSelection()));
                BasicConfigurationElementEditor.this.setDirty(true);
            }
        });
        if (description != null) {
            this.createSpacer(parent, -1, 1);
            Label descriptionLabel = toolkit.createLabel(parent, description, 64);
            descriptionLabel.setLayoutData((Object)new TableWrapData(256));
            descriptionLabel.setForeground(Display.getDefault().getSystemColor(16));
        }
        return button;
    }

    protected void createSpacer(Composite parent, int height, int horizontalSpan) {
        Label label = this.getManagedForm().getToolkit().createLabel(parent, "");
        TableWrapData tableWrapData = new TableWrapData(128, 32, 1, horizontalSpan);
        tableWrapData.heightHint = height;
        label.setLayoutData((Object)tableWrapData);
    }

    protected Text createLabeledText(Composite parent, String labelText, String description, String textValue) {
        return this.createLabeledText(parent, labelText, description, textValue, -1, 4);
    }

    protected Text createLabeledText(Composite parent, String labelText, String description, String textValue, int heightHint, int style) {
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        Label label = toolkit.createLabel(parent, labelText);
        int valign = heightHint == -1 ? 32 : 16;
        label.setLayoutData((Object)new TableWrapData(2, valign));
        Text text = toolkit.createText(parent, textValue, style);
        TableWrapData layoutData = new TableWrapData(256);
        layoutData.maxWidth = 200;
        layoutData.heightHint = heightHint;
        text.setLayoutData((Object)layoutData);
        if (description != null) {
            this.createSpacer(parent, -1, 1);
            Label descriptionLabel = toolkit.createLabel(parent, description, 64);
            descriptionLabel.setLayoutData((Object)new TableWrapData(256));
            descriptionLabel.setForeground(Display.getDefault().getSystemColor(16));
        }
        return text;
    }
}

