/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.builddefinition;

import com.ibm.team.build.client.ClientFactory;
import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.common.builddefinition.AutoDeliverTriggerPolicy;
import com.ibm.team.build.common.model.IBuildConfigurationElement;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.internal.client.iterator.ItemQueryIterator;
import com.ibm.team.build.internal.common.model.BuildDefinition;
import com.ibm.team.build.internal.common.model.BuildProperty;
import com.ibm.team.build.internal.common.model.query.BaseBuildDefinitionQueryModel;
import com.ibm.team.build.internal.scm.LoadComponents;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.editors.builddefinition.BasicConfigurationElementEditor;
import com.ibm.team.build.internal.ui.editors.builddefinition.BuildDefinitionEditorMessages;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.filesystem.ui.WORKSPACES_OR_STREAMS;
import com.ibm.team.filesystem.ui.WorkspaceAndStreamSelectionDialog;
import com.ibm.team.filesystem.ui.WorkspaceComponentSelectionDialog;
import com.ibm.team.filesystem.ui.views.TeamPlaceEditorInput;
import com.ibm.team.filesystem.ui.views.TeamPlacePart2;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.service.IQueryService;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.ComponentNotInWorkspaceException;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class AutoDeliverConfigurationEditor
extends BasicConfigurationElementEditor {
    private FormToolkit fToolkit;
    private IWorkspace fBuildWorkspace;
    private LoadComponents fComponentsToExclude;
    protected Button fAutoDeliverEnabledButton;
    protected Button fTriggerPolicyAlwaysButton;
    protected Button fTriggerPolicyNoErrorsButton;
    protected Button fTriggerPolicyNoWarningsButton;
    protected Button fAbortOnIncompleteActivityButton;
    private IWorkspace fDeliverTarget;
    protected Hyperlink fDeliverTargetTitleHyperlink;
    protected Text fDeliverTargetNameText;
    protected Button fSelectDeliverTargetButton;
    protected Color fEnabledHyperlinkForegroundColor;
    protected Color fDisabledHyperlinkForegroundColor;
    protected Button fDeliverAllComponentsButton;
    private LoadComponents fComponentsToDeliver = new LoadComponents((Collection)Collections.EMPTY_LIST);
    protected Text fComponentsToDeliverText;
    protected Button fSelectComponentsToDeliverButton;
    protected Button fClearComponentsToDeliverButton;
    protected Button fAddNewComponentsToTargetButton;
    protected Button fRemoveComponentsInTargetButton;
    protected Button fDoNotChangeSnapshotOwnerButton;
    protected Button fChangeSnapshotOwnerButton;
    private String fOtherBuildDefinitionWithSameDeliverTarget;
    private boolean fShouldShowDeliverTargetAlreadyUsedDialog = false;
    private boolean fWarningDeliverTargetIsAWorkspace = false;
    private boolean fWarningNoComponentsToDeliver = false;
    private boolean fWarningSomeComponentsToDeliverNoLongerExist = false;
    private boolean fWarningDeliveringFromComponentsToExclude = false;
    private boolean fWarningNoBuildWorkspaceSelected = false;
    private Adapter fPropertyChangedAdapter = new EContentAdapter(){

        public void notifyChanged(Notification notification) {
            Object notifier = notification.getNotifier();
            Object newValue = notification.getNewValue();
            Object oldValue = notification.getOldValue();
            int eventType = notification.getEventType();
            if (notifier instanceof BuildDefinition) {
                IBuildConfigurationElement configElement;
                BuildDefinition definition = (BuildDefinition)notifier;
                if (eventType == 4 && oldValue instanceof IBuildConfigurationElement && "com.ibm.team.build.jazzscm".equals((configElement = (IBuildConfigurationElement)oldValue).getElementId()) && newValue == null) {
                    AutoDeliverConfigurationEditor.this.handleBuildWorkspaceUpdated(null);
                    AutoDeliverConfigurationEditor.this.setComponentsToExclude(new LoadComponents(AutoDeliverConfigurationEditor.this.getTeamRepository(), ""));
                }
                if (eventType == 3 && newValue instanceof IBuildConfigurationElement && "com.ibm.team.build.jazzscm".equals((configElement = (IBuildConfigurationElement)newValue).getElementId()) && oldValue == null) {
                    IBuildProperty componentsToExcludeProperty;
                    ((BuildDefinition)AutoDeliverConfigurationEditor.this.fWorkingCopy).eAdapters().remove((Object)AutoDeliverConfigurationEditor.this.fPropertyChangedAdapter);
                    ((BuildDefinition)AutoDeliverConfigurationEditor.this.fWorkingCopy).eAdapters().add((Object)AutoDeliverConfigurationEditor.this.fPropertyChangedAdapter);
                    IBuildProperty workspaceProperty = definition.getProperty("team.scm.workspaceUUID");
                    if (!(workspaceProperty == null || AutoDeliverConfigurationEditor.this.getBuildWorkspace() != null && workspaceProperty.getValue().equals(AutoDeliverConfigurationEditor.this.getBuildWorkspace().getItemId().getUuidValue()))) {
                        AutoDeliverConfigurationEditor.this.getBuildWorkspaceFromJazzScmProperty();
                    }
                    if ((componentsToExcludeProperty = definition.getProperty("team.scm.loadComponents")) != null) {
                        AutoDeliverConfigurationEditor.this.getComponentsToExcludeFromJazzScmProperty();
                    }
                }
            } else if (notifier instanceof BuildProperty) {
                IBuildProperty property = (IBuildProperty)notifier;
                if ("team.scm.workspaceUUID".equals(property.getName()) && eventType == 1 && (AutoDeliverConfigurationEditor.this.getBuildWorkspace() == null || !property.getValue().equals(AutoDeliverConfigurationEditor.this.getBuildWorkspace().getItemId().getUuidValue()))) {
                    AutoDeliverConfigurationEditor.this.getBuildWorkspaceFromJazzScmProperty();
                }
                if ("team.scm.loadComponents".equals(property.getName()) && eventType == 1) {
                    AutoDeliverConfigurationEditor.this.getComponentsToExcludeFromJazzScmProperty();
                }
            }
        }
    };

    public AutoDeliverConfigurationEditor(String elementId, String title) {
        super(elementId, title);
    }

    @Override
    public void createContent(Composite parent, FormToolkit toolkit) {
        this.fToolkit = toolkit;
        TableWrapLayout layout = new TableWrapLayout();
        layout.verticalSpacing = 20;
        parent.setLayout((Layout)layout);
        this.createAutoDeliverTriggerPolicyWidgets(parent);
        this.createDeliverTargetWidgets(parent);
        this.createComponentsToDeliverWidgets(parent);
        this.createSnapshotOwnerWidgets(parent);
        this.getBuildWorkspaceFromJazzScmProperty();
        this.getComponentsToExcludeFromJazzScmProperty();
        this.createJobToVerifyComponentsToDeliverExistInWorkspace();
        this.verifyComponentsToDeliverAgainstComponentsToExclude(this.getComponentsToDeliver(), this.getComponentsToExclude());
    }

    private void createAutoDeliverTriggerPolicyWidgets(Composite parent) {
        Section section = this.createSection(parent, BuildDefinitionEditorMessages.AutoDeliverConfigurationEditor_DELIVER_TRIGGER_SECTION_TEXT, BuildDefinitionEditorMessages.AutoDeliverConfigurationEditor_DELIVER_TRIGGER_SECTION_DESCRIPTION, false);
        Composite composite = (Composite)section.getClient();
        boolean isAutoDeliverEnabled = this.getAutoDeliverEnabledBuildProperty();
        this.fAutoDeliverEnabledButton = this.fToolkit.createButton(composite, BuildDefinitionEditorMessages.AutoDeliverConfigurationEditor_ENABLE_AUTO_DELIVER_BUTTON_DESCRIPTION, 32);
        TableWrapData layoutData = new TableWrapData(2, 32, 1, 2);
        this.fAutoDeliverEnabledButton.setLayoutData((Object)layoutData);
        this.fAutoDeliverEnabledButton.setSelection(isAutoDeliverEnabled);
        this.fAutoDeliverEnabledButton.addSelectionListener(this.getAutoDeliverEnabledButtonSelectionListener());
        Composite labelComposite = this.fToolkit.createComposite(composite);
        GridLayoutFactory.fillDefaults().applyTo(labelComposite);
        labelComposite.setLayoutData((Object)new TableWrapData(2, 16));
        Label groupLabel = this.fToolkit.createLabel(labelComposite, BuildDefinitionEditorMessages.AutoDeliverConfigurationEditor_AUTO_DELIVER_TRIGGER_BUTTON_GROUP_LABEL);
        AutoDeliverTriggerPolicy policy = this.getAutoDeliverTriggerPolicyBuildProperty();
        Composite group = new Composite(composite, 0);
        group.setLayout((Layout)new TableWrapLayout());
        group.setLayoutData((Object)new TableWrapData(256, 256, 1, 1));
        GridDataFactory.fillDefaults().indent(0, group.getClientArea().y + 6).applyTo((Control)groupLabel);
        this.fTriggerPolicyAlwaysButton = this.fToolkit.createButton(group, BuildDefinitionEditorMessages.AutoDeliverConfigurationEditor_AUTO_DELIVER_TRIGGER_ALWAYS_BUTTON_DESCRIPTION, 16);
        this.fTriggerPolicyAlwaysButton.setSelection(policy.equals((Object)AutoDeliverTriggerPolicy.ALWAYS));
        this.fTriggerPolicyAlwaysButton.setEnabled(this.fAutoDeliverEnabledButton.getSelection());
        this.fTriggerPolicyAlwaysButton.setData((Object)AutoDeliverTriggerPolicy.ALWAYS);
        this.fTriggerPolicyAlwaysButton.addSelectionListener(this.getTriggerPolicyAlwaysButtonSelectionListener());
        this.fTriggerPolicyAlwaysButton.setLayoutData((Object)new TableWrapData());
        this.fTriggerPolicyNoErrorsButton = this.fToolkit.createButton(group, BuildDefinitionEditorMessages.AutoDeliverConfigurationEditor_AUTO_DELIVER_TRIGGER_NO_ERRORS_BUTTON_DESCRIPTION, 16);
        this.fTriggerPolicyNoErrorsButton.setSelection(policy.equals((Object)AutoDeliverTriggerPolicy.NO_ERRORS));
        this.fTriggerPolicyNoErrorsButton.setEnabled(this.fAutoDeliverEnabledButton.getSelection());
        this.fTriggerPolicyNoErrorsButton.setData((Object)AutoDeliverTriggerPolicy.NO_ERRORS);
        this.fTriggerPolicyNoErrorsButton.addSelectionListener(this.getTriggerPolicyNoErrorsButtonSelectionListener());
        this.fTriggerPolicyNoErrorsButton.setLayoutData((Object)new TableWrapData());
        this.fTriggerPolicyNoWarningsButton = this.fToolkit.createButton(group, BuildDefinitionEditorMessages.AutoDeliverConfigurationEditor_AUTO_DELIVER_TRIGGER_NO_WARNINGS_BUTTON_DESCRIPTION, 16);
        this.fTriggerPolicyNoWarningsButton.setSelection(policy.equals((Object)AutoDeliverTriggerPolicy.NO_WARNINGS));
        this.fTriggerPolicyNoWarningsButton.setEnabled(this.fAutoDeliverEnabledButton.getSelection());
        this.fTriggerPolicyNoWarningsButton.setData((Object)AutoDeliverTriggerPolicy.NO_WARNINGS);
        this.fTriggerPolicyNoWarningsButton.addSelectionListener(this.getTriggerPolicyNoWarningsButtonSelectionListener());
        this.fTriggerPolicyNoWarningsButton.setLayoutData((Object)new TableWrapData());
        boolean isAbortOnIncompleteActivity = this.getAbortOnIncompleteActivityBuildProperty();
        this.fAbortOnIncompleteActivityButton = this.fToolkit.createButton(composite, BuildDefinitionEditorMessages.AutoDeliverConfigurationEditor_ABORT_ON_INCOMPLETE_ACTIVITY_BUTTON_DESCRIPTION, 32);
        layoutData = new TableWrapData(2, 32, 1, 2);
        this.fAbortOnIncompleteActivityButton.setLayoutData((Object)layoutData);
        this.fAbortOnIncompleteActivityButton.setSelection(isAbortOnIncompleteActivity);
        this.fAbortOnIncompleteActivityButton.setEnabled(this.fAutoDeliverEnabledButton.getSelection());
        this.fAbortOnIncompleteActivityButton.addSelectionListener(this.getAbortOnIncompleteActivityButtonSelectionListener());
        this.createInfoLabel(composite, NLS.bind((String)BuildDefinitionEditorMessages.AutoDeliverConfigurationEditor_AUTO_DELIVER_TRIGGER_POLICY_BUILD_PROPERTY, (Object[])new String[]{"team.scm.deliver.enabled", "team.scm.deliver.triggerPolicy", "team.scm.deliver.abortOnIncompleteActivity"}, (Object[])new Object[0]), 2);
    }

    protected SelectionListener getAutoDeliverEnabledButtonSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = AutoDeliverConfigurationEditor.this.fAutoDeliverEnabledButton.getSelection();
                AutoDeliverConfigurationEditor.this.setAutoDeliverEnabledBuildProperty(selected);
                AutoDeliverConfigurationEditor.this.handleAutoDeliverEnabledButtonSelectionChange(selected);
                AutoDeliverConfigurationEditor.this.setDirty(true);
                AutoDeliverConfigurationEditor.this.validate();
            }
        };
    }

    protected SelectionListener getTriggerPolicyAlwaysButtonSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AutoDeliverConfigurationEditor.this.fTriggerPolicyAlwaysButton.getSelection()) {
                    AutoDeliverConfigurationEditor.this.setAutoDeliverTriggerPolicyBuildProperty((AutoDeliverTriggerPolicy)AutoDeliverConfigurationEditor.this.fTriggerPolicyAlwaysButton.getData());
                    AutoDeliverConfigurationEditor.this.setDirty(true);
                    AutoDeliverConfigurationEditor.this.validate();
                }
            }
        };
    }

    protected SelectionListener getTriggerPolicyNoErrorsButtonSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AutoDeliverConfigurationEditor.this.fTriggerPolicyNoErrorsButton.getSelection()) {
                    AutoDeliverConfigurationEditor.this.setAutoDeliverTriggerPolicyBuildProperty((AutoDeliverTriggerPolicy)AutoDeliverConfigurationEditor.this.fTriggerPolicyNoErrorsButton.getData());
                    AutoDeliverConfigurationEditor.this.setDirty(true);
                    AutoDeliverConfigurationEditor.this.validate();
                }
            }
        };
    }

    protected SelectionListener getTriggerPolicyNoWarningsButtonSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AutoDeliverConfigurationEditor.this.fTriggerPolicyNoWarningsButton.getSelection()) {
                    AutoDeliverConfigurationEditor.this.setAutoDeliverTriggerPolicyBuildProperty((AutoDeliverTriggerPolicy)AutoDeliverConfigurationEditor.this.fTriggerPolicyNoWarningsButton.getData());
                    AutoDeliverConfigurationEditor.this.setDirty(true);
                    AutoDeliverConfigurationEditor.this.validate();
                }
            }
        };
    }

    protected SelectionListener getAbortOnIncompleteActivityButtonSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = AutoDeliverConfigurationEditor.this.fAbortOnIncompleteActivityButton.getSelection();
                AutoDeliverConfigurationEditor.this.setAbortOnIncompleteActivityBuildProperty(selected);
                AutoDeliverConfigurationEditor.this.setDirty(true);
                AutoDeliverConfigurationEditor.this.validate();
            }
        };
    }

    protected void handleAutoDeliverEnabledButtonSelectionChange(boolean enabled) {
        this.fTriggerPolicyAlwaysButton.setEnabled(enabled);
        this.fTriggerPolicyNoErrorsButton.setEnabled(enabled);
        this.fTriggerPolicyNoWarningsButton.setEnabled(enabled);
        this.fAbortOnIncompleteActivityButton.setEnabled(enabled);
    }

    private void createDeliverTargetWidgets(Composite parent) {
        Section section = this.createSection(parent, BuildDefinitionEditorMessages.AutoDeliverConfigurationEditor_DELIVER_TARGET_SECTION_TEXT, BuildDefinitionEditorMessages.AutoDeliverConfigurationEditor_DELIVER_TARGET_SECTION_DESCRIPTION, false, 3);
        Composite composite = (Composite)section.getClient();
        this.fDeliverTargetTitleHyperlink = this.fToolkit.createHyperlink(composite, BuildDefinitionEditorMessages.AutoDeliverConfigurationEditor_DELIVER_TARGET_LABEL, 0);
        this.fDeliverTargetTitleHyperlink.addHyperlinkListener(this.getDeliverTargetHyperlinkListener());
        this.fEnabledHyperlinkForegroundColor = this.fDeliverTargetTitleHyperlink.getForeground();
        this.fDeliverTargetTitleHyperlink.setLayoutData((Object)new TableWrapData(2, 32));
        this.fDeliverTargetTitleHyperlink.addHyperlinkListener(this.getDeliverTargetHyperlinkListener());
        this.fDeliverTargetNameText = this.fToolkit.createText(composite, "", 0);
        this.fDisabledHyperlinkForegroundColor = this.fDeliverTargetNameText.getForeground();
        this.fDeliverTargetNameText.setEnabled(false);
        this.fDeliverTargetNameText.setEditable(false);
        TableWrapData layoutData = new TableWrapData(256, 32);
        this.fDeliverTargetNameText.setLayoutData((Object)layoutData);
        this.fSelectDeliverTargetButton = this.fToolkit.createButton(composite, BuildDefinitionEditorMessages.AutoDeliverConfigurationEditor_SELECT_DELIVER_TARGET_BUTTON_TITLE, 0);
        this.fSelectDeliverTargetButton.addSelectionListener(this.getSelectDeliverTargetButtonSelectionListener());
        this.fSelectDeliverTargetButton.setLayoutData((Object)new TableWrapData());
        this.createInfoLabel(composite, NLS.bind((String)BuildDefinitionEditorMessages.AutoDeliverConfigurationEditor_DELIVER_TARGET_UUID_BUILD_PROPERTY, (Object)"team.scm.deliver.targetUUID", (Object[])new Object[0]), 3);
        String deliverTargetUUID = this.getDeliverTargetUUIDBuildProperty();
        if (deliverTargetUUID.length() == 0) {
            this.setDeliverTargetNameText("", false);
            return;
        }
        this.setDeliverTargetNameText(BuildDefinitionEditorMessages.AutoDeliverConfigurationEditor_PENDING_LABEL, false);
        final IWorkspaceHandle deliverTargetHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)deliverTargetUUID), null);
        String fetchDeliverTargetJobName = BuildDefinitionEditorMessages.AutoDeliverConfigurationEditor_FETCHING_DELIVER_TARGET_JOB_NAME;
        TeamBuildJob fetchDeliverTargetJob = new TeamBuildJob(fetchDeliverTargetJobName, true, this.getTeamRepository()){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                IWorkspace deliverTarget = AutoDeliverConfigurationEditor.this.fetchWorkspace(deliverTargetHandle, monitor);
                AutoDeliverConfigurationEditor.this.setDeliverTarget(deliverTarget);
                if (deliverTarget != null) {
                    AutoDeliverConfigurationEditor.this.setWarningDeliverTargetIsAWorkspace(!deliverTarget.isStream());
                    AutoDeliverConfigurationEditor.this.handleUpdateDeliverTargetText(deliverTarget.getName());
                    AutoDeliverConfigurationEditor.this.findOtherBuildDefinitionWithSameDeliverTarget(deliverTarget, monitor);
                }
                return Status.OK_STATUS;
            }

            @Override
            protected void jobFinished(IStatus status) {
                if (status.getSeverity() == 4) {
                    AutoDeliverConfigurationEditor.this.handleFetchDeliverTargetFailed(status);
                }
            }
        };
        fetchDeliverTargetJob.schedule();
    }

    protected void createJobToGetOtherBuildDefinitionWithSameDeliverTarget() {
        final IWorkspace deliverTarget = this.getDeliverTarget();
        if (deliverTarget != null) {
            String jobName = BuildDefinitionEditorMessages.AutoDeliverConfigurationEditor_FIND_DEFINITION_WITH_SAME_DELIVER_TARGET_JOB_NAME;
            TeamBuildJob job = new TeamBuildJob(jobName, true, this.getTeamRepository()){

                protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                    AutoDeliverConfigurationEditor.this.findOtherBuildDefinitionWithSameDeliverTarget(deliverTarget, monitor);
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        } else {
            this.setOtherBuildDefinitionWithSameDeliverTarget(null);
        }
    }

    protected void findOtherBuildDefinitionWithSameDeliverTarget(IWorkspace deliverTarget, IProgressMonitor monitor) {
        if (deliverTarget != null) {
            String otherBuildDefinitionIDWithSameDeliverTarget = null;
            this.setOtherBuildDefinitionWithSameDeliverTarget(null);
            try {
                ITeamBuildClient buildClient = ClientFactory.getTeamBuildClient((ITeamRepository)this.getTeamRepository());
                IItemManager itemManager = this.getTeamRepository().itemManager();
                BaseBuildDefinitionQueryModel.BuildDefinitionQueryModel buildDefQueryModel = BaseBuildDefinitionQueryModel.BuildDefinitionQueryModel.ROOT;
                IItemQuery itemQuery = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)buildDefQueryModel);
                itemQuery.filter(buildDefQueryModel.configurationElements().elementId()._eq("com.ibm.team.build.autoDeliver"));
                ItemQueryIterator iter = new ItemQueryIterator(buildClient, itemQuery, IQueryService.EMPTY_PARAMETERS);
                block2: while (otherBuildDefinitionIDWithSameDeliverTarget == null && iter.hasNext(monitor)) {
                    List definitionHandles = iter.next(512, monitor);
                    ArrayList<String> properties = new ArrayList<String>();
                    properties.add(IBuildDefinition.PROPERTY_ID);
                    properties.add(IBuildDefinition.PROPERTY_PROPERTIES);
                    List items = itemManager.fetchPartialItems(definitionHandles, 1, properties, monitor);
                    for (IBuildDefinition item : items) {
                        IBuildProperty otherDeliverTargetProperty;
                        if (item == null || (otherDeliverTargetProperty = item.getProperty("team.scm.deliver.targetUUID")) == null || !deliverTarget.getItemId().getUuidValue().equals(otherDeliverTargetProperty.getValue()) || item.sameItemId((IItemHandle)this.fWorkingCopy)) continue;
                        otherBuildDefinitionIDWithSameDeliverTarget = item.getId();
                        continue block2;
                    }
                }
                this.setOtherBuildDefinitionWithSameDeliverTarget(otherBuildDefinitionIDWithSameDeliverTarget);
            }
            catch (TeamRepositoryException exception) {
                BuildUIPlugin.log(exception);
            }
            this.handleOtherBuildDefinitionUsingSameDeliverTarget(otherBuildDefinitionIDWithSameDeliverTarget);
        }
    }

    protected void handleOtherBuildDefinitionUsingSameDeliverTarget(final String otherBuildDefinitionIDWithSameDeliverTarget) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!AutoDeliverConfigurationEditor.this.fDeliverTargetNameText.isDisposed()) {
                    AutoDeliverConfigurationEditor.this.validate();
                    String deliverTargetName = AutoDeliverConfigurationEditor.this.fDeliverTargetNameText.getText();
                    if (AutoDeliverConfigurationEditor.this.getShouldShowDeliverTargetInUseWarningDialog() && otherBuildDefinitionIDWithSameDeliverTarget != null && deliverTargetName != null) {
                        AutoDeliverConfigurationEditor.this.setShouldShowDeliverTargetInUseWarningDialog(false);
                        Dialog dialog = AutoDeliverConfigurationEditor.this.getDeliverTargetAlreadyInUseWarningDialog(deliverTargetName, otherBuildDefinitionIDWithSameDeliverTarget);
                        int result = dialog.open();
                        if (result == 0) {
                            dialog.close();
                        }
                    }
                }
            }
        });
    }

    protected Dialog getDeliverTargetAlreadyInUseWarningDialog(String deliverTargetName, String buildDefinitionID) {
        return new MessageDialog(this.fDeliverTargetTitleHyperlink.getShell(), BuildDefinitionEditorMessages.AutoDeliverConfigurationEditor_DELIVER_TARGET_USED_ALREADY_WARNING_TITLE, null, NLS.bind((String)BuildDefinitionEditorMessages.AutoDeliverConfigurationEditor_DELIVER_TARGET_USED_ALREADY_WARNING_MESSAGE, (Object)deliverTargetName, (Object[])new Object[]{buildDefinitionID}), 4, new String[]{IDialogConstants.OK_LABEL}, 1);
    }

    protected IWorkspace fetchWorkspace(IWorkspaceHandle workspaceHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return (IWorkspace)this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)workspaceHandle, 0, monitor);
    }

    protected void handleUpdateDeliverTargetText(final String deliverTargetName) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!AutoDeliverConfigurationEditor.this.fDeliverTargetNameText.isDisposed()) {
                    AutoDeliverConfigurationEditor.this.setDeliverTargetNameText(deliverTargetName, true);
                }
            }
        });
    }

    protected void handleFetchDeliverTargetFailed(final IStatus status) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!AutoDeliverConfigurationEditor.this.fDeliverTargetNameText.isDisposed()) {
                    String errorMessage = BuildDefinitionEditorMessages.AutoDeliverConfigurationEditor_ERROR_FETCHING_DELIVER_TARGET;
                    if (status.getException() instanceof ItemNotFoundException) {
                        errorMessage = BuildDefinitionEditorMessages.AutoDeliverConfigurationEditor_DELIVER_TARGET_DELETED;
                    } else if (status.getException() instanceof PermissionDeniedException) {
                        errorMessage = BuildDefinitionEditorMessages.AutoDeliverConfigurationEditor_DELIVER_TARGET_NO_READ_ACCESS;
                    }
                    AutoDeliverConfigurationEditor.this.setDeliverTargetNameText(errorMessage, false);
                }
            }
        });
    }

    protected synchronized IWorkspace getDeliverTarget() {
        return this.fDeliverTarget;
    }

    protected synchronized void setDeliverTarget(IWorkspace deliverTarget) {
        this.fDeliverTarget = deliverTarget;
    }

    protected synchronized boolean getWarningDeliverTargetIsAWorkspace() {
        return this.fWarningDeliverTargetIsAWorkspace;
    }

    protected synchronized void setWarningDeliverTargetIsAWorkspace(boolean isWorkspace) {
        this.fWarningDeliverTargetIsAWorkspace = isWorkspace;
    }

    protected synchronized String getOtherBuildDefinitionWithSameDeliverTarget() {
        return this.fOtherBuildDefinitionWithSameDeliverTarget;
    }

    private synchronized void setOtherBuildDefinitionWithSameDeliverTarget(String buildDefinitionName) {
        this.fOtherBuildDefinitionWithSameDeliverTarget = buildDefinitionName;
    }

    private boolean getShouldShowDeliverTargetInUseWarningDialog() {
        return this.fShouldShowDeliverTargetAlreadyUsedDialog;
    }

    private void setShouldShowDeliverTargetInUseWarningDialog(boolean shouldShowDialog) {
        this.fShouldShowDeliverTargetAlreadyUsedDialog = shouldShowDialog;
    }

    protected IHyperlinkListener getDeliverTargetHyperlinkListener() {
        return new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                AutoDeliverConfigurationEditor.this.openWorkspaceEditor();
            }
        };
    }

    protected void openWorkspaceEditor() {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            TeamPlacePart2.open((IWorkbenchPage)page, (TeamPlaceEditorInput)TeamPlaceEditorInput.newForEdit((AbstractPlaceWrapper)AbstractPlaceWrapper.newWrapper((IWorkspace)this.getDeliverTarget())));
        }
    }

    protected SelectionListener getSelectDeliverTargetButtonSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IWorkspace workspace = AutoDeliverConfigurationEditor.this.openDeliverTargetChooserDialog(AutoDeliverConfigurationEditor.this.fDeliverTargetTitleHyperlink.getShell(), AutoDeliverConfigurationEditor.this.getTeamRepository());
                if (workspace != null && (workspace.isStream() || AutoDeliverConfigurationEditor.this.confirmWorkspaceAsDeliverTargetSelection())) {
                    AutoDeliverConfigurationEditor.this.setNewDeliverTarget(workspace);
                }
            }
        };
    }

    protected IWorkspace openDeliverTargetChooserDialog(Shell shell, ITeamRepository teamRepository) {
        AbstractPlaceWrapper wrapper = WorkspaceAndStreamSelectionDialog.getWorkspaceOrStream((Shell)shell, (ITeamRepository)teamRepository, null, (WORKSPACES_OR_STREAMS)WORKSPACES_OR_STREAMS.STREAMS, null);
        if (wrapper != null) {
            return wrapper.getWorkspace();
        }
        return null;
    }

    protected boolean confirmWorkspaceAsDeliverTargetSelection() {
        return MessageDialog.openQuestion((Shell)this.fDeliverTargetTitleHyperlink.getShell(), (String)BuildDefinitionEditorMessages.AutoDeliverConfigurationEditor_CONFIRM_DELIVER_TARGET_SELECTION_DIALOG_TITLE, (String)BuildDefinitionEditorMessages.AutoDeliverConfigurationEditor_CONFIRM_DELIVER_TARGET_SELECTION_DIALOG_DESCRIPTION);
    }

    protected void setNewDeliverTarget(IWorkspace deliverTarget) {
        if (deliverTarget != null) {
            this.setDeliverTarget(deliverTarget);
            this.setWarningDeliverTargetIsAWorkspace(!deliverTarget.isStream());
            this.setDeliverTargetUUIDBuildProperty(deliverTarget.getItemId().getUuidValue());
            this.setDeliverTargetNameText(deliverTarget.getName(), true);
            this.setDirty(true);
            this.createJobToGetOtherBuildDefinitionWithSameDeliverTarget();
            this.validate();
        }
    }

    private void setDeliverTargetNameText(String text, boolean isDeliverTargetSet) {
        this.fDeliverTargetNameText.setText(text);
        this.fDeliverTargetNameText.setEnabled(isDeliverTargetSet);
        this.setWorkspaceTitleHyperlinkEnablement(isDeliverTargetSet);
    }

    private void setWorkspaceTitleHyperlinkEnablement(boolean enabled) {
        this.fDeliverTargetTitleHyperlink.setForeground(enabled ? this.fEnabledHyperlinkForegroundColor : this.fDisabledHyperlinkForegroundColor);
        this.fDeliverTargetTitleHyperlink.setUnderlined(enabled);
        this.fDeliverTargetTitleHyperlink.setEnabled(enabled);
    }

    private void createComponentsToDeliverWidgets(Composite parent) {
        Section section = this.createSection(parent, BuildDefinitionEditorMessages.AutoDeliverConfigurationEditor_COMPONENTS_TO_DELIVER_SECTION_TEXT, BuildDefinitionEditorMessages.AutoDeliverConfigurationEditor_COMPONENTS_TO_DELIVER_SECTION_DESCRIPTION, false, 4);
        Composite composite = (Composite)section.getClient();
        boolean isDeliverAllcomponents = this.getDeliverAllComponentsBuildProperty();
        this.fDeliverAllComponentsButton = this.fToolkit.createButton(composite, BuildDefinitionEditorMessages.AutoDeliverConfigurationEditor_DELIVER_ALL_COMPONENTS_BUTTON_DESCRIPTION, 32);
        TableWrapData layoutData = new TableWrapData(2, 32, 1, 4);
        this.fDeliverAllComponentsButton.setLayoutData((Object)layoutData);
        this.fDeliverAllComponentsButton.setSelection(isDeliverAllcomponents);
        this.fDeliverAllComponentsButton.addSelectionListener(this.getDeliverAllComponentsButtonSelectionListener());
        this.createInfoLabel(composite, NLS.bind((String)BuildDefinitionEditorMessages.AutoDeliverConfigurationEditor_DELIVER_ALL_COMPONENTS_BUILD_PROPERTY, (Object)"team.scm.deliver.deliverAllComponents", (Object[])new Object[0]), 4);
        this.createSpacer(composite, 10, 4);
        String componentsToDeliverValue = this.getComponentsToDeliverBuildProperty();
        this.setComponentsToDeliver(new LoadComponents(this.getTeamRepository(), componentsToDeliverValue));
        this.createLabel(composite, BuildDefinitionEditorMessages.AutoDeliverConfigurationEditor_COMPONENTS_TO_DELIVER_INTRO_LABEL);
        this.fComponentsToDeliverText = this.fToolkit.createText(composite, componentsToDeliverValue, 0);
        this.fComponentsToDeliverText.setEnabled(false);
        this.fComponentsToDeliverText.setEditable(false);
        layoutData = new TableWrapData(256, 32);
        layoutData.maxWidth = 200;
        this.fComponentsToDeliverText.setLayoutData((Object)layoutData);
        this.fSelectComponentsToDeliverButton = this.fToolkit.createButton(composite, BuildDefinitionEditorMessages.AutoDeliverConfigurationEditor_SELECT_COMPONENTS_TO_DELIVER_BUTTON_TITLE, 0);
        this.fSelectComponentsToDeliverButton.addSelectionListener(this.getSelectComponentsToDeliverButtonSelectionListener());
        this.fClearComponentsToDeliverButton = this.fToolkit.createButton(composite, BuildDefinitionEditorMessages.AutoDeliverConfigurationEditor_CLEAR_COMPONENTS_TO_DELIVER_BUTTON_TITLE, 0);
        this.fClearComponentsToDeliverButton.addSelectionListener(this.getClearComponentsToDeliverButtonSelectionListener());
        this.updateComponentsToDeliver();
        this.updateComponentsToDeliverButtonsEnablement();
        this.createInfoLabel(composite, NLS.bind((String)BuildDefinitionEditorMessages.AutoDeliverConfigurationEditor_COMPONENTS_TO_DELIVER_BUILD_PROPERTY, (Object)"team.scm.deliver.componentsToDeliver", (Object[])new Object[0]), 4);
        this.createSpacer(composite, 10, 4);
        boolean isAddNewComponents = this.getAddNewComponentsBuildProperty();
        this.fAddNewComponentsToTargetButton = this.fToolkit.createButton(composite, BuildDefinitionEditorMessages.AutoDeliverConfigurationEditor_ADD_NEW_COMPONENTS_BUTTON_DESCRIPTION, 32);
        layoutData = new TableWrapData(2, 32, 1, 4);
        this.fAddNewComponentsToTargetButton.setLayoutData((Object)layoutData);
        this.fAddNewComponentsToTargetButton.setSelection(isAddNewComponents);
        this.fAddNewComponentsToTargetButton.addSelectionListener(this.getAddNewComponentsToTargetButtonSelectionListener());
        this.createInfoLabel(composite, NLS.bind((String)BuildDefinitionEditorMessages.AutoDeliverConfigurationEditor_ADD_NEW_COMPONENTS_BUILD_PROPERTY, (Object)"team.scm.deliver.addNewComponentsToTarget", (Object[])new Object[0]), 4);
        this.createSpacer(composite, 10, 4);
        boolean isRemoveComponentsInTarget = this.getRemoveComponentsInTargetBuildProperty();
        this.fRemoveComponentsInTargetButton = this.fToolkit.createButton(composite, BuildDefinitionEditorMessages.AutoDeliverConfigurationEditor_REMOVE_COMPONENTS_IN_DELIVER_TARGET_BUTTON_DESCRIPTION, 32);
        layoutData = new TableWrapData(2, 32, 1, 4);
        this.fRemoveComponentsInTargetButton.setLayoutData((Object)layoutData);
        this.fRemoveComponentsInTargetButton.setSelection(isRemoveComponentsInTarget);
        this.fRemoveComponentsInTargetButton.addSelectionListener(this.getRemoveComponentsInTargetButtonSelectionListener());
        this.createInfoLabel(composite, NLS.bind((String)BuildDefinitionEditorMessages.AutoDeliverConfigurationEditor_REMOVE_COMPONENTS_IN_DELIVER_TARGET_BUILD_PROPERTY, (Object)"team.scm.deliver.removeComponentsInTarget", (Object[])new Object[0]), 4);
    }

    protected SelectionListener getDeliverAllComponentsButtonSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selection = AutoDeliverConfigurationEditor.this.fDeliverAllComponentsButton.getSelection();
                AutoDeliverConfigurationEditor.this.setDeliverAllComponentsBuildProperty(selection);
                AutoDeliverConfigurationEditor.this.updateComponentsToDeliver();
                AutoDeliverConfigurationEditor.this.updateComponentsToDeliverButtonsEnablement();
                AutoDeliverConfigurationEditor.this.updateSnapshotOwnerButtonEnablement();
                AutoDeliverConfigurationEditor.this.setDirty(true);
                AutoDeliverConfigurationEditor.this.validate();
            }
        };
    }

    protected void updateComponentsToDeliverButtonsEnablement() {
        this.fSelectComponentsToDeliverButton.setEnabled(!this.fDeliverAllComponentsButton.getSelection() && this.getBuildWorkspace() != null);
        this.fClearComponentsToDeliverButton.setEnabled(!this.fDeliverAllComponentsButton.getSelection() && this.getComponentsToDeliver().getComponentHandles().size() > 0);
    }

    protected SelectionListener getAddNewComponentsToTargetButtonSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AutoDeliverConfigurationEditor.this.setAddNewComponentsBuildProperty(AutoDeliverConfigurationEditor.this.fAddNewComponentsToTargetButton.getSelection());
                AutoDeliverConfigurationEditor.this.setDirty(true);
                AutoDeliverConfigurationEditor.this.validate();
            }
        };
    }

    protected SelectionListener getRemoveComponentsInTargetButtonSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AutoDeliverConfigurationEditor.this.setRemoveComponentsInTargetBuildProperty(AutoDeliverConfigurationEditor.this.fRemoveComponentsInTargetButton.getSelection());
                AutoDeliverConfigurationEditor.this.setDirty(true);
                AutoDeliverConfigurationEditor.this.validate();
            }
        };
    }

    protected synchronized void getBuildWorkspaceFromJazzScmProperty() {
        String workspaceUUID = this.getBuildWorkspaceUUIDBuildProperty();
        if (workspaceUUID.length() > 0) {
            try {
                final IWorkspaceHandle workspaceHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)workspaceUUID), null);
                if (workspaceHandle != null) {
                    String fetchBuildWorkspaceJobName = BuildDefinitionEditorMessages.AutoDeliverConfigurationEditor_FETCHING_BUILD_WORKSPACE_JOB_NAME;
                    TeamBuildJob fetchBuildWorkspaceJob = new TeamBuildJob(fetchBuildWorkspaceJobName, true, this.getTeamRepository()){

                        protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                            AutoDeliverConfigurationEditor.this.handleBuildWorkspaceUpdated(AutoDeliverConfigurationEditor.this.fetchWorkspace(workspaceHandle, monitor));
                            return Status.OK_STATUS;
                        }
                    };
                    fetchBuildWorkspaceJob.schedule();
                }
            }
            catch (IllegalArgumentException e) {
                BuildUIPlugin.log(e);
            }
        }
    }

    protected synchronized void getComponentsToExcludeFromJazzScmProperty() {
        String componentsToExclude = this.getComponentsToExcludeBuildProperty();
        this.setComponentsToExclude(new LoadComponents(this.getTeamRepository(), componentsToExclude));
    }

    protected void handleBuildWorkspaceUpdated(final IWorkspace workspace) {
        this.setBuildWorkspace(workspace);
        this.createJobToVerifyComponentsToDeliverExistInWorkspace();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                AutoDeliverConfigurationEditor.this.setWarningNoBuildWorkspaceSelected(workspace == null);
                if (!AutoDeliverConfigurationEditor.this.fSelectComponentsToDeliverButton.isDisposed() && !AutoDeliverConfigurationEditor.this.fDeliverAllComponentsButton.isDisposed()) {
                    AutoDeliverConfigurationEditor.this.updateComponentsToDeliverButtonsEnablement();
                    AutoDeliverConfigurationEditor.this.validate();
                }
            }
        });
    }

    protected synchronized IWorkspace getBuildWorkspace() {
        return this.fBuildWorkspace;
    }

    protected synchronized void setBuildWorkspace(IWorkspace workspace) {
        this.fBuildWorkspace = workspace;
    }

    protected synchronized LoadComponents getComponentsToExclude() {
        return this.fComponentsToExclude;
    }

    protected synchronized void setComponentsToExclude(LoadComponents componentsToExclude) {
        this.fComponentsToExclude = componentsToExclude;
        this.verifyComponentsToDeliverAgainstComponentsToExclude(this.getComponentsToDeliver(), componentsToExclude);
    }

    protected synchronized LoadComponents getComponentsToDeliver() {
        return this.fComponentsToDeliver;
    }

    protected synchronized void setComponentsToDeliver(LoadComponents componentsToDeliver) {
        this.fComponentsToDeliver = componentsToDeliver;
    }

    protected synchronized boolean getWarningNoComponentsToDeliver() {
        return this.fWarningNoComponentsToDeliver;
    }

    protected synchronized void setWarningNoComponentsToDeliver(boolean noComponents) {
        this.fWarningNoComponentsToDeliver = noComponents;
    }

    protected synchronized boolean getWarningSomeComponentsToDeliverNoLongerExist() {
        return this.fWarningSomeComponentsToDeliverNoLongerExist;
    }

    protected synchronized void setWarningSomeComponentsToDeliverNoLongerExist(boolean missingComponents) {
        this.fWarningSomeComponentsToDeliverNoLongerExist = missingComponents;
    }

    protected synchronized boolean getWarningDeliveringFromComponentsToExclude() {
        return this.fWarningDeliveringFromComponentsToExclude;
    }

    protected synchronized void setWarningDeliveringFromComponentsToExclude(boolean warningDeliveringFromComponentsToExclude) {
        this.fWarningDeliveringFromComponentsToExclude = warningDeliveringFromComponentsToExclude;
    }

    protected synchronized boolean getWarningNoBuildWorkspaceSelected() {
        return this.fWarningNoBuildWorkspaceSelected;
    }

    protected synchronized void setWarningNoBuildWorkspaceSelected(boolean warningNoBuildWorkspaceSelected) {
        this.fWarningNoBuildWorkspaceSelected = warningNoBuildWorkspaceSelected;
    }

    protected SelectionListener getSelectComponentsToDeliverButtonSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Collection initialSelection = AutoDeliverConfigurationEditor.this.getComponentsToDeliver() != null ? AutoDeliverConfigurationEditor.this.getComponentsToDeliver().getComponentHandles() : Collections.EMPTY_LIST;
                Collection<IComponentHandle> componentsToDeliver = AutoDeliverConfigurationEditor.this.openComponentsToDeliverSelector(initialSelection);
                if (componentsToDeliver != null) {
                    if (initialSelection != componentsToDeliver) {
                        AutoDeliverConfigurationEditor.this.setWarningSomeComponentsToDeliverNoLongerExist(false);
                    }
                    AutoDeliverConfigurationEditor.this.newComponentsToDeliverSelected(componentsToDeliver);
                }
            }
        };
    }

    protected SelectionListener getClearComponentsToDeliverButtonSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AutoDeliverConfigurationEditor.this.confirmClearComponentsToDeliver()) {
                    AutoDeliverConfigurationEditor.this.setComponentsToDeliver(new LoadComponents((Collection)Collections.EMPTY_LIST));
                    AutoDeliverConfigurationEditor.this.updateComponentsToDeliver();
                    AutoDeliverConfigurationEditor.this.validate();
                    AutoDeliverConfigurationEditor.this.setDirty(true);
                    AutoDeliverConfigurationEditor.this.setComponentsToDeliverBuildProperty("");
                }
            }
        };
    }

    protected boolean confirmClearComponentsToDeliver() {
        return MessageDialog.openConfirm((Shell)this.fClearComponentsToDeliverButton.getShell(), (String)BuildDefinitionEditorMessages.AutoDeliverConfigurationEditor_CLEAR_COMPONENTS_TO_DELIVER_CONFIRM_TITLE, (String)BuildDefinitionEditorMessages.AutoDeliverConfigurationEditor_CLEAR_COMPONENTS_TO_DELIVER_CONFIRM_TEXT);
    }

    protected Collection<IComponentHandle> openComponentsToDeliverSelector(Collection<IComponentHandle> initialSelection) {
        try {
            Collection componentsToDeliver = initialSelection;
            IWorkspace buildWorkspace = this.getBuildWorkspace();
            if (buildWorkspace != null) {
                componentsToDeliver = WorkspaceComponentSelectionDialog.pickWorkspaceComponents((Shell)this.fSelectComponentsToDeliverButton.getShell(), (ITeamRepository)this.getTeamRepository(), (IWorkspace)buildWorkspace, (String)BuildDefinitionEditorMessages.AutoDeliverConfigurationEditor_PICK_COMPONENTS_TO_DELIVER_TITLE, (String)BuildDefinitionEditorMessages.AutoDeliverConfigurationEditor_PICK_COMPONENTS_TO_DELIVER_DESC, initialSelection, null);
            }
            return componentsToDeliver;
        }
        catch (TeamRepositoryException e) {
            BuildUIPlugin.log(e);
            return initialSelection;
        }
    }

    protected void updateComponentsToDeliver() {
        this.verifyComponentsToDeliverAgainstComponentsToExclude(this.getComponentsToDeliver(), this.getComponentsToExclude());
        if (this.fDeliverAllComponentsButton.getSelection()) {
            this.fComponentsToDeliverText.setText("");
        } else {
            int numComponentsToDeliver = this.getComponentsToDeliver().getComponentHandles().size();
            if (numComponentsToDeliver == 0) {
                this.setWarningSomeComponentsToDeliverNoLongerExist(false);
                this.setWarningDeliveringFromComponentsToExclude(false);
                this.setWarningNoComponentsToDeliver(true);
                this.fComponentsToDeliverText.setText("");
            } else {
                this.setWarningNoComponentsToDeliver(false);
                String messageId = numComponentsToDeliver > 1 ? BuildDefinitionEditorMessages.AutoDeliverConfigurationEditor_NUMBER_OF_COMPONENTS_TO_DELIVER_TEXT_MULTI : BuildDefinitionEditorMessages.AutoDeliverConfigurationEditor_NUMBER_OF_COMPONENTS_TO_DELIVER_TEXT;
                this.fComponentsToDeliverText.setText(NLS.bind((String)messageId, (Object)numComponentsToDeliver, (Object[])new Object[0]));
            }
            this.updateComponentsToDeliverButtonsEnablement();
        }
    }

    protected void newComponentsToDeliverSelected(Collection<IComponentHandle> componentsToDeliver) {
        if (componentsToDeliver != null) {
            this.setComponentsToDeliver(new LoadComponents(componentsToDeliver));
            String componentsToDeliverString = this.getComponentsToDeliver().getBuildProperty();
            this.setComponentsToDeliverBuildProperty(componentsToDeliverString);
            this.updateComponentsToDeliver();
            this.validate();
            this.setDirty(true);
        }
    }

    private void createJobToVerifyComponentsToDeliverExistInWorkspace() {
        if (this.getComponentsToDeliver() != null && this.getComponentsToDeliver().getComponentHandles().size() > 0) {
            TeamBuildJob verifyingComponentsToDeliverJob = new TeamBuildJob(BuildDefinitionEditorMessages.AutoDeliverConfigurationEditor_VERIFY_COMPONENTS_EXIST_IN_WORKSPACE_JOB_NAME, false, this.getTeamRepository()){

                protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                    IWorkspace buildWorkspace = AutoDeliverConfigurationEditor.this.getBuildWorkspace();
                    if (buildWorkspace != null) {
                        AutoDeliverConfigurationEditor.this.verifyComponentsToDeliverExistInWorkspace(AutoDeliverConfigurationEditor.this.getTeamRepository(), buildWorkspace, AutoDeliverConfigurationEditor.this.getComponentsToDeliver().getComponentHandles(), monitor);
                    } else {
                        AutoDeliverConfigurationEditor.this.setWarningSomeComponentsToDeliverNoLongerExist(false);
                    }
                    return Status.OK_STATUS;
                }
            };
            verifyingComponentsToDeliverJob.schedule();
        } else {
            this.setWarningSomeComponentsToDeliverNoLongerExist(false);
        }
    }

    protected void verifyComponentsToDeliverExistInWorkspace(ITeamRepository repo, IWorkspace buildWorkspace, Collection<IComponentHandle> currentComponentsToDeliverList, IProgressMonitor progress) {
        boolean isMissingComponents = false;
        if (currentComponentsToDeliverList != null && currentComponentsToDeliverList.size() > 0) {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
            try {
                IWorkspaceConnection connection = SCMPlatform.getWorkspaceManager((ITeamRepository)this.getTeamRepository()).getWorkspaceConnection((IWorkspaceHandle)buildWorkspace, (IProgressMonitor)monitor.newChild(10));
                for (IComponentHandle componentHandle : currentComponentsToDeliverList) {
                    try {
                        connection.getComponentInfo(componentHandle);
                    }
                    catch (ComponentNotInWorkspaceException exception) {
                        isMissingComponents = true;
                        break;
                    }
                }
            }
            catch (TeamRepositoryException e) {
                BuildUIPlugin.log(e);
            }
        }
        this.setWarningSomeComponentsToDeliverNoLongerExist(isMissingComponents);
        this.handleUpdateToMissingComponentInComponentsToDeliverList();
    }

    private void handleUpdateToMissingComponentInComponentsToDeliverList() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!AutoDeliverConfigurationEditor.this.fComponentsToDeliverText.isDisposed()) {
                    AutoDeliverConfigurationEditor.this.validate();
                }
            }
        });
    }

    protected void verifyComponentsToDeliverAgainstComponentsToExclude(LoadComponents componentsToDeliver, LoadComponents componentsToExclude) {
        boolean isDeliveredComponentsAlsoExcluded = false;
        if (componentsToDeliver != null && componentsToExclude != null) {
            Collection intersection;
            isDeliveredComponentsAlsoExcluded = this.fDeliverAllComponentsButton.getSelection() && componentsToExclude.getComponentHandles().size() > 0 ? true : (intersection = componentsToExclude.getIntersectingComponents(componentsToDeliver.getComponentHandles())).size() > 0;
        }
        this.setWarningDeliveringFromComponentsToExclude(isDeliveredComponentsAlsoExcluded);
        this.validate();
    }

    private void createSnapshotOwnerWidgets(Composite parent) {
        Section section = this.createSection(parent, BuildDefinitionEditorMessages.AutoDeliverConfigurationEditor_SNAPSHOT_OWNER_SECTION_TEXT, BuildDefinitionEditorMessages.AutoDeliverConfigurationEditor_SNAPSHOT_OWNER_SECTION_DESCRIPTION, false, 2);
        Composite composite = (Composite)section.getClient();
        Composite labelComposite = this.fToolkit.createComposite(composite);
        GridLayoutFactory.fillDefaults().applyTo(labelComposite);
        labelComposite.setLayoutData((Object)new TableWrapData(2, 16));
        Label groupLabel = this.fToolkit.createLabel(labelComposite, BuildDefinitionEditorMessages.AutoDeliverConfigurationEditor_SNAPSHOT_OWNER_BUTTON_GROUP_LABEL);
        boolean changeSnapshotOwner = this.getChangeSnapshotOwnerBuildProperty();
        Composite group = this.fToolkit.createComposite(composite);
        group.setLayout((Layout)new TableWrapLayout());
        group.setLayoutData((Object)new TableWrapData(256, 256, 1, 1));
        GridDataFactory.fillDefaults().indent(0, group.getClientArea().y + 6).applyTo((Control)groupLabel);
        this.fDoNotChangeSnapshotOwnerButton = this.fToolkit.createButton(group, BuildDefinitionEditorMessages.AutoDeliverConfigurationEditor_SNAPSHOT_OWNER_DO_NOT_CHANGE_BUTTON_DESCRIPTION, 16);
        this.fDoNotChangeSnapshotOwnerButton.setSelection(!changeSnapshotOwner);
        this.fDoNotChangeSnapshotOwnerButton.setEnabled(this.fDeliverAllComponentsButton.getSelection());
        this.fDoNotChangeSnapshotOwnerButton.addSelectionListener(this.getDoNotChangeSnapshotOwnerButtonSelectionListener());
        this.fDoNotChangeSnapshotOwnerButton.setLayoutData((Object)new TableWrapData());
        this.fChangeSnapshotOwnerButton = this.fToolkit.createButton(group, BuildDefinitionEditorMessages.AutoDeliverConfigurationEditor_SNAPSHOT_OWNER_DO_CHANGE_BUTTON_DESCRIPTION, 16);
        this.fChangeSnapshotOwnerButton.setSelection(changeSnapshotOwner);
        this.fChangeSnapshotOwnerButton.setEnabled(this.fDeliverAllComponentsButton.getSelection());
        this.fChangeSnapshotOwnerButton.addSelectionListener(this.getChangeSnapshotOwnerButtonSelectionListener());
        this.fChangeSnapshotOwnerButton.setLayoutData((Object)new TableWrapData());
        this.createInfoLabel(composite, NLS.bind((String)BuildDefinitionEditorMessages.AutoDeliverConfigurationEditor_SNAPSHOT_OWNER_BUILD_PROPERTY, (Object)"team.scm.deliver.changeSnapshotOwner", (Object[])new Object[0]), 2);
    }

    protected SelectionListener getDoNotChangeSnapshotOwnerButtonSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AutoDeliverConfigurationEditor.this.fDoNotChangeSnapshotOwnerButton.getSelection()) {
                    AutoDeliverConfigurationEditor.this.setChangeSnapshotOwnerBuildProperty(false);
                    AutoDeliverConfigurationEditor.this.setDirty(true);
                    AutoDeliverConfigurationEditor.this.validate();
                }
            }
        };
    }

    protected SelectionListener getChangeSnapshotOwnerButtonSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AutoDeliverConfigurationEditor.this.fChangeSnapshotOwnerButton.getSelection()) {
                    AutoDeliverConfigurationEditor.this.setChangeSnapshotOwnerBuildProperty(true);
                    AutoDeliverConfigurationEditor.this.setDirty(true);
                    AutoDeliverConfigurationEditor.this.validate();
                }
            }
        };
    }

    protected void updateSnapshotOwnerButtonEnablement() {
        boolean deliverAll = this.fDeliverAllComponentsButton.getSelection();
        this.fDoNotChangeSnapshotOwnerButton.setEnabled(deliverAll);
        this.fChangeSnapshotOwnerButton.setEnabled(deliverAll);
    }

    private Label createInfoLabel(Composite parent, String text, int colSpan) {
        Label label = this.fToolkit.createLabel(parent, text, 64);
        label.setForeground(Display.getDefault().getSystemColor(16));
        label.setLayoutData((Object)new TableWrapData(2, 32, 1, colSpan));
        return label;
    }

    private Label createLabel(Composite parent, String text) {
        Label label = this.fToolkit.createLabel(parent, text, 0);
        label.setLayoutData((Object)new TableWrapData(2, 32));
        return label;
    }

    @Override
    public boolean validate() {
        boolean isValid = true;
        boolean isWarning = false;
        String buildDefinitionWithSameDeliverTarget = this.getOtherBuildDefinitionWithSameDeliverTarget();
        if (this.fDeliverTargetNameText.getText().trim().length() == 0) {
            this.addErrorMessageForRequiredField(this.fDeliverTargetNameText, BuildDefinitionEditorMessages.AutoDeliverConfigurationEditor_DELIVER_TARGET_REQUIRED, (Control)this.fDeliverTargetNameText);
            isValid = false;
        } else if (buildDefinitionWithSameDeliverTarget != null) {
            isWarning = true;
            this.addWarningMessage(this.fDeliverTargetNameText, NLS.bind((String)BuildDefinitionEditorMessages.AutoDeliverConfigurationEditor_DELIVER_TARGET_USED_ALREADY_WARNING_HEADER, (Object)buildDefinitionWithSameDeliverTarget, (Object[])new Object[0]), (Control)this.fDeliverTargetNameText);
        } else if (this.getWarningDeliverTargetIsAWorkspace()) {
            isWarning = true;
            this.addWarningMessage(this.fDeliverTargetNameText, BuildDefinitionEditorMessages.AutoDeliverConfigurationEditor_WARNING_DELIVER_TARGET_IS_A_WORKSPACE, (Control)this.fDeliverTargetNameText);
        } else {
            this.removeMessage(this.fDeliverTargetNameText, (Control)this.fDeliverTargetNameText);
        }
        if (this.fDeliverAllComponentsButton.getSelection()) {
            this.removeMessage(this.fComponentsToDeliverText, (Control)this.fComponentsToDeliverText);
            if (this.getWarningNoBuildWorkspaceSelected()) {
                isWarning = true;
                this.addWarningMessage(this.fDeliverAllComponentsButton, NLS.bind((String)BuildDefinitionEditorMessages.AutoDeliverConfigurationEditor_WARNING_ALL_COMPONENTS_LABEL, (Object)BuildDefinitionEditorMessages.AutoDeliverConfigurationEditor_WARNING_NO_BUILD_WORKSPACE_SELECTED, (Object[])new Object[0]), (Control)this.fDeliverAllComponentsButton);
            } else if (this.getWarningDeliveringFromComponentsToExclude()) {
                isWarning = true;
                this.addWarningMessage(this.fDeliverAllComponentsButton, NLS.bind((String)BuildDefinitionEditorMessages.AutoDeliverConfigurationEditor_WARNING_ALL_COMPONENTS_LABEL, (Object)BuildDefinitionEditorMessages.AutoDeliverConfigurationEditor_WARNING_COMPONENTS_ALSO_IN_COMPONENTS_TO_EXCLUDE, (Object[])new Object[0]), (Control)this.fDeliverAllComponentsButton);
            } else {
                this.removeMessage(this.fDeliverAllComponentsButton, (Control)this.fDeliverAllComponentsButton);
            }
        } else {
            this.removeMessage(this.fDeliverAllComponentsButton, (Control)this.fDeliverAllComponentsButton);
            if (this.getWarningNoBuildWorkspaceSelected()) {
                isWarning = true;
                this.addWarningMessage(this.fComponentsToDeliverText, BuildDefinitionEditorMessages.AutoDeliverConfigurationEditor_WARNING_NO_BUILD_WORKSPACE_SELECTED, (Control)this.fComponentsToDeliverText);
            } else if (this.getWarningDeliveringFromComponentsToExclude()) {
                isWarning = true;
                this.addWarningMessage(this.fComponentsToDeliverText, BuildDefinitionEditorMessages.AutoDeliverConfigurationEditor_WARNING_COMPONENTS_ALSO_IN_COMPONENTS_TO_EXCLUDE, (Control)this.fComponentsToDeliverText);
            } else if (this.getWarningNoComponentsToDeliver()) {
                isWarning = true;
                this.addWarningMessage(this.fComponentsToDeliverText, BuildDefinitionEditorMessages.AutoDeliverConfigurationEditor_WARNING_COMPONENTS_TO_DELIVER_IS_EMPTY, (Control)this.fComponentsToDeliverText);
            } else if (this.getWarningSomeComponentsToDeliverNoLongerExist()) {
                isWarning = true;
                this.addWarningMessage(this.fComponentsToDeliverText, BuildDefinitionEditorMessages.AutoDeliverConfigurationEditor_WARNING_COMPONENTS_TO_DELIVER_HAS_NON_EXISTANT_COMPONENTS, (Control)this.fComponentsToDeliverText);
            } else {
                this.removeMessage(this.fComponentsToDeliverText, (Control)this.fComponentsToDeliverText);
            }
        }
        this.setPageStatusIndicator(!isValid, isWarning);
        return isValid;
    }

    @Override
    public Control getFocusControl() {
        return this.fSelectDeliverTargetButton;
    }

    public void dispose() {
        super.dispose();
        if (this.fWorkingCopy != null) {
            ((BuildDefinition)this.fWorkingCopy).eAdapters().remove((Object)this.fPropertyChangedAdapter);
        }
    }

    @Override
    public void setWorkingCopy(IBuildDefinition definition) {
        if (this.fWorkingCopy != null) {
            ((BuildDefinition)this.fWorkingCopy).eAdapters().remove((Object)this.fPropertyChangedAdapter);
        }
        super.setWorkingCopy(definition);
        ((BuildDefinition)this.fWorkingCopy).eAdapters().add((Object)this.fPropertyChangedAdapter);
    }

    @Override
    protected String getContextHelpId() {
        return "com.ibm.team.build.ui.editor_builddefinitionpostbuilddeliver";
    }

    protected boolean getAutoDeliverEnabledBuildProperty() {
        IBuildProperty property = this.fWorkingCopy.getProperty("team.scm.deliver.enabled");
        if (property != null && property.getValue().length() > 0) {
            return Boolean.valueOf(property.getValue());
        }
        return true;
    }

    protected void setAutoDeliverEnabledBuildProperty(boolean isAutoDeliverEnabled) {
        this.fWorkingCopy.setProperty("team.scm.deliver.enabled", Boolean.toString(isAutoDeliverEnabled));
    }

    protected AutoDeliverTriggerPolicy getAutoDeliverTriggerPolicyBuildProperty() {
        AutoDeliverTriggerPolicy policy = AutoDeliverTriggerPolicy.NO_WARNINGS;
        IBuildProperty property = this.fWorkingCopy.getProperty("team.scm.deliver.triggerPolicy");
        if (property != null && property.getValue().length() > 0) {
            String autoDeliverTriggerPolicyValue = property.getValue();
            try {
                policy = AutoDeliverTriggerPolicy.valueOf((String)autoDeliverTriggerPolicyValue.trim().toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return policy;
    }

    protected void setAutoDeliverTriggerPolicyBuildProperty(AutoDeliverTriggerPolicy policy) {
        this.fWorkingCopy.setProperty("team.scm.deliver.triggerPolicy", policy.name());
    }

    protected String getDeliverTargetUUIDBuildProperty() {
        IBuildProperty property = this.fWorkingCopy.getProperty("team.scm.deliver.targetUUID");
        if (property != null && property.getValue().length() > 0) {
            return property.getValue();
        }
        return "";
    }

    protected boolean getAbortOnIncompleteActivityBuildProperty() {
        IBuildProperty property = this.fWorkingCopy.getProperty("team.scm.deliver.abortOnIncompleteActivity");
        if (property != null && property.getValue().length() > 0) {
            return Boolean.valueOf(property.getValue());
        }
        return true;
    }

    protected void setAbortOnIncompleteActivityBuildProperty(boolean isAbortOnIncompleteActivity) {
        this.fWorkingCopy.setProperty("team.scm.deliver.abortOnIncompleteActivity", Boolean.toString(isAbortOnIncompleteActivity));
    }

    protected void setDeliverTargetUUIDBuildProperty(String deliverTarget) {
        this.fWorkingCopy.setProperty("team.scm.deliver.targetUUID", deliverTarget);
    }

    protected boolean getDeliverAllComponentsBuildProperty() {
        IBuildProperty property = this.fWorkingCopy.getProperty("team.scm.deliver.deliverAllComponents");
        if (property != null && property.getValue().length() > 0) {
            return Boolean.valueOf(property.getValue());
        }
        return true;
    }

    protected void setDeliverAllComponentsBuildProperty(boolean deliverAllComponents) {
        this.fWorkingCopy.setProperty("team.scm.deliver.deliverAllComponents", Boolean.toString(deliverAllComponents));
    }

    protected String getComponentsToDeliverBuildProperty() {
        IBuildProperty property = this.fWorkingCopy.getProperty("team.scm.deliver.componentsToDeliver");
        if (property != null && property.getValue().length() > 0) {
            return property.getValue();
        }
        return "";
    }

    protected void setComponentsToDeliverBuildProperty(String componentsToDeliver) {
        this.fWorkingCopy.setProperty("team.scm.deliver.componentsToDeliver", componentsToDeliver);
    }

    protected boolean getAddNewComponentsBuildProperty() {
        IBuildProperty property = this.fWorkingCopy.getProperty("team.scm.deliver.addNewComponentsToTarget");
        if (property != null && property.getValue().length() > 0) {
            return Boolean.valueOf(property.getValue());
        }
        return false;
    }

    protected void setAddNewComponentsBuildProperty(boolean addNewComponents) {
        this.fWorkingCopy.setProperty("team.scm.deliver.addNewComponentsToTarget", Boolean.toString(addNewComponents));
    }

    protected boolean getRemoveComponentsInTargetBuildProperty() {
        IBuildProperty property = this.fWorkingCopy.getProperty("team.scm.deliver.removeComponentsInTarget");
        if (property != null && property.getValue().length() > 0) {
            return Boolean.valueOf(property.getValue());
        }
        return false;
    }

    protected void setRemoveComponentsInTargetBuildProperty(boolean removeComponentsInTarget) {
        this.fWorkingCopy.setProperty("team.scm.deliver.removeComponentsInTarget", Boolean.toString(removeComponentsInTarget));
    }

    protected String getBuildWorkspaceUUIDBuildProperty() {
        IBuildProperty property = this.fWorkingCopy.getProperty("team.scm.workspaceUUID");
        if (property != null && property.getValue().length() > 0) {
            return property.getValue();
        }
        return "";
    }

    protected String getComponentsToExcludeBuildProperty() {
        IBuildProperty property = this.fWorkingCopy.getProperty("team.scm.loadComponents");
        if (property != null && property.getValue().length() > 0) {
            return property.getValue();
        }
        return "";
    }

    protected boolean getChangeSnapshotOwnerBuildProperty() {
        IBuildProperty property = this.fWorkingCopy.getProperty("team.scm.deliver.changeSnapshotOwner");
        if (property != null && property.getValue().length() > 0) {
            return Boolean.valueOf(property.getValue());
        }
        return false;
    }

    protected void setChangeSnapshotOwnerBuildProperty(boolean changeSnapshotOwner) {
        this.fWorkingCopy.setProperty("team.scm.deliver.changeSnapshotOwner", Boolean.toString(changeSnapshotOwner));
    }
}

