/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.builddefinition;

import com.ibm.team.build.internal.ui.editors.builddefinition.BasicConfigurationElementEditor;
import com.ibm.team.build.internal.ui.editors.builddefinition.BuildDefinitionEditorMessages;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class AntConfigurationEditor
extends BasicConfigurationElementEditor {
    protected Text fBuildFileText;
    protected Text fBuildTargetsText;
    protected Text fAntHomeText;
    protected Text fAntArgsText;
    protected Text fJavaHomeText;
    protected Text fJavaArgsText;
    protected Text fWorkingDirText;
    protected Text fPropertiesFileText;
    protected Button fIncludeToolkitButton;

    public AntConfigurationEditor(String elementId, String title) {
        super(elementId, title);
    }

    @Override
    public void createContent(Composite parent, FormToolkit toolkit) {
        parent.setLayout((Layout)new TableWrapLayout());
        Section section = this.createSection(parent, BuildDefinitionEditorMessages.AntConfigurationEditor_SECTION_TITLE, BuildDefinitionEditorMessages.AntConfigurationEditor_SECTION_DESCRIPTION, false);
        Composite composite = (Composite)section.getClient();
        this.createBuildFileWidgets(composite);
        this.createBuildTargetWidgets(composite);
        this.createSpacer(parent, 15, 1);
        section = this.createSection(parent, BuildDefinitionEditorMessages.AntConfigurationEditor_CONFIG_SECTION_TEXT, BuildDefinitionEditorMessages.AntConfigurationEditor_CONFIG_SECTION_DESCRIPTION, true);
        composite = (Composite)section.getClient();
        this.createIncludeToolkitWidgets(composite);
        this.createAntHomeWidgets(composite);
        this.createAntArgsWidgets(composite);
        this.createWorkingDirWidgets(composite);
        this.createJavaHomeWidgets(composite);
        this.createJavaArgsWidgets(composite);
        this.createPropertiesFileWidgets(composite);
    }

    private void createBuildFileWidgets(Composite parent) {
        this.fBuildFileText = this.createConfigPropertyTextField(parent, "com.ibm.team.build.ant.buildFile", BuildDefinitionEditorMessages.AntConfigurationEditor_BUILD_FILE_LABEL, BuildDefinitionEditorMessages.AntConfigurationEditor_BUILD_FILE_DESC, true);
    }

    private void createBuildTargetWidgets(Composite parent) {
        this.createSpacer(parent, 10, 2);
        this.fBuildTargetsText = this.createConfigPropertyTextField(parent, "com.ibm.team.build.ant.targets", BuildDefinitionEditorMessages.AntConfigurationEditor_BUILD_TARGETS_LABEL, BuildDefinitionEditorMessages.AntConfigurationEditor_BUILD_TARGETS_DESCRIPTION, false);
    }

    private void createIncludeToolkitWidgets(Composite parent) {
        this.fIncludeToolkitButton = this.createConfigPropertyCheckboxField(parent, "com.ibm.team.build.ant.includeToolkit", true, BuildDefinitionEditorMessages.AntConfigurationEditor_TOOLKIT_LABEL, BuildDefinitionEditorMessages.AntConfigurationEditor_INCLUDE_TOOLKIT_BUTTON, BuildDefinitionEditorMessages.AntConfigurationEditor_TOOLKIT_DESCRIPTION, false);
    }

    private void createWorkingDirWidgets(Composite parent) {
        this.createSpacer(parent, 10, 2);
        this.fWorkingDirText = this.createConfigPropertyTextField(parent, "com.ibm.team.build.ant.workingDir", BuildDefinitionEditorMessages.AntConfigurationEditor_WORKING_DIR_LABEL, BuildDefinitionEditorMessages.AntConfigurationEditor_WORKING_DIR_DESC, false);
    }

    private void createPropertiesFileWidgets(Composite parent) {
        this.createSpacer(parent, 10, 2);
        this.fPropertiesFileText = this.createConfigPropertyTextField(parent, "com.ibm.team.build.ant.propertiesFile", BuildDefinitionEditorMessages.AntConfigurationEditor_PROPERTIES_LABEL, BuildDefinitionEditorMessages.AntConfigurationEditor_PROPERTIES_DESC, false);
    }

    private void createAntHomeWidgets(Composite parent) {
        this.createSpacer(parent, 10, 2);
        this.fAntHomeText = this.createConfigPropertyTextField(parent, "com.ibm.team.build.ant.antHome", BuildDefinitionEditorMessages.AntConfigurationEditor_ANT_HOME_LABEL, BuildDefinitionEditorMessages.AntConfigurationEditor_ANT_HOME_DESC, false);
    }

    private void createAntArgsWidgets(Composite parent) {
        this.createSpacer(parent, 10, 2);
        this.fAntArgsText = this.createConfigPropertyTextField(parent, "com.ibm.team.build.ant.antArgs", BuildDefinitionEditorMessages.AntConfigurationEditor_ANT_ARGS_LABEL, BuildDefinitionEditorMessages.AntConfigurationEditor_ANT_ARGS_DESC, false);
    }

    private void createJavaHomeWidgets(Composite parent) {
        this.createSpacer(parent, 10, 2);
        this.fJavaHomeText = this.createConfigPropertyTextField(parent, "com.ibm.team.build.ant.javaHome", BuildDefinitionEditorMessages.AntConfigurationEditor_JAVA_HOME_LABEL, BuildDefinitionEditorMessages.AntConfigurationEditor_JAVA_HOME_DESC, false);
    }

    private void createJavaArgsWidgets(Composite parent) {
        this.createSpacer(parent, 10, 2);
        this.fJavaArgsText = this.createConfigPropertyTextField(parent, "com.ibm.team.build.ant.javaVMArgs", BuildDefinitionEditorMessages.AntConfigurationEditor_VM_ARGS_LABEL, BuildDefinitionEditorMessages.AntConfigurationEditor_VM_ARGS_DESC, false);
    }

    @Override
    public boolean validate() {
        boolean isValid = true;
        if (this.fBuildFileText.getText().trim().equals("")) {
            this.addErrorMessageForRequiredField(this.fBuildFileText, BuildDefinitionEditorMessages.AntConfigurationEditor_BUILD_FILE_REQUIRED, (Control)this.fBuildFileText);
            isValid = false;
        } else {
            this.removeMessage(this.fBuildFileText, (Control)this.fBuildFileText);
        }
        this.setPageStatusIndicator(!isValid, false);
        return isValid;
    }

    @Override
    public Control getFocusControl() {
        return this.fBuildFileText;
    }

    @Override
    protected String getContextHelpId() {
        return "com.ibm.team.build.ui.editor_builddefinitionant";
    }
}

