/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors;

import com.ibm.team.build.internal.ui.editors.BuildItemEditor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IMessage;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class ErrorMessageHyperlinkListener
extends HyperlinkAdapter {
    private BuildItemEditor fEditor;

    public ErrorMessageHyperlinkListener(BuildItemEditor editor) {
        this.fEditor = editor;
    }

    public void linkActivated(HyperlinkEvent e) {
        Hyperlink hyperlink = (Hyperlink)e.widget;
        IMessage[] messages = (IMessage[])e.getHref();
        if (messages.length == 1) {
            this.handleErrorLinkClicked(messages[0], hyperlink.getShell());
            return;
        }
        Shell shell = this.getShell(hyperlink.getDisplay());
        shell.setBackground(this.fEditor.getHeaderForm().getForm().getBackground());
        shell.setLayout((Layout)new GridLayout());
        int i = 0;
        while (i < messages.length) {
            this.createHyperlink(shell, messages[i]);
            ++i;
        }
        Point location = hyperlink.toDisplay(hyperlink.getLocation());
        Point size = shell.computeSize(-1, -1);
        shell.setBounds(location.x - hyperlink.getLocation().x, location.y + 10, size.x, size.y);
        shell.open();
        shell.addShellListener(this.getCloseShellListener(shell));
        shell.addTraverseListener(this.getCloseTraverseListener(shell));
    }

    protected Shell getShell(Display display) {
        return new Shell(display, 18448);
    }

    protected TraverseListener getCloseTraverseListener(final Shell shell) {
        return new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2) {
                    ErrorMessageHyperlinkListener.this.closeShell(shell);
                }
            }
        };
    }

    protected ShellListener getCloseShellListener(final Shell shell) {
        return new ShellAdapter(){

            public void shellDeactivated(ShellEvent event) {
                ErrorMessageHyperlinkListener.this.closeShell(shell);
            }
        };
    }

    public void linkEntered(HyperlinkEvent e) {
        Hyperlink hyperlink = (Hyperlink)e.widget;
        IMessage[] messages = (IMessage[])e.getHref();
        if (messages.length > 1) {
            hyperlink.setToolTipText("");
        }
    }

    private ImageHyperlink createHyperlink(Shell parent, IMessage message) {
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        ImageHyperlink hyperlink = new ImageHyperlink((Composite)parent, 524352);
        if (message.getPrefix() != null) {
            hyperlink.setText(this.stripAmpersand(String.valueOf(message.getPrefix()) + message.getMessage()));
        } else {
            hyperlink.setText(message.getMessage());
        }
        hyperlink.setImage(sharedImages.getImage("IMG_OBJS_ERROR_TSK"));
        hyperlink.setUnderlined(false);
        hyperlink.setBackground(this.fEditor.getHeaderForm().getForm().getBackground());
        hyperlink.setForeground(Display.getDefault().getSystemColor(10));
        hyperlink.addHyperlinkListener(this.getHyperlinkListener(parent, message));
        return hyperlink;
    }

    protected IHyperlinkListener getHyperlinkListener(final Shell parent, final IMessage message) {
        return new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent event) {
                parent.close();
                ErrorMessageHyperlinkListener.this.handleErrorLinkClicked(message, ErrorMessageHyperlinkListener.this.fEditor.getSite().getShell());
            }

            public void linkEntered(HyperlinkEvent event) {
                ((Hyperlink)event.widget).setUnderlined(true);
            }

            public void linkExited(HyperlinkEvent event) {
                ((Hyperlink)event.widget).setUnderlined(false);
            }
        };
    }

    protected void handleErrorLinkClicked(IMessage message, Shell shell) {
        if (message.getData() instanceof IStatus) {
            IStatus status = (IStatus)message.getData();
            ErrorDialog dialog = this.getErrorDialog(shell, message.getMessage(), status);
            dialog.open();
        } else {
            if (message.getData() instanceof Integer) {
                int pageIndex = (Integer)message.getData();
                if (this.fEditor.getPages().length > pageIndex) {
                    this.fEditor.setActivePage(pageIndex);
                }
            }
            if (message.getControl() != null) {
                message.getControl().setFocus();
            }
        }
    }

    protected ErrorDialog getErrorDialog(Shell shell, String title, IStatus status) {
        return new ErrorDialog(shell, title, null, status, 7);
    }

    private String stripAmpersand(String input) {
        return input.replace("&", "");
    }

    protected void closeShell(final Shell shell) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!shell.isDisposed()) {
                    shell.close();
                }
            }
        });
    }
}

