/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors;

import com.ibm.team.build.internal.ui.editors.BuildItemEditorJob;
import com.ibm.team.build.internal.ui.editors.BuildItemEditorTitleDragSupport;
import com.ibm.team.build.internal.ui.editors.ErrorMessageHyperlinkListener;
import com.ibm.team.build.internal.ui.editors.Messages;
import com.ibm.team.build.internal.ui.editors.RefreshBuildItemJob;
import com.ibm.team.build.internal.ui.editors.RefreshEditorAction;
import com.ibm.team.build.internal.ui.editors.SaveEditorAction;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJobContext;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.StaleDataException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.ui.editor.TeamFormEditor;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Form;

public abstract class BuildItemEditor
extends TeamFormEditor {
    private SaveEditorAction fSaveAction;
    protected RefreshEditorAction fRefreshAction;
    private RefreshBuildItemJob fRefreshBuildItemJob;
    protected int fBusyCount;
    private boolean fIsDisposed = false;
    protected IMessageManager fMessageManager;
    protected List<Object> fLifecycleErrorMessages = new LinkedList<Object>();

    public abstract IItem getBuildItem();

    protected abstract boolean isNewItem();

    public abstract ITeamRepository getTeamRepository();

    protected String getBuildItemTypeName() {
        return Messages.BuildItemEditor_ITEM_NAME;
    }

    protected void createHeaderContents(IManagedForm headerForm) {
        Form form = headerForm.getForm().getForm();
        form.setText(this.getHeaderTitleText());
        form.setImage(this.getHeaderTitleImage());
        IToolBarManager toolBarManager = form.getToolBarManager();
        this.fRefreshAction = new RefreshEditorAction(this, form.getShell());
        if (this.isNewItem()) {
            this.fRefreshAction.setEnabled(false);
        }
        toolBarManager.add((IAction)this.fRefreshAction);
        this.fSaveAction = new SaveEditorAction(this);
        toolBarManager.add((IContributionItem)this.fSaveAction);
        this.updateToolBar(form);
        BuildItemEditorTitleDragSupport dragSupport = new BuildItemEditorTitleDragSupport(this);
        form.addTitleDragSupport(4, dragSupport.getTransferTypes(), (DragSourceListener)dragSupport);
        this.addPropertyListener(new DirtyPropertyListener());
        this.fMessageManager = headerForm.getMessageManager();
        this.fMessageManager.setDecorationPosition(16512);
        form.addMessageHyperlinkListener((IHyperlinkListener)new ErrorMessageHyperlinkListener(this));
    }

    protected RefreshEditorAction getRefreshEditorAction() {
        return this.fRefreshAction;
    }

    protected SaveEditorAction getSaveEditorAction() {
        return this.fSaveAction;
    }

    protected void updateToolBar(Form form) {
        form.updateToolBar();
    }

    public void addWarningMessage(Object id, String message, Control control, int pageIndex) {
        this.fMessageManager.addMessage(id, message, (Object)pageIndex, 2, control);
    }

    public void addWarningMessage(Object id, String message, Control control) {
        this.fMessageManager.addMessage(id, message, null, 2, control);
    }

    public void addErrorMessage(Object id, String message, Control control, int pageIndex) {
        this.fMessageManager.addMessage(id, message, (Object)pageIndex, 3, control);
    }

    public void addErrorMessage(Object id, String message, Control control) {
        this.fMessageManager.addMessage(id, message, null, 3, control);
    }

    public void addErrorMessage(Object id, String message, IStatus status) {
        int messageType = status.getSeverity() == 2 ? 2 : 3;
        this.fMessageManager.addMessage(id, message, (Object)status, messageType);
    }

    protected void addLifecycleErrorMessage(Object id, String message, IStatus status) {
        int messageType = status.getSeverity() == 2 ? 2 : 3;
        this.fMessageManager.addMessage(id, message, (Object)status, messageType);
        this.fLifecycleErrorMessages.add(id);
    }

    protected void addLifecycleErrorMessage(Object id, String message, int messageType) {
        this.fMessageManager.addMessage(id, message, null, messageType);
        this.fLifecycleErrorMessages.add(id);
    }

    public void removeErrorMessage(Object id) {
        this.removeMessage(id);
    }

    public void removeErrorMessage(Object id, Control control) {
        this.removeMessage(id, control);
    }

    public void removeMessage(Object id) {
        this.fMessageManager.removeMessage(id);
    }

    public void removeMessage(Object id, Control control) {
        this.fMessageManager.removeMessage(id, control);
    }

    protected abstract String getHeaderTitleText();

    protected abstract Image getHeaderTitleImage();

    protected void refreshBuildItem() {
        Button saveButton;
        this.removeLifecycleErrorMessages();
        SaveEditorAction saveAction = this.getSaveEditorAction();
        if (saveAction != null && (saveButton = saveAction.getSaveButton()) != null && !saveButton.isDisposed()) {
            saveButton.redraw();
        }
        this.fRefreshBuildItemJob = new RefreshBuildItemJob(this);
        this.fRefreshBuildItemJob.schedule();
    }

    private void removeLifecycleErrorMessages() {
        for (Object id : this.fLifecycleErrorMessages) {
            this.fMessageManager.removeMessage(id);
        }
        this.fLifecycleErrorMessages.clear();
    }

    protected abstract void disposeEditorSections();

    protected abstract void refreshBuildItem(IProgressMonitor var1) throws TeamRepositoryException;

    protected void internalHandleRefreshComplete(IStatus refreshStatus) {
        if (refreshStatus.isOK()) {
            this.disposeEditorSections();
            this.handleRefreshComplete();
        }
    }

    protected abstract void handleRefreshComplete();

    protected void setBusy(boolean isBusy) {
        if (!this.isDisposed()) {
            if (this.fBusyCount == 0 && isBusy) {
                this.getHeaderForm().getForm().setBusy(true);
            } else if (this.fBusyCount == 1 && !isBusy) {
                this.getHeaderForm().getForm().setBusy(false);
            }
            if (isBusy) {
                ++this.fBusyCount;
            } else if (this.fBusyCount > 0) {
                --this.fBusyCount;
            }
        }
        this.getSaveEditorAction().updateEnabledState();
        this.getRefreshEditorAction().updateEnabledState();
    }

    protected boolean isBusy() {
        return this.fBusyCount > 0;
    }

    protected abstract void performSave(IProgressMonitor var1) throws TeamRepositoryException, OperationCanceledException;

    public void doSave(IProgressMonitor monitor) {
        TeamBuildJobContext saveContext = new TeamBuildJobContext(){

            @Override
            protected String getStatusMessage(Throwable throwable) {
                if (throwable instanceof StaleDataException) {
                    return Messages.BuildItemEditor_ERROR_MESSAGE_SAVE_CONFLICT;
                }
                return super.getStatusMessage(throwable);
            }
        };
        String jobName = NLS.bind((String)Messages.BuildItemEditor_SAVE_JOB_NAME, (Object)this.getBuildItemTypeName());
        BuildItemEditorJob job = new BuildItemEditorJob(jobName, true, this, saveContext){

            @Override
            protected String getShortName() {
                return Messages.BuildItemEditor_SAVE_JOB_SHORT_NAME;
            }

            @Override
            protected String getHeaderMessageTitle(IStatus status) {
                if (status.getException() instanceof StaleDataException) {
                    return Messages.BuildItemEditor_ERROR_TITLE_SAVE_CONFLICT;
                }
                return super.getHeaderMessageTitle(status);
            }

            @Override
            protected void internalRunProtected(IProgressMonitor internalMonitor) throws Exception {
                final Exception[] saveException = new Exception[1];
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        BuildItemEditor.this.removeLifecycleErrorMessages();
                        IRunnableWithProgress runnable = BuildItemEditor.this.createSaveBuildItemRunnable();
                        try {
                            if (BuildItemEditor.this.preSave() && BuildItemEditor.this.proceedWithSave()) {
                                BuildItemEditor.this.invokeSaveRunnable(runnable);
                                BuildItemEditor.this.postSave(true);
                            } else {
                                saveException[0] = new OperationCanceledException();
                            }
                        }
                        catch (InvocationTargetException exception) {
                            BuildItemEditor.this.postSave(false);
                            saveException[0] = (Exception)exception.getCause();
                        }
                        catch (InterruptedException exception) {
                            saveException[0] = new OperationCanceledException();
                        }
                    }
                });
                if (saveException[0] != null) {
                    throw saveException[0];
                }
            }

            @Override
            protected void internalJobFinished(IStatus status) {
                super.internalJobFinished(status);
                BuildItemEditor.this.handleSaveJobFinished(status);
            }
        };
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!job.getStatus().isOK()) {
            monitor.setCanceled(true);
        }
    }

    protected void invokeSaveRunnable(IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        this.getSite().getWorkbenchWindow().run(true, true, runnable);
    }

    protected boolean preSave() {
        return true;
    }

    protected boolean proceedWithSave() {
        return true;
    }

    protected void postSave(boolean saveSucceeded) {
    }

    protected IRunnableWithProgress createSaveBuildItemRunnable() {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    BuildItemEditor.this.performSave(monitor);
                }
                catch (TeamRepositoryException exception) {
                    throw new InvocationTargetException(exception);
                }
            }
        };
    }

    protected void handleSaveJobFinished(IStatus status) {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSaveAs() {
    }

    protected boolean isDisposed() {
        return this.fIsDisposed;
    }

    public void dispose() {
        this.fIsDisposed = true;
        if (this.fRefreshBuildItemJob != null) {
            this.fRefreshBuildItemJob.cancel();
        }
        super.dispose();
    }

    public void setPageImage(int pageIndex, Image image) {
        super.setPageImage(pageIndex, image);
    }

    protected IFormPage[] getPages() {
        return this.pages.toArray(new IFormPage[this.pages.size()]);
    }

    protected void setActivePage(int pageIndex) {
        super.setActivePage(pageIndex);
    }

    protected Composite createPageContainer(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.getHelpId());
        return super.createPageContainer(parent);
    }

    protected abstract String getHelpId();

    protected class DirtyPropertyListener
    implements IPropertyListener {
        protected DirtyPropertyListener() {
        }

        public void propertyChanged(Object source, int propertyId) {
            if (source instanceof IEditorPart && propertyId == 257) {
                BuildItemEditor.this.getSaveEditorAction().updateEnabledState();
            }
        }
    }
}

