/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.domain;

import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.domain.Messages;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.UUID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ConnectedProjectAreaRegistryHelper {
    public static boolean isTeamAreaSelected(ITeamAreaHandle teamAreaHandle) {
        ValidationHelper.validateNotNull((String)"teamAreaHandle", (Object)teamAreaHandle);
        ITeamRepository teamRepository = (ITeamRepository)teamAreaHandle.getOrigin();
        Map<UUID, ITeamAreaHandle> selectedTeamAreaHandles = ConnectedProjectAreaRegistryHelper.getAllSelectedTeamAreaHandles(teamRepository);
        return selectedTeamAreaHandles.containsKey(teamAreaHandle.getItemId());
    }

    public static Map<UUID, ITeamAreaHandle> getAllSelectedTeamAreaHandles(ITeamRepository teamRepository) {
        ValidationHelper.validateNotNull((String)"teamRepository", (Object)teamRepository);
        HashMap<UUID, ITeamAreaHandle> selectedTeamAreas = new HashMap<UUID, ITeamAreaHandle>();
        ConnectedProjectAreaRegistry registry = ConnectedProjectAreaRegistry.getDefault();
        List projectAreas = registry.getConnectedProjectAreas(teamRepository);
        for (IProjectAreaHandle projectAreaHandle : projectAreas) {
            List teamAreaHandles = registry.getSelectedTeamAreas(projectAreaHandle);
            for (ITeamAreaHandle teamAreaHandle : teamAreaHandles) {
                if (teamAreaHandle == null) continue;
                selectedTeamAreas.put(teamAreaHandle.getItemId(), teamAreaHandle);
            }
        }
        return selectedTeamAreas;
    }

    public static String getProjectAreaName(IProjectAreaHandle projectAreaHandle) {
        String name = ConnectedProjectAreaRegistry.getDefault().getProjectAreaName(projectAreaHandle);
        if (name == null) {
            name = Messages.ConnectedProjectAreaRegistryHelper_UNKNOWN_PROJECT_AREA_NAME;
        }
        return name;
    }

    public static Set<ITeamRepository> getConnectedRepositories() {
        HashSet<ITeamRepository> connectedRepositories = new HashSet<ITeamRepository>();
        List projectAreas = ConnectedProjectAreaRegistry.getDefault().getConnectedProjectAreas(null);
        for (IProjectAreaHandle projectAreaHandle : projectAreas) {
            Object origin = projectAreaHandle.getOrigin();
            if (!(origin instanceof ITeamRepository)) continue;
            connectedRepositories.add((ITeamRepository)origin);
        }
        return connectedRepositories;
    }

    public static IProcessAreaHandle[] getAllSelectedProcessAreas(ITeamRepository repository) {
        ArrayList allProcessAreas = new ArrayList();
        List projectAreas = ConnectedProjectAreaRegistry.getDefault().getConnectedProjectAreas(repository);
        for (IProjectAreaHandle projectAreaHandle : projectAreas) {
            List processAreas = ConnectedProjectAreaRegistry.getDefault().getSelectedProcessAreas(projectAreaHandle);
            allProcessAreas.addAll(processAreas);
        }
        return allProcessAreas.toArray(new IProcessAreaHandle[allProcessAreas.size()]);
    }
}

