/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.domain;

import com.ibm.team.build.common.model.IBuildFolderHandle;
import com.ibm.team.build.internal.ui.actions.DeleteBuildFolderActionDelegate;
import com.ibm.team.build.internal.ui.actions.EditBuildFolderActionDelegate;
import com.ibm.team.build.internal.ui.domain.BuildFolderNode;
import com.ibm.team.process.rcp.ui.teamnavigator.IMenuOperationTarget;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchSite;

public class BuildFolderNodeMenuOperationTarget
implements IMenuOperationTarget {
    public boolean canDoOperation(String actionId, IStructuredSelection selection) {
        if (actionId.equals(IMenuOperationTarget.PROPERTIES)) {
            return this.isSelectionSingleFolder(selection);
        }
        if (actionId.equals(IMenuOperationTarget.DELETE)) {
            return this.isSelectionFolders(selection);
        }
        return false;
    }

    public void doOperation(String actionId, IWorkbenchSite site, IStructuredSelection selection) {
        if (actionId.equals(IMenuOperationTarget.PROPERTIES)) {
            EditBuildFolderActionDelegate editBuildFolderAction = this.getEditBuildFolderAction(site);
            editBuildFolderAction.selectionChanged(null, (ISelection)new StructuredSelection((Object)((BuildFolderNode)selection.getFirstElement()).getBuildFolder()));
            editBuildFolderAction.run(null);
        } else if (actionId.equals(IMenuOperationTarget.DELETE)) {
            DeleteBuildFolderActionDelegate deleteBuildViewFolderAction = this.getDeleteBuildFolderAction();
            ArrayList<IBuildFolderHandle> foldersToDelete = new ArrayList<IBuildFolderHandle>();
            for (BuildFolderNode buildFolder : selection) {
                foldersToDelete.add(buildFolder.getBuildFolder());
            }
            deleteBuildViewFolderAction.selectionChanged(null, (ISelection)new StructuredSelection(foldersToDelete));
            deleteBuildViewFolderAction.run(null);
        }
    }

    public String getLabel(String actionId) {
        return null;
    }

    private boolean isSelectionSingleFolder(IStructuredSelection selection) {
        return selection.size() == 1 && selection.getFirstElement() instanceof BuildFolderNode;
    }

    private boolean isSelectionFolders(IStructuredSelection selection) {
        Iterator i = selection.iterator();
        while (i.hasNext()) {
            if (i.next() instanceof BuildFolderNode) continue;
            return false;
        }
        return selection.size() > 0;
    }

    protected DeleteBuildFolderActionDelegate getDeleteBuildFolderAction() {
        return new DeleteBuildFolderActionDelegate();
    }

    protected EditBuildFolderActionDelegate getEditBuildFolderAction(IWorkbenchSite site) {
        return new EditBuildFolderActionDelegate(site);
    }
}

