/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.domain;

import com.ibm.team.build.common.model.IBuildFolder;
import com.ibm.team.build.common.model.IBuildFolderHandle;
import com.ibm.team.build.internal.ui.domain.AbstractBuildFolderNode;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IItemHandle;

public class BuildFolderNode
extends AbstractBuildFolderNode {
    private IBuildFolderHandle fBuildFolderHandle;
    private BuildFolderNode fParent;
    private final IProjectAreaHandle fProjectAreaHandle;
    private String fLabel;

    public BuildFolderNode(IBuildFolderHandle buildFolderHandle, String label, BuildFolderNode parent, IProjectAreaHandle projectAreaHandle) {
        super(parent);
        this.fLabel = label;
        this.fProjectAreaHandle = projectAreaHandle;
        this.fBuildFolderHandle = buildFolderHandle;
        this.fParent = parent;
    }

    public void update(IBuildFolder updatedFolder) {
        this.fBuildFolderHandle = updatedFolder;
        this.fLabel = updatedFolder.getName();
    }

    public BuildFolderNode getParentFolder() {
        return this.fParent;
    }

    public void setParentFolder(BuildFolderNode parent) {
        this.fParent = parent;
    }

    @Override
    public IProjectAreaHandle getProjectArea() {
        return this.fProjectAreaHandle;
    }

    public int hashCode() {
        return this.fBuildFolderHandle.getItemId().hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof BuildFolderNode) {
            return this.fBuildFolderHandle.sameItemId((IItemHandle)((BuildFolderNode)object).fBuildFolderHandle);
        }
        return false;
    }

    @Override
    public String getLabel() {
        return this.fLabel;
    }

    public IBuildFolderHandle getBuildFolder() {
        return this.fBuildFolderHandle;
    }

    @Override
    public boolean isCategorizable() {
        return true;
    }
}

