/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.domain;

import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.domain.AbstractBuildDomainNode;
import com.ibm.team.build.internal.ui.query.BuildQuery;
import com.ibm.team.build.internal.ui.views.query.BuildQueryView;
import com.ibm.team.repository.client.ITeamRepository;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbenchSite;

public abstract class BuildDomainQueryNode
extends AbstractBuildDomainNode {
    private final ITeamRepository fTeamRepository;
    private final String fLabel;
    private final String fImagePath;
    private final int fSortPosition;

    public BuildDomainQueryNode(ITeamRepository teamRepository, String label, int sortPosition) {
        ValidationHelper.validateNotNull((String)"teamRepository", (Object)teamRepository);
        ValidationHelper.validateNotNull((String)"label", (Object)label);
        this.fTeamRepository = teamRepository;
        this.fLabel = label;
        this.fImagePath = "icons/obj16/buildq_obj.gif";
        this.fSortPosition = sortPosition;
    }

    public ITeamRepository getTeamRepository() {
        return this.fTeamRepository;
    }

    @Override
    public String getLabel() {
        return this.fLabel;
    }

    public Image getImage() {
        return BuildUIPlugin.getImage(this.fImagePath);
    }

    public int getSortPosition() {
        return this.fSortPosition;
    }

    public abstract BuildQuery getQuery();

    public void open(IWorkbenchSite site) {
        BuildQuery query = this.getQuery();
        if (query == null) {
            return;
        }
        BuildQueryView.displayQuery(query, site.getPage());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BuildDomainQueryNode)) {
            return false;
        }
        BuildDomainQueryNode otherNode = (BuildDomainQueryNode)obj;
        if (this.getQuery() != otherNode.getQuery()) {
            return false;
        }
        return this.getHashString().equals(otherNode.getHashString());
    }

    public int hashCode() {
        return this.getHashString().hashCode() + this.getQuery().hashCode();
    }

    private String getHashString() {
        return String.valueOf(this.fTeamRepository.getRepositoryURI()) + this.fLabel;
    }
}

