/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.domain;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildFolder;
import com.ibm.team.build.common.model.IBuildFolderHandle;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.common.model.IBuildFolderEntry;
import com.ibm.team.build.internal.ui.domain.BuildDefinitionQueryNode;
import com.ibm.team.build.internal.ui.domain.BuildDomainContentProvider;
import com.ibm.team.build.internal.ui.domain.BuildFolderNode;
import com.ibm.team.build.internal.ui.domain.Messages;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.build.internal.ui.listeners.AbstractBuildDefinitionChangeListener;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.rcp.ui.teamnavigator.DomainSubtreeRoot;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;

public class BuildDomainJoinedItemsChangeListener
extends AbstractBuildDefinitionChangeListener {
    protected final DomainSubtreeRoot fTreeParent;
    protected final IProjectAreaHandle fProjectAreaHandle;
    protected final BuildDomainContentProvider fContentProvider;

    public BuildDomainJoinedItemsChangeListener(BuildDomainContentProvider contentProvider, IProjectAreaHandle projectAreaHandle, DomainSubtreeRoot parent) {
        ValidationHelper.validateNotNull((String)"contentProvider", (Object)contentProvider);
        ValidationHelper.validateNotNull((String)"projectAreaHandle", (Object)projectAreaHandle);
        this.fContentProvider = contentProvider;
        this.fProjectAreaHandle = projectAreaHandle;
        this.fTreeParent = parent;
    }

    @Override
    protected boolean shouldShowDefinition(IBuildDefinition definition, IProgressMonitor monitor) {
        boolean showDefinition = false;
        if (definition.isPropertySet(IBuildDefinition.PROPERTY_PROCESS_AREA)) {
            List selectedProcessAreas = this.getSelectedProcessAreas();
            for (IProcessAreaHandle handle : selectedProcessAreas) {
                if (!definition.getProcessArea().sameItemId((IItemHandle)handle)) continue;
                showDefinition = true;
                break;
            }
        }
        return showDefinition;
    }

    public void addDefinitions(List<BuildDefinitionQueryNode> children) {
        for (BuildDefinitionQueryNode node : children) {
            this.getItemIdToNodesMap().put(node.getBuildDefinition().getItemId().getUuidValue(), node);
        }
    }

    public void addFolders(List<BuildFolderNode> children) {
        for (BuildFolderNode node : children) {
            this.getItemIdToNodesMap().put(node.getBuildFolder().getItemId().getUuidValue(), node);
        }
    }

    @Override
    protected void updateControl(HashSet<IItem> itemsToAdd, HashSet<IItem> itemsToRemove, HashSet<IItem> itemsToUpdate) {
        super.updateControl(itemsToAdd, itemsToRemove, itemsToUpdate);
        this.addBuildFolders(itemsToAdd);
        this.removeBuildFolders(itemsToRemove);
        this.updateBuildFolders(itemsToUpdate);
        this.addFolderEntries(itemsToAdd);
        this.updateFolderEntries(itemsToUpdate);
        this.removeFolderEntries(itemsToRemove);
    }

    @Override
    public void removeNodesFromViewer(Object parent, Object[] nodes) {
        if (!this.isViewerDisposed()) {
            ((TreeViewer)this.getViewer()).remove(parent, nodes);
        }
    }

    @Override
    public void addNodesToViewer(Object parent, Object[] nodes) {
        if (!this.isViewerDisposed()) {
            ((TreeViewer)this.getViewer()).add(parent, nodes);
        }
    }

    @Override
    public StructuredViewer getViewer() {
        return this.fContentProvider.getTreeViewer();
    }

    @Override
    protected Object getParent() {
        return this.fTreeParent;
    }

    @Override
    protected IProjectAreaHandle getProjectAreaHandle() {
        return this.fProjectAreaHandle;
    }

    protected List getSelectedProcessAreas() {
        return this.fContentProvider.getBuildDomain().getConnectedProjectAreaRegistry().getSelectedProcessAreas(this.fProjectAreaHandle);
    }

    private boolean isViewerDisposed() {
        StructuredViewer viewer = this.getViewer();
        return viewer == null || viewer.getControl().isDisposed();
    }

    protected void addBuildFolders(HashSet<IItem> itemsToAdd) {
        List<IBuildFolder> buildFolders = this.getItemsOfType(itemsToAdd, IBuildFolder.class);
        if (!buildFolders.isEmpty()) {
            ArrayList<BuildFolderNode> nodes = new ArrayList<BuildFolderNode>();
            for (IBuildFolder buildFolder : buildFolders) {
                if (this.getItemIdToNodesMap().get(buildFolder.getItemId().getUuidValue()) == null) {
                    IBuildFolderHandle parentFolderHandle = buildFolder.getParent();
                    BuildFolderNode parentNode = parentFolderHandle == null ? null : (BuildFolderNode)this.getItemIdToNodesMap().get(parentFolderHandle.getItemId().getUuidValue());
                    BuildFolderNode node = new BuildFolderNode((IBuildFolderHandle)buildFolder, buildFolder.getName(), parentNode, this.fProjectAreaHandle);
                    nodes.add(node);
                    this.getItemIdToNodesMap().put(buildFolder.getItemId().getUuidValue(), node);
                    continue;
                }
                this.updateBuildFolders(new HashSet<IBuildFolder>(Collections.singletonList(buildFolder)));
            }
            if (!nodes.isEmpty() && !this.isViewerDisposed()) {
                for (BuildFolderNode currentNode : nodes) {
                    if (currentNode.getParentFolder() == null) {
                        ((TreeViewer)this.getViewer()).add((Object)this.fTreeParent, (Object)currentNode);
                        continue;
                    }
                    ((TreeViewer)this.getViewer()).add((Object)currentNode.getParentFolder(), (Object)currentNode);
                    ((TreeViewer)this.getViewer()).refresh((Object)currentNode);
                }
            }
        }
    }

    protected void updateFolderEntries(HashSet<IItem> itemsToUpdate) {
        List<IBuildFolderEntry> buildFolderEntries = this.getItemsOfType(itemsToUpdate, IBuildFolderEntry.class);
        if (!buildFolderEntries.isEmpty()) {
            for (IBuildFolderEntry buildFolderEntry : buildFolderEntries) {
                IBuildFolderHandle folder = buildFolderEntry.getFolder();
                IBuildDefinitionHandle definition = (IBuildDefinitionHandle)buildFolderEntry.getItem();
                BuildDefinitionQueryNode buildDefinitionNode = (BuildDefinitionQueryNode)this.getItemIdToNodesMap().get(definition.getItemId().getUuidValue());
                BuildFolderNode buildFolderNode = (BuildFolderNode)this.getItemIdToNodesMap().get(folder.getItemId().getUuidValue());
                if (buildDefinitionNode == null || this.isViewerDisposed()) continue;
                ((TreeViewer)this.getViewer()).remove((Object)buildDefinitionNode);
                if (buildFolderNode == null) continue;
                ((TreeViewer)this.getViewer()).add((Object)buildFolderNode, (Object)buildDefinitionNode);
            }
        }
    }

    protected void removeFolderEntries(Set<IItem> itemsToRemove) {
        List<IBuildFolderEntry> buildFolderEntries = this.getItemsOfType(itemsToRemove, IBuildFolderEntry.class);
        ArrayList<IItemHandle> buildDefinitionsToFetch = new ArrayList<IItemHandle>();
        if (!buildFolderEntries.isEmpty()) {
            for (IBuildFolderEntry buildFolderEntry : buildFolderEntries) {
                IBuildDefinitionHandle definition = (IBuildDefinitionHandle)buildFolderEntry.getItem();
                BuildDefinitionQueryNode buildDefinitionNode = (BuildDefinitionQueryNode)this.getItemIdToNodesMap().get(definition.getItemId().getUuidValue());
                if (buildDefinitionNode != null) {
                    if (this.isViewerDisposed()) continue;
                    ((TreeViewer)this.getViewer()).remove((Object)buildDefinitionNode);
                    ((TreeViewer)this.getViewer()).add(this.getParent(), (Object)buildDefinitionNode);
                    continue;
                }
                if (buildDefinitionNode != null) continue;
                buildDefinitionsToFetch.add(buildFolderEntry.getItem());
            }
            if (buildDefinitionsToFetch.size() > 0) {
                this.fetchAndAddMissingDefinitions((ITeamRepository)((IItemHandle)buildDefinitionsToFetch.get(0)).getOrigin(), buildDefinitionsToFetch);
            }
        }
    }

    private void fetchAndAddMissingDefinitions(final ITeamRepository teamRepository, final List<IItemHandle> buildDefinitions) {
        TeamBuildJob buildJob = new TeamBuildJob(Messages.BuildDomainJoinedItemsChangeListener_ADD_MISSING_BUILD_DEFINITIONS_JOB_NAME, false){

            public IStatus runProtected(final IProgressMonitor monitor) throws TeamRepositoryException {
                List items = teamRepository.itemManager().fetchCompleteItems(buildDefinitions, 0, monitor);
                final HashSet definitions = new HashSet(items);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        BuildDomainJoinedItemsChangeListener.this.filterItemsToAdd(definitions, monitor);
                        BuildDomainJoinedItemsChangeListener.this.addBuildDefinitions(definitions);
                    }
                });
                return Status.OK_STATUS;
            }
        };
        buildJob.setUser(false);
        buildJob.schedule();
    }

    protected void addFolderEntries(HashSet<IItem> itemsToAdd) {
        List<IBuildFolderEntry> buildFolderEntries = this.getItemsOfType(itemsToAdd, IBuildFolderEntry.class);
        if (!buildFolderEntries.isEmpty()) {
            for (IBuildFolderEntry buildFolderEntry : buildFolderEntries) {
                IBuildFolderHandle folder = buildFolderEntry.getFolder();
                IBuildDefinitionHandle definition = (IBuildDefinitionHandle)buildFolderEntry.getItem();
                BuildDefinitionQueryNode buildDefinitionNode = (BuildDefinitionQueryNode)this.getItemIdToNodesMap().get(definition.getItemId().getUuidValue());
                BuildFolderNode buildFolderNode = (BuildFolderNode)this.getItemIdToNodesMap().get(folder.getItemId().getUuidValue());
                if (buildDefinitionNode == null || this.isViewerDisposed()) continue;
                ((TreeViewer)this.getViewer()).remove((Object)buildDefinitionNode);
                if (buildFolderNode == null) continue;
                ((TreeViewer)this.getViewer()).add((Object)buildFolderNode, (Object)buildDefinitionNode);
            }
        }
    }

    protected void removeBuildFolders(HashSet<IItem> itemsToRemove) {
        List<IBuildFolder> buildFolders = this.getItemsOfType(itemsToRemove, IBuildFolder.class);
        if (!buildFolders.isEmpty()) {
            ArrayList<BuildFolderNode> nodes = new ArrayList<BuildFolderNode>();
            for (IBuildFolder folder : buildFolders) {
                Object node = this.getItemIdToNodesMap().get(folder.getItemId().getUuidValue());
                if (node == null) continue;
                nodes.add((BuildFolderNode)node);
            }
            if (!nodes.isEmpty() && !this.isViewerDisposed()) {
                ((TreeViewer)this.getViewer()).remove(nodes.toArray());
            }
        }
    }

    protected void updateBuildFolders(HashSet<IItem> itemsToUpdate) {
        List<IBuildFolder> buildFolders = this.getItemsOfType(itemsToUpdate, IBuildFolder.class);
        if (!buildFolders.isEmpty()) {
            for (IBuildFolder folder : buildFolders) {
                BuildFolderNode node = (BuildFolderNode)this.getItemIdToNodesMap().get(folder.getItemId().getUuidValue());
                if (node == null) continue;
                if (folder.getParent() != null && node.getParentFolder() != null && folder.getParent().sameItemId((IItemHandle)node.getParentFolder().getBuildFolder()) || folder.getParent() == null && node.getParentFolder() == null) {
                    node.update(folder);
                    this.getViewer().update((Object)node, null);
                    continue;
                }
                node.update(folder);
                node.setParentFolder(null);
                if (this.isViewerDisposed()) continue;
                ((TreeViewer)this.getViewer()).remove((Object)node);
                if (folder.getParent() == null) {
                    ((TreeViewer)this.getViewer()).add((Object)this.fTreeParent, (Object)node);
                    continue;
                }
                BuildFolderNode newParent = (BuildFolderNode)this.getItemIdToNodesMap().get(folder.getParent().getItemId().getUuidValue());
                if (newParent == null) continue;
                node.setParentFolder(newParent);
                ((TreeViewer)this.getViewer()).add((Object)newParent, (Object)node);
            }
        }
    }

    @Override
    protected void filterItemsToAdd(HashSet<IItem> itemsToAdd, IProgressMonitor monitor) {
        super.filterItemsToAdd(itemsToAdd, monitor);
        List<IBuildFolder> buildFolders = this.getItemsOfType(itemsToAdd, IBuildFolder.class);
        for (IBuildFolder folder : buildFolders) {
            if (buildFolders.isEmpty() || this.shouldShowFolder(folder, monitor)) continue;
            itemsToAdd.remove(folder);
        }
    }

    protected boolean shouldShowFolder(IBuildFolder folder, IProgressMonitor monitor) {
        boolean shouldShow = false;
        if (folder.isPropertySet(IBuildFolder.PROPERTY_PROCESS_AREA)) {
            List selectedProcessAreas = this.getSelectedProcessAreas();
            for (IProcessAreaHandle handle : selectedProcessAreas) {
                if (!folder.getProcessArea().sameItemId((IItemHandle)handle)) continue;
                shouldShow = true;
                break;
            }
        }
        return shouldShow;
    }
}

