/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.domain;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.common.model.dto.DtoFactory;
import com.ibm.team.build.internal.common.model.dto.IBuildEngineStatusRecord;
import com.ibm.team.build.internal.common.model.dto.impl.BuildEngineStatusRecordImpl;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.domain.BuildDomainContentProvider;
import com.ibm.team.build.internal.ui.domain.BuildEngineQueryNode;
import com.ibm.team.build.internal.ui.domain.BuildEnginesNode;
import com.ibm.team.build.internal.ui.listeners.AbstractBuildDefinitionChangeListener;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.rcp.ui.teamnavigator.DomainSubtreeRoot;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;

public class BuildDomainEngineChangeListener
extends AbstractBuildDefinitionChangeListener {
    protected final Object fTreeParent;
    protected final IProjectAreaHandle fProjectAreaHandle;
    protected final BuildDomainContentProvider fContentProvider;

    public BuildDomainEngineChangeListener(BuildDomainContentProvider contentProvider, IProjectAreaHandle projectAreaHandle, DomainSubtreeRoot parent) {
        ValidationHelper.validateNotNull((String)"contentProvider", (Object)contentProvider);
        ValidationHelper.validateNotNull((String)"projectAreaHandle", (Object)projectAreaHandle);
        this.fContentProvider = contentProvider;
        this.fProjectAreaHandle = projectAreaHandle;
        this.fTreeParent = parent;
    }

    public BuildDomainEngineChangeListener(BuildDomainContentProvider contentProvider, IProjectAreaHandle projectAreaHandle, BuildEnginesNode parent, List<BuildEngineQueryNode> children) {
        ValidationHelper.validateNotNull((String)"contentProvider", (Object)contentProvider);
        ValidationHelper.validateNotNull((String)"projectAreaHandle", (Object)projectAreaHandle);
        this.fContentProvider = contentProvider;
        this.fProjectAreaHandle = projectAreaHandle;
        this.fTreeParent = parent;
        for (BuildEngineQueryNode node : children) {
            this.getItemIdToNodesMap().put(node.getBuildEngineStatusRecord().getBuildEngine().getItemId().getUuidValue(), node);
        }
    }

    protected void handleException(TeamRepositoryException exception) {
        BuildUIPlugin.log(exception);
    }

    protected void updateBuildEngines(HashSet<IItem> itemsToUpdate) {
        List<IBuildEngine> buildEngines = this.getItemsOfType(itemsToUpdate, IBuildEngine.class);
        if (!buildEngines.isEmpty()) {
            ArrayList<BuildEngineQueryNode> nodes = new ArrayList<BuildEngineQueryNode>();
            for (IBuildEngine engine : buildEngines) {
                BuildEngineQueryNode node = (BuildEngineQueryNode)this.getItemIdToNodesMap().get(engine.getItemId().getUuidValue());
                if (node == null) continue;
                nodes.add(node);
                this.fContentProvider.fetchAndUpdate(node);
            }
            if (!nodes.isEmpty() && !this.isViewerDisposed()) {
                this.getViewer().update(nodes.toArray(), null);
            }
        }
    }

    protected void addBuildEngines(HashSet<IItem> itemsToAdd) {
        List<IBuildEngine> buildEngines = this.getItemsOfType(itemsToAdd, IBuildEngine.class);
        if (!buildEngines.isEmpty()) {
            ArrayList<BuildEngineQueryNode> nodes = new ArrayList<BuildEngineQueryNode>();
            for (IBuildEngine buildEngine : buildEngines) {
                if (this.getItemIdToNodesMap().get(buildEngine.getItemId().getUuidValue()) != null) continue;
                IBuildEngineStatusRecord engineStatusRecord = this.getBuildEngineStatusRecord(buildEngine);
                BuildEngineQueryNode node = new BuildEngineQueryNode(this.fProjectAreaHandle, engineStatusRecord);
                nodes.add(node);
                this.getItemIdToNodesMap().put(buildEngine.getItemId().getUuidValue(), node);
            }
            if (!nodes.isEmpty()) {
                this.addNodesToViewer(this.fTreeParent, nodes.toArray());
            }
        }
    }

    private IBuildEngineStatusRecord getBuildEngineStatusRecord(IBuildEngine buildEngine) {
        BuildEngineStatusRecordImpl record = (BuildEngineStatusRecordImpl)DtoFactory.eINSTANCE.createBuildEngineStatusRecord();
        record.setLastContactTime(new Timestamp(System.currentTimeMillis()));
        record.setBuildEngine(buildEngine);
        return record;
    }

    protected List getSelectedProcessAreas() {
        return this.fContentProvider.getBuildDomain().getConnectedProjectAreaRegistry().getSelectedProcessAreas(this.fProjectAreaHandle);
    }

    protected void removeBuildEngines(HashSet<IItem> itemsToRemove) {
        List<IBuildEngine> buildEngines = this.getItemsOfType(itemsToRemove, IBuildEngine.class);
        if (!buildEngines.isEmpty()) {
            ArrayList<BuildEngineQueryNode> nodes = new ArrayList<BuildEngineQueryNode>();
            for (IBuildEngine engine : buildEngines) {
                Object node = this.getItemIdToNodesMap().get(engine.getItemId().getUuidValue());
                if (node == null) continue;
                nodes.add((BuildEngineQueryNode)node);
            }
            if (!nodes.isEmpty()) {
                this.removeNodesFromViewer(this.fTreeParent, nodes.toArray());
            }
        }
    }

    @Override
    protected void updateControl(HashSet<IItem> itemsToAdd, HashSet<IItem> itemsToRemove, HashSet<IItem> itemsToUpdate) {
        this.addBuildEngines(itemsToAdd);
        this.removeBuildEngines(itemsToRemove);
        this.updateBuildEngines(itemsToUpdate);
    }

    protected boolean shouldShowEngine(IBuildEngine engine, IProgressMonitor monitor) {
        boolean showEngine = false;
        if (engine.isPropertySet(IBuildEngine.PROPERTY_PROCESS_AREA)) {
            ITeamRepository teamRepository = (ITeamRepository)engine.getOrigin();
            try {
                IProcessArea processArea = (IProcessArea)teamRepository.itemManager().fetchCompleteItem((IItemHandle)engine.getProcessArea(), 0, monitor);
                if (processArea.getProjectArea().sameItemId((IItemHandle)this.fProjectAreaHandle)) {
                    showEngine = true;
                }
            }
            catch (TeamRepositoryException teamRepositoryException) {
                // empty catch block
            }
        }
        return showEngine;
    }

    @Override
    protected void filterItemsToAdd(HashSet<IItem> itemsToAdd, IProgressMonitor monitor) {
        super.filterItemsToAdd(itemsToAdd, monitor);
        List<IBuildEngine> buildEngines = this.getItemsOfType(itemsToAdd, IBuildEngine.class);
        if (!buildEngines.isEmpty()) {
            for (IBuildEngine engine : buildEngines) {
                if (this.shouldShowEngine(engine, monitor)) continue;
                itemsToAdd.remove(engine);
            }
        }
    }

    @Override
    public StructuredViewer getViewer() {
        return this.fContentProvider.getTreeViewer();
    }

    private boolean isViewerDisposed() {
        StructuredViewer viewer = this.getViewer();
        return viewer == null || viewer.getControl().isDisposed();
    }

    @Override
    public void addNodesToViewer(Object parent, Object[] nodes) {
        if (!this.isViewerDisposed()) {
            ((TreeViewer)this.getViewer()).add(parent, nodes);
        }
    }

    @Override
    public void removeNodesFromViewer(Object parent, Object[] nodes) {
        if (!this.isViewerDisposed()) {
            ((TreeViewer)this.getViewer()).remove(parent, nodes);
        }
    }

    @Override
    protected Object getParent() {
        return this.fTreeParent;
    }

    @Override
    protected IProjectAreaHandle getProjectAreaHandle() {
        return this.fProjectAreaHandle;
    }

    @Override
    protected boolean shouldShowDefinition(IBuildDefinition definition, IProgressMonitor monitor) {
        return false;
    }
}

