/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.domain;

import com.ibm.team.build.client.ClientFactory;
import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.common.model.IBuildEngineHandle;
import com.ibm.team.build.common.model.IBuildFolder;
import com.ibm.team.build.common.model.IBuildFolderHandle;
import com.ibm.team.build.internal.client.BuildRecordEventManager;
import com.ibm.team.build.internal.client.IBuildDefinitionStatusRecordListener;
import com.ibm.team.build.internal.client.ITeamBuildRecordClient;
import com.ibm.team.build.internal.common.helper.ItemHandleAwareHashMap;
import com.ibm.team.build.internal.common.model.IBuildFolderEntry;
import com.ibm.team.build.internal.common.model.dto.IBuildDefinitionStatusRecord;
import com.ibm.team.build.internal.common.model.dto.IBuildEngineStatusRecord;
import com.ibm.team.build.internal.common.model.dto.IBuildItemNamePair;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.domain.AbstractBuildFolderNode;
import com.ibm.team.build.internal.ui.domain.BuildDefinitionQueryNode;
import com.ibm.team.build.internal.ui.domain.BuildDomain;
import com.ibm.team.build.internal.ui.domain.BuildDomainEngineChangeListener;
import com.ibm.team.build.internal.ui.domain.BuildDomainJoinedItemsChangeListener;
import com.ibm.team.build.internal.ui.domain.BuildDomainQueryNode;
import com.ibm.team.build.internal.ui.domain.BuildEngineBuildQueueNode;
import com.ibm.team.build.internal.ui.domain.BuildEngineQueryNode;
import com.ibm.team.build.internal.ui.domain.BuildEnginesNode;
import com.ibm.team.build.internal.ui.domain.BuildFolderNode;
import com.ibm.team.build.internal.ui.domain.Messages;
import com.ibm.team.build.internal.ui.helper.EnterpriseHelper;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.build.internal.ui.listeners.AbstractBuildDefinitionChangeListener;
import com.ibm.team.build.internal.ui.listeners.BuildDefinitionStatusRecordListener;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.rcp.ui.teamnavigator.DomainSubtreeRoot;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistry;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistryChangeEvent;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistryListener;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreePathContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.DeferredTreeContentManager;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;

public class BuildDomainContentProvider
implements ITreeContentProvider,
ITreePathContentProvider,
IDeferredWorkbenchAdapter,
IConnectedProjectAreaRegistryListener {
    private final BuildDomain fBuildDomain;
    private AbstractTreeViewer fViewer;
    private DeferredTreeContentManager fDeferredTreeManager;
    private boolean fDisposed;
    private final ItemHandleAwareHashMap<IProjectAreaHandle, BuildEnginesNode> fBuildEnginesNodes = new ItemHandleAwareHashMap();
    protected final ItemHandleAwareHashMap<IProjectAreaHandle, BuildDefinitionStatusRecordListener> fDefinitionRecordListeners = new ItemHandleAwareHashMap();
    protected final ItemHandleAwareHashMap<IProjectAreaHandle, BuildDomainEngineChangeListener> fEngineItemListeners = new ItemHandleAwareHashMap();
    protected final ItemHandleAwareHashMap<IProjectAreaHandle, BuildDomainJoinedItemsChangeListener> fBuildItemListeners = new ItemHandleAwareHashMap();
    private boolean fFetchInProgress;
    private final boolean fIncludeBuildQueue;
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private static final TreePath[] EMPTY_TREEPATH_ARRAY = new TreePath[0];
    private boolean fShowFolders = true;

    public BuildDomainContentProvider(BuildDomain domain, boolean includeBuildQueue) {
        this.fBuildDomain = domain;
        this.fBuildDomain.getConnectedProjectAreaRegistry().addListener((IConnectedProjectAreaRegistryListener)this);
        this.fIncludeBuildQueue = includeBuildQueue;
        IPreferenceStore store = BuildUIPlugin.getDefault().getPreferenceStore();
        this.fShowFolders = store.getBoolean("show_build_folders");
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
        this.fDisposed = true;
        this.fDeferredTreeManager = null;
        this.disposeListeners();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.fViewer = (AbstractTreeViewer)viewer;
        if (this.fDeferredTreeManager == null) {
            this.fDeferredTreeManager = new DeferredTreeContentManager(this, (AbstractTreeViewer)viewer, this.fBuildDomain.getWorkbenchPart().getSite()){

                protected IDeferredWorkbenchAdapter getAdapter(Object element) {
                    if (BuildDomainContentProvider.this.hasChildren(element)) {
                        return BuildDomainContentProvider.this;
                    }
                    return super.getAdapter(element);
                }
            };
        }
    }

    public boolean hasChildren(TreePath path) {
        Object object = path.getLastSegment();
        if (object instanceof DomainSubtreeRoot) {
            return true;
        }
        return object instanceof AbstractBuildFolderNode;
    }

    public Object[] getChildren(TreePath parentPath) {
        Object parentElement = parentPath.getLastSegment();
        if (parentElement instanceof DomainSubtreeRoot || parentElement instanceof AbstractBuildFolderNode) {
            return this.fDeferredTreeManager.getChildren((Object)parentPath);
        }
        return EMPTY_ARRAY;
    }

    public Object getParent(Object element) {
        return null;
    }

    public TreePath[] getParents(Object element) {
        return EMPTY_TREEPATH_ARRAY;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof TreePath) {
            return this.hasChildren((TreePath)element);
        }
        return false;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof TreePath) {
            return this.getChildren((TreePath)parentElement);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
        TreePath parentPath = (TreePath)object;
        Object parent = parentPath.getLastSegment();
        BuildDomainContentProvider buildDomainContentProvider = this;
        synchronized (buildDomainContentProvider) {
            if (this.fFetchInProgress) {
                return;
            }
            this.fFetchInProgress = true;
        }
        try {
            monitor.beginTask("", -1);
            if (parent instanceof DomainSubtreeRoot) {
                this.getChildrenOfBuildDomain((DomainSubtreeRoot)parent, collector, monitor);
            } else if (parent instanceof BuildEnginesNode) {
                this.getChildrenOfBuildEnginesNode((BuildEnginesNode)parent, collector, monitor);
            } else if (parent instanceof BuildFolderNode) {
                this.getChildrenOfBuildFolder((BuildFolderNode)parent, collector, monitor);
            }
        }
        catch (Throwable throwable) {
            BuildDomainContentProvider buildDomainContentProvider2 = this;
            synchronized (buildDomainContentProvider2) {
                this.fFetchInProgress = false;
            }
            collector.done();
            monitor.done();
            throw throwable;
        }
        BuildDomainContentProvider buildDomainContentProvider3 = this;
        synchronized (buildDomainContentProvider3) {
            this.fFetchInProgress = false;
        }
        collector.done();
        monitor.done();
    }

    private void getChildrenOfBuildDomain(DomainSubtreeRoot parent, IElementCollector collector, IProgressMonitor monitor) {
        Object category = parent.getCategoryElement();
        if (category instanceof ITeamArea) {
            category = ((ITeamArea)category).getProjectArea();
        }
        IProjectAreaHandle projectAreaHandle = (IProjectAreaHandle)category;
        collector.add((Object)this.getBuildEnginesNode(parent), monitor);
        try {
            IBuildDefinitionStatusRecord[] statusRecords;
            this.removeDefinitionRecordListeners(projectAreaHandle);
            this.removeJoinedItemListener(projectAreaHandle);
            ArrayList<BuildDefinitionQueryNode> nodes = new ArrayList<BuildDefinitionQueryNode>();
            ITeamBuildClient buildClient = ClientFactory.getTeamBuildClient((ITeamRepository)((ITeamRepository)projectAreaHandle.getOrigin()));
            List selectedProcessAreas = this.fBuildDomain.getConnectedProjectAreaRegistry().getSelectedProcessAreas(projectAreaHandle);
            IPreferenceStore preferenceStore = BuildUIPlugin.getDefault().getPreferenceStore();
            this.fShowFolders = preferenceStore.getBoolean("show_build_folders");
            ArrayList<IBuildItemNamePair> buildFolderPairs = new ArrayList<IBuildItemNamePair>();
            if (this.fShowFolders) {
                IBuildItemNamePair[] childPairs = buildClient.getChildrenOfFolder(null, selectedProcessAreas.toArray(new IProcessAreaHandle[selectedProcessAreas.size()]), monitor);
                ArrayList<IBuildItemNamePair> buildDefinitionPairs = new ArrayList<IBuildItemNamePair>();
                IBuildItemNamePair[] iBuildItemNamePairArray = childPairs;
                int n = childPairs.length;
                int n2 = 0;
                while (n2 < n) {
                    IBuildItemNamePair pair = iBuildItemNamePairArray[n2];
                    IItemHandle itemHandle = pair.getItem();
                    if (itemHandle instanceof IBuildDefinitionHandle) {
                        buildDefinitionPairs.add(pair);
                    } else if (itemHandle instanceof IBuildFolderHandle) {
                        buildFolderPairs.add(pair);
                    }
                    ++n2;
                }
                ArrayList<IBuildDefinitionHandle> buildDefinitions = new ArrayList<IBuildDefinitionHandle>();
                for (IBuildItemNamePair pair : buildDefinitionPairs) {
                    buildDefinitions.add((IBuildDefinitionHandle)pair.getItem());
                }
                IBuildDefinitionStatusRecord[] iBuildDefinitionStatusRecordArray = statusRecords = this.getBuildDefinitionStatusRecordsForDefinitions(projectAreaHandle, buildDefinitions.toArray(new IBuildDefinitionHandle[buildDefinitions.size()]), monitor);
                int n3 = statusRecords.length;
                int n4 = 0;
                while (n4 < n3) {
                    IBuildDefinitionStatusRecord record = iBuildDefinitionStatusRecordArray[n4];
                    if (!EnterpriseHelper.isEnterpriseDefinition(record.getBuildDefinition())) {
                        nodes.add(new BuildDefinitionQueryNode((ITeamRepository)projectAreaHandle.getOrigin(), record));
                    }
                    ++n4;
                }
            } else {
                IBuildDefinitionStatusRecord[] iBuildDefinitionStatusRecordArray = statusRecords = this.getBuildDefinitionStatusRecords(projectAreaHandle, monitor);
                int buildDefinitions = statusRecords.length;
                int buildDefinitionPairs = 0;
                while (buildDefinitionPairs < buildDefinitions) {
                    IBuildDefinitionStatusRecord record = iBuildDefinitionStatusRecordArray[buildDefinitionPairs];
                    if (!EnterpriseHelper.isEnterpriseDefinition(record.getBuildDefinition())) {
                        nodes.add(new BuildDefinitionQueryNode((ITeamRepository)projectAreaHandle.getOrigin(), record));
                    }
                    ++buildDefinitionPairs;
                }
            }
            BuildDomainJoinedItemsChangeListener joinedItemListener = new BuildDomainJoinedItemsChangeListener(this, projectAreaHandle, parent);
            if (this.fShowFolders) {
                ArrayList<BuildFolderNode> folderNodes = new ArrayList<BuildFolderNode>();
                for (IBuildItemNamePair folder : buildFolderPairs) {
                    folderNodes.add(new BuildFolderNode((IBuildFolderHandle)folder.getItem(), folder.getName(), null, projectAreaHandle));
                }
                collector.add(folderNodes.toArray(), monitor);
                joinedItemListener.addFolders(folderNodes);
            }
            joinedItemListener.addDefinitions(nodes);
            collector.add(nodes.toArray(), monitor);
            this.addJoinedItemListener(projectAreaHandle, joinedItemListener);
            this.addBuildDefinitionStatusRecordListener(projectAreaHandle, parent, nodes);
        }
        catch (TeamRepositoryException exception) {
            BuildUIPlugin.log(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addBuildDefinitionStatusRecordListener(IProjectAreaHandle projectAreaHandle, DomainSubtreeRoot parent, List<BuildDefinitionQueryNode> nodes) {
        BuildDefinitionStatusRecordListener recordListener = new BuildDefinitionStatusRecordListener((StructuredViewer)this.getTreeViewer(), nodes.toArray(new BuildDefinitionQueryNode[nodes.size()]));
        BuildDomainContentProvider buildDomainContentProvider = this;
        synchronized (buildDomainContentProvider) {
            this.fDefinitionRecordListeners.put((Object)projectAreaHandle, (Object)recordListener);
        }
        BuildRecordEventManager.getInstance().addListener((IBuildDefinitionStatusRecordListener)recordListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDefinitionRecordListeners(IProjectAreaHandle projectAreaHandle) {
        IBuildDefinitionStatusRecordListener oldRecordListener;
        BuildDomainContentProvider buildDomainContentProvider = this;
        synchronized (buildDomainContentProvider) {
            oldRecordListener = (IBuildDefinitionStatusRecordListener)this.fDefinitionRecordListeners.remove((Object)projectAreaHandle);
        }
        if (oldRecordListener != null) {
            BuildRecordEventManager.getInstance().removeListener(oldRecordListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeJoinedItemListener(IProjectAreaHandle projectAreaHandle) {
        AbstractBuildDefinitionChangeListener oldListener;
        BuildDomainContentProvider buildDomainContentProvider = this;
        synchronized (buildDomainContentProvider) {
            oldListener = (AbstractBuildDefinitionChangeListener)this.fBuildItemListeners.remove((Object)projectAreaHandle);
        }
        if (oldListener != null) {
            ITeamRepository repository = (ITeamRepository)projectAreaHandle.getOrigin();
            repository.itemManager().removeItemChangeListener(IBuildDefinition.ITEM_TYPE, (ISharedItemChangeListener)oldListener);
            repository.itemManager().removeItemChangeListener(IBuildFolder.ITEM_TYPE, (ISharedItemChangeListener)oldListener);
            repository.itemManager().removeItemChangeListener(IBuildFolderEntry.ITEM_TYPE, (ISharedItemChangeListener)oldListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BuildEnginesNode getBuildEnginesNode(DomainSubtreeRoot parent) {
        Object category = parent.getCategoryElement();
        if (category instanceof ITeamArea) {
            category = ((ITeamArea)category).getProjectArea();
        }
        IProjectAreaHandle projectAreaHandle = (IProjectAreaHandle)category;
        BuildDomainContentProvider buildDomainContentProvider = this;
        synchronized (buildDomainContentProvider) {
            BuildEnginesNode node = (BuildEnginesNode)this.fBuildEnginesNodes.get((Object)projectAreaHandle);
            if (node == null) {
                node = new BuildEnginesNode(parent);
                this.fBuildEnginesNodes.put((Object)projectAreaHandle, (Object)node);
            }
            return node;
        }
    }

    private BuildDomainQueryNode getBuildQueueNode(IProjectAreaHandle projectAreaHandle) {
        return new BuildEngineBuildQueueNode(projectAreaHandle, Messages.BuildDomainContentProvider_BUILD_QUEUE_NODE_LABEL, 0);
    }

    private IBuildDefinitionStatusRecord[] getBuildDefinitionStatusRecords(IProjectAreaHandle projectAreaHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository teamRepository = (ITeamRepository)projectAreaHandle.getOrigin();
        ITeamBuildRecordClient client = (ITeamBuildRecordClient)teamRepository.getClientLibrary(ITeamBuildRecordClient.class);
        List processAreaHandles = this.fBuildDomain.getConnectedProjectAreaRegistry().getSelectedProcessAreas(projectAreaHandle);
        return client.getBuildDefinitionStatusRecords(processAreaHandles.toArray(new IProcessAreaHandle[processAreaHandles.size()]), monitor);
    }

    private IBuildDefinitionStatusRecord[] getBuildDefinitionStatusRecordsForDefinitions(IProjectAreaHandle projectAreaHandle, IBuildDefinitionHandle[] definitionHandles, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository teamRepository = (ITeamRepository)projectAreaHandle.getOrigin();
        ITeamBuildRecordClient client = (ITeamBuildRecordClient)teamRepository.getClientLibrary(ITeamBuildRecordClient.class);
        return client.getBuildDefinitionStatusRecords(definitionHandles, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getChildrenOfBuildEnginesNode(BuildEnginesNode parent, IElementCollector collector, IProgressMonitor monitor) {
        try {
            IProjectAreaHandle projectAreaHandle = parent.getProjectArea();
            this.removeEngineItemListener(projectAreaHandle);
            List<BuildEngineQueryNode> nodes = BuildDomainContentProvider.getBuildEngineQueryNodes(parent, monitor);
            if (this.fIncludeBuildQueue) {
                collector.add((Object)this.getBuildQueueNode(parent.getProjectArea()), monitor);
            }
            Collections.sort(nodes, new Comparator<BuildEngineQueryNode>(){

                @Override
                public int compare(BuildEngineQueryNode node1, BuildEngineQueryNode node2) {
                    return node1.getLabel().compareTo(node2.getLabel());
                }
            });
            collector.add(nodes.toArray(), monitor);
            BuildDomainEngineChangeListener engineListener = new BuildDomainEngineChangeListener(this, projectAreaHandle, parent, nodes);
            BuildDomainContentProvider buildDomainContentProvider = this;
            synchronized (buildDomainContentProvider) {
                this.fEngineItemListeners.put((Object)projectAreaHandle, (Object)engineListener);
            }
            this.addEngineItemListener(projectAreaHandle, engineListener);
        }
        catch (TeamRepositoryException exception) {
            BuildUIPlugin.log(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getChildrenOfBuildFolder(BuildFolderNode parent, IElementCollector collector, IProgressMonitor monitor) {
        IProjectAreaHandle projectAreaHandle = parent.getProjectArea();
        try {
            ITeamBuildClient buildClient = ClientFactory.getTeamBuildClient((ITeamRepository)parent.getTeamRepository());
            IBuildItemNamePair[] childPairs = buildClient.getChildrenOfFolder(parent.getBuildFolder(), this.fBuildDomain.getConnectedProjectAreaRegistry().getSelectedProcessAreas(projectAreaHandle).toArray(new IProcessAreaHandle[0]), monitor);
            ArrayList<IBuildItemNamePair> buildDefinitionPairs = new ArrayList<IBuildItemNamePair>();
            ArrayList<IBuildItemNamePair> buildFolderPairs = new ArrayList<IBuildItemNamePair>();
            IBuildItemNamePair[] iBuildItemNamePairArray = childPairs;
            int n = childPairs.length;
            int n2 = 0;
            while (n2 < n) {
                IBuildItemNamePair obj = iBuildItemNamePairArray[n2];
                IItemHandle itemHandle = obj.getItem();
                if (itemHandle.getItemType() == IBuildDefinition.ITEM_TYPE) {
                    buildDefinitionPairs.add(obj);
                } else if (itemHandle instanceof IBuildFolderHandle) {
                    buildFolderPairs.add(obj);
                }
                ++n2;
            }
            ArrayList<BuildFolderNode> buildFolders = new ArrayList<BuildFolderNode>();
            for (IBuildItemNamePair pair : buildFolderPairs) {
                buildFolders.add(new BuildFolderNode((IBuildFolderHandle)pair.getItem(), pair.getName(), parent, projectAreaHandle));
            }
            Object[] buildFolderNodes = buildFolders.toArray(new BuildFolderNode[buildFolders.size()]);
            collector.add(buildFolderNodes, monitor);
            ArrayList<IBuildDefinitionHandle> buildDefinitions = new ArrayList<IBuildDefinitionHandle>();
            for (IBuildItemNamePair pair : buildDefinitionPairs) {
                buildDefinitions.add((IBuildDefinitionHandle)pair.getItem());
            }
            IBuildDefinitionStatusRecord[] statusRecords = this.getBuildDefinitionStatusRecordsForDefinitions(projectAreaHandle, buildDefinitions.toArray(new IBuildDefinitionHandle[buildDefinitions.size()]), monitor);
            ArrayList<BuildDefinitionQueryNode> buildDefinitionNodes = new ArrayList<BuildDefinitionQueryNode>();
            Object object = statusRecords;
            int n3 = statusRecords.length;
            int n4 = 0;
            while (n4 < n3) {
                IBuildDefinitionStatusRecord record = object[n4];
                if (!EnterpriseHelper.isEnterpriseDefinition(record.getBuildDefinition())) {
                    buildDefinitionNodes.add(new BuildDefinitionQueryNode((ITeamRepository)projectAreaHandle.getOrigin(), record));
                }
                ++n4;
            }
            Object[] buildDefinitionQueryNodes = buildDefinitionNodes.toArray(new BuildDefinitionQueryNode[buildDefinitionNodes.size()]);
            collector.add(buildDefinitionQueryNodes, monitor);
            BuildDomainJoinedItemsChangeListener joinedItemsChangeListener = null;
            BuildDefinitionStatusRecordListener statusRecordListener = null;
            object = this;
            synchronized (object) {
                joinedItemsChangeListener = (BuildDomainJoinedItemsChangeListener)this.fBuildItemListeners.get((Object)projectAreaHandle);
                statusRecordListener = (BuildDefinitionStatusRecordListener)this.fDefinitionRecordListeners.get((Object)projectAreaHandle);
            }
            if (joinedItemsChangeListener != null) {
                joinedItemsChangeListener.addDefinitions(buildDefinitionNodes);
                joinedItemsChangeListener.addFolders(buildFolders);
            }
            if (statusRecordListener != null) {
                statusRecordListener.addDefinitions((BuildDefinitionQueryNode[])buildDefinitionQueryNodes);
            }
        }
        catch (TeamRepositoryException exception) {
            BuildUIPlugin.log(exception);
        }
    }

    public static List<BuildEngineQueryNode> getBuildEngineQueryNodes(BuildEnginesNode parent, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamBuildRecordClient client = (ITeamBuildRecordClient)parent.getTeamRepository().getClientLibrary(ITeamBuildRecordClient.class);
        IProjectAreaHandle projectAreaHandle = parent.getProjectArea();
        IBuildEngineStatusRecord[] statusRecords = client.getBuildEngineStatusRecords(new IProjectAreaHandle[]{projectAreaHandle}, monitor);
        List processAreaHandles = null;
        DomainSubtreeRoot root = (DomainSubtreeRoot)parent.getParent();
        if (root != null) {
            processAreaHandles = root.getDomain().getConnectedProjectAreaRegistry().getSelectedProcessAreas(projectAreaHandle);
        }
        ArrayList<BuildEngineQueryNode> nodes = new ArrayList<BuildEngineQueryNode>();
        IBuildEngineStatusRecord[] iBuildEngineStatusRecordArray = statusRecords;
        int n = statusRecords.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildEngineStatusRecord statusRecord = iBuildEngineStatusRecordArray[n2];
            if (processAreaHandles == null || BuildDomainContentProvider.containsHandle(processAreaHandles, (IItemHandle)statusRecord.getBuildEngine().getProcessArea())) {
                nodes.add(new BuildEngineQueryNode(projectAreaHandle, statusRecord));
            }
            ++n2;
        }
        return nodes;
    }

    private static boolean containsHandle(List<? extends IItemHandle> handles, IItemHandle handle) {
        for (IItemHandle iItemHandle : handles) {
            if (!iItemHandle.sameItemId(handle)) continue;
            return true;
        }
        return false;
    }

    public ISchedulingRule getRule(Object object) {
        return null;
    }

    public boolean isContainer() {
        return true;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return null;
    }

    public String getLabel(Object object) {
        if (object instanceof TreePath) {
            TreePath path = (TreePath)object;
            Object lastSegment = path.getLastSegment();
            if (lastSegment instanceof DomainSubtreeRoot) {
                return Messages.BuildDomainContentProvider_BUILD_DOMAIN_NODE;
            }
            if (lastSegment instanceof AbstractBuildFolderNode) {
                return ((AbstractBuildFolderNode)lastSegment).getLabel();
            }
            if (lastSegment instanceof BuildDomainQueryNode) {
                return ((BuildDomainQueryNode)lastSegment).getLabel();
            }
            return object.toString();
        }
        return object.toString();
    }

    protected boolean fetchAndUpdate(BuildDefinitionQueryNode element) {
        TeamBuildJob job = this.getFetchBuildDefinitionStatusRecordJob(element);
        job.schedule();
        return true;
    }

    protected TeamBuildJob getFetchBuildDefinitionStatusRecordJob(final BuildDefinitionQueryNode element) {
        return new TeamBuildJob(NLS.bind((String)Messages.BuildDomainContentProvider_REFRESH_NODE_JOB_NAME, (Object)element.getLabel()), true){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                IBuildDefinition definition = element.getBuildDefinition();
                ITeamBuildRecordClient client = BuildDomainContentProvider.this.getTeamBuildRecordClient(element);
                IBuildDefinitionStatusRecord[] allRecords = client.getBuildDefinitionStatusRecords(new IBuildDefinitionHandle[]{definition}, monitor);
                if (allRecords.length > 0) {
                    IBuildDefinitionStatusRecord record = allRecords[0];
                    element.setStatus(record.getStatus());
                    element.setBuildDefinition(record.getBuildDefinition());
                }
                BuildDomainContentProvider.this.refreshNode(element);
                return Status.OK_STATUS;
            }
        };
    }

    protected boolean fetchAndUpdate(BuildEngineQueryNode element) {
        TeamBuildJob job = this.getFetchBuildEngineStatusRecordJob(element);
        job.schedule();
        return true;
    }

    protected TeamBuildJob getFetchBuildEngineStatusRecordJob(final BuildEngineQueryNode element) {
        return new TeamBuildJob(NLS.bind((String)Messages.BuildDomainContentProvider_REFRESH_NODE_JOB_NAME, (Object)element.getLabel()), true){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                IBuildEngine engine = element.getBuildEngineStatusRecord().getBuildEngine();
                ITeamBuildRecordClient client = BuildDomainContentProvider.this.getTeamBuildRecordClient(element);
                IBuildEngineStatusRecord record = client.getBuildEngineStatusRecord((IBuildEngineHandle)engine, monitor);
                element.setBuildEngineStatusRecord(record);
                BuildDomainContentProvider.this.refreshNode(element);
                return Status.OK_STATUS;
            }
        };
    }

    protected boolean fetchAndUpdate(BuildFolderNode element) {
        TeamBuildJob job = this.getFetchBuildFolderJob(element);
        job.schedule();
        return true;
    }

    protected TeamBuildJob getFetchBuildFolderJob(final BuildFolderNode element) {
        return new TeamBuildJob(NLS.bind((String)Messages.BuildDomainContentProvider_REFRESH_NODE_JOB_NAME, (Object)element.getLabel()), true){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                IBuildFolderHandle folderHandle = element.getBuildFolder();
                IBuildFolder folder = (IBuildFolder)element.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)folderHandle, 1, monitor);
                BuildDomainContentProvider.this.updateAndRefreshFolderNode(element, folder);
                return Status.OK_STATUS;
            }
        };
    }

    private void refreshNode(final BuildDomainQueryNode element) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (BuildDomainContentProvider.this.getTreeViewer() != null && !BuildDomainContentProvider.this.getTreeViewer().getControl().isDisposed()) {
                    BuildDomainContentProvider.this.getTreeViewer().update((Object)element, null);
                }
            }
        });
    }

    private void updateAndRefreshFolderNode(final BuildFolderNode element, final IBuildFolder buildFolder) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (BuildDomainContentProvider.this.getTreeViewer() != null && !BuildDomainContentProvider.this.getTreeViewer().getControl().isDisposed()) {
                    element.update(buildFolder);
                    BuildDomainContentProvider.this.getTreeViewer().refresh((Object)element);
                }
            }
        });
    }

    protected void move(final Object[] nodes, final Object newParent) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (BuildDomainContentProvider.this.getTreeViewer() != null && !BuildDomainContentProvider.this.getTreeViewer().getControl().isDisposed() && nodes != null) {
                    Object[] objectArray = nodes;
                    int n = nodes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object from = objectArray[n2];
                        if (from instanceof BuildFolderNode && newParent instanceof BuildFolderNode) {
                            ((BuildFolderNode)from).setParentFolder(((BuildFolderNode)newParent).getParentFolder());
                        } else if (from instanceof BuildFolderNode && newParent instanceof DomainSubtreeRoot) {
                            ((BuildFolderNode)from).setParentFolder(null);
                        }
                        BuildDomainContentProvider.this.getTreeViewer().remove(from);
                        ++n2;
                    }
                    BuildDomainContentProvider.this.getTreeViewer().add(newParent, nodes);
                    if (newParent instanceof BuildFolderNode) {
                        BuildDomainContentProvider.this.getTreeViewer().refresh(newParent);
                    }
                }
            }
        });
    }

    protected void moveTree(final Object from, final Object to) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (BuildDomainContentProvider.this.getTreeViewer() != null && !BuildDomainContentProvider.this.getTreeViewer().getControl().isDisposed()) {
                    BuildDomainContentProvider.this.getTreeViewer().remove(from);
                    if (to != null) {
                        BuildDomainContentProvider.this.getTreeViewer().refresh(to);
                    }
                }
            }
        });
    }

    public void connectedProjectAreaRegistryChanged(final IConnectedProjectAreaRegistryChangeEvent changeEvent) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                BuildDomainContentProvider.this.handleProjectAreaRegistryChanged(changeEvent);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleProjectAreaRegistryChanged(IConnectedProjectAreaRegistryChangeEvent changeEvent) {
        if (!this.fDisposed) {
            if (changeEvent.getType() == 2) {
                IProjectAreaHandle projectAreaHandle = changeEvent.getProjectAreaHandle();
                this.removeDefinitionRecordListeners(projectAreaHandle);
                this.removeEngineItemListener(projectAreaHandle);
                this.removeJoinedItemListener(projectAreaHandle);
            } else if (changeEvent.getType() == 0) {
                BuildDomainContentProvider projectAreaHandle2;
                ArrayList projectAreaHandles;
                IConnectedProjectAreaRegistry registry = this.fBuildDomain.getConnectedProjectAreaRegistry();
                BuildDomainContentProvider buildDomainContentProvider = this;
                synchronized (buildDomainContentProvider) {
                    projectAreaHandles = new ArrayList(this.fDefinitionRecordListeners.keySet());
                }
                for (BuildDomainContentProvider projectAreaHandle2 : projectAreaHandles) {
                    if (registry.isConnectedProjectArea((IProjectAreaHandle)projectAreaHandle2)) continue;
                    this.removeDefinitionRecordListeners((IProjectAreaHandle)projectAreaHandle2);
                }
                projectAreaHandle2 = this;
                synchronized (projectAreaHandle2) {
                    projectAreaHandles = new ArrayList(this.fEngineItemListeners.keySet());
                }
                for (BuildDomainContentProvider projectAreaHandle2 : projectAreaHandles) {
                    if (registry.isConnectedProjectArea((IProjectAreaHandle)projectAreaHandle2)) continue;
                    this.removeEngineItemListener((IProjectAreaHandle)projectAreaHandle2);
                }
                projectAreaHandle2 = this;
                synchronized (projectAreaHandle2) {
                    projectAreaHandles = new ArrayList(this.fBuildItemListeners.keySet());
                }
                for (BuildDomainContentProvider projectAreaHandle2 : projectAreaHandles) {
                    if (registry.isConnectedProjectArea((IProjectAreaHandle)projectAreaHandle2)) continue;
                    this.removeJoinedItemListener((IProjectAreaHandle)projectAreaHandle2);
                }
            }
        }
    }

    private void addEngineItemListener(IProjectAreaHandle projectAreaHandle, AbstractBuildDefinitionChangeListener listener) {
        ITeamRepository repository = (ITeamRepository)projectAreaHandle.getOrigin();
        repository.itemManager().addItemChangeListener(IBuildEngine.ITEM_TYPE, (ISharedItemChangeListener)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeEngineItemListener(IProjectAreaHandle projectAreaHandle) {
        AbstractBuildDefinitionChangeListener oldEngineListener;
        BuildDomainContentProvider buildDomainContentProvider = this;
        synchronized (buildDomainContentProvider) {
            oldEngineListener = (AbstractBuildDefinitionChangeListener)this.fEngineItemListeners.remove((Object)projectAreaHandle);
        }
        if (oldEngineListener != null) {
            this.removeEngineItemListener(projectAreaHandle, oldEngineListener);
        }
    }

    private void removeEngineItemListener(IProjectAreaHandle projectAreaHandle, AbstractBuildDefinitionChangeListener listener) {
        ITeamRepository repository = (ITeamRepository)projectAreaHandle.getOrigin();
        repository.itemManager().removeItemChangeListener(IBuildEngine.ITEM_TYPE, (ISharedItemChangeListener)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addJoinedItemListener(IProjectAreaHandle projectAreaHandle, BuildDomainJoinedItemsChangeListener listener) {
        BuildDomainContentProvider buildDomainContentProvider = this;
        synchronized (buildDomainContentProvider) {
            this.fBuildItemListeners.put((Object)projectAreaHandle, (Object)listener);
        }
        ITeamRepository teamRepository = (ITeamRepository)projectAreaHandle.getOrigin();
        teamRepository.itemManager().addItemChangeListener(IBuildDefinition.ITEM_TYPE, (ISharedItemChangeListener)listener);
        teamRepository.itemManager().addItemChangeListener(IBuildFolder.ITEM_TYPE, (ISharedItemChangeListener)listener);
        teamRepository.itemManager().addItemChangeListener(IBuildFolderEntry.ITEM_TYPE, (ISharedItemChangeListener)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeListeners() {
        BuildDomainContentProvider projectAreaHandle2;
        ArrayList projectAreaHandles;
        this.fBuildDomain.getConnectedProjectAreaRegistry().removeListener((IConnectedProjectAreaRegistryListener)this);
        BuildDomainContentProvider buildDomainContentProvider = this;
        synchronized (buildDomainContentProvider) {
            projectAreaHandles = new ArrayList(this.fDefinitionRecordListeners.keySet());
        }
        for (BuildDomainContentProvider projectAreaHandle2 : projectAreaHandles) {
            this.removeDefinitionRecordListeners((IProjectAreaHandle)projectAreaHandle2);
        }
        projectAreaHandle2 = this;
        synchronized (projectAreaHandle2) {
            projectAreaHandles = new ArrayList(this.fEngineItemListeners.keySet());
        }
        for (BuildDomainContentProvider projectAreaHandle2 : projectAreaHandles) {
            this.removeEngineItemListener((IProjectAreaHandle)projectAreaHandle2);
        }
        projectAreaHandle2 = this;
        synchronized (projectAreaHandle2) {
            projectAreaHandles = new ArrayList(this.fBuildItemListeners.keySet());
        }
        for (BuildDomainContentProvider projectAreaHandle2 : projectAreaHandles) {
            this.removeJoinedItemListener((IProjectAreaHandle)projectAreaHandle2);
        }
    }

    protected AbstractTreeViewer getTreeViewer() {
        return this.fViewer;
    }

    protected BuildDomain getBuildDomain() {
        return this.fBuildDomain;
    }

    private ITeamBuildRecordClient getTeamBuildRecordClient(BuildDomainQueryNode element) {
        ITeamRepository repository = element.getTeamRepository();
        ITeamBuildRecordClient client = (ITeamBuildRecordClient)repository.getClientLibrary(ITeamBuildRecordClient.class);
        return client;
    }

    public void showFolders(boolean showFolders) {
        this.fShowFolders = showFolders;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (BuildDomainContentProvider.this.getTreeViewer() != null && !BuildDomainContentProvider.this.getTreeViewer().getControl().isDisposed()) {
                    BuildDomainContentProvider.this.getTreeViewer().refresh();
                }
            }
        });
    }
}

