/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.domain;

import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildFolderHandle;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.actions.EditBuildDefinitionActionDelegate;
import com.ibm.team.build.internal.ui.actions.EditBuildEngineActionDelegate;
import com.ibm.team.build.internal.ui.actions.MoveBuildItemsAction;
import com.ibm.team.build.internal.ui.actions.NewBuildDefinitionActionDelegate;
import com.ibm.team.build.internal.ui.actions.NewBuildEngineActionDelegate;
import com.ibm.team.build.internal.ui.actions.NewBuildFolderActionDelegate;
import com.ibm.team.build.internal.ui.actions.OpenLatestBuildActionDelegate;
import com.ibm.team.build.internal.ui.actions.RequestBuildActionDelegate;
import com.ibm.team.build.internal.ui.actions.ShowBuildResultsActionDelegate;
import com.ibm.team.build.internal.ui.actions.ShowBuildResultsWithTagActionDelegate;
import com.ibm.team.build.internal.ui.actions.SubscribeToFeedAction;
import com.ibm.team.build.internal.ui.dialogs.RequestBuildDialog;
import com.ibm.team.build.internal.ui.domain.BuildDefinitionQueryNode;
import com.ibm.team.build.internal.ui.domain.BuildDomain;
import com.ibm.team.build.internal.ui.domain.BuildDomainProjectAreaQueryNode;
import com.ibm.team.build.internal.ui.domain.BuildDomainQueryNode;
import com.ibm.team.build.internal.ui.domain.BuildEngineQueryNode;
import com.ibm.team.build.internal.ui.domain.BuildEnginesNode;
import com.ibm.team.build.internal.ui.domain.BuildFolderNode;
import com.ibm.team.build.internal.ui.domain.Messages;
import com.ibm.team.build.internal.ui.domain.ShowBuildsWithTagAction;
import com.ibm.team.build.internal.ui.helper.BuildUIHelper;
import com.ibm.team.build.internal.ui.query.BuildQuery;
import com.ibm.team.build.internal.ui.query.BuildQueryByDefinition;
import com.ibm.team.build.internal.ui.query.BuildQueryByEngine;
import com.ibm.team.build.internal.ui.query.BuildQueryForBuildQueue;
import com.ibm.team.build.internal.ui.views.query.AdaptableBuildQueryRow;
import com.ibm.team.build.internal.ui.views.query.BuildQueryView;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.rcp.ui.teamnavigator.DomainSubtreeRoot;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.IWorkbenchPartSite;

public class BuildDomainActionHelper {
    public static final String CM_ACTIONS_GROUP = "jazz.build.actions.group";
    public static final String CM_FEEDS_GROUP = "jazz.build.feeds.group";
    private IMenuManager fMenuManager;
    private IStructuredSelection fSelection;
    private IWorkbenchPartSite fPartSite;
    private final IPreferenceStore fPreferenceStore = BuildUIPlugin.getDefault().getPreferenceStore();

    public BuildDomainActionHelper(IMenuManager manager, IStructuredSelection selection, IWorkbenchPartSite site) {
        this.fMenuManager = manager;
        this.fSelection = selection;
        this.fPartSite = site;
    }

    public void contributeActions() {
        if (this.fSelection.isEmpty()) {
            return;
        }
        this.fMenuManager.insertAfter("jazz.navigate.group", (IContributionItem)new Separator(CM_ACTIONS_GROUP));
        this.fMenuManager.insertAfter(CM_ACTIONS_GROUP, (IContributionItem)new Separator(CM_FEEDS_GROUP));
        Object element = this.fSelection.getFirstElement();
        if (this.fSelection.size() == 1 && element instanceof DomainSubtreeRoot) {
            DomainSubtreeRoot root = (DomainSubtreeRoot)element;
            if (root.getDomain() instanceof BuildDomain) {
                this.contributeBuildsNodeActions((DomainSubtreeRoot)element);
            }
        } else if (this.fSelection.size() == 1 && element instanceof BuildEnginesNode) {
            this.contributeActivityNodeActions((BuildEnginesNode)element);
        } else if (this.isAllNodesOfType(this.fSelection, BuildDomainQueryNode.class)) {
            this.contributeQueryNodeActions(this.fSelection);
        } else if (this.isAllNodesOfType(this.fSelection, BuildFolderNode.class)) {
            this.contributeFolderNodeActions(this.fSelection);
        }
        if (this.fSelection.size() > 0) {
            this.contributeOtherNodeActions(this.fSelection);
        }
    }

    private boolean isAllNodesOfType(IStructuredSelection selection, Class type) {
        for (Object item : this.fSelection) {
            if (type.isInstance(item)) continue;
            return false;
        }
        return true;
    }

    private void contributeActivityNodeActions(BuildEnginesNode node) {
        IProjectAreaHandle projectArea = node.getProjectArea();
        this.fMenuManager.appendToGroup("jazz.new.group", (IAction)this.getNewBuildEngineAction(projectArea));
    }

    private void contributeQueryNodeActions(IStructuredSelection selection) {
        List<BuildDomainQueryNode> queryNodes = this.getQueryNodesFromSelection(selection);
        List<IBuildDefinitionHandle> buildDefinitionHandles = this.getBuildDefinitionsFromQueryNodes(queryNodes);
        if (queryNodes.size() > 1 && queryNodes.size() == buildDefinitionHandles.size()) {
            this.fMenuManager.appendToGroup("jazz.open.group", (IAction)this.getShowBuildResultsWithTagAction(queryNodes));
            this.fMenuManager.appendToGroup("jazz.open.group", (IAction)this.getOpenBuildDefinitionAction(queryNodes));
        } else if (queryNodes.size() > 1) {
            if (this.areAllBuildEngineQueryNodes(queryNodes)) {
                this.fMenuManager.appendToGroup("jazz.open.group", (IAction)this.getOpenBuildEngineAction(queryNodes));
            }
        } else {
            BuildDomainQueryNode queryNode = queryNodes.get(0);
            if (queryNode.getQuery() instanceof BuildQueryByDefinition) {
                BuildQueryByDefinition queryByType = (BuildQueryByDefinition)queryNode.getQuery();
                ITeamRepository teamRepository = (ITeamRepository)queryByType.getBuildDefinitionHandles().get(0).getOrigin();
                this.fMenuManager.appendToGroup("jazz.open.group", (IAction)this.getOpenLatestBuildAction(queryNodes.get(0).getLabel(), teamRepository));
                this.fMenuManager.appendToGroup("jazz.open.group", (IAction)this.getShowBuildResultsWithTagAction(queryNodes));
                this.fMenuManager.appendToGroup("jazz.open.group", (IAction)this.getOpenBuildDefinitionAction(Collections.singletonList(queryNode)));
                this.fMenuManager.appendToGroup(CM_ACTIONS_GROUP, (IAction)this.getRequestBuildAction(queryByType.getBuildDefinitionHandles().get(0)));
                this.fMenuManager.appendToGroup(CM_FEEDS_GROUP, (IAction)this.getSubscribeToFeedAction(queryByType.getName(), queryByType.getBuildDefinitionHandles().get(0)));
            } else if (queryNode.getQuery() instanceof BuildQueryByEngine) {
                this.fMenuManager.appendToGroup("jazz.open.group", (IAction)this.getShowBuildActivityAction(queryNode));
                this.fMenuManager.appendToGroup("jazz.open.group", (IAction)this.getOpenBuildEngineAction(queryNodes));
            } else if (queryNode.getQuery() instanceof BuildQueryForBuildQueue) {
                this.fMenuManager.appendToGroup("jazz.open.group", (IAction)this.getShowBuildQueueAction(((BuildDomainProjectAreaQueryNode)queryNode).getProjectAreaHandle()));
            }
        }
    }

    private void contributeBuildsNodeActions(DomainSubtreeRoot root) {
        Object category = root.getCategoryElement();
        if (category instanceof ITeamArea) {
            category = ((ITeamArea)category).getProjectArea();
        }
        IProjectAreaHandle projectAreaHandle = (IProjectAreaHandle)category;
        this.fMenuManager.appendToGroup("jazz.new.group", (IAction)new NewBuildDefinitionActionDelegate().getAction(projectAreaHandle, this.fPartSite.getShell()));
        this.fMenuManager.appendToGroup("jazz.new.group", (IAction)new NewBuildFolderActionDelegate().getAction((IProcessAreaHandle)root.getCategoryElement(), this.fPartSite.getShell()));
        this.fMenuManager.appendToGroup("jazz.new.group", (IContributionItem)new Separator());
        this.fMenuManager.appendToGroup("jazz.open.group", (IAction)this.getShowBuildResultsAction(projectAreaHandle));
        this.fMenuManager.appendToGroup("jazz.open.group", (IAction)this.getShowBuildResultsWithTagAction(projectAreaHandle));
        boolean showFolders = this.fPreferenceStore.getBoolean("show_build_folders");
        final Action showFoldersAction = this.getShowFoldersToggleAction(showFolders, (BuildDomain)root.getDomain());
        showFoldersAction.setChecked(showFolders);
        this.fPreferenceStore.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("show_build_folders")) {
                    showFoldersAction.setChecked(((Boolean)event.getNewValue()).booleanValue());
                    showFoldersAction.run();
                }
            }
        });
        this.fMenuManager.appendToGroup("additions", (IAction)showFoldersAction);
    }

    private void contributeFolderNodeActions(IStructuredSelection selection) {
        if (selection.size() == 1) {
            BuildFolderNode buildFolderNode = (BuildFolderNode)selection.getFirstElement();
            IProjectAreaHandle projectAreaHandle = buildFolderNode.getProjectArea();
            IBuildFolderHandle buildFolderHandle = buildFolderNode.getBuildFolder();
            this.fMenuManager.appendToGroup("jazz.new.group", (IAction)new NewBuildDefinitionActionDelegate().getAction(projectAreaHandle, buildFolderHandle, this.fPartSite.getShell()));
            this.fMenuManager.appendToGroup("jazz.new.group", (IAction)new NewBuildFolderActionDelegate().getAction(buildFolderHandle, this.fPartSite.getShell()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void contributeOtherNodeActions(IStructuredSelection selection) {
        if (!(selection instanceof TreeSelection)) return;
        TreeSelection treeSelection = (TreeSelection)selection;
        TreePath[] treePaths = treeSelection.getPaths();
        Object firstRootLevelNode = treePaths[0].getFirstSegment();
        ArrayList<Object> itemHandles = new ArrayList<Object>();
        IProjectAreaHandle processAreaHandle = null;
        TreePath[] treePathArray = treePaths;
        int n = treePaths.length;
        int n2 = 0;
        while (n2 < n) {
            TreePath treePath = treePathArray[n2];
            if (treePath.getFirstSegment() != firstRootLevelNode) return;
            Object lastSegment = treePath.getLastSegment();
            if (lastSegment instanceof BuildFolderNode) {
                itemHandles.add(((BuildFolderNode)lastSegment).getBuildFolder());
                if (processAreaHandle == null) {
                    processAreaHandle = ((BuildFolderNode)lastSegment).getProjectArea();
                }
            } else {
                if (!(lastSegment instanceof BuildDefinitionQueryNode)) return;
                itemHandles.add(((BuildDefinitionQueryNode)lastSegment).getBuildDefinition());
                if (processAreaHandle == null) {
                    processAreaHandle = ((BuildDefinitionQueryNode)lastSegment).getBuildDefinition().getProcessArea();
                }
            }
            ++n2;
        }
        this.fMenuManager.appendToGroup("jazz.refactoring.group", (IAction)this.getMoveBuildItemsAction(itemHandles.toArray(new IItemHandle[itemHandles.size()]), (IProcessAreaHandle)processAreaHandle));
    }

    protected Action getMoveBuildItemsAction(IItemHandle[] itemHandles, IProcessAreaHandle processAreaHandle) {
        return new MoveBuildItemsAction(this.fPartSite.getShell(), itemHandles, processAreaHandle);
    }

    private Action getShowFoldersToggleAction(boolean initialValue, final BuildDomain buildDomain) {
        final IPreferenceStore store = BuildUIPlugin.getDefault().getPreferenceStore();
        return new Action(Messages.BuildDomainActionHelper_SHOW_FOLDERS_TOGGLE, 2){

            public void run() {
                store.setValue("show_build_folders", this.isChecked());
                buildDomain.showFolders(this.isChecked());
            }

            public String getId() {
                return "toggle.build.folders";
            }
        };
    }

    protected Action getShowBuildResultsAction(IProjectAreaHandle projectAreaHandle) {
        return new ShowBuildResultsActionDelegate().getAction(projectAreaHandle, this.fPartSite);
    }

    protected Action getNewBuildEngineAction(IProjectAreaHandle projectAreaHandle) {
        return new NewBuildEngineActionDelegate().getAction(projectAreaHandle, this.fPartSite.getShell());
    }

    protected Action getRequestBuildAction(IBuildDefinitionHandle buildDefinitionHandle) {
        return new RequestBuildActionDelegate().getAction(buildDefinitionHandle, this.fPartSite);
    }

    protected Action getSubscribeToFeedAction(String buildDefinitionId, IBuildDefinitionHandle buildDefinitionHandle) {
        return new SubscribeToFeedAction(buildDefinitionId, buildDefinitionHandle);
    }

    protected Action getOpenBuildDefinitionAction(final List<BuildDomainQueryNode> queryNodes) {
        return new Action(Messages.BuildDomainActionHelper_OPEN_BUILD_DEFINITION){

            public void run() {
                for (BuildDomainQueryNode node : queryNodes) {
                    if (!(node instanceof BuildDefinitionQueryNode)) continue;
                    EditBuildDefinitionActionDelegate.run(((BuildDefinitionQueryNode)node).getBuildDefinition(), BuildDomainActionHelper.this.fPartSite.getWorkbenchWindow().getActivePage());
                }
            }

            public String getId() {
                return "open.build.definition";
            }
        };
    }

    protected Action getShowBuildActivityAction(final BuildDomainQueryNode queryNode) {
        return new Action(Messages.BuildDomainActionHelper_ACTION_LABEL_SHOW_BUILD_ACTIVITY){

            public void run() {
                BuildQuery query = ((BuildEngineQueryNode)queryNode).getActiveBuildQuery();
                BuildQueryView.displayQuery(query, BuildDomainActionHelper.this.fPartSite.getPage());
            }

            public String getId() {
                return "show.build.activity";
            }
        };
    }

    protected Action getOpenBuildEngineAction(final List<BuildDomainQueryNode> queryNodes) {
        return new Action(Messages.BuildDomainActionHelper_OPEN_BUILD_ENGINE){

            public void run() {
                for (BuildDomainQueryNode node : queryNodes) {
                    if (!(node instanceof BuildEngineQueryNode)) continue;
                    EditBuildEngineActionDelegate.run(((BuildEngineQueryNode)node).getBuildEngineStatusRecord().getBuildEngine(), BuildDomainActionHelper.this.fPartSite.getWorkbenchWindow().getActivePage());
                }
            }

            public String getId() {
                return "open.build.engine";
            }
        };
    }

    protected Action getShowBuildResultsAction(List<BuildDomainQueryNode> buildDefinitionQueryNodes) {
        List<IBuildDefinitionHandle> buildDefinitionHandles = this.getBuildDefinitionsFromQueryNodes(buildDefinitionQueryNodes);
        return new ShowBuildResultsActionDelegate().getAction(buildDefinitionQueryNodes, buildDefinitionHandles, this.fPartSite);
    }

    protected Action getShowBuildResultsWithTagAction(List<BuildDomainQueryNode> buildDefinitionQueryNodes) {
        List<IBuildDefinitionHandle> buildDefinitionHandles = this.getBuildDefinitionsFromQueryNodes(buildDefinitionQueryNodes);
        return new ShowBuildResultsWithTagActionDelegate().getAction(buildDefinitionQueryNodes, buildDefinitionHandles, this.fPartSite);
    }

    protected Action getShowBuildResultsWithTagAction(IProjectAreaHandle projectAreaHandle) {
        return new ShowBuildsWithTagAction(Messages.BuildDomainActionHelper_TAG_QUERY_ACTION_NAME, projectAreaHandle, this.fPartSite);
    }

    protected Action getShowBuildQueueAction(final IProjectAreaHandle projectAreaHandle) {
        final ITeamRepository teamRepository = (ITeamRepository)projectAreaHandle.getOrigin();
        return new Action(Messages.BuildDomainActionHelper_ACTION_LABEL_SHOW_BUILD_QUEUE){

            public void run() {
                BuildQueryForBuildQueue query = new BuildQueryForBuildQueue(Messages.BuildDomainActionHelper_QUERY_NAME_BUILD_QUEUE, null, AdaptableBuildQueryRow.Factory, projectAreaHandle, teamRepository);
                BuildQueryView.displayQuery(query, BuildDomainActionHelper.this.fPartSite.getPage());
            }

            public String getId() {
                return "show.build.queue";
            }
        };
    }

    protected Action getOpenLatestBuildAction(String buildDefinitionId, ITeamRepository teamRepository) {
        return new OpenLatestBuildActionDelegate().getAction(buildDefinitionId, teamRepository, this.fPartSite);
    }

    private boolean areAllBuildEngineQueryNodes(List<BuildDomainQueryNode> nodes) {
        for (BuildDomainQueryNode buildDomainQueryNode : nodes) {
            if (buildDomainQueryNode instanceof BuildEngineQueryNode) continue;
            return false;
        }
        return true;
    }

    private List<IBuildDefinitionHandle> getBuildDefinitionsFromQueryNodes(List<BuildDomainQueryNode> queryNodes) {
        ArrayList<IBuildDefinitionHandle> buildDefinitionHandles = new ArrayList<IBuildDefinitionHandle>();
        for (BuildDomainQueryNode node : queryNodes) {
            BuildQuery query = node.getQuery();
            if (!(query instanceof BuildQueryByDefinition)) continue;
            BuildQueryByDefinition queryByType = (BuildQueryByDefinition)query;
            buildDefinitionHandles.addAll(queryByType.getBuildDefinitionHandles());
        }
        return buildDefinitionHandles;
    }

    private List<BuildDomainQueryNode> getQueryNodesFromSelection(IStructuredSelection selection) {
        ArrayList<BuildDomainQueryNode> queryNodes = new ArrayList<BuildDomainQueryNode>();
        List list = selection.toList();
        for (Object object : list) {
            if (!(object instanceof BuildDomainQueryNode)) continue;
            queryNodes.add((BuildDomainQueryNode)object);
        }
        return queryNodes;
    }

    protected void showInfoDialog(String title, String message) {
        BuildUIHelper.showInfoDialog(this.fPartSite.getShell(), title, message);
    }

    protected void showErrorDialog(String errorMessage) {
        BuildUIHelper.showErrorDialog(errorMessage);
    }

    protected void openDialog(RequestBuildDialog dialog) {
        dialog.open();
    }
}

