/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.domain;

import com.ibm.icu.text.Collator;
import com.ibm.team.build.client.ClientFactory;
import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.common.model.IBuildFolderHandle;
import com.ibm.team.build.internal.ui.domain.AbstractBuildDomainNode;
import com.ibm.team.build.internal.ui.domain.BuildDefinitionQueryNode;
import com.ibm.team.build.internal.ui.domain.BuildDomainActionHelper;
import com.ibm.team.build.internal.ui.domain.BuildDomainContentProvider;
import com.ibm.team.build.internal.ui.domain.BuildDomainLabelProvider;
import com.ibm.team.build.internal.ui.domain.BuildDomainQueryNode;
import com.ibm.team.build.internal.ui.domain.BuildEngineBuildQueueNode;
import com.ibm.team.build.internal.ui.domain.BuildEngineQueryNode;
import com.ibm.team.build.internal.ui.domain.BuildEnginesNode;
import com.ibm.team.build.internal.ui.domain.BuildFolderNode;
import com.ibm.team.build.internal.ui.domain.Messages;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.rcp.ui.teamnavigator.Category;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.process.rcp.ui.teamnavigator.Domain;
import com.ibm.team.process.rcp.ui.teamnavigator.DomainSubtreeRoot;
import com.ibm.team.process.rcp.ui.teamnavigator.IProcessAreaCategory;
import com.ibm.team.process.rcp.ui.teamnavigator.IProcessAreaEditorCategory;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreePathContentProvider;
import org.eclipse.jface.viewers.ITreePathLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.progress.PendingUpdateAdapter;

public class BuildDomain
extends Domain {
    protected BuildDomainContentProvider fContentProvider;
    private BuildDomainLabelProvider fLabelProvider;
    private ViewerSorter fViewerSorter;

    public boolean contains(Object element) {
        return element instanceof AbstractBuildDomainNode;
    }

    public ITreePathContentProvider getContentProvider() {
        if (this.fContentProvider == null) {
            this.fContentProvider = new BuildDomainContentProvider(this, this.includeBuildQueue());
        }
        return this.fContentProvider;
    }

    private boolean includeBuildQueue() {
        return !(this.getCategory() instanceof IProcessAreaEditorCategory);
    }

    public ITreePathLabelProvider getLabelProvider() {
        if (this.fLabelProvider == null) {
            this.fLabelProvider = new BuildDomainLabelProvider();
        }
        return this.fLabelProvider;
    }

    public Object getRoot() {
        return this;
    }

    public boolean supportsCategory(Category category) {
        return category instanceof IProcessAreaCategory;
    }

    public boolean open(IWorkbenchPartSite site, IStructuredSelection selection) {
        if (selection.size() != 1) {
            return false;
        }
        Object element = selection.getFirstElement();
        if (element instanceof BuildDomainQueryNode) {
            BuildDomainQueryNode node = (BuildDomainQueryNode)element;
            node.open((IWorkbenchSite)site);
            return true;
        }
        return false;
    }

    public void contributeContextMenuActions(IMenuManager manager, IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return;
        }
        BuildDomainActionHelper actionHelper = new BuildDomainActionHelper(manager, selection, this.getWorkbenchPart().getSite());
        actionHelper.contributeActions();
        super.contributeContextMenuActions(manager, selection);
    }

    public ViewerSorter getSorter() {
        if (this.fViewerSorter == null) {
            this.fViewerSorter = new BuildDomainNodeViewerSorter();
        }
        return this.fViewerSorter;
    }

    public void dispose() {
        if (this.fContentProvider != null) {
            this.fContentProvider.dispose();
            this.fContentProvider = null;
        }
    }

    public boolean refresh(Object element) {
        if (element instanceof BuildDefinitionQueryNode) {
            return ((BuildDomainContentProvider)this.getContentProvider()).fetchAndUpdate((BuildDefinitionQueryNode)element);
        }
        if (element instanceof BuildEngineQueryNode) {
            return ((BuildDomainContentProvider)this.getContentProvider()).fetchAndUpdate((BuildEngineQueryNode)element);
        }
        if (element instanceof BuildFolderNode) {
            return ((BuildDomainContentProvider)this.getContentProvider()).fetchAndUpdate((BuildFolderNode)element);
        }
        return super.refresh(element);
    }

    public boolean validateDrop(Object target, ISelection selection, int operation) {
        IProjectAreaHandle targetProjectArea = null;
        if (target instanceof DomainSubtreeRoot) {
            Object category = ((DomainSubtreeRoot)target).getCategoryElement();
            if (category instanceof IProjectAreaHandle) {
                targetProjectArea = (IProjectAreaHandle)category;
            }
        } else if (target instanceof BuildFolderNode) {
            targetProjectArea = ((BuildFolderNode)target).getProjectArea();
        }
        if (targetProjectArea == null) {
            return false;
        }
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection str = (IStructuredSelection)selection;
            for (Object node : str) {
                if (!target.equals(node) && node instanceof AbstractBuildDomainNode && ((AbstractBuildDomainNode)node).isCategorizable()) {
                    IProjectAreaHandle sourceProjectArea = null;
                    if (node instanceof BuildFolderNode) {
                        sourceProjectArea = ((BuildFolderNode)node).getProjectArea();
                    } else if (node instanceof BuildDefinitionQueryNode) {
                        IProcessAreaHandle definitionProcessAreaHandle = ((BuildDefinitionQueryNode)node).getBuildDefinition().getProcessArea();
                        if (definitionProcessAreaHandle instanceof ITeamAreaHandle) {
                            sourceProjectArea = ConnectedProjectAreaRegistry.getDefault().getConnectedProjectArea((ITeamAreaHandle)definitionProcessAreaHandle);
                        } else if (definitionProcessAreaHandle instanceof IProjectAreaHandle) {
                            sourceProjectArea = (IProjectAreaHandle)definitionProcessAreaHandle;
                        }
                    }
                    if (sourceProjectArea != null && targetProjectArea.sameItemId((IItemHandle)sourceProjectArea)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean performDrop(Object target, ISelection selection, int operation) {
        ITeamRepository teamRepository;
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        final IBuildFolderHandle targetFolder = target instanceof BuildFolderNode ? ((BuildFolderNode)target).getBuildFolder() : null;
        final ArrayList<Object> itemsToMove = new ArrayList<Object>();
        for (Object next : structuredSelection) {
            if (next instanceof BuildDefinitionQueryNode) {
                BuildDefinitionQueryNode defQueryNode = (BuildDefinitionQueryNode)next;
                itemsToMove.add(defQueryNode.getBuildDefinition());
                continue;
            }
            if (!(next instanceof BuildFolderNode)) continue;
            BuildFolderNode folderNode = (BuildFolderNode)next;
            itemsToMove.add(folderNode.getBuildFolder());
        }
        if (target instanceof DomainSubtreeRoot) {
            Object category = ((DomainSubtreeRoot)target).getCategoryElement();
            if (!(category instanceof IProjectArea)) return false;
            teamRepository = (ITeamRepository)((IProjectArea)category).getOrigin();
        } else {
            if (!(target instanceof BuildFolderNode)) return false;
            teamRepository = ((BuildFolderNode)target).getTeamRepository();
        }
        if (itemsToMove.size() <= 0) return false;
        TeamBuildJob moveBuildJob = new TeamBuildJob(Messages.BuildDomain_MOVE_BUILD_ITEMS_JOB_NAME, true, teamRepository){

            protected IStatus runProtected(IProgressMonitor monitor) throws TeamRepositoryException {
                try {
                    monitor.beginTask(this.getName(), -1);
                    ITeamBuildClient buildClient = ClientFactory.getTeamBuildClient((ITeamRepository)teamRepository);
                    buildClient.moveItemsToFolder(itemsToMove.toArray(new IItemHandle[itemsToMove.size()]), targetFolder, monitor);
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                finally {
                    monitor.done();
                }
            }
        };
        moveBuildJob.setWarnOnError();
        moveBuildJob.schedule();
        return false;
    }

    public void showFolders(boolean showFolders) {
        ((BuildDomainContentProvider)this.getContentProvider()).showFolders(showFolders);
    }

    public int getSupportedOperationsForSelection(ISelection selection) {
        return 2;
    }

    public static class BuildDomainNodeViewerSorter
    extends ViewerSorter {
        private Collator fCollator = Collator.getInstance();

        public int category(Object element) {
            if (element instanceof BuildEnginesNode) {
                return 0;
            }
            if (element instanceof BuildEngineBuildQueueNode) {
                return 1;
            }
            if (element instanceof PendingUpdateAdapter) {
                return 2;
            }
            if (element instanceof BuildEngineQueryNode) {
                return 3;
            }
            if (element instanceof BuildFolderNode) {
                return 4;
            }
            if (element instanceof BuildDomainQueryNode) {
                return 5;
            }
            return 6;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int cat2;
            int cat1 = this.category(e1);
            if (cat1 != (cat2 = this.category(e2))) {
                return cat1 - cat2;
            }
            if (e1 instanceof AbstractBuildDomainNode && e2 instanceof AbstractBuildDomainNode) {
                return this.fCollator.compare(((AbstractBuildDomainNode)e1).getLabel(), ((AbstractBuildDomainNode)e2).getLabel());
            }
            return 0;
        }
    }
}

