/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.domain;

import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.internal.common.model.dto.IBuildDefinitionStatusRecord;
import com.ibm.team.build.internal.ui.BuildCompositeImageRegistry;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.IBuildFavoriteItem;
import com.ibm.team.build.internal.ui.domain.BuildDomainQueryNode;
import com.ibm.team.build.internal.ui.query.BuildQuery;
import com.ibm.team.build.internal.ui.query.BuildQueryByDefinition;
import com.ibm.team.build.internal.ui.views.query.AdaptableBuildQueryRow;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import org.eclipse.swt.graphics.Image;

public class BuildDefinitionQueryNode
extends BuildDomainQueryNode
implements IBuildFavoriteItem {
    private BuildStatus fStatus;
    private IBuildDefinition fBuildDefinition;
    private BuildQuery fBuildQuery;

    public BuildDefinitionQueryNode(ITeamRepository repository, IBuildDefinitionStatusRecord record) {
        super(repository, record.getBuildDefinition().getId(), 0);
        this.setStatus(record.getStatus());
        this.setBuildDefinition(record.getBuildDefinition());
    }

    @Override
    public synchronized BuildQuery getQuery() {
        if (this.fBuildQuery == null) {
            this.fBuildQuery = new BuildQueryByDefinition(this.fBuildDefinition.getId(), null, AdaptableBuildQueryRow.Factory, (IBuildDefinitionHandle)this.fBuildDefinition, this.getTeamRepository());
        }
        return this.fBuildQuery;
    }

    @Override
    public Image getImage() {
        Image undecoratedImage = BuildUIPlugin.getImage("icons/obj16/build_type_obj.gif");
        if (this.getStatus() == null) {
            return undecoratedImage;
        }
        return BuildCompositeImageRegistry.getImage(undecoratedImage, this.fStatus);
    }

    @Override
    public synchronized String getLabel() {
        return this.fBuildDefinition.getId();
    }

    public synchronized BuildStatus getStatus() {
        return this.fStatus;
    }

    public synchronized void setStatus(BuildStatus status) {
        this.fStatus = status;
    }

    public String getBuildDefinitionId() {
        return this.getBuildDefinition().getId();
    }

    public synchronized IBuildDefinition getBuildDefinition() {
        return this.fBuildDefinition;
    }

    public synchronized void setBuildDefinition(IBuildDefinition definition) {
        this.fBuildDefinition = definition;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BuildDefinitionQueryNode) {
            return ((BuildDefinitionQueryNode)obj).getBuildDefinition().getItemId().equals((Object)this.getBuildDefinition().getItemId());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getBuildDefinition().getItemId().hashCode();
    }

    @Override
    public boolean isCategorizable() {
        return true;
    }

    @Override
    public IItem getItem() {
        return this.fBuildDefinition;
    }

    @Override
    public String getItemDescription() {
        return this.fBuildDefinition.getDescription();
    }

    @Override
    public String getItemName() {
        return this.fBuildDefinition.getId();
    }

    @Override
    public String getItemReferenceType() {
        return IBuildDefinition.class.getName();
    }
}

