/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.domain;

import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildConfigurationElement;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.internal.ui.BuildCompositeImageRegistry;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.jface.labelProviders.TypeLabelProvider;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Image;

public class BuildDefinitionLabelProvider
extends TypeLabelProvider {
    public void updateLabel(ViewerLabel label, Object element) {
        if (element instanceof IBuildDefinition) {
            IBuildDefinition buildDefinition = (IBuildDefinition)element;
            for (Object property : buildDefinition.getProperties()) {
                if (!(property instanceof IBuildProperty)) continue;
                IBuildProperty buildProp = (IBuildProperty)property;
                String name = buildProp.getName();
                String kind = buildProp.getKind();
                String buildLabel = buildProp.getLabel();
                String string = buildProp.getValue();
            }
            Image icon = BuildUIPlugin.getImage("icons/obj16/build_type_obj.gif");
            for (Object config : buildDefinition.getConfigurationElements()) {
                IBuildConfigurationElement buildConfigElement = (IBuildConfigurationElement)config;
                if (buildConfigElement.getElementId().contains("promotion")) {
                    icon = BuildUIPlugin.getImage("icons/obj16/promotion_obj.gif");
                    continue;
                }
                if (buildConfigElement.getElementId().contains("packaging")) {
                    icon = BuildUIPlugin.getImage("icons/obj16/package_obj.gif");
                    continue;
                }
                if (!buildConfigElement.getElementId().contains("deploy")) continue;
                icon = BuildUIPlugin.getImage("icons/obj16/deployment_obj.gif");
            }
            label.setText(buildDefinition.getId());
            BuildStatus status = this.getStatus(buildDefinition);
            if (status != null) {
                icon = BuildCompositeImageRegistry.getImage(icon, status);
            }
            label.setImage(icon);
        }
    }

    private BuildStatus getStatus(IBuildDefinition buildDefinition) {
        return null;
    }
}

