/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.dialogs.tags;

import com.ibm.team.build.internal.common.helper.TagsHelper;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.dialogs.tags.BuildUICategoryDialogMessages;
import com.ibm.team.build.internal.ui.tags.TagContentProposalProvider;
import com.ibm.team.build.internal.ui.tags.TagsField;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class PromptForTagDialog
extends InputDialog {
    private String fTag;
    private TagContentProposalProvider fTagProvider;
    private TagsField fTagsField;
    private static IInputValidator SINGLE_TAG = new SingleTagValidator();

    public PromptForTagDialog(Shell parentShell, TagContentProposalProvider tagProvider) {
        super(parentShell, BuildUICategoryDialogMessages.PromptForTagDialog_TITLE, BuildUICategoryDialogMessages.PromptForTagDialog_TAG_INTRO, "", SINGLE_TAG);
        ValidationHelper.validateNotNull((String)"tagProvider", (Object)tagProvider);
        this.fTagProvider = tagProvider;
    }

    protected Control createDialogArea(Composite parent) {
        Control control = super.createDialogArea(parent);
        this.fTagsField = new TagsField(super.getText(), this.fTagProvider);
        ControlDecoration decoration = new ControlDecoration((Control)super.getText(), 16512);
        decoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL").getImage());
        decoration.setDescriptionText(BuildUICategoryDialogMessages.getContentAssistMessage());
        PlatformUI.getWorkbench().getHelpSystem().setHelp(control, "com.ibm.team.build.ui.dialog_tag");
        return control;
    }

    public String getTags() {
        if (this.fTag == null) {
            return "";
        }
        return this.fTag;
    }

    public void setTags(String tags) {
        this.fTag = tags;
    }

    protected void okPressed() {
        this.fTag = this.getText().getText().trim();
        this.fTagsField.dispose();
        super.okPressed();
    }

    public Text getTagText() {
        return super.getText();
    }

    static class SingleTagValidator
    implements IInputValidator {
        SingleTagValidator() {
        }

        public String isValid(String newText) {
            if (!TagsHelper.isOnlyOneTag((String)newText.trim())) {
                return BuildUICategoryDialogMessages.PromptForTagDialog_INVALID_TAG_MESSAGE;
            }
            return null;
        }
    }
}

