/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.dialogs.definitions;

import com.ibm.icu.text.Collator;
import com.ibm.team.build.client.ClientFactory;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.query.IBaseBuildDefinitionQueryModel;
import com.ibm.team.build.internal.client.iterator.ItemQueryIterator;
import com.ibm.team.build.internal.common.model.query.BaseBuildDefinitionQueryModel;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.dialogs.definitions.BuildDefinitionDialogMessages;
import com.ibm.team.build.internal.ui.dialogs.definitions.BuildDefinitionSelectionDialog;
import com.ibm.team.build.internal.ui.domain.ConnectedProjectAreaRegistryHelper;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.ast.IItemHandleInputArg;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;

public class FetchBuildDefinitionsInConnectedProjectAreasJob
extends TeamBuildJob {
    private final BuildDefinitionSelectionDialog fBuildDefinitionSelectionDialog;
    protected IBuildDefinition[] fFetchedBuildDefinitions;
    protected int fConnectedRepositoryCount = 0;
    protected int fDisconnectedRepositoryCount = 0;

    public FetchBuildDefinitionsInConnectedProjectAreasJob(BuildDefinitionSelectionDialog dialog) {
        super(BuildDefinitionDialogMessages.FetchBuildDefinitionStatusRecordsJob_0, false);
        this.fBuildDefinitionSelectionDialog = dialog;
    }

    protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        return this.doFetch(monitor);
    }

    protected IStatus doFetch(IProgressMonitor monitor) throws Exception {
        ITeamRepository[] connectedRepositories;
        ArrayList<IBuildDefinition> allBuilds = new ArrayList<IBuildDefinition>();
        ArrayList<IStatus> errors = null;
        ITeamRepository[] iTeamRepositoryArray = connectedRepositories = this.getConnectedRepositories();
        int n = connectedRepositories.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamRepository repository = iTeamRepositoryArray[n2];
            if (repository.loggedIn()) {
                try {
                    IBuildDefinition[] definitions = this.fetchBuildDefinitions(repository, monitor);
                    allBuilds.addAll(Arrays.asList(definitions));
                    ++this.fConnectedRepositoryCount;
                }
                catch (OperationCanceledException exception) {
                    return Status.CANCEL_STATUS;
                }
                catch (Exception exception) {
                    String repoId;
                    if (errors == null) {
                        errors = new ArrayList<IStatus>();
                    }
                    if ((repoId = repository.getName()) == null || repoId.length() == 0) {
                        repoId = repository.getRepositoryURI();
                    }
                    String errorMessage = NLS.bind((String)BuildDefinitionDialogMessages.FetchBuildDefinitionStatusRecordsJob_ERROR_CONNECTING_TO_REPOSITORY_X, (Object)repoId);
                    errors.add(this.createStatus(errorMessage, exception));
                }
            } else {
                ++this.fDisconnectedRepositoryCount;
            }
            ++n2;
        }
        this.fFetchedBuildDefinitions = allBuilds.toArray(new IBuildDefinition[allBuilds.size()]);
        IStatus status = Status.OK_STATUS;
        if (errors != null) {
            String message = null;
            message = connectedRepositories.length == 1 ? BuildDefinitionDialogMessages.FetchBuildDefinitionStatusRecordsJob_COULD_NOT_CONNECT_TO_REPOSITORY : (this.fConnectedRepositoryCount == 0 ? BuildDefinitionDialogMessages.FetchBuildDefinitionStatusRecordsJob_COULD_NOT_CONNECT_TO_ANY_REPOSITORIES : BuildDefinitionDialogMessages.FetchBuildDefinitionStatusRecordsJob_COULD_NOT_CONNECT_TO_ALL_REPOSITORIES);
            IStatus[] statuses = errors.toArray(new IStatus[errors.size()]);
            status = new MultiStatus(BuildUIPlugin.getUniqueIdentifier(), 0, statuses, message, null);
        }
        return status;
    }

    protected IBuildDefinition[] fetchBuildDefinitions(ITeamRepository repository, IProgressMonitor monitor) throws TeamRepositoryException {
        IProcessAreaHandle[] processAreaHandles = ConnectedProjectAreaRegistryHelper.getAllSelectedProcessAreas(repository);
        Comparator<IBuildDefinition> comparator = new Comparator<IBuildDefinition>(){
            Collator collator = Collator.getInstance();

            @Override
            public int compare(IBuildDefinition buildDefinition1, IBuildDefinition buildDefinition2) {
                if (buildDefinition1 != null && buildDefinition2 != null) {
                    return this.collator.compare(buildDefinition1.getId(), buildDefinition2.getId());
                }
                if (buildDefinition1 == null && buildDefinition2 == null) {
                    return 0;
                }
                if (buildDefinition1 == null) {
                    return -1;
                }
                return 1;
            }
        };
        TreeSet<IBuildDefinition> buildDefinitions = new TreeSet<IBuildDefinition>(comparator);
        if (processAreaHandles.length > 0) {
            int current = 0;
            while (current < processAreaHandles.length) {
                IBaseBuildDefinitionQueryModel.IBuildDefinitionQueryModel buildDefinitionQueryModel = IBaseBuildDefinitionQueryModel.IBuildDefinitionQueryModel.ROOT;
                IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)buildDefinitionQueryModel);
                int end = Math.min(processAreaHandles.length, current + 1000);
                ArrayList<IProcessAreaHandle> parms = new ArrayList<IProcessAreaHandle>(end - current);
                IItemHandleInputArg[] itemHandleArgs = new IItemHandleInputArg[end - current];
                int i = 0;
                while (i < itemHandleArgs.length) {
                    itemHandleArgs[i] = query.newItemHandleArg();
                    parms.add(processAreaHandles[current + i]);
                    ++i;
                }
                IPredicate filter = ((BaseBuildDefinitionQueryModel.BuildDefinitionQueryModel)buildDefinitionQueryModel).processArea()._in(itemHandleArgs);
                query.filter(filter);
                IItemManager itemManager = repository.itemManager();
                ItemQueryIterator iter = new ItemQueryIterator(ClientFactory.getTeamBuildClient((ITeamRepository)repository), query, parms.toArray());
                while (iter.hasNext(monitor)) {
                    List definitionHandles = iter.next(512, monitor);
                    List buildDefns = itemManager.fetchCompleteItems(definitionHandles, 0, monitor);
                    for (IBuildDefinition buildDefinition : buildDefns) {
                        if (buildDefinition == null) continue;
                        buildDefinitions.add(buildDefinition);
                    }
                }
                current += 1000;
            }
        }
        return buildDefinitions.toArray(new IBuildDefinition[buildDefinitions.size()]);
    }

    @Override
    protected void jobFinished(IStatus status) {
        if (status.getSeverity() == 8) {
            return;
        }
        this.updateDialogStatus(status);
    }

    protected boolean isBuildDefinitionSelectionDialogDisposed() {
        return this.fBuildDefinitionSelectionDialog.getShell() == null || this.fBuildDefinitionSelectionDialog.getShell().isDisposed();
    }

    protected void asyncExec(Runnable runnable) {
        Display.getDefault().asyncExec(runnable);
    }

    protected void updateDialogStatus(final IStatus status) {
        this.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (FetchBuildDefinitionsInConnectedProjectAreasJob.this.isBuildDefinitionSelectionDialogDisposed()) {
                    return;
                }
                FetchBuildDefinitionsInConnectedProjectAreasJob.this.fBuildDefinitionSelectionDialog.setFetchingDone();
                FetchBuildDefinitionsInConnectedProjectAreasJob.this.fBuildDefinitionSelectionDialog.setListElements(FetchBuildDefinitionsInConnectedProjectAreasJob.this.fFetchedBuildDefinitions);
                IStatus updateStatus = null;
                if (!status.isOK()) {
                    updateStatus = status;
                } else if (FetchBuildDefinitionsInConnectedProjectAreasJob.this.fConnectedRepositoryCount == 0) {
                    String message = BuildDefinitionDialogMessages.FetchBuildDefinitionStatusRecordsJob_NOT_CONNECTED_TO_PROJECT_AREAS;
                    updateStatus = new Status(2, BuildUIPlugin.getUniqueIdentifier(), message);
                } else if (FetchBuildDefinitionsInConnectedProjectAreasJob.this.fDisconnectedRepositoryCount > 0) {
                    String message = BuildDefinitionDialogMessages.FetchBuildDefinitionStatusRecordsJob_NOT_LOGGED_IN_TO_SOME_REPOSITORIES;
                    updateStatus = new Status(2, BuildUIPlugin.getUniqueIdentifier(), message);
                }
                if (updateStatus != null) {
                    FetchBuildDefinitionsInConnectedProjectAreasJob.this.updateBuildDefinitionSelectionDialogStatus(updateStatus);
                }
            }
        });
    }

    protected void updateBuildDefinitionSelectionDialogStatus(IStatus updateStatus) {
        this.fBuildDefinitionSelectionDialog.setStatus(updateStatus);
    }

    protected ITeamRepository[] getConnectedRepositories() {
        Set<ITeamRepository> connectedRepositories = ConnectedProjectAreaRegistryHelper.getConnectedRepositories();
        return connectedRepositories.toArray(new ITeamRepository[connectedRepositories.size()]);
    }
}

